/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.datareview;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.faf.algo.FAFAlgoUtil;
import kd.macc.faf.dataquery.dto.ModelDynamicVO;
import kd.macc.faf.datareview.AnalysisModelDataQuery;
import kd.macc.faf.datareview.FAFListColumns;
import kd.macc.faf.datareview.FAFReportAnalysisModel;
import kd.macc.faf.datareview.ProcessViewListPlugin;
import kd.macc.faf.util.FormatUtils;
import kd.macc.faf.util.IDataDateUtil;

public class ProcessDetailListPlugin
extends FAFListColumns {
    private static final Log logger = LogFactory.getLog(ProcessViewListPlugin.class);

    public DataSet query(ReportQueryParam reportQueryParam, Object o) throws Throwable {
        try {
            Object rowMeta;
            FilterInfo paramFilter = reportQueryParam.getFilter();
            List qFilters = paramFilter.getQFilters();
            Long modelId = Long.parseLong(((QFilter)qFilters.get(0)).getValue().toString());
            Long summaryId = Long.parseLong(((QFilter)qFilters.get(1)).getValue().toString());
            Long dataDetailId = null;
            Long timestamp = new Date().getTime();
            if (qFilters.size() >= 3) {
                String property = ((QFilter)qFilters.get(2)).getProperty();
                long value = Long.parseLong(((QFilter)qFilters.get(2)).getValue().toString());
                if ("detailid".equals(property)) {
                    dataDetailId = value;
                } else if ("timestamp".equals(property)) {
                    timestamp = value;
                }
            }
            FilterItemInfo shownumber = paramFilter.getFilterItem("shownumber");
            boolean needNumber = true;
            if (shownumber != null) {
                needNumber = shownumber.getBoolean();
            }
            AnalysisModelDataQuery dataQuery = new AnalysisModelDataQuery(modelId);
            ModelDynamicVO modelVo = dataQuery.getModelVo();
            this.fAFReportAnalysisModel = new FAFReportAnalysisModel(modelId, needNumber);
            List measureNumbers = this.fAFReportAnalysisModel.getMeasureList().stream().map(new Function<FAFReportAnalysisModel.Measure, String>(){

                @Override
                public String apply(FAFReportAnalysisModel.Measure measure) {
                    return measure.getNumber();
                }
            }).collect(Collectors.toList());
            List<FAFReportAnalysisModel.Field> columnsMap = this.fAFReportAnalysisModel.getColumnNumbers();
            String selectFields = this.fAFReportAnalysisModel.getSelectFields2String();
            long subExecLogId = 0L;
            if (dataDetailId != null) {
                DynamicObject queryOne = QueryServiceHelper.queryOne((String)modelVo.getEntityname_D(), (String)"createtime,subexeclogid", (QFilter[])new QFilter("id", "=", (Object)dataDetailId).toArray());
                timestamp = queryOne.getDate("createtime").getTime();
                subExecLogId = queryOne.getLong("subexeclogid");
            } else if (qFilters.size() == 4) {
                subExecLogId = Long.parseLong(((QFilter)qFilters.get(3)).getValue().toString());
            }
            ArrayList<Object[]> dataList = new ArrayList<Object[]>(10);
            HashMap<String, BigDecimal> measureSumMap = new HashMap<String, BigDecimal>(measureNumbers.size());
            QFilter filter = new QFilter("summaryid", "in", (Object)summaryId).and(new QFilter("createtime", "<", (Object)new Date(timestamp))).and(new QFilter("subExecLogId", "!=", (Object)subExecLogId).or(new QFilter("subExecLogId", "is null", null)));
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"FAF-querydetaildatas", (String)modelVo.getEntityname_D(), (String)selectFields, (QFilter[])filter.toArray(), null);){
                rowMeta = dataSet.getRowMeta();
                for (Row row : dataSet) {
                    Field[] fields = rowMeta.getFields();
                    ArrayList<Object> rowData = new ArrayList<Object>(columnsMap.size());
                    for (Field field : fields) {
                        Object value = row.get(field.getName());
                        if (measureNumbers.contains(field.getName())) {
                            measureSumMap.merge(field.getName(), FAFAlgoUtil.safeGet((Row)row, (String)field.getName()), BigDecimal::add);
                        }
                        if (value instanceof Date) {
                            value = IDataDateUtil.dateToString((Date)((Date)value), (String)"yyyy-MM-dd HH:mm:ss");
                        }
                        rowData.add(value);
                    }
                    dataList.add(rowData.toArray());
                }
            }
            ArrayList<Object[]> finallyData = new ArrayList<Object[]>(dataList.size() + 1);
            DataSet dataSet = QueryServiceHelper.queryDataSet((String)"FAF-querysummarydatas", (String)modelVo.getEntityname(), (String)selectFields, (QFilter[])new QFilter("id", "=", (Object)summaryId).toArray(), null);
            rowMeta = null;
            try {
                for (Row row : dataSet) {
                    ArrayList<Object> rowData = new ArrayList<Object>(columnsMap.size());
                    for (FAFReportAnalysisModel.Field columnNumber : columnsMap) {
                        Object value = row.get(columnNumber.getNumber());
                        if (value instanceof Date) {
                            value = IDataDateUtil.dateToString((Date)((Date)value), (String)"yyyy-MM-dd HH:mm:ss");
                        }
                        rowData.add(value);
                    }
                    finallyData.add(rowData.toArray());
                }
            }
            catch (Throwable throwable) {
                rowMeta = throwable;
                throw throwable;
            }
            finally {
                if (dataSet != null) {
                    if (rowMeta != null) {
                        try {
                            dataSet.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)rowMeta).addSuppressed(throwable);
                        }
                    } else {
                        dataSet.close();
                    }
                }
            }
            finallyData.addAll(dataList);
            Object[] updateRow = (Object[])finallyData.get(0);
            for (int i = 0; i < updateRow.length; ++i) {
                FAFReportAnalysisModel.Field currentColumnNumber = columnsMap.get(i);
                if (!measureNumbers.contains(currentColumnNumber.getNumber())) continue;
                updateRow[i] = measureSumMap.get(currentColumnNumber.getNumber());
            }
            Algo algo = Algo.create((String)((Object)((Object)this)).getClass().getName());
            ArrayList<Field> fields = new ArrayList<Field>(columnsMap.size());
            for (FAFReportAnalysisModel.Field colNumber : columnsMap) {
                Field currentField = new Field(colNumber.getNumber(), (DataType)DataType.StringType);
                fields.add(currentField);
            }
            for (Object[] objects : finallyData) {
                for (int i = this.fAFReportAnalysisModel.getMeasureNumberIndex(); i < measureNumbers.size() + this.fAFReportAnalysisModel.getMeasureNumberIndex(); ++i) {
                    FAFReportAnalysisModel.Measure measure = (FAFReportAnalysisModel.Measure)columnsMap.get(i);
                    if ("2".equals(measure.measuretype)) {
                        objects[i] = "-";
                        continue;
                    }
                    if (objects[i] == null || !(objects[i] instanceof BigDecimal)) continue;
                    objects[i] = FormatUtils.formatNumber((Long)RequestContext.get().getCurrUserId(), (int)measure.getPrecision(), (BigDecimal)((BigDecimal)objects[i]));
                }
            }
            return algo.createDataSet(finallyData.iterator(), new RowMeta(fields.toArray(new Field[0])));
        }
        catch (KDBizException ex) {
            throw ex;
        }
        catch (Exception ex) {
            logger.error("[FAF] - dataquery trace souce detail ", (Throwable)ex);
            throw new KDBizException(ex.getMessage());
        }
    }
}

