/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.datareview;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.report.IReportView;
import kd.bos.report.ReportShowParameter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.macc.faf.FAFDataAdjustFormPlugin;
import kd.macc.faf.datareview.ProcessViewReportFormPlugin;
import kd.macc.faf.dto.ProcessDataReviewDTO;
import kd.macc.faf.dto.SourceToModelTableMappingDTO;
import kd.macc.faf.helper.FAFTableDataHelper;
import org.jetbrains.annotations.NotNull;

public class ProcessDetailReportFormPlugin
extends ProcessViewReportFormPlugin {
    @Override
    public boolean verifyQuery(ReportQueryParam queryParam) {
        IReportView view = this.getView();
        FormShowParameter fsp = view.getFormShowParameter();
        Long analysisModelId = (Long)fsp.getCustomParam("analysis_model");
        if (analysisModelId == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5206\u6790\u6a21\u578b\u3002", (String)"ProcessDetailReportFormPlugin_0", (String)"macc-faf-formplugin", (Object[])new Object[0]));
            return false;
        }
        long summaryId = Long.parseLong(fsp.getCustomParam("summaryid").toString());
        if (summaryId == 0L) {
            view.showTipNotification(ResManager.loadKDString((String)"\u7f3a\u5c11\u6c47\u603b\u6570\u636eID\u3002", (String)"ProcessDetailReportFormPlugin_1", (String)"macc-faf-formplugin", (Object[])new Object[0]));
            return false;
        }
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(3);
        filterList.add(new QFilter("analysis_model", "=", (Object)analysisModelId));
        filterList.add(new QFilter("summaryId", "=", (Object)summaryId));
        Object detailid = fsp.getCustomParam("detailid");
        Object timestamp = fsp.getCustomParam("timestamp");
        if (timestamp != null) {
            timestamp = Long.parseLong(timestamp.toString());
            filterList.add(new QFilter("timestamp", "=", timestamp));
            filterList.add(new QFilter("subexeclogid", "=", fsp.getCustomParam("subexeclogid")));
        } else if (detailid != null) {
            detailid = Long.parseLong(detailid.toString());
            filterList.add(new QFilter("detailid", "=", detailid));
        }
        FilterInfo filterInfo = new FilterInfo();
        Object shownumberValue = this.getView().getFormShowParameter().getCustomParams().get("shownumber");
        filterInfo.addFilterItem("shownumber", shownumberValue);
        filterInfo.setQFilters(filterList);
        queryParam.setFilter(filterInfo);
        return true;
    }

    @Override
    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        String fieldName = hyperLinkClickEvent.getFieldName();
        DynamicObject rowData = hyperLinkClickEvent.getRowData();
        String collectstatus = rowData.getString("collectstatus");
        if ("datastatus".equals(fieldName) && "0".equals(collectstatus)) {
            IReportView view = this.getView();
            FormShowParameter fsp = view.getFormShowParameter();
            Long analysisModelId = (Long)fsp.getCustomParam("analysis_model");
            Long id = rowData.getLong("id");
            String datastatus = rowData.getString("datastatus");
            Boolean shownumber = (Boolean)fsp.getCustomParam("shownumber");
            HashSet<String> adSet = new HashSet<String>(Arrays.asList("3", "-3"));
            if ("0".equals(datastatus)) {
                SourceToModelTableMappingDTO sourceToModelTableMappingDTO = FAFTableDataHelper.queryOneSourceToModelTableMapping((Long)analysisModelId, (Long)id);
                if (sourceToModelTableMappingDTO == null) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u6765\u6e90\u6620\u5c04\u8868\u627e\u4e0d\u5230\u76f8\u5173\u6570\u636e", (String)"ProcessDetailReportFormPlugin_2", (String)"macc-faf-formplugin", (Object[])new Object[0]));
                }
                String sourceNumber = sourceToModelTableMappingDTO.getSourceNumber();
                if (StringUtils.isNotEmpty((CharSequence)sourceNumber)) {
                    BillShowParameter formShowParameter = new BillShowParameter();
                    formShowParameter.setPkId((Object)sourceToModelTableMappingDTO.getEntityPrimaryKey());
                    formShowParameter.setFormId(sourceToModelTableMappingDTO.getSourceNumber());
                    formShowParameter.setStatus(OperationStatus.VIEW);
                    formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                    this.getView().showForm((FormShowParameter)formShowParameter);
                }
            } else if (adSet.contains(datastatus)) {
                FAFDataAdjustFormPlugin.openF7((AbstractFormPlugin)this, analysisModelId, id);
            } else {
                Boolean isNeedColor = (Boolean)fsp.getCustomParam("isNeedColor");
                ProcessViewReportFormPlugin.openF7((AbstractFormPlugin)this, analysisModelId, id, view.getPageCache().get("report_analysis"), view.getPageCache().get("report_analysis_model"), isNeedColor, shownumber);
            }
        }
    }

    @Override
    public void processRowData(String gridPK, DynamicObjectCollection rowData, ReportQueryParam queryParam) {
        FormShowParameter fsp = this.getView().getFormShowParameter();
        String sysName = fsp.getCustomParam("report_analysis").toString();
        String analysismodelName = fsp.getCustomParam("report_analysis_model").toString();
        long summaryId = Long.parseLong(fsp.getCustomParam("summaryid").toString());
        Boolean isNeedColor = (Boolean)fsp.getCustomParam("isNeedColor");
        List<Long> ids = rowData.stream().filter(p -> "0".equals(p.getString("collectstatus")) && "0".equals(p.getString("datastatus"))).map(p -> p.getLong("id")).collect(Collectors.toList());
        Map<Object, Object> idMapSourceNumber = Collections.emptyMap();
        if (!ids.isEmpty()) {
            Long analysisModelId = (Long)fsp.getCustomParam("analysis_model");
            List sourceToModelTableMappingDTOS = FAFTableDataHelper.transformQuerySourceModelTable((Long)analysisModelId, (boolean)false, (Long[])ids.toArray(new Long[0]));
            idMapSourceNumber = sourceToModelTableMappingDTOS.stream().collect(Collectors.toMap(SourceToModelTableMappingDTO::getModelTableId, SourceToModelTableMappingDTO::getSourceNumber));
        }
        Map finalIdMapSourceNumber = idMapSourceNumber;
        rowData.forEach(p -> {
            if (isNeedColor.booleanValue() && p.getLong("id") == summaryId) {
                p.set("color", (Object)"1");
            }
            if ("1".equals(p.getString("collectstatus"))) {
                p.set("report_analysis", (Object)sysName);
                p.set("report_analysis_model", (Object)analysismodelName);
                p.set("datastatus", (Object)"");
            } else {
                p.set("report_period_name", null);
                p.set("report_org_name", null);
                p.set("report_account_name", null);
                p.set("report_period_number", null);
                p.set("report_org_number", null);
                p.set("report_account_number", null);
                if ("gl_balance".equals(finalIdMapSourceNumber.get(p.getLong("id"))) || finalIdMapSourceNumber.get(p.getLong("id")) == null && "0".equals(p.get("datastatus"))) {
                    p.set("datastatus", (Object)"");
                }
            }
        });
    }

    public static void openF7(AbstractFormPlugin abstractFormPlugin, @NotNull Long analysisModelId, @NotNull Long summaryId) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((Object)analysisModelId, (String)"pa_analysismodel");
        if (dynamicObject == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6a21\u578b\u8868\u4e2d\u627e\u4e0d\u5230\u8be5\u8bb0\u5f55", (String)"ProcessDetailReportFormPlugin_3", (String)"macc-faf-formplugin", (Object[])new Object[0]));
        }
        String name = dynamicObject.getString("name");
        String sysName = dynamicObject.getString("analysis_system.name");
        ProcessDetailReportFormPlugin.openF7(abstractFormPlugin, analysisModelId, summaryId, null, sysName, name);
    }

    public static void openF7(AbstractFormPlugin abstractFormPlugin, @NotNull Long analysisModelId, @NotNull Long summaryId, Long detailId, String analysisName, String analysisModelName) {
        ProcessDetailReportFormPlugin.openF7(abstractFormPlugin, analysisModelId, summaryId, detailId, analysisName, analysisModelName, true, false);
    }

    public static void openF7(AbstractFormPlugin abstractFormPlugin, @NotNull Long analysisModelId, @NotNull Long summaryId, Long detailId, String analysisName, String analysisModelName, Boolean isNeedColor, Boolean shownumber) {
        ProcessDataReviewDTO processDataReviewDTO = new ProcessDataReviewDTO("detailid");
        processDataReviewDTO.setDetailId(detailId);
        processDataReviewDTO.setSummaryId(summaryId);
        processDataReviewDTO.setAnalysisModelId(analysisModelId);
        processDataReviewDTO.setAnalysisName(analysisName);
        processDataReviewDTO.setAnalysisModelName(analysisModelName);
        processDataReviewDTO.setNeedColor(isNeedColor);
        processDataReviewDTO.setShowNumber(shownumber);
        ProcessDetailReportFormPlugin.openF7(abstractFormPlugin, processDataReviewDTO);
    }

    public static void openF7(AbstractFormPlugin abstractFormPlugin, ProcessDataReviewDTO processDataReviewDTO) {
        String type = processDataReviewDTO.getType();
        if (!"detailid".equals(type) && !"timestamp".equals(type)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53c2\u6570\u4e0d\u5408\u6cd5", (String)"ProcessDetailReportFormPlugin_4", (String)"macc-faf-formplugin", (Object[])new Object[0]));
        }
        ReportShowParameter formShowParameter = new ReportShowParameter();
        formShowParameter.getCustomParams().put("analysis_model", processDataReviewDTO.getAnalysisModelId());
        formShowParameter.getCustomParams().put("summaryid", processDataReviewDTO.getSummaryId());
        if ("detailid".equals(type)) {
            formShowParameter.getCustomParams().put("detailid", processDataReviewDTO.getDetailId());
        } else {
            formShowParameter.getCustomParams().put("timestamp", processDataReviewDTO.getTimeStamp());
            formShowParameter.getCustomParams().put("subexeclogid", processDataReviewDTO.getSubExecLogId());
        }
        formShowParameter.getCustomParams().put("report_analysis", processDataReviewDTO.getAnalysisName());
        formShowParameter.getCustomParams().put("report_analysis_model", processDataReviewDTO.getAnalysisModelName());
        formShowParameter.getCustomParams().put("isNeedColor", processDataReviewDTO.getNeedColor());
        formShowParameter.getCustomParams().put("shownumber", processDataReviewDTO.getShowNumber());
        formShowParameter.setFormId("pa_reviewsource2");
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        abstractFormPlugin.getView().showForm((FormShowParameter)formShowParameter);
    }
}

