/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.datareview;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.context.RequestContext;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.faf.algo.FAFAlgoUtil;
import kd.macc.faf.dataquery.dto.TraceInfo;
import kd.macc.faf.datareview.AnalysisModelDataQuery;
import kd.macc.faf.datareview.FAFListColumns;
import kd.macc.faf.datareview.FAFReportAnalysisModel;
import kd.macc.faf.enums.DataStatusEnum;
import kd.macc.faf.util.FormatUtils;
import kd.macc.faf.util.IDataDateUtil;

public class ProcessViewListPlugin
extends FAFListColumns {
    private static final Log logger = LogFactory.getLog(ProcessViewListPlugin.class);
    private List<FAFReportAnalysisModel.Measure> measureNumbers;

    public DataSet query(ReportQueryParam queryParam, Object selectedObj) throws Throwable {
        try {
            Object row2;
            FilterInfo paramFilter = queryParam.getFilter();
            List qFilters = paramFilter.getQFilters();
            Long modelId = Long.parseLong(((QFilter)qFilters.get(0)).getValue().toString());
            Long dataDetailId = Long.parseLong(((QFilter)qFilters.get(1)).getValue().toString());
            FilterItemInfo shownumber = paramFilter.getFilterItem("shownumber");
            boolean needNumber = shownumber == null || shownumber.getBoolean();
            this.fAFReportAnalysisModel = new FAFReportAnalysisModel(modelId, needNumber);
            this.measureNumbers = this.fAFReportAnalysisModel.getMeasureList();
            List<FAFReportAnalysisModel.Field> columnsMap = this.fAFReportAnalysisModel.getColumnNumbers();
            AnalysisModelDataQuery dataQuery = new AnalysisModelDataQuery(modelId);
            TraceInfo trace = dataQuery.traceThrow(dataDetailId);
            String selectFields = this.fAFReportAnalysisModel.getSelectFields2String();
            ArrayList<Object[]> dataList = new ArrayList<Object[]>(10);
            QFilter sourceIdFilter = new QFilter("id", "=", (Object)trace.getSourceId());
            try (DataSet dataset = QueryServiceHelper.queryDataSet((String)"FAF-querySourceBills", (String)trace.getSourceEntityname(), (String)selectFields, (QFilter[])sourceIdFilter.toArray(), null, (int)1);){
                for (Object row2 : dataset) {
                    ArrayList rowData = new ArrayList(columnsMap.size());
                    for (FAFReportAnalysisModel.Field columnNumber : columnsMap) {
                        Iterator<FAFReportAnalysisModel.Field> value = row2.get(columnNumber.getNumber());
                        if ("collectstatus".equals(columnNumber.getNumber()) && row2.getInteger("collectstatus") == 0) {
                            value = 1;
                        }
                        if (value instanceof Date) {
                            value = IDataDateUtil.dateToString((Date)((Date)((Object)value)), (String)"yyyy-MM-dd HH:mm:ss");
                        }
                        rowData.add(value);
                    }
                    dataList.add(rowData.toArray());
                }
            }
            Map<String, BigDecimal> sumToMap = this.calMeasureSumTopMap(trace);
            Set offstatusSet = DataStatusEnum.offstatusSet();
            DataSet dataSet = QueryServiceHelper.queryDataSet((String)"PA-queryTargetBills", (String)trace.getTargetEntityname(), (String)selectFields, (QFilter[])trace.getTargetQfilters().toArray(new QFilter[0]), null);
            row2 = null;
            try {
                for (Row next : dataSet) {
                    ArrayList<Object> rowData = new ArrayList<Object>(columnsMap.size());
                    for (FAFReportAnalysisModel.Field columnNumber : columnsMap) {
                        Object value;
                        if (trace.isMergeData() && this.measureNumbers.contains(columnNumber) && ((FAFReportAnalysisModel.Measure)columnNumber).measuretype.equals("1")) {
                            BigDecimal bigDecimal = next.getBigDecimal(columnNumber.getNumber());
                            if (bigDecimal == null) {
                                bigDecimal = new BigDecimal(0);
                            }
                            sumToMap.merge(columnNumber.getNumber(), bigDecimal, BigDecimal::add);
                        }
                        if ((value = next.get(columnNumber.getNumber())) instanceof Date) {
                            value = IDataDateUtil.dateToString((Date)((Date)value), (String)"yyyy-MM-dd HH:mm:ss");
                        }
                        rowData.add(value);
                    }
                    if (offstatusSet.contains(next.getString("datastatus"))) continue;
                    dataList.add(rowData.toArray());
                }
            }
            catch (Throwable rowData) {
                row2 = rowData;
                throw rowData;
            }
            finally {
                if (dataSet != null) {
                    if (row2 != null) {
                        try {
                            dataSet.close();
                        }
                        catch (Throwable rowData) {
                            ((Throwable)row2).addSuppressed(rowData);
                        }
                    } else {
                        dataSet.close();
                    }
                }
            }
            if (trace.isMergeData()) {
                int index;
                Object[] updateRow = (Object[])dataList.get(0);
                for (int i = index = this.fAFReportAnalysisModel.getMeasureNumberIndex(); i < updateRow.length; ++i) {
                    BigDecimal bigDecimal;
                    FAFReportAnalysisModel.Field currentColumnNumber = columnsMap.get(i);
                    if (!this.measureNumbers.contains(currentColumnNumber) || (bigDecimal = sumToMap.get(currentColumnNumber.getNumber())) == null) continue;
                    updateRow[i] = bigDecimal;
                }
            }
            Algo algo = Algo.create((String)((Object)((Object)this)).getClass().getName());
            ArrayList<Field> fields = new ArrayList<Field>(columnsMap.size());
            for (FAFReportAnalysisModel.Field colNumber : columnsMap) {
                Field currentField = new Field(colNumber.getNumber(), (DataType)DataType.StringType);
                fields.add(currentField);
            }
            for (Object[] objects : dataList) {
                for (int i = this.fAFReportAnalysisModel.getMeasureNumberIndex(); i < this.measureNumbers.size() + this.fAFReportAnalysisModel.getMeasureNumberIndex(); ++i) {
                    FAFReportAnalysisModel.Measure measure = (FAFReportAnalysisModel.Measure)columnsMap.get(i);
                    if ("2".equals(measure.measuretype)) {
                        objects[i] = "-";
                        continue;
                    }
                    if (objects[i] == null || !(objects[i] instanceof BigDecimal)) continue;
                    objects[i] = FormatUtils.formatNumber((Long)RequestContext.get().getCurrUserId(), (int)measure.getPrecision(), (BigDecimal)((BigDecimal)objects[i]));
                }
            }
            return algo.createDataSet(dataList.iterator(), new RowMeta(fields.toArray(new Field[0])));
        }
        catch (KDBizException ex) {
            throw ex;
        }
        catch (Exception ex) {
            logger.error("[FAF] - dataquery trace souce", (Throwable)ex);
            throw new KDBizException(ex.getMessage());
        }
    }

    private Map<String, BigDecimal> calMeasureSumTopMap(TraceInfo trace) {
        if (!trace.isMergeData()) {
            return Collections.emptyMap();
        }
        String entityNumber = trace.getTargetEntityname();
        Long summaryid = trace.getSourceId();
        Long executionTime = trace.getExecTime();
        String selectFields = this.measureNumbers.stream().filter(p -> "1".equals(p.measuretype)).map(FAFReportAnalysisModel.Field::getNumber).collect(Collectors.joining(","));
        QFilter filter = new QFilter("summaryid", "=", (Object)summaryid).and(new QFilter("createstamp", "<", (Object)executionTime));
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"FAF-getMeasureValue", (String)entityNumber, (String)selectFields, (QFilter[])filter.toArray(), null);){
            HashMap<String, BigDecimal> sumMap = new HashMap<String, BigDecimal>(4);
            for (Row row : dataSet) {
                Field[] fields;
                RowMeta rowMeta = dataSet.getRowMeta();
                for (Field field : fields = rowMeta.getFields()) {
                    sumMap.merge(field.getName(), FAFAlgoUtil.safeGet((Row)row, (String)field.getName()), BigDecimal::add);
                }
            }
            HashMap<String, BigDecimal> hashMap = sumMap;
            return hashMap;
        }
    }
}

