/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.datareview;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.MapFunction;
import kd.bos.algo.ReduceGroupFunctionWithCollector;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.faf.datareview.FAFListColumns;
import kd.macc.faf.datareview.FAFReportAnalysisModel;
import kd.macc.faf.datareview.function.DataFormatMapFunc;
import kd.macc.faf.datareview.function.RecalculateMeaReduceGroupFunc;

public class ProcessViewListPlugin2
extends FAFListColumns {
    private static final String ALGO_KEY = ProcessViewListPlugin2.class.getName();

    public DataSet query(ReportQueryParam reportQueryParam, Object selectedObj) throws Throwable {
        FilterInfo filterInfo = reportQueryParam.getFilter();
        List filterInfoQFilters = filterInfo.getQFilters();
        Long execLogId = Long.parseLong(((QFilter)filterInfoQFilters.get(0)).getValue().toString());
        Long ruleExecLogId = Long.parseLong(((QFilter)filterInfoQFilters.get(1)).getValue().toString());
        DynamicObject execLogDy = BusinessDataServiceHelper.loadSingleFromCache((Object)execLogId, (String)"pa_executionlog");
        if (execLogDy == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u6267\u884c\u7ed3\u679c\u5df2\u4e0d\u5b58\u5728", (String)"ProcessViewListPlugin2_0", (String)"macc-faf-formplugin", (Object[])new Object[0]));
        }
        DynamicObject analysisModelDy = execLogDy.getDynamicObject("analysis_model");
        if (analysisModelDy == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u6267\u884c\u7ed3\u679c\u672a\u627e\u5230\u5bf9\u5e94\u6a21\u578b", (String)"ProcessViewListPlugin2_1", (String)"macc-faf-formplugin", (Object[])new Object[0]));
        }
        Long analysisModelId = analysisModelDy.getLong("id");
        boolean needNumber = filterInfo.getFilterItem("shownumber") == null || filterInfo.getFilterItem("shownumber").getBoolean();
        this.fAFReportAnalysisModel = new FAFReportAnalysisModel(analysisModelId, needNumber);
        String detailTableNumber = this.fAFReportAnalysisModel.getTableNumber();
        String summaryTableNumber = this.fAFReportAnalysisModel.getSummaryTableNumber();
        String selectFields2String = this.fAFReportAnalysisModel.getSelectFields2String();
        List<FAFReportAnalysisModel.Measure> measureList = this.fAFReportAnalysisModel.getMeasureList();
        Map<String, Integer> ordMeasureMap = measureList.stream().filter(measure -> "1".equals(measure.getMeasuretype())).collect(Collectors.toMap(measure -> measure.number, measure -> measure.index));
        Map<String, Integer> calMeasureMap = measureList.stream().filter(measure -> "2".equals(measure.getMeasuretype())).collect(Collectors.toMap(measure -> measure.number, measure -> measure.index));
        List<FAFReportAnalysisModel.Field> columnNumbers = this.fAFReportAnalysisModel.getColumnNumbers();
        RowMeta resultRowMeta = new RowMeta((Field[])columnNumbers.stream().map(field -> new Field(field.number, (DataType)DataType.StringType)).toArray(Field[]::new));
        this.setProgress(50);
        QFilter execLogFilter = new QFilter("execlogid", "=", (Object)execLogId);
        QFilter ruleExecLogFilter = new QFilter("subexeclogid", "=", (Object)ruleExecLogId);
        QFilter offStatusFilter = new QFilter("datastatus", "not in", (Object)new Object[]{-1, -2, -3});
        DataSet detailDataSet = QueryServiceHelper.queryDataSet((String)ALGO_KEY, (String)detailTableNumber, (String)(selectFields2String + ",execparentbillid"), (QFilter[])new QFilter[]{execLogFilter, ruleExecLogFilter, offStatusFilter}, null);
        this.setProgress(80);
        HashSet<Long> summaryIdSet = new HashSet<Long>();
        try (DataSet summaryIdDataSet = detailDataSet.copy().distinct();){
            for (Row row : summaryIdDataSet) {
                Long summaryId = row.getLong("execparentbillid");
                summaryIdSet.add(summaryId);
            }
        }
        if (summaryIdSet.isEmpty()) {
            return detailDataSet;
        }
        QFilter idFilter = new QFilter("id", "in", summaryIdSet);
        DataSet summaryDataSet = QueryServiceHelper.queryDataSet((String)ALGO_KEY, (String)summaryTableNumber, (String)(selectFields2String + ",id as execparentbillid"), (QFilter[])new QFilter[]{idFilter}, null);
        DataSet resultDataSet = summaryDataSet.union(detailDataSet).groupBy(new String[]{"execparentbillid"}).reduceGroup((ReduceGroupFunctionWithCollector)new RecalculateMeaReduceGroupFunc(summaryDataSet.getRowMeta(), ordMeasureMap)).orderBy(new String[]{"execparentbillid desc", "collectstatus desc"});
        this.setProgress(90);
        Map<String, Tuple<Integer, Integer>> ordMeasureIndexAndPrecisionMap = measureList.stream().filter(measure -> "1".equals(measure.getMeasuretype())).collect(Collectors.toMap(measure -> measure.number, measure -> new Tuple((Object)measure.index, (Object)measure.getPrecision()), (a, b) -> a));
        DataSet mapDataSet = resultDataSet.map((MapFunction)new DataFormatMapFunc(resultRowMeta, ordMeasureIndexAndPrecisionMap, calMeasureMap));
        this.setProgress(100);
        return mapDataSet;
    }
}

