/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.datareview;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.report.IReportView;
import kd.bos.report.ReportList;
import kd.bos.report.ReportShowParameter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.macc.faf.FAFDataAdjustFormPlugin;
import kd.macc.faf.datareview.ProcessDetailReportFormPlugin;
import org.jetbrains.annotations.NotNull;

public class ProcessViewReportFormPlugin
extends AbstractReportFormPlugin
implements HyperLinkClickListener {
    public void afterCreateNewData(EventObject e) {
        FormShowParameter fsp = this.getView().getFormShowParameter();
        String sysName = fsp.getCustomParam("report_analysis").toString();
        String analysismodelName = fsp.getCustomParam("report_analysis_model").toString();
        this.getView().getPageCache().put("report_analysis", sysName);
        this.getView().getPageCache().put("report_analysis_model", analysismodelName);
        this.getView().refresh();
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        IReportView view = this.getView();
        FormShowParameter fsp = view.getFormShowParameter();
        Long analysisModelId = (Long)fsp.getCustomParam("analysis_model");
        if (analysisModelId == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5206\u6790\u6a21\u578b\u3002", (String)"ProcessViewReportFormPlugin_0", (String)"macc-faf-formplugin", (Object[])new Object[0]));
            return false;
        }
        long dataDetailId = Long.parseLong(fsp.getCustomParam("id").toString());
        if (dataDetailId == 0L) {
            view.showTipNotification(ResManager.loadKDString((String)"\u7f3a\u5c11\u660e\u7ec6\u6570\u636eID\u3002", (String)"ProcessViewReportFormPlugin_1", (String)"macc-faf-formplugin", (Object[])new Object[0]));
            return false;
        }
        Boolean shownumber = (Boolean)fsp.getCustomParam("shownumber");
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(2);
        filterList.add(new QFilter("analysis_model", "=", (Object)analysisModelId));
        filterList.add(new QFilter("id", "=", (Object)dataDetailId));
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.addFilterItem("shownumber", (Object)shownumber);
        filterInfo.setQFilters(filterList);
        queryParam.setFilter(filterInfo);
        return true;
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        String fieldName = hyperLinkClickEvent.getFieldName();
        DynamicObject rowData = hyperLinkClickEvent.getRowData();
        HashSet<String> adSet = new HashSet<String>(Arrays.asList("3", "-3"));
        String datastatus = rowData.getString("datastatus");
        String collectstatus = rowData.getString("collectstatus");
        if ("report_operation".equals(fieldName) && "1".equals(collectstatus)) {
            IReportView view = this.getView();
            FormShowParameter fsp = view.getFormShowParameter();
            Long analysisModelId = (Long)fsp.getCustomParam("analysis_model");
            Long id = rowData.getLong("id");
            Long detailId = Long.parseLong(fsp.getCustomParam("id").toString());
            Boolean isNeedColor = (Boolean)fsp.getCustomParam("isNeedColor");
            Boolean shownumber = (Boolean)fsp.getCustomParam("shownumber");
            String report_analysis = view.getPageCache().get("report_analysis");
            String report_analysis_model = view.getPageCache().get("report_analysis_model");
            if ("".equals(rowData.getString("datastatus"))) {
                ProcessDetailReportFormPlugin.openF7((AbstractFormPlugin)this, analysisModelId, id, detailId, report_analysis, report_analysis_model, isNeedColor, shownumber);
            } else if (adSet.contains(datastatus)) {
                FAFDataAdjustFormPlugin.openF7((AbstractFormPlugin)this, analysisModelId, id);
            } else {
                ProcessViewReportFormPlugin.openF7((AbstractFormPlugin)this, analysisModelId, id, report_analysis, report_analysis_model, isNeedColor, shownumber);
            }
        }
    }

    public void processRowData(String gridPK, DynamicObjectCollection rowData, ReportQueryParam queryParam) {
        FormShowParameter fsp = this.getView().getFormShowParameter();
        String sysName = fsp.getCustomParam("report_analysis").toString();
        String analysismodelName = fsp.getCustomParam("report_analysis_model").toString();
        long dataDetailId = Long.parseLong(fsp.getCustomParam("id").toString());
        Boolean isNeedColor = (Boolean)fsp.getCustomParam("isNeedColor");
        rowData.forEach(p -> {
            if (isNeedColor.booleanValue() && p.getLong("id") == dataDetailId) {
                p.set("color", (Object)"1");
            }
            if ("1".equals(p.getString("collectstatus"))) {
                p.set("report_analysis", (Object)sysName);
                p.set("report_analysis_model", (Object)analysismodelName);
                if ("0".equals(p.getString("datastatus"))) {
                    p.set("datastatus", (Object)"");
                }
                p.set("report_operation", (Object)new LocaleString(ResManager.loadKDString((String)"\u67e5\u770b", (String)"ProcessViewReportFormPlugin_2", (String)"macc-faf-formplugin", (Object[])new Object[0])).toString());
            }
        });
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ReportList reportList = (ReportList)this.getView().getControl("reportlistap");
        reportList.addHyperClickListener((HyperLinkClickListener)this);
    }

    public static void openF7(AbstractFormPlugin abstractFormPlugin, @NotNull Long analysisModelId, @NotNull Long detailId, String analysisName, String analysisModelName, Boolean needNumber) {
        ProcessViewReportFormPlugin.openF7(abstractFormPlugin, analysisModelId, detailId, analysisName, analysisModelName, true, needNumber);
    }

    public static void openF7(AbstractFormPlugin abstractFormPlugin, @NotNull Long analysisModelId, @NotNull Long detailId, String analysisName, String analysisModelName, Boolean isNeedColor, Boolean shownumber) {
        ReportShowParameter formShowParameter = new ReportShowParameter();
        formShowParameter.getCustomParams().put("id", detailId);
        formShowParameter.getCustomParams().put("analysis_model", analysisModelId);
        formShowParameter.setFormId("pa_reviewsource");
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        formShowParameter.getCustomParams().put("isNeedColor", isNeedColor);
        formShowParameter.getCustomParams().put("shownumber", shownumber);
        formShowParameter.getCustomParams().put("report_analysis", analysisName);
        formShowParameter.getCustomParams().put("report_analysis_model", analysisModelName);
        abstractFormPlugin.getView().showForm((FormShowParameter)formShowParameter);
    }
}

