/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.datareview.function;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kd.bos.algo.Collector;
import kd.bos.algo.ReduceGroupFunctionWithCollector;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.macc.faf.enums.FAFCollectStatusEnum;

public class RecalculateMeaReduceGroupFunc
extends ReduceGroupFunctionWithCollector {
    private static final long serialVersionUID = -234353532381003789L;
    private final RowMeta rowMeta;
    private final Map<String, Integer> ordMeasureMap;

    public RecalculateMeaReduceGroupFunc(RowMeta rowMeta, Map<String, Integer> ordMeasureMap) {
        this.rowMeta = rowMeta;
        this.ordMeasureMap = ordMeasureMap;
    }

    public void reduce(Iterator<Row> iterator, Collector collector) {
        HashMap<String, BigDecimal> summaryMap = new HashMap<String, BigDecimal>(this.ordMeasureMap.size());
        int collectStatusIndex = 1;
        Row summaryRow = null;
        while (iterator.hasNext()) {
            Row row = iterator.next();
            String collectStatus = row.getString(collectStatusIndex);
            if (FAFCollectStatusEnum.COLLECT.getCodeString().equals(collectStatus)) {
                summaryRow = row;
                continue;
            }
            Object[] detailObj = new Object[this.rowMeta.getFieldCount()];
            for (int i = 0; i < this.rowMeta.getFieldCount(); ++i) {
                Object value;
                detailObj[i] = value = row.get(i);
            }
            for (Map.Entry<String, Integer> entry : this.ordMeasureMap.entrySet()) {
                String measureNumber = entry.getKey();
                Integer measureIndex = entry.getValue();
                BigDecimal detailValue = row.getBigDecimal(measureIndex.intValue()) == null ? BigDecimal.ZERO : row.getBigDecimal(measureIndex.intValue());
                detailObj[measureIndex.intValue()] = row.getBigDecimal(measureIndex.intValue()) == null ? BigDecimal.ZERO : row.getBigDecimal(measureIndex.intValue());
                BigDecimal summaryValue = summaryMap.getOrDefault(measureNumber, BigDecimal.ZERO);
                summaryMap.put(measureNumber, summaryValue.add(detailValue));
            }
            collector.collect(detailObj);
        }
        if (summaryRow != null) {
            Object[] summaryObj = new Object[this.rowMeta.getFieldCount()];
            for (int i = 0; i < this.rowMeta.getFieldCount(); ++i) {
                Object value;
                summaryObj[i] = value = summaryRow.get(i);
            }
            for (Map.Entry<String, Integer> entry : this.ordMeasureMap.entrySet()) {
                String measureNumber = entry.getKey();
                Integer measureIndex = entry.getValue();
                BigDecimal summaryValue = summaryMap.getOrDefault(measureNumber, BigDecimal.ZERO);
                if (summaryValue.compareTo(BigDecimal.ZERO) == 0) {
                    summaryValue = (BigDecimal)summaryRow.get(measureNumber);
                }
                summaryObj[measureIndex.intValue()] = summaryValue;
            }
            collector.collect(summaryObj);
        }
    }

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }
}

