/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.datasource;

import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.LargeTextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.faf.absplugin.SafeAbstractFormPlugin;
import kd.macc.faf.datasource.DatasourceSelectMemberDialogPlugin;
import kd.macc.faf.datasource.dto.DimensionFetchScope;
import kd.macc.faf.datasource.dto.LoadMemberDTO;
import kd.macc.faf.enums.DataSourceTypeEnum;

public class DatasourceConfigApiEdit
extends SafeAbstractFormPlugin
implements BeforeF7SelectListener {
    public static final String F_PARAMSRC = "paramsrc";
    private static final String ENTRY_FILTER_API = "entryentityfilterapi";
    private static final String F_E_DIMENSION = "bcmdimension";
    private static final String F_E_textfilter = "textfilter";
    private static final String ACTIONID_BCM_SELECTMEMBER = "bcmselectmember";

    public void initialize() {
        super.initialize();
        this.getView().addCustomControls(new String[]{F_E_textfilter});
    }

    @Override
    public void onGetControl(OnGetControlArgs e) {
        String key = e.getKey();
        if (F_E_textfilter.equals(key)) {
            LargeTextEdit control = new LargeTextEdit(){

                public void detailClick(Map<String, Object> args) {
                    DatasourceConfigApiEdit.this.jumpToQFilterSettingDialog();
                }
            };
            control.setKey(F_E_textfilter);
            control.setModel(this.getModel());
            control.setView(this.getView());
            e.setControl((Control)control);
        }
    }

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"advcontoolbarapapi"});
        BasedataEdit fieldgroupEdit = (BasedataEdit)this.getView().getControl(F_E_DIMENSION);
        fieldgroupEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    @Override
    public void afterBindDataSafe(EventObject e) {
        Map<String, Object> settingMap;
        if (this.isApiBCM() && (settingMap = this.getParamsSettingMap()) != null) {
            this.getPageCache().put("bcmsystemfilter", String.valueOf(settingMap.getOrDefault("system", "")));
            DynamicObjectCollection entry = (DynamicObjectCollection)this.getModel().getValue(ENTRY_FILTER_API);
            if (entry.isEmpty()) {
                this.autoSetScenario();
            }
        }
    }

    @Override
    public void propertyChangedSafe(PropertyChangedArgs e) {
        String propName = e.getProperty().getName();
        if (StringUtils.equals((CharSequence)"paramsrc_tag", (CharSequence)propName) || StringUtils.equals((CharSequence)"synctype", (CharSequence)propName)) {
            if (this.isBCM()) {
                String oldVal;
                QFilter systemQFilter = this.getSystemQFilter();
                if (systemQFilter == null) {
                    this.clearBCMFilterSetting();
                    return;
                }
                String newVal = String.valueOf(systemQFilter.getValue());
                if (!StringUtils.equals((CharSequence)newVal, (CharSequence)(oldVal = this.getPageCache().get("bcmsystemfilter")))) {
                    this.autoSetScenario();
                    this.getPageCache().put("bcmsystemfilter", newVal);
                }
            } else {
                this.clearBCMFilterSetting();
            }
        } else if (StringUtils.equals((CharSequence)F_E_DIMENSION, (CharSequence)propName)) {
            int rowIndex = this.getModel().getEntryCurrentRowIndex(ENTRY_FILTER_API);
            this.getModel().setValue(F_E_textfilter, (Object)"", rowIndex);
            this.getModel().setValue("textfilter_tag", (Object)"", rowIndex);
        }
    }

    @Override
    public void beforeItemClickSafe(BeforeItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if ("baritemadd".equals(itemKey)) {
            Map<String, Object> settingMap = this.getParamsSettingMap();
            if (settingMap == null) {
                evt.setCancel(true);
            }
        } else if ("baritemdel".equals(itemKey)) {
            int rowIndex = this.getModel().getEntryCurrentRowIndex(ENTRY_FILTER_API);
            DynamicObject dimension = (DynamicObject)this.getModel().getValue(F_E_DIMENSION, rowIndex);
            if (dimension != null && StringUtils.equals((CharSequence)"Scenario", (CharSequence)dimension.getString("number"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u60c5\u666f\u7ef4\u5ea6\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"DatasourceConfigApiEdit_0", (String)"macc-faf-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String key = evt.getProperty().getName();
        if (key.equals(F_E_DIMENSION)) {
            QFilter systemQFilter = this.getSystemQFilter();
            if (systemQFilter == null) {
                return;
            }
            evt.addCustomQFilter(systemQFilter);
            List<Object> alreadySet = this.getDimensionSettingIds();
            evt.addCustomQFilter(new QFilter("id", "not in", alreadySet));
            evt.addCustomQFilter(new QFilter("number", "not in", Arrays.asList("Entity", "Period", "Year", "Scenario")));
        }
    }

    @Override
    public void closedCallBackSafe(ClosedCallBackEvent e) {
        String actionId = e.getActionId();
        if (ACTIONID_BCM_SELECTMEMBER.equals(actionId) && e.getReturnData() != null) {
            int rowIndex = this.getModel().getEntryCurrentRowIndex(ENTRY_FILTER_API);
            IDataModel model = this.getModel();
            DimensionFetchScope scope = (DimensionFetchScope)e.getReturnData();
            model.setValue(F_E_textfilter, (Object)scope.toDescText(), rowIndex);
            model.setValue("textfilter_tag", (Object)scope.toTagText(), rowIndex);
        }
    }

    private boolean isApiBCM() {
        String datasourceType = (String)this.getModel().getValue("datasource_type");
        boolean synctype = (Boolean)this.getModel().getValue("synctype");
        return DataSourceTypeEnum.BCM.getCode().equals(datasourceType) && synctype;
    }

    private boolean isBCM() {
        String datasourceType = (String)this.getModel().getValue("datasource_type");
        return DataSourceTypeEnum.BCM.getCode().equals(datasourceType);
    }

    private void autoSetScenario() {
        QFilter systemQFilter = this.getSystemQFilter();
        if (systemQFilter == null) {
            return;
        }
        QFilter qfilter = systemQFilter.and(new QFilter("number", "=", (Object)"Scenario"));
        List ids = QueryServiceHelper.queryPrimaryKeys((String)"bcm_dimension", (QFilter[])qfilter.toArray(), null, (int)2);
        if (ids.size() == 1) {
            IDataModel model = this.getModel();
            model.deleteEntryData(ENTRY_FILTER_API);
            int currentRow = model.createNewEntryRow(ENTRY_FILTER_API);
            model.setValue(F_E_DIMENSION, ids.get(0), currentRow);
            this.getView().updateView(ENTRY_FILTER_API);
        }
    }

    private void clearBCMFilterSetting() {
        this.getPageCache().remove("bcmsystemfilter");
        IDataModel model = this.getModel();
        model.deleteEntryData(ENTRY_FILTER_API);
        this.getView().updateView(ENTRY_FILTER_API);
    }

    private QFilter getSystemQFilter() {
        Map<String, Object> settingMap = this.getParamsSettingMap();
        if (settingMap == null) {
            return null;
        }
        return new QFilter("model", "=", settingMap.getOrDefault("system", ""));
    }

    private Map<String, Object> getParamsSettingMap() {
        String setting = (String)this.getModel().getValue("paramsrc_tag");
        if (ObjectUtils.isEmpty((Object)setting)) {
            String tip = ResManager.loadKDString((String)"\u8bf7\u5148\u8fdb\u884c\u53c2\u6570\u8bbe\u7f6e\u3002", (String)"DatasourceConfigApiEdit_1", (String)"macc-faf-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(tip);
            return null;
        }
        return (Map)SerializationUtils.fromJsonString((String)setting, Map.class);
    }

    private List<Object> getDimensionSettingIds() {
        DynamicObjectCollection entrys = this.getModel().getEntryEntity(ENTRY_FILTER_API);
        return entrys.stream().map(dynamicObject -> dynamicObject.get("bcmdimension_id")).collect(Collectors.toList());
    }

    private void jumpToQFilterSettingDialog() {
        Map<String, Object> settingMap = this.getParamsSettingMap();
        if (settingMap == null) {
            return;
        }
        int rowIndex = this.getModel().getEntryCurrentRowIndex(ENTRY_FILTER_API);
        DynamicObject bcmDimension = (DynamicObject)this.getModel().getValue(F_E_DIMENSION, rowIndex);
        if (bcmDimension == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7ef4\u5ea6\u3002", (String)"DatasourceConfigApiEdit_2", (String)"macc-faf-formplugin", (Object[])new Object[0]));
            return;
        }
        LoadMemberDTO dto = new LoadMemberDTO();
        dto.setModelId((Long)settingMap.get("system"));
        dto.setDimId(Long.valueOf(bcmDimension.getLong("id")));
        dto.setDimNumber(bcmDimension.getString("number"));
        dto.setDimName(bcmDimension.getString("name"));
        dto.setDimEntityName(bcmDimension.getString("membermodel"));
        dto.setScope(String.valueOf(this.getModel().getValue("textfilter_tag", rowIndex)));
        Object orgview = settingMap.getOrDefault("orgview", null);
        if (orgview instanceof Long) {
            dto.setOrgViewId((Long)orgview);
        }
        DatasourceSelectMemberDialogPlugin.openBy((AbstractFormPlugin)this, ACTIONID_BCM_SELECTMEMBER, dto);
    }
}

