/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.datasource;

import java.util.EventObject;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.macc.faf.absplugin.SafeAbstractFormPlugin;
import kd.macc.faf.common.FAFUtils;
import kd.macc.faf.datasource.DatasourceServiceHelper;
import kd.macc.faf.datasource.TreeAPSearchFocus;
import kd.macc.faf.datasource.dto.DimensionFetchScope;
import kd.macc.faf.datasource.dto.LoadMemberDTO;
import kd.macc.faf.datasource.dto.MemberScope;
import kd.macc.faf.exception.BizTipException;
import kd.macc.faf.olap.OlapServerDimMemberMetaInfo;

public class DatasourceSelectMemberDialogPlugin
extends SafeAbstractFormPlugin {
    private static final String FORMID = "faf_bcmselectmemberdialog";
    private static final String ENTRY_ENTITY = "entryentity";
    private TreeAPSearchFocus treeAPSearchFocus;

    public void initialize() {
        super.initialize();
        this.treeAPSearchFocus = new TreeAPSearchFocus(this.getView());
    }

    public void registerListener(EventObject evt) {
        this.addClickListeners(new String[]{"btnok"});
        this.addClickListeners(new String[]{"moveright", "moverightall", "moveleft", "moveleftall", "imageup", "imagedown"});
        this.treeAPSearchFocus.registerListener();
    }

    @Override
    public void afterCreateNewDataSafe(EventObject e) {
        this.intiView(this.getSelectMemberDTO());
    }

    @Override
    public void clickSafe(EventObject evt) {
        String key;
        Control Control2 = (Control)evt.getSource();
        switch (key = Control2.getKey()) {
            case "moveright": {
                this.moveRight(false);
                break;
            }
            case "moverightall": {
                this.moveRight(true);
                break;
            }
            case "moveleft": {
                this.moveLeft(false);
                break;
            }
            case "moveleftall": {
                this.moveLeft(true);
                break;
            }
            case "btnok": {
                this.btnOk();
                break;
            }
            case "imageup": 
            case "imagedown": {
                this.treeAPSearchFocus.click(evt);
            }
        }
    }

    private void intiView(LoadMemberDTO dto) {
        Long orgViewId = dto.getOrgViewId();
        this.getModel().setValue("cslscheme", (Object)orgViewId);
        this.getModel().setValue("dimNumber", (Object)dto.getDimNumber());
        Map treedata = DatasourceServiceHelper.loadDimensionMembers((LoadMemberDTO)dto);
        Map<String, TreeNode> nodeMap = treedata.values().stream().map(this::buildTreeNode).collect(Collectors.toMap(TreeNode::getId, treeNode -> treeNode));
        this.treeAPSearchFocus.initTree(nodeMap);
        String scope = dto.getScope();
        if (StringUtils.isNotEmpty((CharSequence)scope)) {
            DimensionFetchScope fetchScope = (DimensionFetchScope)SerializationUtils.fromJsonString((String)scope, DimensionFetchScope.class);
            List members = fetchScope.getMembers();
            if (members.isEmpty()) {
                return;
            }
            int index = 0;
            this.getModel().beginInit();
            int[] rows = this.getModel().batchCreateNewEntryRow(ENTRY_ENTITY, members.size());
            for (MemberScope memberScope : members) {
                this.getModel().setValue("number", (Object)memberScope.getNumber(), rows[index]);
                this.getModel().setValue("name", (Object)memberScope.getName(), rows[index]);
                this.getModel().setValue("scope", (Object)memberScope.getScope(), rows[index]);
                this.getModel().setValue("id", (Object)memberScope.getId(), rows[index]);
                this.getModel().setValue("parent", (Object)memberScope.getParent(), rows[index]);
                ++index;
            }
            this.getModel().endInit();
            this.getView().updateView(ENTRY_ENTITY);
        }
    }

    protected TreeNode buildTreeNode(OlapServerDimMemberMetaInfo meta) {
        TreeNode node = new TreeNode();
        node.setId(String.valueOf(meta.getId()));
        node.setParentid(String.valueOf(meta.getParent()));
        node.setText(meta.getNumber() + " " + meta.getName());
        LinkedHashMap<String, Object> data = new LinkedHashMap<String, Object>();
        data.put("number", meta.getNumber());
        data.put("name", meta.getName());
        data.put("longnumber", meta.getLongNumber());
        data.put("id", meta.getId());
        data.put("parent", meta.getParent());
        node.setData(data);
        return node;
    }

    private void moveLeft(boolean all) {
        if (all) {
            this.getModel().deleteEntryData(ENTRY_ENTITY);
        } else {
            EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRY_ENTITY);
            int[] selectRows = entryGrid.getSelectRows();
            if (selectRows.length == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u64cd\u4f5c\u6570\u636e\u884c\u3002", (String)"DatasourceSelectMemberDialogPlugin_0", (String)"macc-faf-formplugin", (Object[])new Object[0]));
                return;
            }
            this.getModel().deleteEntryRows(ENTRY_ENTITY, selectRows);
        }
    }

    private void moveRight(boolean all) {
        List<TreeNode> selectedNodes = this.treeAPSearchFocus.getSelectedNodes(all);
        List<TreeNode> newselectedNodes = this.excludeSelected(selectedNodes);
        if (newselectedNodes.isEmpty()) {
            return;
        }
        int index = 0;
        this.getModel().beginInit();
        int[] rows = this.getModel().batchCreateNewEntryRow(ENTRY_ENTITY, newselectedNodes.size());
        for (TreeNode selectedNode : newselectedNodes) {
            Map data = (Map)selectedNode.getData();
            this.getModel().setValue("number", data.get("number"), rows[index]);
            this.getModel().setValue("name", data.get("name"), rows[index]);
            this.getModel().setValue("id", data.get("id"), rows[index]);
            this.getModel().setValue("parent", data.get("parent"), rows[index]);
            ++index;
        }
        this.getModel().endInit();
        this.getView().updateView(ENTRY_ENTITY);
    }

    private List<TreeNode> excludeSelected(List<TreeNode> selectedNodes) {
        DynamicObjectCollection selected = this.getModel().getEntryEntity(ENTRY_ENTITY);
        Set selectedIds = selected.stream().map(dynamicObject -> dynamicObject.getString("id")).collect(Collectors.toSet());
        String dimNumber = this.getSelectMemberDTO().getDimNumber();
        return selectedNodes.stream().filter(treeNode -> !selectedIds.contains(treeNode.getId())).filter(treeNode -> {
            Map data = (Map)FAFUtils.cast((Object)treeNode.getData());
            return !StringUtils.equals((CharSequence)dimNumber, (CharSequence)((CharSequence)data.get("number")));
        }).collect(Collectors.toList());
    }

    private void btnOk() {
        DynamicObjectCollection selected = this.getModel().getEntryEntity(ENTRY_ENTITY);
        String dimNumber = (String)this.getModel().getValue("dimNumber");
        if (StringUtils.equals((CharSequence)"Scenario", (CharSequence)dimNumber) && selected.size() == 0) {
            throw new BizTipException(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u60c5\u666f\u7ef4\u5ea6\u7684\u53d6\u6570\u8303\u56f4\u3002", (String)"DatasourceSelectMemberDialogPlugin_1", (String)"macc-faf-formplugin", (Object[])new Object[0]));
        }
        DimensionFetchScope scope = DatasourceServiceHelper.buildMemberFetchScope((LoadMemberDTO)this.getSelectMemberDTO(), (DynamicObjectCollection)selected);
        this.getView().returnDataToParent((Object)scope);
        this.getView().close();
    }

    private LoadMemberDTO getSelectMemberDTO() {
        FormShowParameter fsp = this.getView().getFormShowParameter();
        String params = (String)fsp.getCustomParam("selectMemberParams");
        return (LoadMemberDTO)SerializationUtils.fromJsonString((String)params, LoadMemberDTO.class);
    }

    public static void openBy(AbstractFormPlugin plugin, String actionId, LoadMemberDTO dto) {
        FormShowParameter fsp = new FormShowParameter();
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setFormId(FORMID);
        fsp.setCaption(ResManager.loadKDString((String)"\u53d6\u6570\u8303\u56f4\u8bbe\u7f6e", (String)"DatasourceSelectMemberDialogPlugin_2", (String)"macc-faf-formplugin", (Object[])new Object[0]));
        fsp.setCustomParam("selectMemberParams", (Object)SerializationUtils.toJsonString((Object)dto));
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, actionId));
        plugin.getView().showForm(fsp);
    }
}

