/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.datasource;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.entity.operate.SaveAndNew;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.mvc.base.BaseModel;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataRefrenceHelper;
import kd.macc.faf.absplugin.SafeAbstractFormPlugin;
import kd.macc.faf.common.ChangeDataDTO;
import kd.macc.faf.enums.DataSourceTypeEnum;
import kd.macc.faf.helper.EntityMetaHelper;

public class FAFDatasourceConfigEdit
extends SafeAbstractFormPlugin {
    private static final String FIELD_DATASOURCE_TYPE = "datasource_type";
    private static final String FIELD_ENTITY_NUMBER = "entity_number";
    private static final String FIELD_ACCOUNTBOOKSTYPE = "accountbookstype";
    private static final String FIELD_ENTITYFILTER_TAG = "entityfilter_tag";
    private static final String CTRL_FILTERGRIDAP = "filtergridap";
    private static final String CALLBACKID_changedata = "callbackid_changedata";
    private final String[] baseinfo = new String[]{"number", "datasource_type", "entity_number", "accountbookstype", "paramsrcname", "paramsrc"};

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        Object eSource = e.getSource();
        if (eSource instanceof BaseModel) {
            ((BaseModel)eSource).getDataEntity().set("issystem", (Object)"0");
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        FilterGrid filterGrid = (FilterGrid)this.getControl(CTRL_FILTERGRIDAP);
        DynamicObject dataEntity = (DynamicObject)this.getModel().getValue(FIELD_ENTITY_NUMBER);
        String dataType = (String)this.getModel().getValue(FIELD_DATASOURCE_TYPE);
        if (dataEntity != null) {
            if ("4".equals(dataType)) {
                this.setInitFilterGridCondition();
            } else {
                filterGrid.setEntityNumber(dataEntity.getString("number"));
            }
        }
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.lockCtrls();
        String filterJson = this.getModel().getDataEntity().getString(FIELD_ENTITYFILTER_TAG);
        if (StringUtils.isNotBlank((CharSequence)filterJson)) {
            FilterGrid filterGrid = (FilterGrid)this.getControl(CTRL_FILTERGRIDAP);
            FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filterJson, FilterCondition.class);
            filterGrid.SetValue(filterCondition);
        }
        this.setCtrlMustInput();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        String operateKey = source.getOperateKey();
        String datasourceType = (String)this.getModel().getValue(FIELD_DATASOURCE_TYPE);
        DataSourceTypeEnum anEnum = DataSourceTypeEnum.getEnum((String)datasourceType);
        if ("save".equals(operateKey) && anEnum != DataSourceTypeEnum.BCM && anEnum != DataSourceTypeEnum.EPM) {
            boolean success = this.prepareFields();
            args.setCancel(!success);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        OperationResult operationResult = args.getOperationResult();
        if (args.getSource() instanceof SaveAndNew && operationResult.isSuccess()) {
            this.unlockCtrls();
        }
    }

    @Override
    public void propertyChangedSafe(PropertyChangedArgs e) {
        String propName = e.getProperty().getName();
        ChangeDataDTO dto = new ChangeDataDTO(e.getProperty().getName(), e.getChangeSet());
        if (FIELD_DATASOURCE_TYPE.equals(propName)) {
            this.getModel().setValue("paramsrcname", null);
            this.getModel().setValue("paramsrc", null);
            this.getModel().setValue("paramsrc_tag", null);
            this.getModel().deleteEntryData("entryentity");
            FilterGrid filterGrid = (FilterGrid)this.getView().getControl(CTRL_FILTERGRIDAP);
            List filterRow = filterGrid.getFilterGridState().getFilterCondition().getFilterRow();
            if (CollectionUtils.isEmpty((Collection)filterRow)) {
                this.setCtrlMustInput();
                this.ctrlField((String)dto.getNewValue());
                this.resetCommonFilterControl();
                return;
            }
            ConfirmCallBackListener listener = new ConfirmCallBackListener(CALLBACKID_changedata, (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u66f4\u6539\u6570\u636e\u6765\u6e90\u5c06\u6e05\u7a7a\u5df2\u586b\u7684\u53c2\u6570\u914d\u7f6e\uff0c\u662f\u5426\u786e\u8ba4\uff1f", (String)"FAFDatasourceConfigEdit_0", (String)"macc-faf-formplugin", (Object[])new Object[0]), null, MessageBoxOptions.YesNo, ConfirmTypes.Default, listener, null, SerializationUtils.toJsonString((Object)dto));
        } else if (FIELD_ENTITY_NUMBER.equals(dto.getPropName())) {
            FilterGrid filterGrid = (FilterGrid)this.getView().getControl(CTRL_FILTERGRIDAP);
            List filterRow = filterGrid.getFilterGridState().getFilterCondition().getFilterRow();
            if (CollectionUtils.isEmpty((Collection)filterRow)) {
                this.setCtrlMustInput();
                this.resetCommonFilterControl();
                return;
            }
            ConfirmCallBackListener listener = new ConfirmCallBackListener(CALLBACKID_changedata, (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u66f4\u6539\u5b9e\u4f53\u5bf9\u8c61\u5c06\u6e05\u7a7a\u5df2\u586b\u7684\u53c2\u6570\u914d\u7f6e\uff0c\u662f\u5426\u786e\u8ba4\uff1f", (String)"FAFDatasourceConfigEdit_1", (String)"macc-faf-formplugin", (Object[])new Object[0]), null, MessageBoxOptions.YesNo, ConfirmTypes.Default, listener, null, SerializationUtils.toJsonString((Object)new ChangeDataDTO(propName, e.getChangeSet())));
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        String callBackId = event.getCallBackId();
        if (CALLBACKID_changedata.equals(callBackId)) {
            String customVaule = event.getCustomVaule();
            ChangeDataDTO dto = (ChangeDataDTO)SerializationUtils.fromJsonString((String)customVaule, ChangeDataDTO.class);
            MessageBoxResult result = event.getResult();
            if (MessageBoxResult.Yes.equals((Object)result)) {
                this.getModel().beginInit();
                if (FIELD_DATASOURCE_TYPE.equals(dto.getPropName())) {
                    this.setCtrlMustInput();
                    this.ctrlField((String)dto.getNewValue());
                    this.resetCommonFilterControl();
                } else if (FIELD_ENTITY_NUMBER.equals(dto.getPropName())) {
                    this.setCtrlMustInput();
                    this.resetCommonFilterControl();
                }
                this.getModel().endInit();
            } else if (MessageBoxResult.No.equals((Object)result)) {
                this.getModel().beginInit();
                Object oldValue = dto.getOldValue();
                if (oldValue instanceof Map) {
                    this.getModel().setValue(dto.getPropName(), ((Map)oldValue).get("id"));
                } else {
                    this.getModel().setValue(dto.getPropName(), oldValue);
                }
                this.getModel().endInit();
            }
            this.getView().updateView();
        }
    }

    private void resetCommonFilterControl() {
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl(CTRL_FILTERGRIDAP);
        filterGrid.SetValue(new FilterCondition());
        this.getModel().setValue(FIELD_ENTITYFILTER_TAG, null);
        Object entityObject = this.getModel().getValue(FIELD_ENTITY_NUMBER);
        String dataType = (String)this.getModel().getValue(FIELD_DATASOURCE_TYPE);
        if (entityObject instanceof DynamicObject) {
            if ("4".equals(dataType)) {
                this.setInitFilterGridCondition();
            } else {
                filterGrid.setEntityNumber(((DynamicObject)entityObject).getString("number"));
            }
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap"});
        }
        this.getView().updateView(CTRL_FILTERGRIDAP);
    }

    private boolean prepareFields() {
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl(CTRL_FILTERGRIDAP);
        FilterGrid.FilterGridState filterGridState = filterGrid.getFilterGridState();
        FilterCondition filterCondition = filterGridState.getFilterCondition();
        DynamicObject entityObject = (DynamicObject)this.getModel().getValue(FIELD_ENTITY_NUMBER);
        String number = entityObject.getString("number");
        Set flexProperties = EntityMetaHelper.matchFlexPropertyWithoutParent((String)number);
        List filterRows = filterCondition.getFilterRow();
        for (SimpleFilterRow simpleFilterRow : filterRows) {
            String fieldName = simpleFilterRow.getFieldName();
            if (!flexProperties.contains(fieldName)) continue;
            Map filterColumn = filterGrid.getFilterColumns().stream().filter(column -> column.get("fieldName").equals(fieldName)).collect(Collectors.toList()).stream().findFirst().orElseGet(Collections::emptyMap);
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u53c2\u6570\u914d\u7f6e\u4e0d\u652f\u6301\u5f39\u6027\u57df\u7c7b\u578b\u7684\u5b57\u6bb5\uff1a%s\u3002", (String)"FAFDatasourceConfigEdit_2", (String)"macc-faf-formplugin", (Object[])new Object[0]), filterColumn.get("fieldCaption")));
            return false;
        }
        String dataType = (String)this.getModel().getValue(FIELD_DATASOURCE_TYPE);
        if ("4".equals(dataType)) {
            number = "bd_accountview";
        }
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)number);
        FilterBuilder filterBuilder = new FilterBuilder(entityType, filterCondition);
        filterBuilder.buildFilter(false);
        String conditionJson = SerializationUtils.toJsonString((Object)filterCondition);
        this.getModel().setValue(FIELD_ENTITYFILTER_TAG, (Object)conditionJson);
        return true;
    }

    private void setCtrlMustInput() {
        Object value = this.getModel().getValue(FIELD_DATASOURCE_TYPE);
        if (value == null) {
            return;
        }
        Object vEntity = this.getModel().getValue(FIELD_ENTITY_NUMBER);
        String entityNumber = vEntity instanceof DynamicObject ? ((DynamicObject)vEntity).getString("number") : " ";
        ((FieldEdit)this.getControl(FIELD_ENTITY_NUMBER)).setMustInput("1".equals(value) || "2".equals(value) || "3".equals(value) || "4".equals(value));
        ((FieldEdit)this.getControl(FIELD_ACCOUNTBOOKSTYPE)).setMustInput("1".equals(value) || "2".equals(value) || "4".equals(value) || "gl_balance".equals(entityNumber));
        DataSourceTypeEnum anEnum = DataSourceTypeEnum.getEnum((String)((String)value));
        if (anEnum == DataSourceTypeEnum.BCM || anEnum == DataSourceTypeEnum.EPM) {
            ((FieldEdit)this.getControl("paramsrcname")).setMustInput(true);
            ((FieldEdit)this.getControl(FIELD_ENTITY_NUMBER)).setMustInput(false);
        } else {
            ((FieldEdit)this.getControl("paramsrcname")).setMustInput(false);
        }
    }

    private void ctrlField(String entityType) {
        switch (entityType) {
            case "1": {
                this.getModel().setValue(FIELD_ENTITY_NUMBER, (Object)"ai_bizvoucher");
                this.getModel().setValue(FIELD_ACCOUNTBOOKSTYPE, null);
                break;
            }
            case "2": {
                this.getModel().setValue(FIELD_ENTITY_NUMBER, (Object)"gl_voucher");
                this.getModel().setValue(FIELD_ACCOUNTBOOKSTYPE, null);
                break;
            }
            case "3": 
            case "5": 
            case "6": {
                this.getModel().setValue(FIELD_ENTITY_NUMBER, null);
                this.getModel().setValue(FIELD_ACCOUNTBOOKSTYPE, null);
                break;
            }
            case "4": {
                this.getModel().setValue(FIELD_ENTITY_NUMBER, (Object)"gl_balance");
                this.getModel().setValue(FIELD_ACCOUNTBOOKSTYPE, null);
                break;
            }
            case "7": {
                this.getModel().setValue(FIELD_ENTITY_NUMBER, (Object)"im_inv_periodbalance");
                this.getModel().setValue(FIELD_ACCOUNTBOOKSTYPE, null);
            }
        }
    }

    private void lockCtrls() {
        Long id = (Long)this.getModel().getValue("id");
        if (id != 0L && BaseDataRefrenceHelper.isRefrenced((String)"pa_datasourceconfig", (Object)id)) {
            this.getView().setEnable(Boolean.FALSE, this.baseinfo);
        }
    }

    private void unlockCtrls() {
        this.getView().setEnable(Boolean.TRUE, this.baseinfo);
    }

    private void setInitFilterGridCondition() {
        FilterGrid filterGrid = (FilterGrid)this.getControl(CTRL_FILTERGRIDAP);
        filterGrid.setEntityNumber("bd_accountview");
        LinkedHashMap<String, Map> colMap = new LinkedHashMap<String, Map>(10);
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)"bd_accountview");
        List allFilterColumns = new EntityTypeUtil().getFilterColumns((IDataEntityType)entityType);
        for (Map fc : allFilterColumns) {
            String fieldName = String.valueOf(fc.get("fieldName"));
            String fieldCaption = (String)fc.get("fieldCaption");
            fc.put("fieldCaption", String.format(ResManager.loadKDString((String)"\u4f1a\u8ba1\u79d1\u76ee.%s", (String)"FAFDatasourceConfigEdit_3", (String)"macc-faf-formplugin", (Object[])new Object[0]), fieldCaption));
            colMap.put(fieldName, fc);
        }
        filterGrid.setFilterColumns(new ArrayList(colMap.values()));
        String conditionJson = (String)this.getView().getFormShowParameter().getCustomParam("conditionJson");
        if (StringUtils.isNotBlank((CharSequence)conditionJson)) {
            FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)conditionJson, FilterCondition.class);
            filterGrid.SetValue(filterCondition);
        }
        this.getView().updateView(CTRL_FILTERGRIDAP);
    }
}

