/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.datasource;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.macc.faf.enums.DataSourceTypeEnum;
import kd.macc.faf.enums.OlapFromServiceEnum;
import kd.macc.faf.olap.driver.OlapRequestParam;
import kd.macc.faf.olap.driver.ParamBuilder;
import kd.macc.faf.olap.driver.bcm.BcmOlapRequest;
import kd.macc.faf.param.FAFDimensionSingleSelect;
import kd.macc.faf.param.FAFF7Return;
import kd.macc.faf.param.FAFF7Util;
import kd.macc.faf.param.FAFMemberSelect;
import kd.macc.faf.param.FAFParamTemplateHelper;

public class FAFDatasourceConfigEditOlap
extends AbstractFormPlugin {
    private static final String FIELD_DATASOURCE_TYPE = "datasource_type";
    private static final String FIELD_DIMENSIONVAL = "dimensionval";
    public static final String PAGETYPE = "pageType";
    public static final String PARAMNUMBER = "paramNumber";
    public static final String PARAMSRC_TAG = "paramsrc_tag";
    public static final String PARAMSRCNAME = "paramsrcname";
    private static final String FIELD_DIMENSION = "dimensionfield";
    private static final String FIELD_DIMENSIONTEXT = "dimensiontext";
    private static final String FIELD_DIMENSIONTEXT_TAG = "dimensiontext_tag";
    private static final String ENTRY_FILTER = "entryentity";
    private static final String ACTIONID_PARAMSRC = "paramsrcselected";
    private static final String ACTIONID_MEBER = "memberSelected";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{PARAMSRCNAME, FIELD_DIMENSIONVAL, FIELD_DIMENSION});
        this.addItemClickListeners(new String[]{"advcontoolbarap1"});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initParamSrcName();
    }

    private void initParamSrcName() {
        String dataSrcType = (String)this.getModel().getValue(FIELD_DATASOURCE_TYPE);
        String param = (String)this.getModel().getValue(PARAMSRC_TAG);
        if (StringUtils.isEmpty((CharSequence)param)) {
            return;
        }
        DynamicObject entityLoad = FAFParamTemplateHelper.getParamDynamic(dataSrcType);
        if (StringUtils.isNotBlank((CharSequence)param) && entityLoad != null) {
            Map paramMap = (Map)JSON.parseObject((String)param, (TypeReference)new TypeReference<Map<String, Object>>(){}, (Feature[])new Feature[0]);
            DynamicObjectCollection entryEntity = entityLoad.getDynamicObjectCollection(ENTRY_FILTER);
            String paramSrcName = entryEntity.stream().map(entry -> {
                DynamicObject dynamicObject;
                String paramNum = entry.getString("paramnumber");
                DynamicObject objectType = entry.getDynamicObject("objecttype");
                Object pkId = paramMap.get(paramNum);
                if (objectType != null && pkId != null && (dynamicObject = BusinessDataServiceHelper.loadSingleFromCache(pkId, (String)objectType.getString("number"))) != null) {
                    return dynamicObject.getString("name");
                }
                return "";
            }).filter(StringUtils::isNotBlank).collect(Collectors.joining(","));
            this.getModel().setValue(PARAMSRCNAME, (Object)(paramSrcName.length() > 1024 ? paramSrcName.substring(0, 1024) : paramSrcName));
            this.getModel().setDataChanged(false);
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String param;
        String itemKey = evt.getItemKey();
        if ("advconbaritemap".equals(itemKey) && StringUtils.isEmpty((CharSequence)(param = this.getParamsSetting()))) {
            evt.setCancel(true);
        }
    }

    public void click(EventObject evt) {
        String key;
        Control ctl = (Control)evt.getSource();
        switch (key = ctl.getKey()) {
            case "paramsrcname": {
                this.openParamSrc();
                break;
            }
            case "dimensionfield": {
                this.openDimensionF7();
                break;
            }
            case "dimensionval": {
                this.openMemberF7();
                break;
            }
        }
    }

    private void openDimensionF7() {
        String param = this.getParamsSetting();
        if (StringUtils.isEmpty((CharSequence)param)) {
            return;
        }
        int i = this.getModel().getEntryCurrentRowIndex(ENTRY_FILTER);
        Long dimensionid = (Long)this.getModel().getValue("dimensionid", i);
        DynamicObjectCollection entryentity = this.getModel().getEntryEntity(ENTRY_FILTER);
        HashSet<Long> existDimId = new HashSet<Long>(entryentity.size());
        for (DynamicObject dynamicObject : entryentity) {
            long dimensionid1 = dynamicObject.getLong("dimensionid");
            if (dimensionid1 == dimensionid) continue;
            existDimId.add(dimensionid1);
        }
        String datasourceType = (String)this.getModel().getValue(FIELD_DATASOURCE_TYPE);
        OlapFromServiceEnum anEnum = OlapFromServiceEnum.getEnum((String)datasourceType);
        FAFDimensionSingleSelect.openF7(this, anEnum, param, existDimId, "dimreturn");
    }

    private void openMemberF7() {
        String param = this.getParamsSetting();
        if (StringUtils.isEmpty((CharSequence)param)) {
            return;
        }
        int i = this.getModel().getEntryCurrentRowIndex(ENTRY_FILTER);
        String dimensionNumber = (String)this.getModel().getValue("dimensionnum", i);
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)dimensionNumber)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7ef4\u5ea6\u5b57\u6bb5\u3002", (String)"FAFDatasourceConfigEditOlap_1", (String)"macc-faf-formplugin", (Object[])new Object[0]));
            return;
        }
        String dimensionName = (String)this.getModel().getValue(FIELD_DIMENSION, i);
        String dimensionText = (String)this.getModel().getValue(FIELD_DIMENSIONTEXT_TAG, i);
        List datas = (List)JSON.parseObject((String)dimensionText, (TypeReference)new TypeReference<List<FAFF7Return>>(){}, (Feature[])new Feature[0]);
        Set<Long> selectIds = null;
        if (!CollectionUtils.isEmpty((Collection)datas)) {
            selectIds = datas.stream().map(FAFF7Return::getId).collect(Collectors.toSet());
        }
        String datasource_type = (String)this.getModel().getValue(FIELD_DATASOURCE_TYPE);
        OlapFromServiceEnum olapFromServiceEnum = Objects.requireNonNull(OlapFromServiceEnum.getEnum((String)datasource_type));
        OlapRequestParam olapRequestParam = ParamBuilder.getParam((OlapFromServiceEnum)olapFromServiceEnum, (String)param);
        olapRequestParam.setDimNumber(dimensionNumber);
        FAFMemberSelect.openF7(this, olapFromServiceEnum, dimensionName, olapRequestParam, ACTIONID_MEBER, selectIds);
    }

    private void openParamSrc() {
        IDataModel model = this.getModel();
        String dataSrcType = (String)model.getValue(FIELD_DATASOURCE_TYPE);
        if (StringUtils.isBlank((CharSequence)dataSrcType)) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6570\u636e\u6e90\u7c7b\u578b", (String)"FAFDatasourceConfigEditOlap_2", (String)"macc-faf-formplugin", (Object[])new Object[0]));
            return;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(PAGETYPE, "DATASOURCE_FIELD");
        params.put(PARAMSRC_TAG, model.getValue(PARAMSRC_TAG));
        params.put(PARAMNUMBER, dataSrcType);
        DynamicObject entityLoad = FAFParamTemplateHelper.getParamDynamic(dataSrcType);
        if (entityLoad == null) {
            return;
        }
        FAFF7Util f7 = new FAFF7Util(this, ResManager.loadKDString((String)"\u53c2\u6570\u8bbe\u7f6e", (String)"FAFDatasourceConfigEditOlap_3", (String)"macc-faf-formplugin", (Object[])new Object[0]), ACTIONID_PARAMSRC, params);
        f7.open("pa_srcparam_setting");
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        switch (key) {
            case "dimensionfield": {
                int i = this.getModel().getEntryCurrentRowIndex(ENTRY_FILTER);
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)((String)newValue))) {
                    this.getModel().setValue("dimensionid", null, i);
                    this.getModel().setValue("dimensionnum", null, i);
                }
                this.getModel().setValue(FIELD_DIMENSIONVAL, null, i);
                this.getModel().setValue(FIELD_DIMENSIONTEXT, null, i);
                break;
            }
            case "dimensionval": {
                int i = this.getModel().getEntryCurrentRowIndex(ENTRY_FILTER);
                if (!org.apache.commons.lang3.StringUtils.isBlank((CharSequence)((String)newValue))) break;
                this.getModel().setValue(FIELD_DIMENSIONTEXT, null, i);
                this.getModel().setValue(FIELD_DIMENSIONTEXT_TAG, null, i);
                break;
            }
            case "paramsrcname": {
                this.getModel().deleteEntryData(ENTRY_FILTER);
                if (!org.apache.commons.lang3.StringUtils.isBlank((CharSequence)((String)newValue))) break;
                this.getModel().setValue("paramsrc", null);
                this.getModel().setValue(PARAMSRC_TAG, null);
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        IDataModel model = this.getModel();
        Object returnData1 = e.getReturnData();
        if (returnData1 == null) {
            return;
        }
        switch (actionId) {
            case "paramsrcselected": {
                DynamicObjectCollection entryEntity;
                Map returnData = (Map)returnData1;
                String dataSrcType = (String)model.getValue(FIELD_DATASOURCE_TYPE);
                StringBuilder strB = new StringBuilder();
                DynamicObject entityLoad = FAFParamTemplateHelper.getParamDynamic(dataSrcType);
                if (entityLoad != null && (entryEntity = entityLoad.getDynamicObjectCollection(ENTRY_FILTER)) != null && !entryEntity.isEmpty()) {
                    for (DynamicObject entry : entryEntity) {
                        String paramNumber = entry.getString(PARAMNUMBER);
                        String name = (String)returnData.get(paramNumber + "name");
                        if (!StringUtils.isNotBlank((CharSequence)name)) continue;
                        if (strB.length() == 0) {
                            strB.append(name);
                            continue;
                        }
                        strB.append(',').append(name);
                    }
                }
                if (DataSourceTypeEnum.BCM == DataSourceTypeEnum.getEnum((String)dataSrcType)) {
                    BcmOlapRequest bcmOlapRequest = new BcmOlapRequest();
                    String cube = bcmOlapRequest.getModelNumber((Long)returnData.get("system"));
                    returnData.put("cube", cube);
                }
                String paramSrc = SerializationUtils.toJsonString((Object)returnData);
                model.setValue(PARAMSRC_TAG, (Object)paramSrc);
                model.setValue(PARAMSRCNAME, (Object)(strB.length() > 1024 ? strB.substring(0, 1024) : strB));
                break;
            }
            case "memberSelected": {
                if (ObjectUtils.isEmpty((Object)returnData1) || "[]".equals(returnData1)) {
                    return;
                }
                int filterEntryIndex = this.getModel().getEntryCurrentRowIndex(ENTRY_FILTER);
                List datas = (List)JSON.parseObject((String)returnData1.toString(), (TypeReference)new TypeReference<List<FAFF7Return>>(){}, (Feature[])new Feature[0]);
                StringBuilder name = new StringBuilder();
                datas.forEach(dto -> name.append(dto.getName()).append(","));
                String bcmModel = name.substring(0, name.length() - 1);
                String text = JSON.toJSONString((Object)datas);
                this.getModel().setValue(FIELD_DIMENSIONVAL, (Object)(bcmModel.length() > 1024 ? bcmModel.substring(0, 1024) : bcmModel), filterEntryIndex);
                this.getModel().setValue(FIELD_DIMENSIONTEXT, (Object)(text.length() > 255 ? text.substring(0, 255) : text), filterEntryIndex);
                this.getModel().setValue(FIELD_DIMENSIONTEXT_TAG, (Object)text, filterEntryIndex);
                break;
            }
            case "dimreturn": {
                int i = this.getModel().getEntryCurrentRowIndex(ENTRY_FILTER);
                FAFF7Return faff7Return = (FAFF7Return)returnData1;
                this.getModel().setValue(FIELD_DIMENSION, (Object)faff7Return.getName(), i);
                this.getModel().setValue("dimensionid", (Object)faff7Return.getId(), i);
                this.getModel().setValue("dimensionnum", (Object)faff7Return.getNumber(), i);
                break;
            }
        }
    }

    private String getParamsSetting() {
        String param = (String)this.getModel().getValue(PARAMSRC_TAG);
        if (ObjectUtils.isEmpty((Object)param)) {
            Object value = this.getModel().getValue(FIELD_DATASOURCE_TYPE);
            if (DataSourceTypeEnum.BCM.getCode().equals(value) || DataSourceTypeEnum.EPM.getCode().equals(value)) {
                String tip = ResManager.loadKDString((String)"\u8bf7\u5148\u8fdb\u884c\u53c2\u6570\u8bbe\u7f6e\u3002", (String)"FAFDatasourceConfigEditOlap_0", (String)"macc-faf-formplugin", (Object[])new Object[0]);
                this.getView().showTipNotification(tip);
            }
            return "";
        }
        return param;
    }
}

