/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.datasource;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;

public class TreeAPSearchFocus {
    private static final String ROOT_ID = "##rootNode##";
    private static final String focusColor = "#fc8055";
    private static final String CACHE_TREE_ROOT = "treeroot";
    private static final String CACHE_MATCH_NODES = "searchMatchList";
    private static final String CACHE_FOCUS = "focusIndex";
    private final TreeView treeView;
    private final Search search;
    private final IFormView view;

    public TreeAPSearchFocus(IFormView view) {
        this.view = view;
        this.treeView = (TreeView)view.getControl("membertreeap");
        this.search = (Search)view.getControl("searchap");
    }

    public IFormView getView() {
        return this.view;
    }

    public IPageCache getPageCache() {
        return this.view.getPageCache();
    }

    public void registerListener() {
        this.search.addEnterListener(evt -> {
            String text = evt.getText();
            if (text != null && !"".equals(text)) {
                this.search(evt.getText().trim());
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u7f16\u53f7\u6216\u540d\u79f0\u540e\u6309\u56de\u8f66\u952e\u3002", (String)"TreeAPSearchFocus_0", (String)"macc-faf-formplugin", (Object[])new Object[0]));
            }
        });
    }

    public void click(EventObject evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "imageup": 
            case "imagedown": {
                int newfocus;
                String matchNodesText = this.getPageCache().get(CACHE_MATCH_NODES);
                if (StringUtils.isEmpty((CharSequence)matchNodesText)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u641c\u7d22\u9700\u8981\u7684\u5185\u5bb9\u3002", (String)"TreeAPSearchFocus_1", (String)"macc-faf-formplugin", (Object[])new Object[0]));
                    return;
                }
                TreeNode[] matchNodes = (TreeNode[])SerializationUtils.fromJsonString((String)matchNodesText, TreeNode[].class);
                int prefocus = (Integer)SerializationUtils.fromJsonString((String)this.getPageCache().get(CACHE_FOCUS), Integer.class);
                TreeNode preNode = matchNodes[prefocus];
                if ("imageup".equals(key)) {
                    if (0 == prefocus) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u4e2d\u7684\u662f\u7b2c\u4e00\u6761\u5185\u5bb9\u3002", (String)"TreeAPSearchFocus_2", (String)"macc-faf-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    newfocus = prefocus - 1;
                } else {
                    if (matchNodes.length - 1 == prefocus) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u4e2d\u7684\u662f\u6700\u540e\u4e00\u6761\u5185\u5bb9\u3002", (String)"TreeAPSearchFocus_3", (String)"macc-faf-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    newfocus = prefocus + 1;
                }
                preNode.setColor("");
                TreeNode newNode = matchNodes[newfocus];
                newNode.setColor(focusColor);
                TreeNode root = this.getRootTreeNode();
                List childPathNodes = root.getChildPathNodes(newNode.getId());
                for (TreeNode node : childPathNodes) {
                    List children = node.getChildren();
                    if (children == null || children.size() <= 0 || node.isExpend()) continue;
                    node.setIsOpened(true);
                    this.treeView.expand(node.getId());
                }
                this.treeView.focusNode(newNode);
                this.treeView.updateNodes(Arrays.asList(preNode, newNode));
                this.rechecked(root);
                this.getPageCache().put(CACHE_FOCUS, String.valueOf(newfocus));
                this.getPageCache().put(CACHE_TREE_ROOT, SerializationUtils.toJsonString((Object)root));
            }
        }
    }

    private void search(String text) {
        TreeNode root = this.getRootTreeNode();
        ArrayList<TreeNode> matchNodes = new ArrayList<TreeNode>();
        this.getTreeNodeListByText(root, matchNodes, text, 100);
        if (matchNodes.size() > 0) {
            HashSet alltreeNodes = new HashSet(root.getChildPathNodes(((TreeNode)matchNodes.get(0)).getId()));
            for (TreeNode treeNode2 : alltreeNodes) {
                List children = treeNode2.getChildren();
                if (children == null || children.size() <= 0) continue;
                treeNode2.setIsOpened(true);
                this.treeView.expand(treeNode2.getId());
            }
            ArrayList updateNode = new ArrayList(2);
            root.iterate(100, treeNode -> {
                if (treeNode.getId().equals(((TreeNode)matchNodes.get(0)).getId())) {
                    treeNode.setColor(focusColor);
                    updateNode.add(treeNode);
                } else if (treeNode.getColor() != null) {
                    treeNode.setColor("");
                    updateNode.add(treeNode);
                }
            });
            this.treeView.focusNode((TreeNode)matchNodes.get(0));
            this.treeView.updateNodes(updateNode);
            this.rechecked(root);
            this.getPageCache().put(CACHE_FOCUS, "0");
            this.getPageCache().put(CACHE_MATCH_NODES, SerializationUtils.toJsonString((Object)matchNodes.toArray()));
            this.getPageCache().put(CACHE_TREE_ROOT, SerializationUtils.toJsonString((Object)root));
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u76f8\u5173\u6570\u636e\u3002", (String)"TreeAPSearchFocus_4", (String)"macc-faf-formplugin", (Object[])new Object[0]));
        }
    }

    public void getTreeNodeListByText(TreeNode node, List<TreeNode> treeNodes, String text, int maxLevel) {
        if (node.getText() != null && node.getText().toLowerCase().contains(text.toLowerCase())) {
            treeNodes.add(node);
        }
        if (maxLevel > 0 && node.getChildren() != null) {
            for (TreeNode child : node.getChildren()) {
                this.getTreeNodeListByText(child, treeNodes, text, maxLevel - 1);
            }
        }
    }

    public TreeNode getRootTreeNode() {
        return (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(CACHE_TREE_ROOT), TreeNode.class);
    }

    public void initTree(Map<String, TreeNode> nodeMap) {
        TreeNode rootNode = new TreeNode("", ROOT_ID, ROOT_ID);
        Collection<TreeNode> values = nodeMap.values();
        for (TreeNode node : values) {
            TreeNode parentNode = nodeMap.get(node.getParentid());
            if (parentNode != null) {
                parentNode.addChild(node);
                continue;
            }
            node.setDisabled(true);
            rootNode.addChild(node);
        }
        this.treeView.addNode(rootNode);
        this.treeView.expand(rootNode.getId());
        this.expand(rootNode, 2);
        this.treeView.setRootVisible(false);
        this.getPageCache().put(CACHE_TREE_ROOT, SerializationUtils.toJsonString((Object)rootNode));
    }

    private void rechecked(TreeNode root) {
        ArrayList<TreeNode> nodes = new ArrayList<TreeNode>(10);
        List checkedNodeIds = this.treeView.getTreeState().getCheckedNodeIds();
        for (String id : checkedNodeIds) {
            TreeNode node = root.getTreeNode(id, Integer.MAX_VALUE);
            nodes.add(node);
        }
        this.treeView.checkNodesWithoutChild(nodes);
    }

    private void expand(TreeNode rootNode, int level) {
        List children;
        if (level > 0 && (children = rootNode.getChildren()) != null && children.size() < 20) {
            for (TreeNode child : children) {
                this.treeView.expand(child.getId());
                this.expand(child, level - 1);
            }
        }
    }

    public List<TreeNode> getSelectedNodes(boolean all) {
        ArrayList<TreeNode> selectedNodes = new ArrayList<TreeNode>();
        HashSet ids = all ? Collections.emptySet() : new HashSet(this.treeView.getTreeState().getSelectedNodeId());
        TreeNode rootTreeNode = this.getRootTreeNode();
        for (TreeNode child : rootTreeNode.getChildren()) {
            child.iterate(100, treeNode -> {
                if (all || ids.contains(treeNode.getId())) {
                    selectedNodes.add((TreeNode)treeNode);
                }
            });
        }
        return selectedNodes;
    }
}

