/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.designer;

import java.lang.reflect.Constructor;
import java.util.EventObject;
import java.util.List;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.macc.faf.helper.EntityMetaHelper;
import org.apache.commons.lang3.StringUtils;

public class FAFAggregationAttributeFormPlugin
extends AbstractBillPlugIn {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter fsp = this.getView().getFormShowParameter();
        String entityNumber = (String)fsp.getCustomParam("entityName");
        if (entityNumber != null) {
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{entityNumber}) && !entityNumber.contains(".")) {
                MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
                EntityMetaHelper.initEntryEntity((MainEntityType)dataEntityType, (AbstractFormDataModel)((AbstractFormDataModel)this.getModel()), (IFormView)this.getView(), null);
            } else if (entityNumber.contains(".")) {
                CustomShowFieldInterface instance = this.getInstance(entityNumber);
                List<ShowFieldModel> showFieldModels = instance.setShowField();
                this.getModel().beginInit();
                TableValueSetter vs = new TableValueSetter(new String[0]);
                vs.addField("showname", new Object[0]);
                vs.addField("shownumber", new Object[0]);
                vs.addField("showdatatype", new Object[0]);
                for (ShowFieldModel showFieldModel : showFieldModels) {
                    String showName = showFieldModel.showName;
                    String showNumber = showFieldModel.showNumber;
                    String showdatatype = showFieldModel.showDatatype;
                    vs.addRow(new Object[]{showName, showNumber, showdatatype});
                }
                int count = vs.getCount();
                if (count > 0) {
                    ((AbstractFormDataModel)this.getModel()).batchCreateNewEntryRow("entryentity", vs);
                    this.getModel().endInit();
                    this.getView().updateView("entryentity");
                } else {
                    this.getModel().endInit();
                }
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        if ("btnok".equals(control.getKey())) {
            EntryGrid entryEntity = (EntryGrid)this.getControl("entryentity");
            int[] rowIndex = entryEntity.getSelectRows();
            AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
            DynamicObjectCollection rows = new DynamicObjectCollection();
            for (int index : rowIndex) {
                DynamicObject selectRow = model.getEntryEntity("entryentity", index);
                rows.add((Object)selectRow);
            }
            this.getView().returnDataToParent((Object)rows);
            this.getModel().setDataChanged(false);
            this.getView().close();
        }
    }

    private CustomShowFieldInterface getInstance(String customShowFieldInterface) {
        try {
            Class<?> aClass = Class.forName(customShowFieldInterface);
            Constructor<?> constructor = aClass.getConstructor(new Class[0]);
            return (CustomShowFieldInterface)constructor.newInstance(new Object[0]);
        }
        catch (ClassNotFoundException e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53c2\u6570CustomShowFieldInterface\u9700\u4e3a\u7ee7\u627fCustomShowFieldInterface\u7684\u4ee3\u7406\u7c7b\u5168\u7c7b\u540d", (String)"FAFAggregationAttributeFormPlugin_0", (String)"macc-faf-formplugin", (Object[])new Object[0]));
        }
        catch (NoSuchMethodException e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4ee3\u7406\u7c7b\u9700\u63d0\u4f9b\u65e0\u53c2\u6784\u9020\u65b9\u6cd5", (String)"FAFAggregationAttributeFormPlugin_1", (String)"macc-faf-formplugin", (Object[])new Object[0]));
        }
        catch (Exception e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4ee3\u7406\u7c7b\u6784\u9020\u5f02\u5e38", (String)"FAFAggregationAttributeFormPlugin_2", (String)"macc-faf-formplugin", (Object[])new Object[0]));
        }
    }

    public static class ShowFieldModel {
        String showName;
        String showNumber;
        String showDatatype;

        public ShowFieldModel(String showName, String showNumber, String showDatatype) {
            this.showName = showName;
            this.showNumber = showNumber;
            this.showDatatype = showDatatype;
        }
    }

    @FunctionalInterface
    public static interface CustomShowFieldInterface {
        public List<ShowFieldModel> setShowField();
    }
}

