/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.designer;

import com.alibaba.fastjson.JSON;
import java.util.Date;
import java.util.EventObject;
import java.util.LinkedHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.ComboProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.macc.faf.designer.field.DefaultCombo;
import kd.macc.faf.designer.field.DefaultDate;
import kd.macc.faf.designer.field.DefaultField;
import kd.macc.faf.designer.field.DefaultText;
import kd.macc.faf.enums.MultiFuncFieldSelectEnum;

public class FAFNonBaseDataSelectFormPlugin
extends AbstractFormPlugin {
    public static final String FIELD = "FIELD";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initFieldValue();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.settingFieldVisible();
    }

    public void click(EventObject evt) {
        super.click(evt);
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        String key = ((Control)evt.getSource()).getKey();
        if ("btnok".equals(key)) {
            DefaultField defaultField = this.getDefaultField();
            MultiFuncFieldSelectEnum fieldSelectEnum = defaultField.getType();
            switch (fieldSelectEnum) {
                case TEXT: {
                    String textValue = (String)model.getValue(fieldSelectEnum.getCode());
                    view.returnDataToParent((Object)new DefaultText(textValue));
                    break;
                }
                case DATE: {
                    Date dateFieldValue = (Date)this.getModel().getValue(fieldSelectEnum.getCode());
                    this.getView().returnDataToParent((Object)new DefaultDate(dateFieldValue));
                    break;
                }
                case COMBO: 
                case MULCOMBO: {
                    String enumValue = (String)model.getValue(fieldSelectEnum.getCode());
                    if (StringUtils.isBlank((CharSequence)enumValue)) {
                        view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"FAFNonBaseDataSelectFormPlugin_3", (String)"macc-faf-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    LinkedHashMap comboEnumMap = ((DefaultCombo)defaultField).getComboEnumMap();
                    view.returnDataToParent((Object)new DefaultCombo(enumValue, comboEnumMap));
                    break;
                }
                default: {
                    throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u5b57\u6bb5\u7c7b\u578b", (String)"FAFNonBaseDataSelectFormPlugin_4", (String)"macc-faf-formplugin", (Object[])new Object[0]));
                }
            }
            view.close();
        }
    }

    private void initFieldValue() {
        DefaultField field = this.getDefaultField();
        IDataModel model = this.getModel();
        MultiFuncFieldSelectEnum fieldSelectEnum = field.getType();
        String code = fieldSelectEnum.getCode();
        switch (fieldSelectEnum) {
            case TEXT: {
                String textFieldValue = ((DefaultText)field).getValue();
                model.setValue(code, (Object)textFieldValue);
                break;
            }
            case DATE: {
                Date dateFieldValue = ((DefaultDate)field).getDate();
                model.setValue(code, (Object)dateFieldValue);
                break;
            }
            case COMBO: 
            case MULCOMBO: {
                String comboFieldValue = ((DefaultCombo)field).getValue();
                LinkedHashMap comboEnumMap = ((DefaultCombo)field).getComboEnumMap();
                model.setValue(code, (Object)comboFieldValue);
                ComboProp comboProp = (ComboProp)model.getDataEntityType().getProperty(code);
                comboProp.setComboItems(comboEnumMap.entrySet().stream().map(entry -> new ValueMapItem(null, (String)entry.getKey(), new LocaleString((String)entry.getValue()))).collect(Collectors.toList()));
                ComboEdit comboEdit = (ComboEdit)this.getControl(code);
                comboEdit.setComboItems(comboEnumMap.entrySet().stream().map(entry -> new ComboItem(new LocaleString((String)entry.getValue()), (String)entry.getKey())).collect(Collectors.toList()));
                break;
            }
            default: {
                throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u5b57\u6bb5\u7c7b\u578b", (String)"FAFNonBaseDataSelectFormPlugin_4", (String)"macc-faf-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private void settingFieldVisible() {
        MultiFuncFieldSelectEnum fieldSelectEnum = this.getDefaultField().getType();
        String[] visibleFieldNumbers = (String[])Stream.of(fieldSelectEnum.getCode()).toArray(String[]::new);
        String[] invisibleFieldNumbers = (String[])Stream.of(MultiFuncFieldSelectEnum.values()).filter(fieldEnum -> fieldSelectEnum != fieldEnum).map(MultiFuncFieldSelectEnum::getCode).toArray(String[]::new);
        this.getView().setVisible(Boolean.TRUE, visibleFieldNumbers);
        this.getView().setVisible(Boolean.FALSE, invisibleFieldNumbers);
    }

    private DefaultField getDefaultField() {
        String paramJson = (String)this.getView().getFormShowParameter().getCustomParam(FIELD);
        MultiFuncFieldSelectEnum fieldType = ((DefaultField)JSON.parseObject((String)paramJson, DefaultField.class)).getType();
        return (DefaultField)JSON.parseObject((String)paramJson, (Class)fieldType.getClazz());
    }

    public static void openDefaultValueFillingPage(AbstractFormPlugin plugIn, DefaultField field) {
        FAFNonBaseDataSelectFormPlugin.openDefaultValueFillingPage(plugIn, field, ResManager.loadKDString((String)"\u9ed8\u8ba4\u503c", (String)"FAFNonBaseDataSelectFormPlugin_2", (String)"macc-faf-formplugin", (Object[])new Object[0]));
    }

    public static void openDefaultValueFillingPage(AbstractFormPlugin plugIn, DefaultField field, String title) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("pa_nonbasedata_select");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)plugIn, "NonBaseDataDimension"));
        formShowParameter.setCaption(title);
        formShowParameter.setCustomParam(FIELD, (Object)JSON.toJSONString((Object)field));
        plugIn.getView().showForm(formShowParameter);
    }
}

