/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.designer;

import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.util.CollectionUtils;

public class FAFSelectFieldDialogPlugin
extends AbstractFormPlugin {
    private static final String FORMID = "pa_fieldselect_dialog";
    private static final String FIELD_FIELD_ENTRY = "field_entry";
    public static final String PARAM_HAD_SELECTFIELD = "had_selectField";
    public static final String PARAM_AVAILABLE_FIELD = "param_available_field";

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        this.addClickListeners(new String[]{"btnok"});
    }

    public void afterCreateNewData(EventObject e) {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        FormShowParameter fsp = view.getFormShowParameter();
        Map availableFields = (Map)fsp.getCustomParam(PARAM_AVAILABLE_FIELD);
        Set entries = availableFields.entrySet();
        if (entries.size() > 0) {
            model.beginInit();
            model.batchCreateNewEntryRow(FIELD_FIELD_ENTRY, entries.size());
            DynamicObjectCollection entryEntity = model.getEntryEntity(FIELD_FIELD_ENTRY);
            int i = 0;
            for (Map.Entry entry : entries) {
                DynamicObject dynamicObject = (DynamicObject)entryEntity.get(i);
                dynamicObject.set("name", entry.getValue());
                dynamicObject.set("number", entry.getKey());
                ++i;
            }
            model.endInit();
            this.getView().updateView(FIELD_FIELD_ENTRY);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FormShowParameter fsp = this.getView().getFormShowParameter();
        String hadSelectField = (String)fsp.getCustomParam(PARAM_HAD_SELECTFIELD);
        if (StringUtils.isNotEmpty((CharSequence)hadSelectField)) {
            IDataModel model = this.getModel();
            HashSet<String> selectFieldSet = new HashSet<String>(Arrays.asList(hadSelectField.split(",")));
            Map availableFields = (Map)fsp.getCustomParam(PARAM_AVAILABLE_FIELD);
            Set fieldNumberSet = availableFields.keySet();
            fieldNumberSet.retainAll(selectFieldSet);
            if (!CollectionUtils.isEmpty(fieldNumberSet)) {
                int entryRowCount = model.getEntryRowCount(FIELD_FIELD_ENTRY);
                EntryGrid entryGrid = (EntryGrid)this.getControl(FIELD_FIELD_ENTRY);
                int[] selectIdx = new int[selectFieldSet.size()];
                int j = 0;
                for (int i = 0; i < entryRowCount; ++i) {
                    if (!selectFieldSet.contains((String)model.getValue("number", i))) continue;
                    selectIdx[j++] = i;
                }
                entryGrid.selectRows(selectIdx, -1);
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctl = (Control)evt.getSource();
        String key = ctl.getKey();
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        if ("btnok".equals(key)) {
            int entryRowCount = model.getEntryRowCount(FIELD_FIELD_ENTRY);
            EntryGrid entry = (EntryGrid)this.getControl(FIELD_FIELD_ENTRY);
            int[] selectRows = entry.getSelectRows();
            HashMap<String, String> choiceFields = new HashMap<String, String>(entryRowCount);
            for (int selectRow : selectRows) {
                Object number = model.getValue("number", selectRow);
                Object name = model.getValue("name", selectRow);
                choiceFields.put(number.toString(), name.toString());
            }
            model.setDataChanged(false);
            view.returnDataToParent(choiceFields);
            view.close();
        }
    }

    public static void openBy(AbstractFormPlugin plugin, Map<String, String> availableField, String selectField, String actionId) {
        FormShowParameter fsp = new FormShowParameter();
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setFormId(FORMID);
        fsp.setCaption(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9", (String)"FAFSelectFieldDialogPlugin_0", (String)"macc-faf-formplugin", (Object[])new Object[0]));
        fsp.setCustomParam(PARAM_AVAILABLE_FIELD, availableField);
        fsp.setCustomParam(PARAM_HAD_SELECTFIELD, (Object)selectField);
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, actionId));
        plugin.getView().showForm(fsp);
    }
}

