/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.dialog;

import java.util.Collection;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.FilterField;
import kd.bos.entity.filter.FilterObject;
import kd.bos.entity.filter.FilterValue;
import kd.bos.entity.filter.JavaTypeParseChecker;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.IntegerProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.macc.faf.common.FAFUtils;
import kd.macc.faf.datasync.BusinessDynamicObjectFactory;
import kd.macc.faf.datasync.exec.data.DataSyncModel;
import kd.macc.faf.dialog.SetValueAbstractDialogPlugin;
import kd.macc.faf.dto.TagTextFiledData;
import kd.macc.faf.fas.FAFIndexBusinessHelper;

public class SyncDataConditionDialogPlugin
extends SetValueAbstractDialogPlugin {
    private static final Log logger = LogFactory.getLog(SyncDataConditionDialogPlugin.class);
    private static final String FORMID = "faf_setconditiondialog";
    private static final String CTRL_FILTERGRIDAP = "filtergridap";
    private static final Set<String> excludeSet = new HashSet<String>();
    private static final Set<String> excludeSet2 = new HashSet<String>();

    public static void openBy(AbstractFormPlugin plugin, TagTextFiledData data, String actionId) {
        FormShowParameter fsp = new FormShowParameter();
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        if (data.getCaption() != null) {
            fsp.setCaption(data.getCaption());
        }
        fsp.setFormId(FORMID);
        fsp.setCustomParam("TagTextFiledData_json", (Object)SerializationUtils.toJsonString((Object)data));
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, actionId));
        fsp.setStatus(plugin.getView().getFormShowParameter().getStatus());
        plugin.getView().showForm(fsp);
    }

    private void clearSomeCpOption(Map<String, Object> fc) {
        List list = (List)FAFUtils.cast((Object)fc.get("compareTypes"));
        if (list != null) {
            list.removeIf(dto -> excludeSet.contains(dto.getId()));
        }
    }

    private void clearSomeCpOption2(Map<String, Object> fc) {
        List list = (List)FAFUtils.cast((Object)fc.get("compareTypes"));
        if (list != null) {
            list.removeIf(dto -> excludeSet2.contains(dto.getId()));
        }
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        FilterGrid filterGrid = (FilterGrid)this.getControl(CTRL_FILTERGRIDAP);
        filterGrid.addBeforeF7SelectListener(evt -> {
            QFilter qFilter = this.getDimensionTypeQFilter(evt.getFieldName());
            if (qFilter != null) {
                evt.addCustomQFilter(qFilter);
            }
        });
    }

    public void afterBindData(EventObject e) {
        DataSyncModel dataSyncModel = BusinessDynamicObjectFactory.createDataSyncModel((Object)this.getModelPkValue());
        String entityNumber = dataSyncModel.getEntitynumber();
        FilterGrid filterGrid = (FilterGrid)this.getControl(CTRL_FILTERGRIDAP);
        filterGrid.setEntityNumber(entityNumber);
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)entityNumber);
        List allFilterColumns = new EntityTypeUtil().getFilterColumns((IDataEntityType)entityType);
        List dimensionFields = dataSyncModel.getAllDimensionFields();
        HashSet set = new HashSet();
        Object object = this.getTagTextFiledData().getParams().get("exclude");
        if (object instanceof Collection) {
            List excludeFields = (List)FAFUtils.cast(object);
            dimensionFields.removeAll(excludeFields);
        }
        set.addAll(dimensionFields);
        set.addAll(dataSyncModel.getOrdinaryMeasure());
        List list = allFilterColumns.stream().filter(fc -> {
            String fieldName = (String)fc.get("fieldName");
            if (fieldName.contains(".")) {
                return set.contains(fieldName.substring(0, fieldName.indexOf(".")));
            }
            return set.contains(fieldName);
        }).filter(fc -> !"datetime".equals(fc.getOrDefault("type", ""))).peek(fc -> {
            String fieldName = (String)fc.get("fieldName");
            if (fieldName.contains(".") || dimensionFields.contains(fieldName)) {
                this.clearSomeCpOption2((Map<String, Object>)fc);
            }
        }).peek(this::clearSomeCpOption).collect(Collectors.toList());
        filterGrid.setFilterColumns(list);
        TagTextFiledData data = this.getTagTextFiledData();
        if (StringUtils.isNotBlank((CharSequence)data.getValue())) {
            FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)data.getValue(), FilterCondition.class);
            filterGrid.SetValue(filterCondition);
        }
        this.getView().updateView(CTRL_FILTERGRIDAP);
    }

    @Override
    protected void btnOk() {
        FilterGrid filterGrid = (FilterGrid)this.getControl(CTRL_FILTERGRIDAP);
        String entityNumber = filterGrid.getEntityNumber();
        TagTextFiledData data = this.getTagTextFiledData();
        if (StringUtils.isNotEmpty((CharSequence)entityNumber)) {
            try {
                MainEntityType dataType = EntityMetadataCache.getDataEntityType((String)filterGrid.getEntityNumber());
                FilterGrid.FilterGridState filterGridState = filterGrid.getFilterGridState();
                FilterBuilder filterBuilder = new FilterBuilder(dataType, filterGridState.getFilterCondition(), true);
                FilterObject filterObject = filterBuilder.getFilterObject();
                FilterCondition filterCondition = filterGridState.getFilterCondition();
                filterBuilder.buildFilter(false);
                filterCondition.setFilter(filterObject.getFilter());
                List filterRow = filterCondition.getFilterRow();
                Map allFilterFields = filterObject.getAllFilterFields();
                for (SimpleFilterRow row : filterRow) {
                    String valueOf;
                    FilterValue filterValue;
                    List value;
                    FilterField filterField = (FilterField)allFilterFields.get(row.getFieldName());
                    IDataEntityProperty fieldProp = filterField.getFieldProp();
                    if (fieldProp.getClass() == DecimalProp.class) {
                        value = row.getValue();
                        filterValue = (FilterValue)value.get(0);
                        valueOf = String.valueOf(filterValue.getValue());
                        if (!valueOf.contains(".")) {
                            filterValue.setValue((Object)(valueOf + ".00"));
                            continue;
                        }
                        if (!valueOf.endsWith(".")) continue;
                        filterValue.setValue((Object)(valueOf + "00"));
                        continue;
                    }
                    if (fieldProp.getClass() != IntegerProp.class) continue;
                    value = row.getValue();
                    filterValue = (FilterValue)value.get(0);
                    valueOf = String.valueOf(filterValue.getValue());
                    try {
                        JavaTypeParseChecker.parseInt((String)valueOf);
                    }
                    catch (KDBizException kex) {
                        this.getView().showTipNotification(String.format("%1$s\uff1a%2$s", filterField.getCaption(), kex.getMessage()));
                        return;
                    }
                }
                if (!filterRow.isEmpty()) {
                    String conditionJson = SerializationUtils.toJsonString((Object)filterCondition);
                    String desc = filterCondition.getFilter();
                    data.setText(desc.substring(0, Math.min(desc.length(), 200)));
                    data.setValue(conditionJson);
                } else {
                    data.setText("");
                    data.setValue("");
                }
            }
            catch (Exception ex) {
                logger.error("data-sync-schema-set-value", (Throwable)ex);
                this.getView().showTipNotification(ex.getMessage());
                return;
            }
        }
        this.getView().returnDataToParent((Object)data);
        this.getView().close();
    }

    private QFilter getDimensionTypeQFilter(String fieldName) {
        String dimensionNumber = fieldName.substring(0, fieldName.lastIndexOf("."));
        DataSyncModel dataSyncModel = BusinessDynamicObjectFactory.createDataSyncModel((Object)this.getModelPkValue());
        Optional<DynamicObject> any = dataSyncModel.getDimensionEntry().stream().map(dynamicObject -> dynamicObject.getDynamicObject("dimension")).filter(dynamicObject -> Objects.equals(dimensionNumber, dynamicObject.getString("number"))).findAny();
        return any.map(FAFIndexBusinessHelper::getQFilterByDimension).orElse(null);
    }

    public Long getModelPkValue() {
        TagTextFiledData data = this.getTagTextFiledData();
        Object object = data.getParams().get("model");
        return FAFUtils.toLongPkvalue(object);
    }

    static {
        excludeSet.add("-1");
        excludeSet.add("-2");
        excludeSet.add("-3");
        excludeSet.add("-4");
        excludeSet.add("-5");
        excludeSet.add("-6");
        excludeSet.add("103");
        excludeSet.add("104");
        excludeSet2.add("21");
        excludeSet2.add("36");
        excludeSet2.add("19");
        excludeSet2.add("65");
    }
}

