/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.fas;

import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Search;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.macc.faf.fas.helper.FAFFormulaEditHelper;

public class FAFCalculationFormulaEdit
extends AbstractFormPlugin
implements SearchEnterListener,
RowClickEventListener {
    private static final Log logger = LogFactory.getLog(FAFCalculationFormulaEdit.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Search search = (Search)this.getControl("searchap");
        search.addEnterListener((SearchEnterListener)this);
        EntryGrid entryGrid = (EntryGrid)this.getControl("indexentry");
        entryGrid.addRowClickListener((RowClickEventListener)this);
        this.addClickListeners(new String[]{"button_leftbracket", "button_rightbracket", "button_add", "button_minus", "button_multiply", "button_division", "button_clear", "button_cancel"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FAFFormulaEditHelper.initFormulaPanel(this.getView());
        FAFFormulaEditHelper.initIndexEntry(this.getView(), null);
        try {
            FAFFormulaEditHelper.initDimensionEntry(this.getView());
        }
        catch (KDBizException ex) {
            logger.error(ex.getMessage());
            this.getView().showErrorNotification(ex.getMessage());
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FAFFormulaEditHelper.setVisibleAndEnableByStatus(this.getView());
    }

    public void entryRowClick(RowClickEvent evt) {
        super.entryRowClick(evt);
        IFormView parentView = this.getView().getParentView();
        if (parentView == null || "true".equals(this.getView().getFormShowParameter().getCustomParam("isRefrenced"))) {
            return;
        }
        int row = evt.getRow();
        DynamicObjectCollection indexEntry = this.getModel().getEntryEntity("indexentry");
        FAFFormulaEditHelper.buildFormulaExpressionByClick(this.getView(), "indexentry", ((DynamicObject)indexEntry.get(row)).getString("indexnumber"));
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (FAFFormulaEditHelper.OPERATION_NUMBER_NAME.containsKey(key)) {
            FAFFormulaEditHelper.buildFormulaExpressionByClick(this.getView(), key, FAFFormulaEditHelper.OPERATION_NUMBER_NAME.get(key));
        } else if ("button_cancel".equals(key)) {
            try {
                FAFFormulaEditHelper.backSpace(this.getView(), key);
            }
            catch (Exception exception) {
                throw new KDBizException(exception.getCause() != null ? exception.getCause().getMessage() : exception.getMessage());
            }
        } else if ("button_clear".equals(key)) {
            this.getModel().setValue("text_formula", (Object)"");
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if ("confirm".equals(operateKey)) {
            if (StringUtils.isBlank((Object)this.getModel().getValue("text_formula"))) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FAFCalculationFormulaEdit_0", (String)"macc-faf-formplugin", (Object[])new Object[0]));
                return;
            }
            boolean isValid = (Boolean)this.getModel().getValue("is_valid");
            if (!isValid) {
                String formulaTranslation = (String)this.getModel().getValue("text_formulatranslation");
                this.getView().showErrorNotification(formulaTranslation);
                return;
            }
            this.getView().returnDataToParent((Object)FAFFormulaEditHelper.buildFormulaResultDTO(this.getModel()));
            this.getPageCache().put("closeable", "true");
            this.getView().close();
        } else if ("close".equals(operateKey) && FAFFormulaEditHelper.formulaIsChanged(this.getView())) {
            this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u8868\u8fbe\u5f0f\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u9000\u51fa\uff1f%s\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"FAFCalculationFormulaEdit_1", (String)"macc-faf-formplugin", (Object[])new Object[0]), "\n"), MessageBoxOptions.YesNo, new ConfirmCallBackListener("cancel_save_formula", (IFormPlugin)this));
            args.setCancel(true);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        String result = messageBoxClosedEvent.getResultValue();
        if ("cancel_save_formula".equals(callBackId) && MessageBoxResult.Yes.name().equals(result)) {
            this.getPageCache().put("closeable", "true");
            this.getView().close();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if ("text_formula".equals(key)) {
            FAFFormulaEditHelper.translateCurrentFormulaExpression(this.getView());
            boolean formulaIsValid = (Boolean)this.getModel().getValue("is_valid");
            if (formulaIsValid) {
                FAFFormulaEditHelper.initDimensionEntry(this.getView());
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        String closeable = this.getPageCache().get("closeable");
        if (!"true".equals(closeable) && FAFFormulaEditHelper.formulaIsChanged(this.getView())) {
            this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u8868\u8fbe\u5f0f\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u9000\u51fa\uff1f%s\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"FAFCalculationFormulaEdit_1", (String)"macc-faf-formplugin", (Object[])new Object[0]), "\n"), MessageBoxOptions.YesNo, new ConfirmCallBackListener("cancel_save_formula", (IFormPlugin)this));
            this.getPageCache().put("closeable", null);
            e.setCancel(true);
        }
    }

    public void search(SearchEnterEvent searchEnterEvent) {
        FAFFormulaEditHelper.initIndexEntry(this.getView(), searchEnterEvent.getText());
    }

    public static void jumpMe(IFormView view, String formula, String formulaDesc, AbstractFormPlugin formPlugin, DynamicObject f_system) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("pa_fasfomulacalculation");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCustomParam("currentIndexId", (Object)(view.getModel().getValue("id") + ""));
        formShowParameter.setCustomParam("text_formula", (Object)formula);
        formShowParameter.setCustomParam("text_description", (Object)formulaDesc);
        formShowParameter.setCustomParam("isRefrenced", (Object)view.getPageCache().get("isRefrenced"));
        formShowParameter.setCustomParam("systemId", (Object)f_system.getLong("id"));
        formShowParameter.setCustomParam("createOrgId", (Object)((DynamicObject)view.getModel().getValue("createorg")).getString("id"));
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)formPlugin, "formula_calculation"));
        view.showForm(formShowParameter);
    }
}

