/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.fas;

import java.util.Date;
import java.util.EventObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.macc.faf.fas.dto.FAFDateRange;

public class FAFDialogDateRangePlugin
extends AbstractFormPlugin {
    private static final String FORMID = "pa_fasdialogdaterange";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String predata = (String)this.getView().getFormShowParameter().getCustomParam("predata");
        if (StringUtils.isNotEmpty((CharSequence)predata)) {
            FAFDateRange dateRange = new FAFDateRange(predata);
            this.getModel().setValue("startdate", (Object)dateRange.getStartDate());
            this.getModel().setValue("enddate", (Object)dateRange.getEndDate());
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if ("btnok".equals(key)) {
            this.returnText();
        }
    }

    private void returnText() {
        Date startdate = (Date)this.getModel().getValue("startdate");
        Date enddate = (Date)this.getModel().getValue("enddate");
        FAFDateRange dateRange = new FAFDateRange(startdate, enddate);
        this.getView().returnDataToParent((Object)dateRange);
        this.getView().close();
    }

    public static void openBy(AbstractFormPlugin plugin, String predata, String actionId) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(FORMID);
        showParameter.setCaption(ResManager.loadKDString((String)"\u65e5\u671f\u8303\u56f4", (String)"FAFDialogDateRangePlugin_0", (String)"macc-faf-formplugin", (Object[])new Object[0]));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.getCustomParams().put("predata", predata);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, actionId));
        plugin.getView().showForm(showParameter);
    }
}

