/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.fas;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.macc.faf.common.FAFUtils;
import kd.macc.faf.fas.FAFIndexBusinessHelper;

public class FAFFilterDialogPlugin
extends AbstractFormPlugin {
    private static final Log logger = LogFactory.getLog(FAFFilterDialogPlugin.class);
    private static final String FORMID = "pa_fasindex_filterdialog";
    private static final String F_MODEL = "model";
    private static final String CTRL_FILTERGRIDAP = "filtergridap";
    private static final String P_MODEL = "model";
    private static final String P_ISREFRENCED = "isRefrenced";
    private static final String P_USEORG = "useOrgId";
    private static final String P_CONDITIONJSON = "conditionJson";
    private static final String P_CONDITIONJSONDESC = "conditionDesc";
    private static final Set<String> set = new HashSet<String>();
    private static final Set<String> datetimeSet = new HashSet<String>();

    public static void openBy(AbstractFormPlugin plugin, Object modelPkId, String isRefrenced, Object conditionJson, String useOrgId, String actionId) {
        FormShowParameter fsp = new FormShowParameter();
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setFormId(FORMID);
        fsp.setCustomParam("model", modelPkId);
        fsp.setCustomParam(P_ISREFRENCED, (Object)isRefrenced);
        fsp.setCustomParam(P_USEORG, (Object)useOrgId);
        fsp.setCustomParam(P_CONDITIONJSON, conditionJson);
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, actionId));
        plugin.getView().showForm(fsp);
    }

    private long getUseOrg() {
        Object useOrgId = this.getView().getFormShowParameter().getCustomParams().get(P_USEORG);
        return Long.parseLong((String)useOrgId);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
        FilterGrid filterGrid = (FilterGrid)this.getControl(CTRL_FILTERGRIDAP);
        filterGrid.addBeforeF7SelectListener(evt -> {
            QFilter qFilter = this.getDimensionTypeQFilter(evt.getFieldName());
            if (qFilter != null) {
                evt.addCustomQFilter(qFilter);
            }
            evt.setUseOrgId(this.getUseOrg());
        });
    }

    public QFilter getDimensionTypeQFilter(String fieldName) {
        Map<String, DynamicObject> map = this.getDimensionsFromModelMap();
        DynamicObject dimension = map.get(fieldName.substring(0, fieldName.lastIndexOf(".")));
        return FAFIndexBusinessHelper.getQFilterByDimension((DynamicObject)dimension);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Object customParam = this.getView().getFormShowParameter().getCustomParam("model");
        this.getModel().setValue("model", customParam);
        String isRefrenced = (String)this.getView().getFormShowParameter().getCustomParam(P_ISREFRENCED);
        if ("true".equals(isRefrenced)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{CTRL_FILTERGRIDAP});
        }
    }

    public void afterBindData(EventObject e) {
        this.setInitFilterGridCondition();
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        if ("btnok".equals(control.getKey())) {
            this.closeAndreturnData();
        }
    }

    private void setInitFilterGridCondition() {
        FilterGrid filterGrid = (FilterGrid)this.getControl(CTRL_FILTERGRIDAP);
        String entityNumber = this.getEntityNumber();
        if (entityNumber == null) {
            return;
        }
        filterGrid.setEntityNumber(entityNumber);
        LinkedHashMap<String, Map> colMap = new LinkedHashMap<String, Map>(10);
        Set<String> dfieldNameSet = this.getDimensionsFromModel().keySet();
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)entityNumber);
        List allFilterColumns = new EntityTypeUtil().getFilterColumns((IDataEntityType)entityType);
        for (Map fc : allFilterColumns) {
            String fieldName = String.valueOf(fc.get("fieldName"));
            String fieldCaption = (String)fc.get("fieldCaption");
            if (dfieldNameSet.contains(fieldName)) {
                this.clearSomeCpOption(fc);
                colMap.put(fieldName, fc);
                continue;
            }
            int charIndex = fieldName.lastIndexOf(".");
            String baseField = charIndex > -1 ? fieldName.substring(0, charIndex) : fieldName;
            if (!dfieldNameSet.contains(baseField) || !fieldName.endsWith(".name") && !fieldName.endsWith(".number") && !fieldName.endsWith(".longnumber")) continue;
            String baseFieldCaption = fieldCaption.substring(0, fieldCaption.indexOf("."));
            fc.put("fieldCaption", baseFieldCaption);
            this.clearSomeCpOption(fc);
            Map map = (Map)colMap.get(baseField);
            if (map != null) {
                if (!fieldName.endsWith(".name")) continue;
                colMap.put(baseField, fc);
                continue;
            }
            colMap.put(baseField, fc);
        }
        filterGrid.setFilterColumns(new ArrayList(colMap.values()));
        String conditionJson = (String)this.getView().getFormShowParameter().getCustomParam(P_CONDITIONJSON);
        if (StringUtils.isNotBlank((CharSequence)conditionJson)) {
            FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)conditionJson, FilterCondition.class);
            filterGrid.SetValue(filterCondition);
        }
        this.getView().updateView(CTRL_FILTERGRIDAP);
    }

    private void clearSomeCpOption(Map<String, Object> fc) {
        List list = (List)FAFUtils.cast((Object)fc.get("compareTypes"));
        if ("datetime".equals(fc.getOrDefault("type", ""))) {
            if (list != null) {
                list.removeIf(dto -> !datetimeSet.contains(dto.getId()));
            }
        } else if (list != null) {
            list.removeIf(dto -> set.contains(dto.getId()));
        }
    }

    private String getEntityNumber() {
        DynamicObject dataEntity = (DynamicObject)this.getModel().getValue("model");
        if (dataEntity != null) {
            String tablenumber = dataEntity.getString("tablenumber");
            if (StringUtils.isNotEmpty((CharSequence)tablenumber)) {
                return "pa_" + dataEntity.getString("tablenumber");
            }
            throw new KDBizException(ResManager.loadKDString((String)"\u6a21\u578b\u6570\u636e\u8868\u4e0d\u5b58\u5728\u6216\u672a\u521b\u5efa\u3002", (String)"FAFFilterDialogPlugin_0", (String)"macc-faf-formplugin", (Object[])new Object[0]));
        }
        return null;
    }

    private Map<String, String> getDimensionsFromModel() {
        Object pkvalue = this.getModel().getValue("model_id");
        if (pkvalue == null || pkvalue.equals(0L)) {
            return Collections.emptyMap();
        }
        DynamicObject dyModel = BusinessDataServiceHelper.loadSingleFromCache((Object)pkvalue, (String)"pa_analysismodel");
        DynamicObjectCollection dEntry = dyModel.getDynamicObjectCollection("dimension_entry");
        return dEntry.stream().collect(Collectors.toMap(dynamicObject -> dynamicObject.getString("dimension.number"), dynamicObject -> dynamicObject.getString("dimension.name")));
    }

    private Map<String, DynamicObject> getDimensionsFromModelMap() {
        Object pkvalue = this.getModel().getValue("model_id");
        if (pkvalue == null || pkvalue.equals(0L)) {
            return Collections.emptyMap();
        }
        DynamicObject dyModel = BusinessDataServiceHelper.loadSingleFromCache((Object)pkvalue, (String)"pa_analysismodel");
        DynamicObjectCollection dEntry = dyModel.getDynamicObjectCollection("dimension_entry");
        return dEntry.stream().collect(Collectors.toMap(dynamicObject -> dynamicObject.getString("dimension.number"), dynamicObject -> dynamicObject.getDynamicObject("dimension")));
    }

    private void closeAndreturnData() {
        FilterGrid filterGrid = (FilterGrid)this.getControl(CTRL_FILTERGRIDAP);
        String entityNumber = filterGrid.getEntityNumber();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(P_CONDITIONJSON, "");
        params.put(P_CONDITIONJSONDESC, ResManager.loadKDString((String)"\u70b9\u51fb\u8bbe\u7f6e", (String)"FAFFilterDialogPlugin_1", (String)"macc-faf-formplugin", (Object[])new Object[0]));
        if (StringUtils.isNotEmpty((CharSequence)entityNumber)) {
            try {
                MainEntityType dataType = EntityMetadataCache.getDataEntityType((String)filterGrid.getEntityNumber());
                FilterGrid.FilterGridState filterGridState = filterGrid.getFilterGridState();
                FilterBuilder filterBuilder = new FilterBuilder(dataType, filterGridState.getFilterCondition(), true);
                filterBuilder.buildFilter(false);
                filterGridState.getFilterCondition().setFilter(filterBuilder.getFilterObject().getFilter());
                FilterCondition filterCondition = filterGridState.getFilterCondition();
                String conditionJson = SerializationUtils.toJsonString((Object)filterCondition);
                List filterRow = filterCondition.getFilterRow();
                if (filterRow.size() > 0) {
                    for (SimpleFilterRow row : filterRow) {
                        String fieldName = row.getFieldName();
                        if (!fieldName.endsWith(".name") || "9".equals(row.getCompareType()) || "37".equals(row.getCompareType()) || row.getValue().size() == row.getBaseDataIds().size()) continue;
                        int charIndex = fieldName.indexOf(".");
                        String baseField = charIndex > -1 ? fieldName.substring(0, charIndex) : fieldName;
                        String name = this.getDimensionsFromModel().get(baseField);
                        this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u7684\u6761\u4ef6\u503c\u5931\u6548\u6216\u9519\u8bef,\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"FAFFilterDialogPlugin_2", (String)"macc-faf-formplugin", (Object[])new Object[0]), name));
                        return;
                    }
                }
                FAFIndexBusinessHelper.getIndexModelQFilter((String)filterGrid.getEntityNumber(), (String)conditionJson);
                params.put(P_CONDITIONJSON, conditionJson);
                params.put(P_CONDITIONJSONDESC, ResManager.loadKDString((String)"\u70b9\u51fb\u67e5\u770b", (String)"FAFFilterDialogPlugin_3", (String)"macc-faf-formplugin", (Object[])new Object[0]));
            }
            catch (Exception ex) {
                logger.error("pa.fas.fasfilterdialogplugin", (Throwable)ex);
                this.getView().showTipNotification(ex.getMessage());
                return;
            }
        }
        this.getView().returnDataToParent(params);
        this.getView().close();
    }

    static {
        set.add("60");
        set.add("211");
        set.add("21");
        set.add("36");
        set.add("19");
        set.add("65");
        set.add("-1");
        set.add("-2");
        set.add("-3");
        set.add("-4");
        datetimeSet.add("501");
        datetimeSet.add("502");
        datetimeSet.add("1");
        datetimeSet.add("67");
        datetimeSet.add("21");
        datetimeSet.add("36");
    }
}

