/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.fas;

import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.entity.operate.SaveAndNew;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.LargeTextEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.license.api.LicenseCheckResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.basedata.BaseDataRefrenceHelper;
import kd.macc.faf.common.FAFUtils;
import kd.macc.faf.fas.FAFCalculationFormulaEdit;
import kd.macc.faf.fas.FAFFilterDialogPlugin;
import kd.macc.faf.fas.FAFFormulaCalculationDataHelper;
import kd.macc.faf.fas.FAFIndexBusinessHelper;
import kd.macc.faf.fas.FAFIndexConstants;
import kd.macc.faf.fas.FAFIndexTestRptPlugin;
import kd.macc.faf.fas.dto.FAFFormulaResultDTO;
import kd.macc.faf.fas.enums.FAFIndexAggregateEnum;
import kd.macc.faf.fas.enums.FAFIndexCategoryEnum;
import kd.macc.faf.fas.enums.FAFIndexUnitEnum;
import kd.macc.faf.fas.util.FAFViewUitl;
import kd.macc.faf.util.LicenseUtil;

public class FAFIndexEdit
extends AbstractFormPlugin {
    private static final Log logger = LogFactory.getLog(FAFIndexEdit.class);
    private static final String FORMID = "pa_fasindex";
    private static final String F_GROUP = "group";
    private static final String F_IS_SYSTEM = "issystem";
    private static final String F_CATEGORY = "category";
    private static final String F_AGGREGATE = "aggregate";
    private static final String F_SYSTEM = "system";
    private static final String F_MODEL = "model";
    private static final String F_DEFAULTGROUPER = "defaultgrouper";
    private static final String F_AGGMEASURE = "aggmeasure";
    private static final String F_FORMULA = "formula";
    private static final String F_INDEXFORMULA = "indexformula";
    private static final String F_INDEXFORMULADESC = "indexformuladesc";
    private static final String F_INDEXFORMULAARGS = "indexformulaargs";
    private static final String F_UNITCATEGORY = "unitcategory";
    private static final String F_UNITBASEDATA = "unitbasedata";
    private static final String F_UNIT = "unit";
    private static final String F_DIMENSIONCONDITION = "dimensioncondition";

    public void initialize() {
        super.initialize();
        this.getView().addCustomControls(new String[]{F_DIMENSIONCONDITION, F_FORMULA});
    }

    public void onGetControl(OnGetControlArgs e) {
        super.onGetControl(e);
        String key = e.getKey();
        if (F_DIMENSIONCONDITION.equals(key)) {
            LargeTextEdit control = new LargeTextEdit(){

                public void detailClick(Map<String, Object> args) {
                    FAFIndexEdit.this.jumpToQFilterSettingDialog();
                }
            };
            control.setKey(F_DIMENSIONCONDITION);
            control.setModel(this.getModel());
            control.setView(this.getView());
            e.setControl((Control)control);
        } else if (F_FORMULA.equals(key)) {
            LargeTextEdit control = new LargeTextEdit(){

                public void detailClick(Map<String, Object> args) {
                    FAFIndexEdit.this.jumpToFormulaCaculation();
                }
            };
            control.setKey(F_FORMULA);
            control.setModel(this.getModel());
            control.setView(this.getView());
            e.setControl((Control)control);
        }
    }

    public void registerListener(EventObject evt) {
        BasedataEdit modelF7 = (BasedataEdit)this.getControl(F_MODEL);
        modelF7.addBeforeF7SelectListener(event -> {
            DynamicObject dy = this.getFsystem();
            if (dy == null) {
                event.setCancel(true);
                return;
            }
            QFilter qFilter = new QFilter("analysis_system", "=", dy.getPkValue()).and("tablenumber", "!=", (Object)Character.valueOf(' ')).and("tablenumber", "is not null", null);
            event.getCustomQFilters().add(qFilter);
        });
        BasedataEdit aggmeasure = (BasedataEdit)this.getControl(F_AGGMEASURE);
        aggmeasure.addBeforeF7SelectListener(event -> {
            DynamicObject dy = this.getFmodel();
            if (dy == null) {
                event.setCancel(true);
                return;
            }
            Set collect = dy.getDynamicObjectCollection("measure_entry").stream().map(dynamicObject -> dynamicObject.getDynamicObject("measure").getPkValue()).collect(Collectors.toSet());
            event.getCustomQFilters().add(new QFilter("id", "in", collect));
        });
        BasedataEdit indexformulaargs = (BasedataEdit)this.getControl(F_INDEXFORMULAARGS);
        indexformulaargs.addBeforeF7SelectListener(event -> {
            DynamicObject dy = this.getFsystem();
            if (dy == null) {
                event.setCancel(true);
                return;
            }
            List customQFilters = event.getCustomQFilters();
            customQFilters.add(new QFilter(F_SYSTEM, "=", dy.getPkValue()));
            customQFilters.add(new QFilter("id", "!=", this.getModel().getDataEntity().getPkValue()));
        });
        BasedataEdit defaultgrouper = (BasedataEdit)this.getControl(F_DEFAULTGROUPER);
        defaultgrouper.addBeforeF7SelectListener(event -> {
            DynamicObject dy;
            if ("0".equals(this.getModel().getValue(F_CATEGORY)) && (dy = this.getFmodel()) == null) {
                event.setCancel(true);
                return;
            }
            event.getCustomQFilters().add(new QFilter("id", "in", this.getAllDidmensions()));
        });
        this.addClickListeners(new String[]{F_FORMULA});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getModel().setValue(F_DIMENSIONCONDITION, (Object)"");
        String category = this.getCategoryParams();
        if (FAFIndexCategoryEnum.COMPOSITE.getCode().equals(category)) {
            this.getModel().setValue(F_CATEGORY, (Object)FAFIndexCategoryEnum.COMPOSITE.getCode());
        } else {
            this.getModel().setValue(F_CATEGORY, (Object)FAFIndexCategoryEnum.ELEMENTARY.getCode());
        }
        this.setGroupParams();
        this.setSystemParams();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        try {
            this.lockCtrls();
            this.syncSetBindValue();
            this.fillFormulaText();
            this.updateCtrlMustInputByCategory();
            this.updateCtrlMustInputByUnitCategory();
            this.adjustControlTitle();
        }
        catch (KDBizException ex) {
            this.getView().showErrorNotification(ex.getMessage());
        }
    }

    private void adjustControlTitle() {
        if ("1".equals(this.getModel().getValue(F_CATEGORY))) {
            FAFViewUitl.updateName(this.getView(), "flexpanelap", ResManager.loadKDString((String)"\u516c\u5f0f\u8bbe\u7f6e", (String)"FAFIndexEdit_0", (String)"macc-faf-formplugin", (Object[])new Object[0]));
        } else if ("0".equals(this.getModel().getValue(F_CATEGORY))) {
            FAFViewUitl.updateName(this.getView(), "flexpanelap", ResManager.loadKDString((String)"\u5ea6\u91cf\u8bbe\u7f6e", (String)"FAFIndexEdit_1", (String)"macc-faf-formplugin", (Object[])new Object[0]));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        FormOperate formOperate = (FormOperate)args.getSource();
        OperationResult operationResult = args.getOperationResult();
        if (args.getSource() instanceof Save && operationResult.isSuccess()) {
            this.lockCtrls();
            String category = (String)this.getModel().getValue(F_CATEGORY);
            this.getPageCache().put("index_category", category);
            String systemid = String.valueOf(this.getModel().getValue("system_id"));
            this.getPageCache().put("systemid", systemid);
            String group = String.valueOf(this.getModel().getValue("group_id"));
            this.getPageCache().put("groupid", group);
        }
        if (args.getSource() instanceof SaveAndNew && operationResult.isSuccess()) {
            this.unlockCtrls();
        }
        if ("trialcalculate".equals(formOperate.getOperateKey()) && args.getOperationResult().isSuccess()) {
            Object pkValue = this.getModel().getDataEntity().getPkValue();
            if (pkValue == null || pkValue.equals(0L)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5b8c\u6210\u4fdd\u5b58\u64cd\u4f5c\u3002", (String)"FAFIndexEdit_2", (String)"macc-faf-formplugin", (Object[])new Object[0]));
            } else {
                FAFIndexTestRptPlugin.openBy(this, pkValue, this.getCreateOrg(), "ac_trialcalculate");
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName = e.getProperty().getName();
        IDataModel model = this.getModel();
        switch (propName) {
            case "category": {
                this.updateCtrlMustInputByCategory();
                break;
            }
            case "aggregate": {
                this.updateCtrlMustInputByAggregate();
                break;
            }
            case "system": {
                model.setValue(F_MODEL, null);
                break;
            }
            case "model": {
                this.clearValueByChangeModel();
                break;
            }
            case "formula": {
                String newValue = (String)e.getChangeSet()[0].getNewValue();
                if (!StringUtils.isBlank((CharSequence)newValue)) break;
                this.changeValueByClearFormula(newValue);
                break;
            }
            case "indexformula": {
                this.changeValueByChangeIndexFormula();
                break;
            }
            case "unitcategory": {
                this.changeValueByUnitCategory((String)e.getChangeSet()[0].getNewValue());
                this.updateCtrlMustInputByUnitCategory();
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        String actionId = event.getActionId();
        if ("set_dimension_filter".equals(actionId) && event.getReturnData() != null) {
            Map params = (Map)FAFUtils.cast((Object)event.getReturnData());
            String conditionJson = (String)params.get("conditionJson");
            String conditionDesc = (String)params.get("conditionDesc");
            this.getModel().setValue(F_DIMENSIONCONDITION, (Object)conditionDesc.substring(0, Math.min(conditionDesc.length(), 200)));
            this.getModel().setValue(FAFUtils.bigTextField((String)F_DIMENSIONCONDITION), (Object)conditionJson);
        } else if ("formula_calculation".equals(actionId) && event.getReturnData() != null) {
            FAFFormulaResultDTO formulaExpressionResultDTO = (FAFFormulaResultDTO)event.getReturnData();
            String formulaExpress = formulaExpressionResultDTO.getFormulaExpress();
            String formulaExpressTranslationDesc = formulaExpressionResultDTO.getFormulaExpressTranslationDesc();
            String desc = formulaExpressionResultDTO.getDesc();
            Object[] indexArgs = formulaExpressionResultDTO.getIndexArgs();
            this.getModel().setValue(F_FORMULA, (Object)formulaExpressTranslationDesc);
            this.getModel().setValue(F_INDEXFORMULA, (Object)formulaExpress);
            this.getModel().setValue(F_INDEXFORMULADESC, (Object)desc);
            this.getModel().setValue(F_INDEXFORMULAARGS, (Object)(CollectionUtils.isEmpty((Collection)indexArgs) ? new Object[]{} : indexArgs));
        }
    }

    private String getCategoryParams() {
        String category = this.getPageCache().get("index_category");
        if (category == null) {
            category = (String)this.getView().getFormShowParameter().getCustomParam("index_category");
        } else {
            this.getPageCache().remove("index_category");
        }
        return category;
    }

    private void setSystemParams() {
        String systemid = this.getPageCache().get("systemid");
        if (systemid == null) {
            systemid = (String)this.getView().getFormShowParameter().getCustomParam("system.id");
        } else {
            this.getPageCache().remove("systemid");
        }
        this.getModel().setValue(F_SYSTEM, (Object)systemid);
    }

    private void setGroupParams() {
        String group = this.getPageCache().get("groupid");
        if (group != null) {
            this.getModel().setValue(F_GROUP, (Object)group);
            this.getPageCache().remove("groupid");
        }
    }

    private void fillFormulaText() {
        String indexformula = (String)this.getModel().getValue(F_INDEXFORMULA);
        Long systemId = (Long)this.getModel().getValue("system_id");
        String indexformulaTranslation = FAFFormulaCalculationDataHelper.translateFormulaExpression((String)indexformula, (Long)systemId);
        this.getModel().beginInit();
        this.getModel().setValue(F_FORMULA, (Object)indexformulaTranslation);
        this.getModel().endInit();
        this.getView().updateView(F_FORMULA);
        this.getModel().setDataChanged(false);
    }

    private void syncSetBindValue() {
        Integer precision = (Integer)this.getModel().getValue("precision");
        if (precision == FAFIndexConstants.EMPTY_PRECISION) {
            this.getModel().setValue("precision", null);
            this.getModel().setDataChanged(false);
        }
    }

    private void changeValueByUnitCategory(String unitCategory) {
        if (FAFIndexUnitEnum.UNIT_MONEY.eq((Object)unitCategory)) {
            this.getModel().setValue(F_UNITBASEDATA, (Object)"bd_currency");
        } else if (FAFIndexUnitEnum.UNIT_QUANTITY.eq((Object)unitCategory)) {
            this.getModel().setValue(F_UNITBASEDATA, (Object)"bd_measureunits");
        } else if (FAFIndexUnitEnum.UNIT_NUMERICAL.eq((Object)unitCategory)) {
            this.getModel().setValue(F_UNITBASEDATA, null);
        }
        this.getModel().setValue(F_UNIT, null);
    }

    private void updateCtrlMustInputByCategory() {
        String category = (String)this.getModel().getValue(F_CATEGORY);
        if (FAFIndexCategoryEnum.COMPOSITE.eq((Object)category)) {
            this.setMustInput(F_MODEL, false);
            this.setMustInput(F_AGGREGATE, false);
            this.setMustInput(F_AGGMEASURE, false);
            this.setMustInput(F_FORMULA, true);
            this.setMustInput(F_INDEXFORMULA, true);
            this.setMustInput(F_INDEXFORMULAARGS, true);
        } else {
            this.setMustInput(F_MODEL, true);
            this.setMustInput(F_AGGREGATE, true);
            this.updateCtrlMustInputByAggregate();
            this.setMustInput(F_FORMULA, false);
            this.setMustInput(F_INDEXFORMULA, false);
            this.setMustInput(F_INDEXFORMULAARGS, false);
        }
    }

    private void updateCtrlMustInputByAggregate() {
        String aggregate = (String)this.getModel().getValue(F_AGGREGATE);
        this.setMustInput(F_AGGMEASURE, !FAFIndexAggregateEnum.COUNT.eq((Object)aggregate));
    }

    private void updateCtrlMustInputByUnitCategory() {
        String unitCategory = (String)this.getModel().getValue(F_UNITCATEGORY);
        FieldEdit edit = (FieldEdit)this.getControl(F_UNIT);
        if (FAFIndexUnitEnum.UNIT_NUMERICAL.eq((Object)unitCategory)) {
            edit.setMustInput(false);
        } else {
            edit.setMustInput(true);
            if (FAFIndexUnitEnum.UNIT_MONEY.eq((Object)unitCategory)) {
                edit.setCaption(new LocaleString(ResManager.loadKDString((String)"\u5e01\u79cd", (String)"FAFIndexEdit_3", (String)"macc-faf-formplugin", (Object[])new Object[0])));
            } else if (FAFIndexUnitEnum.UNIT_QUANTITY.eq((Object)unitCategory)) {
                edit.setCaption(new LocaleString(ResManager.loadKDString((String)"\u8ba1\u91cf\u5355\u4f4d", (String)"FAFIndexEdit_4", (String)"macc-faf-formplugin", (Object[])new Object[0])));
            }
        }
    }

    private void clearValueByChangeModel() {
        this.getModel().beginInit();
        this.getModel().setValue(F_AGGMEASURE, null);
        this.getModel().setValue(F_DEFAULTGROUPER, null);
        this.getModel().setValue(F_DIMENSIONCONDITION, (Object)ResManager.loadKDString((String)"\u70b9\u51fb\u8bbe\u7f6e", (String)"FAFIndexEdit_5", (String)"macc-faf-formplugin", (Object[])new Object[0]));
        this.getModel().setValue(FAFUtils.bigTextField((String)F_DIMENSIONCONDITION), null);
        this.getModel().endInit();
        this.getView().updateView(F_AGGMEASURE);
        this.getView().updateView(F_DEFAULTGROUPER);
        this.getView().updateView(F_DIMENSIONCONDITION);
    }

    private void changeValueByChangeIndexFormula() {
        this.getModel().beginInit();
        this.getModel().setValue(F_INDEXFORMULADESC, null);
        this.getModel().setValue(F_INDEXFORMULAARGS, null);
        this.getModel().setValue(F_DEFAULTGROUPER, null);
        this.getModel().endInit();
        this.getView().updateView(F_INDEXFORMULADESC);
        this.getView().updateView(F_INDEXFORMULAARGS);
        this.getView().updateView(F_DEFAULTGROUPER);
    }

    private void changeValueByClearFormula(String newValue) {
        this.getModel().beginInit();
        this.getModel().setValue(F_INDEXFORMULA, null);
        this.getModel().setValue(F_INDEXFORMULADESC, null);
        this.getModel().setValue(F_INDEXFORMULAARGS, null);
        this.getModel().setValue(F_DEFAULTGROUPER, null);
        this.getModel().endInit();
        this.getView().updateView(F_INDEXFORMULA);
        this.getView().updateView(F_INDEXFORMULADESC);
        this.getView().updateView(F_INDEXFORMULAARGS);
        this.getView().updateView(F_DEFAULTGROUPER);
    }

    private void setMustInput(String key, boolean mustInput) {
        FieldEdit edit = (FieldEdit)this.getControl(key);
        edit.setMustInput(mustInput);
    }

    private void lockCtrls() {
        Long pkValue;
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (!status.equals((Object)OperationStatus.ADDNEW)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{F_CATEGORY});
        }
        if ((pkValue = (Long)this.getModel().getDataEntity().getPkValue()) > 0L) {
            Boolean isSystem = (Boolean)this.getModel().getValue(F_IS_SYSTEM);
            if (Boolean.TRUE.equals(isSystem)) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"conentpanel"});
            } else {
                this.getView().setEnable(Boolean.FALSE, new String[]{F_CATEGORY});
            }
            if (BaseDataRefrenceHelper.isRefrenced((String)FORMID, (Object)pkValue) || BaseDataRefrenceHelper.getAllRefs((String)FORMID, (Object)pkValue).size() > 0) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"number", F_GROUP, "ctrlstrategy", F_SYSTEM, F_MODEL, "description", "advconap", F_DIMENSIONCONDITION});
                this.getPageCache().put("isRefrenced", "true");
            }
        }
    }

    private void unlockCtrls() {
        this.getView().setEnable(Boolean.TRUE, new String[]{"number", F_GROUP, "ctrlstrategy", F_SYSTEM, F_MODEL, "description", "advconap", F_DIMENSIONCONDITION, "conentpanel"});
        this.getPageCache().remove("isRefrenced");
    }

    private DynamicObject getFmodel() {
        DynamicObject dy = (DynamicObject)this.getModel().getValue(F_MODEL);
        if (dy == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u5206\u6790\u6a21\u578b\u201d\u3002", (String)"FAFIndexEdit_6", (String)"macc-faf-formplugin", (Object[])new Object[0]));
            return null;
        }
        return dy;
    }

    private DynamicObject getFsystem() {
        DynamicObject dy = (DynamicObject)this.getModel().getValue(F_SYSTEM);
        if (dy == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u5206\u6790\u4f53\u7cfb\u201d\u3002", (String)"FAFIndexEdit_7", (String)"macc-faf-formplugin", (Object[])new Object[0]));
            return null;
        }
        return dy;
    }

    private String getCreateOrg() {
        return String.valueOf(this.getModel().getValue("createorg_id"));
    }

    private List<Object> getAllDidmensions() {
        return FAFIndexBusinessHelper.loadAllDimensionIds((Object)this.getModel().getDataEntity());
    }

    private void jumpToQFilterSettingDialog() {
        DynamicObject model = this.getFmodel();
        if (model == null) {
            return;
        }
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        FAFFilterDialogPlugin.openBy(this, model.getPkValue(), this.getPageCache().get("isRefrenced"), this.getModel().getValue(FAFUtils.bigTextField((String)F_DIMENSIONCONDITION)), this.getCreateOrg(), "set_dimension_filter");
    }

    private void jumpToFormulaCaculation() {
        DynamicObject f_system = this.getFsystem();
        if (f_system != null) {
            String indexformula = (String)this.getModel().getValue(F_INDEXFORMULA);
            String indexformulaDesc = (String)this.getModel().getValue(F_INDEXFORMULADESC);
            FAFCalculationFormulaEdit.jumpMe(this.getView(), indexformula, indexformulaDesc, this, f_system);
        }
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        String formId;
        String bizAppId = ShowFormHelper.getBizAppId((FormShowParameter)e.getFormShowParameter());
        LicenseCheckResult checkResult = LicenseUtil.Check(bizAppId, formId = e.getFormShowParameter().getFormId());
        boolean hasLicense = checkResult.getHasLicense();
        e.setCancel(!hasLicense);
        e.setCancelMessage(checkResult.getMsg());
        e.setCancelFormShowParameter(checkResult.getCancelFormShowParameter());
    }
}

