/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.fas;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.AlgoException;
import kd.bos.algo.CachedDataSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.FilterFunction;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ComboPropShowStyle;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.ComboReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.macc.faf.enums.FAFDimensionTypeEnum;
import kd.macc.faf.fas.FAFIndexBusinessHelper;
import kd.macc.faf.fas.enums.FAFComparisonEnum;
import kd.macc.faf.fas.enums.FAFComparisonMetaEnum;
import kd.macc.faf.fas.enums.FAFSystemVariableEnum;
import kd.macc.faf.fas.index.func.algo.FAFResultFilterFunction;
import kd.macc.faf.fas.index.model.FAFIndex;
import kd.macc.faf.fas.index.model.FAFVariable;
import kd.macc.faf.fas.service.factory.FAFIndexServiceFactory;
import kd.macc.faf.fas.service.helper.FAFCalcCacheServiceHelper;
import kd.macc.faf.helper.FAFDimensionHelper;

public class FAFIndexTestRptListPlugin
extends AbstractReportListDataPlugin {
    private static final String ALGO_KEY = FAFIndexTestRptListPlugin.class.getName();
    private FAFIndex fasindex;
    private RowMeta rowMeta;

    public Map<String, Object> queryCalculteResult(ReportQueryParam queryParam) {
        this.fasindex = FAFIndexBusinessHelper.buildFasIndex((ReportQueryParam)queryParam);
        Map commit = FAFIndexServiceFactory.getCalculateService().commit(this.fasindex, 20);
        this.rowMeta = (RowMeta)commit.get("rowMeta");
        commit.put("fasindex", this.fasindex);
        return commit;
    }

    public DataSet query(ReportQueryParam queryParam, Object selectedObj) throws Throwable {
        try {
            Map<String, Object> map = this.queryCalculteResult(queryParam);
            String chacheId = (String)map.get("cacheId");
            CachedDataSet cacheDataSet = Algo.getCacheDataSet((String)chacheId);
            DataSet dataset = cacheDataSet.toDataSet(Algo.create((String)ALGO_KEY), false);
            List variables = this.fasindex.getVariableList();
            for (FAFVariable variable : variables) {
                dataset = dataset.filter((FilterFunction)new FAFResultFilterFunction(variable.getFieldName(), FAFSystemVariableEnum.getValues((Object)variable.getVariableCode())));
            }
            return dataset.limit(0, 1000);
        }
        catch (AlgoException ex) {
            FAFCalcCacheServiceHelper.clearCache((FAFIndex)this.fasindex);
            throw new KDBizException(ResManager.loadKDString((String)"\u8ba1\u7b97\u7ed3\u679c\u96c6\u5931\u6548,\u8bf7\u91cd\u8bd5", (String)"FAFIndexTestRptListPlugin_0", (String)"macc-faf-formplugin", (Object[])new Object[0]));
        }
        catch (Exception ex) {
            String message = ex.getMessage();
            if (message != null && message.endsWith("\u3002")) {
                message = message.substring(0, message.length() - 1);
            }
            throw new KDBizException(message);
        }
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) throws Throwable {
        int fieldCount = this.rowMeta.getFieldCount();
        List dimensions = this.fasindex.getDimensions();
        Map<String, DynamicObject> dimensionMap = dimensions.stream().collect(Collectors.toMap(dynamicObject -> dynamicObject.getString("number"), o -> o));
        Map allIndexMap = this.fasindex.getAllIndexMap();
        for (int i = 0; i < fieldCount; ++i) {
            ReportColumn column;
            Field field = this.rowMeta.getField(i);
            String fieldName = field.getName();
            String sqlType = field.getDataType().getSql();
            String caption = field.getAlias();
            if ("BigDecimal".equals(sqlType) || "Integer".equals(sqlType)) {
                int precision;
                column = new ReportColumn();
                column.setFieldKey(fieldName);
                if ("BigDecimal".equals(sqlType)) {
                    column.setFieldType("decimal");
                } else {
                    column.setFieldType("integer");
                }
                String comparisonFieldCaption = FAFComparisonEnum.getCaption((String)this.fasindex.getIndexName(), (String)fieldName);
                if (comparisonFieldCaption != null) {
                    precision = this.fasindex.getScale();
                    caption = comparisonFieldCaption;
                } else {
                    FAFComparisonMetaEnum[] values;
                    FAFIndex index = (FAFIndex)allIndexMap.get(field.getName());
                    String endfix = "";
                    for (FAFComparisonMetaEnum cmeta : values = FAFComparisonMetaEnum.values()) {
                        boolean comparison = fieldName.startsWith(cmeta.getPrefix());
                        if (!comparison) continue;
                        index = (FAFIndex)allIndexMap.get(fieldName.substring(cmeta.getPrefix().length()));
                        endfix = cmeta.getDescription();
                    }
                    if (index != null) {
                        caption = index.getIndexName() + endfix;
                        precision = index.getScale();
                    } else {
                        precision = this.fasindex.getScale();
                    }
                }
                column.setScale(precision);
                column.setZeroShow(true);
            } else {
                column = new ReportColumn();
                column.setFieldKey(field.getName());
                column.setFieldType("text");
                DynamicObject dimension = dimensionMap.get(fieldName);
                if (dimension != null) {
                    caption = dimension.getString("name");
                    String dimensiontype = dimension.getString("dimensiontype");
                    if (FAFDimensionTypeEnum.DATABASE.eqScene((Object)dimensiontype)) {
                        column.setFieldType("basedata");
                        column.setEntityId(dimension.getDynamicObject("dimensionsource").getString("number"));
                    } else if (FAFDimensionTypeEnum.ASSISTANTDATA.eqScene((Object)dimensiontype)) {
                        column.setFieldType("basedata");
                        column.setEntityId("bos_assistantdata_detail");
                    } else if (FAFDimensionTypeEnum.DATE.eqScene((Object)dimensiontype)) {
                        column.setFieldType("date");
                    } else if (FAFDimensionTypeEnum.DENUMS.eqScene((Object)dimensiontype)) {
                        ComboReportColumn comboColumn = new ComboReportColumn();
                        comboColumn.setFieldKey(field.getName());
                        comboColumn.setFieldType("combofield");
                        comboColumn.setComboShowStyle(ComboPropShowStyle.Title.getValue());
                        List comboItems = FAFDimensionHelper.getValueMapItems((DynamicObject)dimension);
                        comboColumn.setComboItems(comboItems);
                        ComboProp property = new ComboProp();
                        property.setName(fieldName);
                        property.setComboItems(comboItems);
                        comboColumn.setFieldProperty((DynamicProperty)property);
                        column = comboColumn;
                    }
                }
            }
            column.setCaption(new LocaleString(caption));
            columns.add((AbstractReportColumn)column);
        }
        return super.getColumns(columns);
    }
}

