/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.fas;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.report.IReportView;
import kd.bos.report.ReportShowParameter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.macc.faf.common.FAFUtils;
import kd.macc.faf.common.OpLogProxy;
import kd.macc.faf.enums.FAFDimensionTypeEnum;
import kd.macc.faf.fas.FAFDialogDateRangePlugin;
import kd.macc.faf.fas.FAFDialogMatchVariablePlugin;
import kd.macc.faf.fas.FAFFormulaCalculationDataHelper;
import kd.macc.faf.fas.FAFIndexBusinessHelper;
import kd.macc.faf.fas.FAFInputComboFormPlugin;
import kd.macc.faf.fas.FAFInputTextFormPlugin;
import kd.macc.faf.fas.dto.FAFDateRange;
import kd.macc.faf.fas.enums.FAFComparisonEnum;
import kd.macc.faf.fas.enums.FAFIndexCategoryEnum;
import kd.macc.faf.fas.enums.FAFParamsCompareEnum;
import kd.macc.faf.fas.enums.FAFSystemVariableEnum;
import kd.macc.faf.fas.index.FAFIndexDynamicObject;
import kd.macc.faf.fas.index.model.FAFIndex;
import kd.macc.faf.fas.qing.FAFIndexQingDataProvider;
import kd.macc.faf.fas.service.helper.FAFCalcCacheServiceHelper;
import kd.macc.faf.helper.FAFDimensionHelper;
import kd.macc.faf.util.BaseDataUtil;

public class FAFIndexTestRptPlugin
extends AbstractReportFormPlugin {
    private static final String FORMID = "pa_fasindex_testcalculate";
    private static final String P_FASINDEX = "fasindex";
    private static final String F_FASINDEX = "fasindex";
    private static final String F_COMPARISONTYPE = "comparisontypes";
    private static final String F_INCLUDEPROCESS = "includeProcess";
    private static final String ENTRY_PARAMS = "entryentityparams";
    private static final String F_E_DIMENSION = "dimension";
    private static final String F_E_VALUETEXT = "valuetext";
    private static final String F_E_COMPARETYPE = "comparetype";
    private static final String F_E_VALUEIDS = "valueids";
    private static final String ACTION_SETFILTER = "setfilter";
    private static final String ACTION_SETFILTER_TEXT = "setfiltertext";
    private static final String ACTION_SETFILTER_ENUMS = "setfilterenums";
    private static final String ACTION_SET_MATCH_VAR = "setmatchvariable";
    private static final String ACTION_SET_DATERANGE = "setdateRange";

    public static void openBy(AbstractFormPlugin plugin, Object pkValue, String useOrgId, String actionId) {
        if (FAFIndexTestRptPlugin.validField(plugin.getView(), pkValue)) {
            ReportShowParameter fsp = new ReportShowParameter();
            fsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            fsp.setFormId(FORMID);
            fsp.setCaption(ResManager.loadKDString((String)"\u8bd5\u8ba1\u7b97", (String)"FAFIndexTestRptPlugin_9", (String)"macc-faf-formplugin", (Object[])new Object[0]));
            fsp.setCustomParam("fasindex", pkValue);
            fsp.setCustomParam("useOrgId", (Object)useOrgId);
            fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, actionId));
            plugin.getView().showForm((FormShowParameter)fsp);
        }
    }

    private static boolean validField(IFormView view, Object pkValue) {
        try {
            FAFIndexDynamicObject.create((Object)pkValue);
        }
        catch (KDBizException ex) {
            view.showErrorNotification(ex.getMessage());
            return false;
        }
        return true;
    }

    public void registerListener(EventObject evt) {
        this.addItemClickListeners(new String[]{"toolbarap"});
        BasedataEdit fasindex = (BasedataEdit)this.getControl("fasindex");
        fasindex.addBeforeF7SelectListener(event -> ((ListShowParameter)event.getFormShowParameter()).setUseOrgId(this.getUseOrg()));
        this.addClickListeners(new String[]{F_E_VALUETEXT});
        BasedataEdit control = (BasedataEdit)this.getControl(F_E_DIMENSION);
        control.addBeforeF7SelectListener(event -> {
            DynamicObject dy = this.getFasindex();
            if (dy == null) {
                event.setCancel(true);
                return;
            }
            List pkIds = FAFIndexBusinessHelper.loadAllDimensionIds((Object)dy.getPkValue());
            pkIds.removeAll(this.getDimensionSettingIds());
            event.getCustomQFilters().add(new QFilter("id", "in", (Object)pkIds));
        });
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        try {
            Object pkValue = this.getView().getFormShowParameter().getCustomParam("fasindex");
            if (pkValue != null && !pkValue.equals(0L)) {
                this.getModel().setValue("fasindex", pkValue);
                this.getView().setEnable(Boolean.FALSE, new String[]{"fasindex"});
                this.initSetting(pkValue);
            }
        }
        catch (KDBizException ex) {
            this.getView().showTipNotification(ex.getMessage());
        }
        catch (Exception ex) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u6307\u6807\u914d\u7f6e\u9519\u8bef:%s\u3002", (String)"FAFIndexTestRptPlugin_0", (String)"macc-faf-formplugin", (Object[])new Object[0]), ex.getMessage()));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        IDataModel model = this.getModel();
        ChangeData changeData = e.getChangeSet()[0];
        if (F_E_VALUETEXT.equals(name)) {
            if (StringUtils.isEmpty((CharSequence)String.valueOf(changeData.getNewValue()))) {
                int rowIndex = model.getEntryCurrentRowIndex(ENTRY_PARAMS);
                model.setValue(F_E_VALUEIDS, null, rowIndex);
            }
        } else if ("fasindex".equals(name)) {
            this.initSetting(this.getModel().getValue("fasindex_id"));
        } else if (F_E_COMPARETYPE.equals(name)) {
            int rowIndex = model.getEntryCurrentRowIndex(ENTRY_PARAMS);
            model.setValue(F_E_VALUETEXT, null, rowIndex);
            model.setValue(F_E_VALUEIDS, null, rowIndex);
        } else if (F_E_DIMENSION.equals(name)) {
            int rowIndex = changeData.getRowIndex();
            DynamicObject dimension = (DynamicObject)changeData.getNewValue();
            this.initDimensionSettingRow(dimension, rowIndex);
        }
    }

    private void initDimensionSettingRow(DynamicObject dimension, int rowIndex) {
        IDataModel model = this.getModel();
        if (dimension != null) {
            String dimensiontype = dimension.getString("dimensiontype");
            if (FAFDimensionTypeEnum.DATE.eqScene((Object)dimensiontype)) {
                model.setValue(F_E_COMPARETYPE, (Object)FAFParamsCompareEnum.COMPARE_DATE_BETWEEN_AND_1.getCode(), rowIndex);
            } else {
                model.setValue(F_E_COMPARETYPE, (Object)FAFParamsCompareEnum.COMPARE_IN_0.getCode(), rowIndex);
            }
        } else {
            model.setValue(F_E_COMPARETYPE, (Object)FAFParamsCompareEnum.COMPARE_IN_0.getCode(), rowIndex);
        }
        model.setValue(F_E_VALUETEXT, null, rowIndex);
        model.setValue(F_E_VALUEIDS, null, rowIndex);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if ("baritemapqing".equals(args.getOperateKey()) && args.getOperationResult().isSuccess()) {
            this.openQingPage(new ReportQueryParam());
        } else if ("clearcache".equals(args.getOperateKey()) && args.getOperationResult().isSuccess()) {
            this.clearCalculateCache(new ReportQueryParam());
        }
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        IDataModel model = this.getModel();
        if (F_E_VALUETEXT.equals(key)) {
            int rowIndex = model.getEntryCurrentRowIndex(ENTRY_PARAMS);
            String valueids = (String)model.getValue(F_E_VALUEIDS, rowIndex);
            Object pkvalue = model.getValue("dimension_id", rowIndex);
            if (pkvalue != null && !pkvalue.equals(0L)) {
                Object value = this.getModel().getValue(F_E_COMPARETYPE, rowIndex);
                if (FAFParamsCompareEnum.COMPARE_IN_0.eq(value)) {
                    DynamicObject paDimension = BusinessDataServiceHelper.loadSingleFromCache((Object)pkvalue, (String)"pa_dimension");
                    this.showFilterForm(paDimension, valueids);
                } else if (FAFParamsCompareEnum.COMPARE_DATE_BETWEEN_AND_1.eq(value)) {
                    this.doCompareTypeByBetweenAnd(pkvalue, valueids);
                } else if (FAFParamsCompareEnum.COMPARE_MATCHING_A.eq(value)) {
                    this.doCompareTypeByMatching(pkvalue, valueids);
                }
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u7ef4\u5ea6\u201d\u3002", (String)"FAFIndexTestRptPlugin_1", (String)"macc-faf-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private void doCompareTypeByMatching(Object pkvalue, String valueids) {
        FAFIndexDynamicObject fobject = FAFIndexDynamicObject.create((Object)Objects.requireNonNull(this.getFasindex()).getPkValue());
        FAFIndex root = fobject.getRoot();
        DynamicObject dimOrg = root.getDimensionOrg();
        if (pkvalue.equals(dimOrg.getPkValue())) {
            FAFDialogMatchVariablePlugin.openBy((AbstractFormPlugin)this, valueids, ACTION_SET_MATCH_VAR);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u652f\u6301\u8be5\u7c7b\u578b\u7ef4\u5ea6\u7684\u5339\u914d\u53d8\u91cf\u3002", (String)"FAFIndexTestRptPlugin_2", (String)"macc-faf-formplugin", (Object[])new Object[0]));
        }
    }

    private void doCompareTypeByBetweenAnd(Object pkvalue, String valueids) {
        FAFDialogDateRangePlugin.openBy((AbstractFormPlugin)this, valueids, ACTION_SET_DATERANGE);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionId = e.getActionId();
        if (ACTION_SETFILTER.equals(actionId) && e.getReturnData() != null) {
            ListSelectedRowCollection data = (ListSelectedRowCollection)e.getReturnData();
            if (data != null && !data.isEmpty()) {
                StringBuilder nameBuilder = new StringBuilder();
                StringBuilder idBuilder = new StringBuilder();
                for (ListSelectedRow row : data) {
                    nameBuilder.append(row.getName()).append(',');
                    idBuilder.append(row.getPrimaryKeyValue()).append(',');
                }
                int rowIndex = this.getModel().getEntryCurrentRowIndex(ENTRY_PARAMS);
                IDataModel model = this.getModel();
                model.setValue(F_E_VALUETEXT, (Object)nameBuilder.subSequence(0, nameBuilder.length() - 1), rowIndex);
                model.setValue(F_E_VALUEIDS, (Object)idBuilder.subSequence(0, idBuilder.length() - 1), rowIndex);
            }
        } else if (ACTION_SETFILTER_TEXT.equals(actionId) && e.getReturnData() != null) {
            String text = (String)e.getReturnData();
            int rowIndex = this.getModel().getEntryCurrentRowIndex(ENTRY_PARAMS);
            this.getModel().setValue(F_E_VALUEIDS, (Object)text, rowIndex);
            this.getModel().setValue(F_E_VALUETEXT, (Object)text, rowIndex);
        } else if (ACTION_SETFILTER_ENUMS.equals(actionId) && e.getReturnData() != null) {
            Object returnData = e.getReturnData();
            int rowIndex = this.getModel().getEntryCurrentRowIndex(ENTRY_PARAMS);
            if (returnData instanceof Map) {
                Map map = (Map)FAFUtils.cast((Object)returnData);
                this.getModel().setValue(F_E_VALUEIDS, map.get("value"), rowIndex);
                this.getModel().setValue(F_E_VALUETEXT, map.get("text"), rowIndex);
            }
        } else if (ACTION_SET_MATCH_VAR.equals(actionId) && e.getReturnData() != null) {
            String systemvariable = (String)e.getReturnData();
            FAFSystemVariableEnum variableEnum = FAFSystemVariableEnum.getEnum((String)systemvariable);
            int rowIndex = this.getModel().getEntryCurrentRowIndex(ENTRY_PARAMS);
            this.getModel().setValue(F_E_VALUEIDS, (Object)systemvariable, rowIndex);
            this.getModel().setValue(F_E_VALUETEXT, (Object)variableEnum.getCaption(), rowIndex);
        } else if (ACTION_SET_DATERANGE.equals(actionId) && e.getReturnData() != null) {
            FAFDateRange dateRange = (FAFDateRange)e.getReturnData();
            int rowIndex = this.getModel().getEntryCurrentRowIndex(ENTRY_PARAMS);
            this.getModel().setValue(F_E_VALUEIDS, (Object)dateRange.getDateRange(), rowIndex);
            this.getModel().setValue(F_E_VALUETEXT, (Object)dateRange.getShowText(), rowIndex);
        }
    }

    private void clearCalculateCache(ReportQueryParam queryParam) {
        boolean verifyQuery = this.verifyQuery(queryParam);
        if (!verifyQuery) {
            return;
        }
        FAFIndex fasIndex = FAFIndexBusinessHelper.buildFasIndex((ReportQueryParam)queryParam);
        FAFCalcCacheServiceHelper.clearCache((FAFIndex)fasIndex);
    }

    private void openQingPage(ReportQueryParam queryParam) {
        boolean verifyQuery = this.verifyQuery(queryParam);
        if (!verifyQuery) {
            return;
        }
        Map customParam = queryParam.getCustomParam();
        Map params = (Map)FAFUtils.cast(customParam.get("params"));
        String comparisontype = (String)customParam.get("comparisontype");
        FAFIndex fasIndex = FAFIndexDynamicObject.create(customParam.get("pkValue")).calculate(params, comparisontype);
        DynamicObject dimensionOrg = fasIndex.getDimensionOrg();
        if (dimensionOrg == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6307\u6807\u53c2\u4e0e\u8ba1\u7b97\u7684\u5206\u6790\u6a21\u578b\u7684\u5fc5\u8981\u7ef4\u5ea6\"\u7ec4\u7ec7\"\u4e0d\u540c,\u65e0\u6cd5\u8fdb\u5165\u8f7b\u5206\u6790\u3002", (String)"FAFIndexTestRptPlugin_3", (String)"macc-faf-formplugin", (Object[])new Object[0]));
            return;
        }
        List matchs = (List)FAFUtils.cast(customParam.get("matchs"));
        if (matchs != null) {
            matchs.removeIf(map -> !FAFParamsCompareEnum.COMPARE_MATCHING_A.eq((Object)map.getOrDefault(F_E_COMPARETYPE, "")));
        }
        Set longs = params.keySet();
        boolean seletedOrg = false;
        for (Long aLong : longs) {
            DynamicObject period;
            if (fasIndex.needComparison() && aLong.equals((period = fasIndex.getDimensionPeriod()).getPkValue())) continue;
            if (aLong.equals(dimensionOrg.getPkValue())) {
                seletedOrg = true;
            }
            params.put(aLong, new Object[0]);
        }
        if (!seletedOrg) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8fdb\u5165\u8f7b\u5206\u6790\u8981\u6c42\u7ef4\u5ea6\u8bbe\u7f6e\u6dfb\u52a0\"%s\"\u7ef4\u5ea6\u3002", (String)"FAFIndexTestRptPlugin_4", (String)"macc-faf-formplugin", (Object[])new Object[0]), dimensionOrg.getString("name")));
            return;
        }
        customParam.put("params", params);
        FormShowParameter parameter = FAFIndexQingDataProvider.buildFsp(queryParam, Objects.requireNonNull(this.getFasindex()).getPkValue());
        this.getView().showForm(parameter);
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        DynamicObject dy = this.getFasindex();
        if (dy == null) {
            return false;
        }
        String comparisontype = (String)this.getModel().getValue(F_COMPARISONTYPE);
        if (comparisontype == null) {
            return false;
        }
        Map customParam = queryParam.getCustomParam();
        boolean fill = this.fillDimensionSetting(customParam);
        customParam.put("comparisontype", comparisontype);
        customParam.put("pkValue", dy.getPkValue());
        Boolean includeProcess = (Boolean)this.getModel().getValue(F_INCLUDEPROCESS);
        customParam.put(F_INCLUDEPROCESS, includeProcess.toString());
        return fill;
    }

    private boolean fillDimensionSetting(Map<String, Object> customParam) {
        DynamicObjectCollection entrys = this.getModel().getEntryEntity(ENTRY_PARAMS);
        LinkedHashMap<Long, Object[]> inMap = new LinkedHashMap<Long, Object[]>(entrys.size());
        ArrayList matchs = new ArrayList(2);
        for (DynamicObject entry : entrys) {
            DynamicObject dimension = entry.getDynamicObject(F_E_DIMENSION);
            if (dimension == null) continue;
            String compareType = entry.getString(F_E_COMPARETYPE);
            if (FAFParamsCompareEnum.COMPARE_IN_0.eq((Object)compareType)) {
                inMap.put(dimension.getLong("id"), this.parseFEvalueIds(entry));
                continue;
            }
            if (FAFParamsCompareEnum.COMPARE_DATE_BETWEEN_AND_1.eq((Object)compareType)) {
                inMap.put(dimension.getLong("id"), new String[0]);
                HashMap<String, Object> match = new HashMap<String, Object>(3);
                match.put("dimensionid", dimension.getLong("id"));
                match.put(F_E_COMPARETYPE, compareType);
                match.put("variable", this.parseFEvalueIds(entry));
                matchs.add(match);
                inMap.put(dimension.getLong("id"), new String[0]);
                continue;
            }
            if (!FAFParamsCompareEnum.COMPARE_MATCHING_A.eq((Object)compareType)) continue;
            String matchvariable = entry.getString(F_E_VALUEIDS);
            if (StringUtils.isNotEmpty((CharSequence)matchvariable)) {
                inMap.put(dimension.getLong("id"), new String[0]);
                HashMap<String, Object> match = new HashMap<String, Object>(3);
                match.put("dimensionid", dimension.getLong("id"));
                match.put(F_E_COMPARETYPE, compareType);
                match.put("variable", new Object[]{matchvariable});
                matchs.add(match);
                continue;
            }
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7ef4\u5ea6\u201c%s\u201d\u5339\u914d\u53d8\u91cf\u7684\u503c\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FAFIndexTestRptPlugin_5", (String)"macc-faf-formplugin", (Object[])new Object[0]), dimension.getString("name")));
            return false;
        }
        customParam.put("params", inMap);
        customParam.put("matchs", matchs);
        return true;
    }

    private Object[] parseFEvalueIds(DynamicObject entry) {
        Object[] split;
        String string = entry.getString(F_E_VALUEIDS);
        if (StringUtils.isNotEmpty((CharSequence)string)) {
            if (string.startsWith(",")) {
                string = string.substring(1);
            }
            split = string.split(",");
        } else {
            split = new String[]{};
        }
        return split;
    }

    private String getComparisontypeDesc(String comparisonTypes) {
        String[] split = comparisonTypes.split(",");
        return Stream.of(split).filter(StringUtils::isNotEmpty).map(s -> FAFComparisonEnum.getEnum((String)s).getDescription()).collect(Collectors.joining(","));
    }

    public void afterQuery(ReportQueryParam queryParam) {
        super.afterQuery(queryParam);
        DynamicObject index = this.getFasindex();
        String str = (String)this.getModel().getValue(F_COMPARISONTYPE);
        if (index != null) {
            OpLogProxy.create((String)this.getView().getEntityId()).setOpName("refresh", ResManager.loadKDString((String)"\u6307\u6807\u8bd5\u8ba1\u7b97", (String)"FAFIndexTestRptPlugin_6", (String)"macc-faf-formplugin", (Object[])new Object[0])).setOpDesc(new MultiLangEnumBridge("\u8bd5\u8ba1\u7b97\u6210\u529f\uff1a\u6307\u6807\uff1a%1$s\uff0c\u503c\u7c7b\u578b\uff1a%2$s", "FAFIndexTestRptPlugin_7", "macc-faf-formplugin"), new String[]{index.getString("number"), this.getComparisontypeDesc(str)}).saveLog();
        }
    }

    public void packageData(PackageDataEvent e) {
        if (ReportColumn.class.isAssignableFrom(e.getSource().getClass())) {
            BigDecimal bigDecimalVal;
            String fieldType = ((ReportColumn)e.getSource()).getFieldType();
            String key = ((ReportColumn)e.getSource()).getFieldKey();
            Object value = e.getRowData().get(key);
            if (("decimal".equals(fieldType) || value instanceof BigDecimal) && (BigDecimal.ZERO.equals(bigDecimalVal = (BigDecimal)value) || value == null)) {
                e.setFormatValue((Object)"#DIV/0!");
            }
        }
    }

    private List<Object> getDimensionSettingIds() {
        DynamicObjectCollection entrys = this.getModel().getEntryEntity(ENTRY_PARAMS);
        return entrys.stream().map(dynamicObject -> dynamicObject.get("dimension_id")).collect(Collectors.toList());
    }

    private DynamicObject getFasindex() {
        DynamicObject dy = (DynamicObject)this.getModel().getValue("fasindex");
        if (dy == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u6307\u6807\u201d\u3002", (String)"FAFIndexTestRptPlugin_8", (String)"macc-faf-formplugin", (Object[])new Object[0]));
            return null;
        }
        return dy;
    }

    private void initSetting(Object pkValue) {
        this.initDimensionSetting(pkValue);
        this.initFormulaInfo();
    }

    private void initDimensionSetting(Object obj) {
        IReportView view = this.getView();
        IDataModel model = this.getModel();
        model.deleteEntryData(ENTRY_PARAMS);
        this.getModel().setValue("necessityorg", null);
        if (obj != null && !obj.equals(0L)) {
            model.beginInit();
            FAFIndexDynamicObject FAFIndexDynamicObject2 = FAFIndexDynamicObject.create((Object)obj);
            FAFIndex root = FAFIndexDynamicObject2.getRoot();
            this.getModel().setValue("necessityorg", (Object)root.getDimensionOrg());
            this.getModel().setValue("necessityperiod", (Object)root.getDimensionPeriod());
            List seletedDimensions = root.getDimensions();
            for (DynamicObject dimension : seletedDimensions) {
                int currentRow = model.createNewEntryRow(ENTRY_PARAMS);
                model.setValue(F_E_DIMENSION, (Object)dimension, currentRow);
                this.initDimensionSettingRow(dimension, currentRow);
            }
        }
        model.endInit();
        view.updateView(ENTRY_PARAMS);
    }

    private void initFormulaInfo() {
        DynamicObject index = this.getFasindex();
        if (index != null && FAFIndexCategoryEnum.COMPOSITE == FAFIndexCategoryEnum.getEnum((String)index.getString("category"))) {
            Long systemId = (Long)index.get("system_id");
            this.getModel().setValue("formulatranslation", (Object)FAFFormulaCalculationDataHelper.translateFormulaExpression((String)index.getString("indexformula"), (Long)systemId));
            this.getModel().setValue("formuladesc", (Object)index.getString("indexformuladesc"));
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"formulatranslation"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"formuladesc"});
        }
    }

    public void showFilterForm(DynamicObject dimension, String valueids) {
        String dimensiontype = dimension.getString("dimensiontype");
        if (FAFDimensionTypeEnum.DATABASE.eqScene((Object)dimensiontype)) {
            QFilter qFilter = FAFIndexBusinessHelper.getQFilterByDimension((DynamicObject)dimension);
            DynamicObject baseData = dimension.getDynamicObject("dimensionsource");
            this.showF7FilterForm((String)baseData.getPkValue(), qFilter, valueids);
        } else if (FAFDimensionTypeEnum.ASSISTANTDATA.eqScene((Object)dimensiontype)) {
            this.showF7FilterForm("bos_assistantdata_detail", FAFIndexBusinessHelper.getQFilterByDimension((DynamicObject)dimension), valueids);
        } else if (FAFDimensionTypeEnum.DENUMS.eqScene((Object)dimensiontype)) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("items", FAFDimensionHelper.getValueMapItems((DynamicObject)dimension));
            map.put("seleted", valueids);
            FAFInputComboFormPlugin.openBy((AbstractFormPlugin)this, dimension.getString("name"), map, ACTION_SETFILTER_ENUMS);
        } else if (FAFDimensionTypeEnum.OTHER.eqScene((Object)dimensiontype)) {
            FAFInputTextFormPlugin.openBy((AbstractFormPlugin)this, dimension.getString("name"), ACTION_SETFILTER_TEXT);
        }
    }

    private void showF7FilterForm(String baseEntityId, QFilter qFilter, String pkIdsText) {
        ListShowParameter lsp = BaseDataUtil.createF7ShowParameter(baseEntityId, true, pkIdsText);
        if (qFilter != null) {
            lsp.getListFilterParameter().getQFilters().add(qFilter);
        }
        lsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ACTION_SETFILTER));
        this.getView().showForm((FormShowParameter)lsp);
    }

    private long getUseOrg() {
        Object useOrgId = this.getView().getFormShowParameter().getCustomParams().get("useOrgId");
        if (useOrgId == null) {
            return RequestContext.get().getOrgId();
        }
        return Long.parseLong((String)useOrgId);
    }
}

