/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.fas;

import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ValueMapItem;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.MulComboEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;

public class FAFInputComboFormPlugin
extends AbstractFormPlugin {
    private static final String FORMID = "faf_fasdialogcombo";
    private static final String FIELD_COMBO = "combofield";
    private int limit = 5;
    private Map<String, String> itemsMap;

    public static void openBy(AbstractFormPlugin plugin, String caption, Map<String, Object> params, String actionId) {
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId(FORMID);
        fsp.setCaption(caption);
        fsp.setCustomParam("fieldtitle", (Object)caption);
        fsp.setCustomParam("params", (Object)SerializationUtils.serializeToBase64(params));
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, actionId));
        plugin.getView().showForm(fsp);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        MulComboEdit comboEdit = (MulComboEdit)this.getControl(FIELD_COMBO);
        String title = (String)this.getView().getFormShowParameter().getCustomParam("fieldtitle");
        if (title != null) {
            comboEdit.setCaption(new LocaleString(title));
        }
        try {
            String params = (String)this.getView().getFormShowParameter().getCustomParam("params");
            if (StringUtils.isNotEmpty((CharSequence)params)) {
                Map map = (Map)SerializationUtils.deSerializeFromBase64((String)params);
                List items = (List)map.get("items");
                comboEdit.setComboItems(this.revertToComboItem(items));
                this.cacheItems(items);
                String seleted = (String)map.get("seleted");
                this.getModel().setValue(FIELD_COMBO, (Object)seleted);
            }
        }
        catch (Exception ex) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0b\u62c9\u5f39\u7a97\u7684\u53c2\u6570\u89e3\u6790\u9519\u8bef\u3002", (String)"FAFInputComboFormPlugin_0", (String)"macc-faf-formplugin", (Object[])new Object[0]));
        }
    }

    private List<ComboItem> revertToComboItem(List<ValueMapItem> items) {
        return items.stream().map(vmi -> new ComboItem(vmi.getName(), vmi.getValue(), vmi.getImageKey())).collect(Collectors.toList());
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if ("btnok".equals(key)) {
            this.returnResult();
        }
    }

    private void returnResult() {
        String text = (String)this.getModel().getValue(FIELD_COMBO);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("value", text);
        map.put("text", this.buildDesc(text));
        this.getView().returnDataToParent(map);
        this.getView().close();
    }

    private String buildDesc(String text) {
        String[] split = text.split(",");
        String collect = Arrays.stream(split).filter(s -> !"".equals(s)).map(this::convertToComboName).limit(this.limit).collect(Collectors.joining(","));
        if (collect.length() > 80) {
            collect = collect + "...";
        } else if (split.length > this.limit) {
            collect = collect + "...";
        }
        return collect.substring(0, Math.min(80, collect.length()));
    }

    private void cacheItems(List<ValueMapItem> items) {
        this.itemsMap = items.stream().collect(Collectors.toMap(ValueMapItem::getValue, valueMapItem -> valueMapItem.getName().toString()));
        this.getPageCache().putBigObject("combo_items", SerializationUtils.toJsonString(this.itemsMap));
    }

    private String convertToComboName(String value) {
        if (this.itemsMap == null) {
            String comboItems = this.getPageCache().getBigObject("combo_items");
            this.itemsMap = StringUtils.isNotEmpty((CharSequence)comboItems) ? (Map<Object, Object>)SerializationUtils.fromJsonString((String)comboItems, Map.class) : new LinkedHashMap<String, String>();
        }
        return this.itemsMap.get(value);
    }
}

