/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.fas.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.exception.KDBizException;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.macc.faf.fas.FAFFormulaCalculationDataHelper;
import kd.macc.faf.fas.FAFIndexBusinessHelper;
import kd.macc.faf.fas.dto.FAFFormulaResultDTO;
import kd.macc.faf.fas.exception.FAFFormulaTranslationException;

public class FAFFormulaEditHelper {
    private static final Log logger = LogFactory.getLog(FAFFormulaEditHelper.class);
    public static final String INDEX_ENTRY = "indexentry";
    public static final String DIMENSION_ENTRY = "dimensionentry";
    public static final String PA_FORMULA_CALCULATION = "pa_fasfomulacalculation";
    public static final String TEXT_FORMULA = "text_formula";
    public static final String TEXT_FORMULA_TRANSLATION = "text_formulatranslation";
    public static final String TEXT_DESCRIPTION = "text_description";
    public static final String IS_VALID = "is_valid";
    public static final String INDEX_FORMULA_ARGS = "indexformulaargs";
    public static final Map<String, String> OPERATION_NUMBER_NAME = new HashMap<String, String>(6);

    /*
     * Loose catch block
     */
    public static void initFormulaPanel(IFormView view) {
        String formula = (String)view.getFormShowParameter().getCustomParam(TEXT_FORMULA);
        String formulaDesc = (String)view.getFormShowParameter().getCustomParam(TEXT_DESCRIPTION);
        Long systemId = (Long)view.getFormShowParameter().getCustomParam("systemId");
        if (StringUtils.isBlank((CharSequence)formula)) {
            return;
        }
        String formulaExpressionTranslation = null;
        List orderedIndexIds = null;
        try {
            formulaExpressionTranslation = FAFFormulaCalculationDataHelper.translateFormulaExpression((String)formula, (Long)systemId);
            orderedIndexIds = FAFIndexBusinessHelper.getOrderedIndexIdsByNumbers((List)FAFFormulaCalculationDataHelper.getVariateNumberInFormula((String)formula), (Long)systemId);
        }
        catch (FAFFormulaTranslationException exception) {
            String message;
            formulaExpressionTranslation = message = exception.getCause() != null ? exception.getCause().getMessage() : exception.getMessage();
            view.showErrorNotification(message);
            logger.error(message);
            view.getModel().setValue(TEXT_FORMULA, (Object)formula);
            view.getModel().setValue(TEXT_FORMULA_TRANSLATION, (Object)formulaExpressionTranslation);
            view.getModel().setValue(TEXT_DESCRIPTION, (Object)formulaDesc);
            view.getModel().setValue(IS_VALID, (Object)Boolean.TRUE);
            view.getModel().setValue(INDEX_FORMULA_ARGS, orderedIndexIds == null || orderedIndexIds.isEmpty() ? null : orderedIndexIds.toArray());
        }
        catch (Exception exception1) {
            String message = exception1.getCause() != null ? exception1.getCause().getMessage() : exception1.getMessage();
            throw new KDBizException(message);
            {
                catch (Throwable throwable) {
                    view.getModel().setValue(TEXT_FORMULA, (Object)formula);
                    view.getModel().setValue(TEXT_FORMULA_TRANSLATION, (Object)formulaExpressionTranslation);
                    view.getModel().setValue(TEXT_DESCRIPTION, (Object)formulaDesc);
                    view.getModel().setValue(IS_VALID, (Object)Boolean.TRUE);
                    view.getModel().setValue(INDEX_FORMULA_ARGS, orderedIndexIds == null || orderedIndexIds.isEmpty() ? null : orderedIndexIds.toArray());
                    throw throwable;
                }
            }
        }
        view.getModel().setValue(TEXT_FORMULA, (Object)formula);
        view.getModel().setValue(TEXT_FORMULA_TRANSLATION, (Object)formulaExpressionTranslation);
        view.getModel().setValue(TEXT_DESCRIPTION, (Object)formulaDesc);
        view.getModel().setValue(IS_VALID, (Object)Boolean.TRUE);
        view.getModel().setValue(INDEX_FORMULA_ARGS, orderedIndexIds == null || orderedIndexIds.isEmpty() ? null : orderedIndexIds.toArray());
    }

    public static void initIndexEntry(IFormView view, String searchText) {
        AbstractFormDataModel model = (AbstractFormDataModel)view.getModel();
        model.deleteEntryData(INDEX_ENTRY);
        QFilter unSelfFilter = null;
        long currentIndexId = Long.parseLong((String)view.getFormShowParameter().getCustomParam("currentIndexId"));
        if (currentIndexId > 0L) {
            unSelfFilter = new QFilter("id", "!=", (Object)currentIndexId);
        }
        QFilter referenceSelfFilter = null;
        if (currentIndexId > 0L) {
            referenceSelfFilter = new QFilter("indexformulaargs.fbasedataid.id", "!=", (Object)currentIndexId);
        }
        QFilter systemFilter = null;
        Long systemId = (Long)view.getFormShowParameter().getCustomParam("systemId");
        if (systemId != null) {
            systemFilter = new QFilter("system", "=", (Object)systemId);
        }
        QFilter searchFilter = null;
        if (StringUtils.isNotBlank((CharSequence)searchText)) {
            searchFilter = new QFilter("number", "like", (Object)("%" + searchText + "%")).or(new QFilter("name", "like", (Object)("%" + searchText + "%")));
        }
        QFilter ctrlFilter = BaseDataServiceHelper.getBaseDataFilter((String)"pa_fasindex", (Long)Long.parseLong((String)view.getFormShowParameter().getCustomParam("createOrgId")));
        Map dynamicObjectMap = BusinessDataServiceHelper.loadFromCache((String)"pa_fasindex", (QFilter[])new QFilter[]{unSelfFilter, referenceSelfFilter, systemFilter, searchFilter, ctrlFilter});
        if (CollectionUtils.isEmpty((Map)dynamicObjectMap)) {
            return;
        }
        model.beginInit();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("indexid", new Object[0]);
        vs.addField("indexnumber", new Object[0]);
        vs.addField("indexname", new Object[0]);
        vs.addField("indexshowname", new Object[0]);
        for (Map.Entry objectDynamicObjectEntry : dynamicObjectMap.entrySet()) {
            DynamicObject value = (DynamicObject)objectDynamicObjectEntry.getValue();
            long id = value.getLong("id");
            String number = value.getString("number");
            String name = value.getString("name");
            String showName = String.format("%s(%s)", name, number);
            vs.addRow(new Object[]{id, number, name, showName});
        }
        model.batchCreateNewEntryRow(INDEX_ENTRY, vs);
        model.endInit();
        view.updateView(INDEX_ENTRY);
    }

    public static void initDimensionEntry(IFormView view) {
        ArrayList<DynamicObject> validIndexes = new ArrayList<DynamicObject>(16);
        String formulaExpression = (String)view.getModel().getValue(TEXT_FORMULA);
        QFilter systemFilter = null;
        Long systemId = (Long)view.getFormShowParameter().getCustomParam("systemId");
        if (systemId != null) {
            systemFilter = new QFilter("system", "=", (Object)systemId);
        }
        Map idDynamicMap = BusinessDataServiceHelper.loadFromCache((String)"pa_fasindex", (QFilter[])new QFilter[]{systemFilter});
        Map<String, DynamicObject> numberDynamicMap = idDynamicMap.values().stream().collect(Collectors.toMap(dy -> dy.getString("number"), dy -> dy));
        if (StringUtils.isNotBlank((CharSequence)formulaExpression)) {
            List variateNumberInFormula = FAFFormulaCalculationDataHelper.getVariateNumberInFormula((String)formulaExpression);
            for (String variateNumber : variateNumberInFormula) {
                DynamicObject index = numberDynamicMap.get(variateNumber);
                if (index == null) continue;
                validIndexes.add(index);
            }
        }
        List retainDimensions = FAFIndexBusinessHelper.loadAllDimensions((Object[])validIndexes.stream().map(dy -> dy.getLong("id")).toArray());
        AbstractFormDataModel model = (AbstractFormDataModel)view.getModel();
        model.deleteEntryData(DIMENSION_ENTRY);
        if (CollectionUtils.isEmpty((Collection)retainDimensions)) {
            return;
        }
        model.beginInit();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("dimensionid", new Object[0]);
        vs.addField("dimensionnumber", new Object[0]);
        vs.addField("dimensionshowname", new Object[0]);
        for (DynamicObject retainDimension : retainDimensions) {
            long id = retainDimension.getLong("id");
            String number = retainDimension.getString("number");
            String showName = String.format("%s(%s)", retainDimension.getString("name"), number);
            vs.addRow(new Object[]{id, number, showName});
        }
        model.batchCreateNewEntryRow(DIMENSION_ENTRY, vs);
        model.endInit();
        view.updateView(DIMENSION_ENTRY);
    }

    public static void setVisibleAndEnableByStatus(IFormView view) {
        IFormView parentView = view.getParentView();
        if (parentView == null) {
            return;
        }
        if ("true".equals(view.getFormShowParameter().getCustomParam("isRefrenced"))) {
            view.setEnable(Boolean.FALSE, new String[]{"contentpanel"});
            view.setVisible(Boolean.FALSE, new String[]{"btnok"});
        }
    }

    public static void buildFormulaExpressionByClick(IFormView view, String controlKey, String insertStr) {
        int currentIndex = FAFFormulaEditHelper.getFormulaExpressionCursorIndex(view, controlKey, TEXT_FORMULA);
        String formulaExpressionStr = (String)view.getModel().getValue(TEXT_FORMULA);
        if (StringUtils.isBlank((CharSequence)formulaExpressionStr)) {
            formulaExpressionStr = insertStr;
        } else {
            int i;
            StringBuilder sb = new StringBuilder();
            for (i = 0; i < currentIndex; ++i) {
                sb.append(formulaExpressionStr.charAt(i));
            }
            insertStr = ' ' + insertStr;
            sb.append(insertStr);
            for (i = currentIndex; i < formulaExpressionStr.length(); ++i) {
                sb.append(formulaExpressionStr.charAt(i));
            }
            formulaExpressionStr = sb.toString();
        }
        String formatFormulaExpression = FAFFormulaCalculationDataHelper.formatFormulaExpression((String)formulaExpressionStr);
        HashMap<String, Object> cursorMap = new HashMap<String, Object>(16);
        cursorMap.put("cursorIndex", formatFormulaExpression.length());
        cursorMap.put("ctrlKey", TEXT_FORMULA);
        IClientViewProxy proxy = (IClientViewProxy)view.getService(IClientViewProxy.class);
        proxy.addAction("setTextareaCursorPosition", cursorMap);
        view.getModel().setValue(TEXT_FORMULA, (Object)formatFormulaExpression);
    }

    private static int getFormulaExpressionCursorIndex(IFormView view, String controlKey, String formulaNumber) {
        String formulaStr = (String)view.getModel().getValue(formulaNumber);
        int cursorIndex = StringUtils.isBlank((CharSequence)formulaStr) ? 0 : formulaStr.length();
        IClientViewProxy proxy = (IClientViewProxy)view.getService(IClientViewProxy.class);
        Object listPostData = proxy.getViewState(controlKey);
        if (listPostData instanceof Map) {
            Map map = (Map)listPostData;
            if (map.get("focus") != null) {
                Map focus = (Map)map.get("focus");
                if (focus.get(formulaNumber) != null) {
                    cursorIndex = (Integer)focus.get(formulaNumber);
                }
            } else if (map.get(formulaNumber) != null) {
                cursorIndex = (Integer)map.get(formulaNumber);
            }
        }
        return cursorIndex;
    }

    public static void backSpace(IFormView view, String buttonKey) {
        int currentIndex = FAFFormulaEditHelper.getFormulaExpressionCursorIndex(view, buttonKey, TEXT_FORMULA);
        String formulaExpression = (String)view.getModel().getValue(TEXT_FORMULA);
        if (StringUtils.isBlank((CharSequence)formulaExpression)) {
            return;
        }
        HashSet<String> haltSingleStrSet = new HashSet<String>(16);
        haltSingleStrSet.add(" ");
        haltSingleStrSet.addAll(OPERATION_NUMBER_NAME.values());
        int substrEndPos = currentIndex;
        int substrStartPos = FAFFormulaEditHelper.getSubStartPos(formulaExpression, currentIndex, haltSingleStrSet);
        if (currentIndex != formulaExpression.length()) {
            char currentChar = formulaExpression.charAt(currentIndex);
            if (currentIndex != 0 && !haltSingleStrSet.contains(currentChar + "") && !haltSingleStrSet.contains(formulaExpression.charAt(currentIndex - 1) + "")) {
                int latelyHaltStrPos = haltSingleStrSet.stream().mapToInt(str -> formulaExpression.indexOf((String)str, currentIndex)).filter(index -> index >= 0).min().orElse(-1);
                substrEndPos = latelyHaltStrPos != -1 ? latelyHaltStrPos : formulaExpression.length();
            }
        }
        String newFormulaExpression = formulaExpression.substring(0, substrStartPos) + formulaExpression.substring(substrEndPos);
        HashMap<String, Object> cursorMap = new HashMap<String, Object>(16);
        cursorMap.put("cursorIndex", substrStartPos);
        cursorMap.put("ctrlKey", TEXT_FORMULA);
        IClientViewProxy proxy = (IClientViewProxy)view.getService(IClientViewProxy.class);
        proxy.addAction("setTextareaCursorPosition", cursorMap);
        view.getModel().setValue(TEXT_FORMULA, (Object)newFormulaExpression);
    }

    private static int getSubStartPos(String formulaExpression, int currentIndex, Set<String> haltSingleStrSet) {
        int substrStartPos = 0;
        for (int i1 = currentIndex - 1; i1 >= 0; --i1) {
            substrStartPos = i1;
            if (' ' != formulaExpression.charAt(i1)) break;
        }
        int i2 = substrStartPos;
        while (i2 >= 0 && !haltSingleStrSet.contains(formulaExpression.charAt(i2) + "")) {
            substrStartPos = i2--;
        }
        return substrStartPos;
    }

    public static boolean formulaIsChanged(IFormView view) {
        String currentFormatFormula;
        String originFormatFormula;
        try {
            originFormatFormula = FAFFormulaCalculationDataHelper.formatFormulaExpression((String)((String)view.getFormShowParameter().getCustomParam(TEXT_FORMULA)));
            currentFormatFormula = FAFFormulaCalculationDataHelper.formatFormulaExpression((String)((String)view.getModel().getValue(TEXT_FORMULA)));
        }
        catch (FAFFormulaTranslationException formulaTranslationException) {
            return true;
        }
        return !StringUtils.equals((CharSequence)originFormatFormula, (CharSequence)currentFormatFormula);
    }

    public static FAFFormulaResultDTO buildFormulaResultDTO(IDataModel model) {
        String formula = (String)model.getValue(TEXT_FORMULA);
        String formulaTranslation = (String)model.getValue(TEXT_FORMULA_TRANSLATION);
        String description = (String)model.getValue(TEXT_DESCRIPTION);
        DynamicObjectCollection indexFormulaArgs = (DynamicObjectCollection)model.getValue(INDEX_FORMULA_ARGS);
        FAFFormulaResultDTO formulaExpressionResultDTO = new FAFFormulaResultDTO();
        formulaExpressionResultDTO.setFormulaExpress(formula);
        formulaExpressionResultDTO.setFormulaExpressTranslationDesc(formulaTranslation);
        formulaExpressionResultDTO.setDesc(description);
        formulaExpressionResultDTO.setIndexArgs(indexFormulaArgs);
        return formulaExpressionResultDTO;
    }

    public static void translateCurrentFormulaExpression(IFormView view) {
        IDataModel model = view.getModel();
        String formulaExpression = (String)model.getValue(TEXT_FORMULA);
        Long systemId = (Long)view.getFormShowParameter().getCustomParam("systemId");
        if (StringUtils.isBlank((CharSequence)formulaExpression)) {
            model.setValue(IS_VALID, (Object)Boolean.FALSE);
            model.setValue(INDEX_FORMULA_ARGS, null);
            model.setValue(TEXT_FORMULA_TRANSLATION, (Object)"");
            return;
        }
        try {
            String translateFormulaExpression = FAFFormulaCalculationDataHelper.translateFormulaExpression((String)formulaExpression, (Long)systemId);
            List orderedIndexIdsByNumbers = FAFIndexBusinessHelper.getOrderedIndexIdsByNumbers((List)FAFFormulaCalculationDataHelper.getVariateNumberInFormula((String)formulaExpression), (Long)systemId);
            model.setValue(IS_VALID, (Object)Boolean.TRUE);
            model.setValue(INDEX_FORMULA_ARGS, (Object)orderedIndexIdsByNumbers.toArray());
            model.setValue(TEXT_FORMULA_TRANSLATION, (Object)translateFormulaExpression);
        }
        catch (FAFFormulaTranslationException exception) {
            String translatedFormulaExpression = exception.getCause() != null ? exception.getCause().getMessage() : exception.getMessage();
            model.setValue(IS_VALID, (Object)Boolean.FALSE);
            model.setValue(INDEX_FORMULA_ARGS, null);
            model.setValue(TEXT_FORMULA_TRANSLATION, (Object)translatedFormulaExpression);
            logger.error(exception.getCause() != null ? exception.getCause().getMessage() : exception.getMessage());
        }
        catch (Exception exception2) {
            model.setValue(IS_VALID, (Object)Boolean.FALSE);
            model.setValue(INDEX_FORMULA_ARGS, null);
            model.setValue(TEXT_FORMULA_TRANSLATION, (Object)String.format(ResManager.loadKDString((String)"\u8bed\u6cd5\u9519\u8bef:%s\u8868\u8fbe\u5f0f\u8bed\u6cd5\u5b58\u5728\u9519\u8bef,\u89e3\u6790\u5931\u8d25", (String)"FAFFormulaEditHelper_0", (String)"macc-faf-formplugin", (Object[])new Object[0]), "\r\n"));
            logger.error(exception2.getCause() != null ? exception2.getCause().getMessage() : exception2.getMessage());
        }
    }

    static {
        OPERATION_NUMBER_NAME.put("button_leftbracket", "(");
        OPERATION_NUMBER_NAME.put("button_rightbracket", ")");
        OPERATION_NUMBER_NAME.put("button_add", "+");
        OPERATION_NUMBER_NAME.put("button_minus", "-");
        OPERATION_NUMBER_NAME.put("button_multiply", "*");
        OPERATION_NUMBER_NAME.put("button_division", "/");
    }
}

