/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.fas.qing;

import java.time.Duration;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.algo.Algo;
import kd.bos.algo.AlgoException;
import kd.bos.algo.CachedDataSet;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.qing.Field;
import kd.bos.entity.qing.IQingDataProvider;
import kd.bos.entity.qing.QingData;
import kd.bos.entity.qing.QingFieldType;
import kd.bos.entity.qing.QingMeta;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.macc.faf.fas.FAFIndexTestRptListPlugin;
import kd.macc.faf.fas.qing.FAFQingData;
import kd.macc.faf.fas.service.helper.FAFCalcCacheServiceHelper;

public class FAFIndexQingDataProvider
extends AbstractFormPlugin
implements IQingDataProvider {
    private static final Log logger = LogFactory.getLog(FAFIndexQingDataProvider.class);
    private static final String PARAMS_QUERYPARAM = "queryParam";
    private static final String PARAMS_INDEXPKVALUE = "indexPkValue";
    private static final String QING_CAlC_RESULT = "fasIndexQingDataProvider_qingcalcresult";
    private static final String QING_META = "fasIndexQingDataProvider_qingMeta";
    private static final Pattern humpPattern = Pattern.compile("[A-Z]");

    private int getQingType(String fieldType) {
        switch (fieldType) {
            case "price": 
            case "qty": 
            case "amount": 
            case "decimal": {
                return QingFieldType.Number.toNumber();
            }
            case "integer": {
                return QingFieldType.Int.toNumber();
            }
            case "date": {
                return QingFieldType.Date.toNumber();
            }
        }
        return QingFieldType.String.toNumber();
    }

    private ReportQueryParam getReportQueryParam() {
        String parameter = this.getFilterParameter();
        if (parameter == null) {
            parameter = this.getPageCache().get(PARAMS_QUERYPARAM);
        }
        return (ReportQueryParam)SerializationUtils.deSerializeFromBase64((String)parameter);
    }

    private QingMeta createQingMeta(List<AbstractReportColumn> columns) {
        QingMeta qingMeta = new QingMeta();
        for (AbstractReportColumn reportColumn : columns) {
            ReportColumn column = (ReportColumn)reportColumn;
            qingMeta.addColumn(this.createField(column));
        }
        return qingMeta;
    }

    public static String compatibilityFieldKey(String str) {
        Matcher matcher = humpPattern.matcher(str);
        StringBuffer sb = new StringBuffer();
        boolean match = false;
        while (matcher.find()) {
            match = true;
            matcher.appendReplacement(sb, "_" + matcher.group(0).toLowerCase());
        }
        matcher.appendTail(sb);
        if (match) {
            sb.insert(0, "_");
        }
        return sb.toString().toLowerCase();
    }

    private Field createField(ReportColumn column) {
        Field field = new Field();
        field.setKey(FAFIndexQingDataProvider.compatibilityFieldKey(column.getFieldKey()));
        field.setName(column.getCaption());
        field.setFieldType(this.getQingType(column.getFieldType()));
        field.setEntity(column.getEntityId());
        field.setRefEntity(column.getEntityId());
        return field;
    }

    public void setFilterParameter(String filterParameter) {
        this.getPageCache().put(PARAMS_QUERYPARAM, filterParameter);
        this.getPageCache().saveChanges();
    }

    public String getFilterParameter() {
        return (String)this.getView().getFormShowParameter().getCustomParam(PARAMS_QUERYPARAM);
    }

    public QingMeta getMeta(String pageId) {
        try {
            LocalDateTime startTime = LocalDateTime.now();
            logger.info("getMeta : start: {}  pageId: {} ", (Object)startTime, (Object)pageId);
            ReportQueryParam queryParam = this.getReportQueryParam();
            queryParam.getCustomParam().put("requestSource", "qing");
            FAFIndexTestRptListPlugin rpt = new FAFIndexTestRptListPlugin();
            Map<String, Object> result = rpt.queryCalculteResult(queryParam);
            try {
                String cacheId = (String)result.get("cacheId");
                CachedDataSet cachedDataSet = Algo.getCacheDataSet((String)cacheId);
            }
            catch (AlgoException ex) {
                FAFCalcCacheServiceHelper.clearCache((String)((String)result.getOrDefault("cacheKey", "")));
                result = rpt.queryCalculteResult(queryParam);
            }
            this.getPageCache().put(QING_CAlC_RESULT, SerializationUtils.serializeToBase64(result));
            List<AbstractReportColumn> columns = rpt.getColumns(new ArrayList<AbstractReportColumn>());
            QingMeta qingMeta = this.createQingMeta(columns);
            this.getPageCache().put(QING_META, SerializationUtils.serializeToBase64((Object)qingMeta));
            this.getPageCache().saveChanges();
            LocalDateTime endTime = LocalDateTime.now();
            logger.info("getMeta : end: {} pageId: {} \u8017\u65f6(\u6beb\u79d2): {}", new Object[]{endTime, pageId, Duration.between(startTime, endTime).toMillis()});
            return qingMeta;
        }
        catch (Throwable e) {
            logger.error("qing erro", e);
            throw new KDBizException(e.getMessage());
        }
    }

    public QingData getData(String pageId, int startRow, int limit) {
        LocalDateTime startTime = LocalDateTime.now();
        logger.info("getData : start: {} pageId: {} {}-{}", new Object[]{startTime, pageId, startRow, limit});
        QingMeta qingMeta = (QingMeta)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get(QING_META));
        Map result = (Map)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get(QING_CAlC_RESULT));
        FAFQingData qingDataSet = new FAFQingData(result, qingMeta, startRow, limit);
        QingData qingData = qingDataSet.getQingData();
        LocalDateTime endTime = LocalDateTime.now();
        logger.info("getData : end: {} pageId: {} \u8017\u65f6(\u6beb\u79d2): {}", new Object[]{endTime, pageId, Duration.between(startTime, endTime).toMillis()});
        return qingData;
    }

    public String getSchemaAdditionalTag(String pageId) {
        Object indexPkValue = this.getView().getFormShowParameter().getCustomParam(PARAMS_INDEXPKVALUE);
        String tag = "_tag_" + indexPkValue;
        logger.info("getSchemaAdditionalTag: return -> " + tag);
        return tag;
    }

    public void dispose() {
    }

    public static FormShowParameter buildFsp(ReportQueryParam queryParam, Object indexPkValue) {
        FormShowParameter fsp = new FormShowParameter();
        fsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        fsp.setFormId("pa_fasindex_qing");
        fsp.setCaption(ResManager.loadKDString((String)"\u6307\u6807\u8f7b\u5206\u6790", (String)"FAFIndexQingDataProvider_0", (String)"macc-faf-formplugin", (Object[])new Object[0]));
        fsp.setCustomParam(PARAMS_QUERYPARAM, (Object)SerializationUtils.serializeToBase64((Object)queryParam));
        fsp.setCustomParam(PARAMS_INDEXPKVALUE, (Object)(indexPkValue + ""));
        return fsp;
    }
}

