/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.fas.qing;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.Algo;
import kd.bos.algo.AlgoException;
import kd.bos.algo.CachedDataSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.FilterFunction;
import kd.bos.algo.Row;
import kd.bos.algo.dataset.AbstractRow;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.qing.Field;
import kd.bos.entity.qing.QingData;
import kd.bos.entity.qing.QingMeta;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.macc.faf.fas.enums.FAFSystemVariableEnum;
import kd.macc.faf.fas.index.func.algo.FAFResultFilterFunction;
import kd.macc.faf.fas.index.model.FAFIndex;
import kd.macc.faf.fas.index.model.FAFVariable;
import kd.macc.faf.fas.service.helper.FAFCalcCacheServiceHelper;

public class FAFQingData {
    private static final Log logger = LogFactory.getLog(FAFQingData.class);
    private final int startRow;
    private final int length;
    private final Map<String, Integer> dataindex;
    private final Map<String, Object> result;

    public FAFQingData(Map<String, Object> result, QingMeta qingMeta, int startRow, int length) {
        if (result == null || result.get("cacheId") == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u96c6\u52a0\u8f7d\u9519\u8bef\u3002", (String)"FAFQingData_0", (String)"macc-faf-formplugin", (Object[])new Object[0]));
        }
        this.result = result;
        this.startRow = startRow;
        this.length = length;
        this.dataindex = new LinkedHashMap<String, Integer>(qingMeta.getColumns().size());
        int columnSeqNo = 0;
        for (Field field : qingMeta.getColumns()) {
            if (this.dataindex.containsKey(field.getKey().toLowerCase())) continue;
            this.dataindex.put(field.getKey().toLowerCase(), columnSeqNo++);
        }
    }

    private List<Object[]> buildRows() {
        try {
            CachedDataSet cacheDataSet = Algo.getCacheDataSet((String)((String)this.result.get("cacheId")));
            FAFIndex fasindex = (FAFIndex)this.result.get("fasindex");
            List variables = fasindex.getVariableList();
            if (variables.size() > 0) {
                logger.info("buildRows : vd1 {}", (Object)LocalDateTime.now());
                DataSet dataSet = cacheDataSet.toDataSet(Algo.create((String)"pa_fas_qingdata"), false);
                for (FAFVariable variable : variables) {
                    dataSet = dataSet.filter((FilterFunction)new FAFResultFilterFunction("_id_" + variable.getFieldName(), FAFSystemVariableEnum.getValues((Object)variable.getVariableCode())));
                }
                dataSet = dataSet.limit(this.startRow - 1, this.length);
                logger.info("buildRows : vd2 {}", (Object)LocalDateTime.now());
                ArrayList<Object[]> objects = new ArrayList<Object[]>();
                for (Row row : dataSet) {
                    objects.add(((AbstractRow)row).values());
                }
                logger.info("buildRows : vd3 {}", (Object)LocalDateTime.now());
                return objects;
            }
            logger.info("buildRows : d1 {}", (Object)LocalDateTime.now());
            List list = cacheDataSet.getList(this.startRow - 1, this.length);
            logger.info("buildRows : d2 {}", (Object)LocalDateTime.now());
            ArrayList<Object[]> objects = new ArrayList<Object[]>(list.size());
            for (Row row : list) {
                objects.add(((AbstractRow)row).values());
            }
            logger.info("buildRows : d3 {}", (Object)LocalDateTime.now());
            return objects;
        }
        catch (AlgoException ex) {
            FAFCalcCacheServiceHelper.clearCache((String)((String)this.result.getOrDefault("cacheKey", "")));
            throw new KDBizException(ResManager.loadKDString((String)"\u8ba1\u7b97\u7ed3\u679c\u96c6\u5931\u6548,\u8bf7\u91cd\u8bd5\u3002", (String)"FAFQingData_1", (String)"macc-faf-formplugin", (Object[])new Object[0]));
        }
    }

    public QingData getQingData() {
        QingData qingData = new QingData();
        qingData.setRows(this.buildRows());
        qingData.setDataindex(this.dataindex);
        return qingData;
    }
}

