/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.management;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.filter.CompareTypeEnum;
import kd.bos.entity.filter.ControlFilters;
import kd.bos.exception.KDBizException;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.SchemeFilterColumn;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.license.api.LicenseCheckResult;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.GenericServiceResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.faf.management.bo.param.request.QueryTaskParam;
import kd.macc.faf.management.enums.TaskOptTypeEnum;
import kd.macc.faf.management.enums.TaskStatusEnum;
import kd.macc.faf.management.factory.TaskParamFactory;
import kd.macc.faf.util.LicenseUtil;

public class FAFTaskManagementListPlugin
extends AbstractListPlugin {
    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        try {
            Map currentCommonFilter = args.getCurrentCommonFilter();
            if (!CollectionUtils.isEmpty((Map)currentCommonFilter)) {
                String currentFieldName = ((List)currentCommonFilter.get("FieldName")).get(0).toString();
                if ("anamodel.analysis_system.id".equals(currentFieldName)) {
                    ((List)args.getFilterValues().get("customfilter")).removeIf(t -> ((List)t.get("FieldName")).get(0).equals("anamodel.id"));
                    ((List)args.getFilterValues().get("customfilter")).removeIf(t -> ((List)t.get("FieldName")).get(0).equals("period.id"));
                } else if ("anamodel.id".equals(currentFieldName)) {
                    ((List)args.getFilterValues().get("customfilter")).removeIf(t -> ((List)t.get("FieldName")).get(0).equals("period.id"));
                }
            }
        }
        catch (Exception exception) {
            String errorMessage = exception.getCause() != null ? exception.getCause().getMessage() : exception.getMessage();
            throw new KDBizException(errorMessage);
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        try {
            FilterColumn createTimeColumn;
            QFilter systemFilter;
            List primaryKeys;
            List modelFilterValues;
            Object specifyAnalysisModelId;
            List systemFilterValues;
            ControlFilters controlFilters = ((ListView)this.getView()).getControlFilters();
            Map formShowCustomParams = this.getView().getFormShowParameter().getCustomParams();
            String defaultSystemId = this.initAnalysisSystemFilter(args, formShowCustomParams);
            if (StringUtils.isBlank((CharSequence)defaultSystemId)) {
                return;
            }
            Long currentSystemId = null;
            if (controlFilters != null && !CollectionUtils.isEmpty((Collection)(systemFilterValues = controlFilters.getFilter("anamodel.analysis_system.id")))) {
                currentSystemId = Long.parseLong(systemFilterValues.get(0).toString());
            }
            if (currentSystemId == null) {
                currentSystemId = Long.parseLong(defaultSystemId);
            }
            String defaultModelId = this.initAnalysisModelFilter(args, formShowCustomParams, currentSystemId);
            FilterColumn orgColumn = args.getFilterColumn("org.number");
            if (orgColumn != null) {
                List modelComboItems = null;
                if (orgColumn instanceof SchemeFilterColumn) {
                    modelComboItems = ((SchemeFilterColumn)orgColumn).getComboItems();
                } else if (orgColumn instanceof CommonFilterColumn) {
                    modelComboItems = ((CommonFilterColumn)orgColumn).getComboItems();
                }
                specifyAnalysisModelId = formShowCustomParams.get("analysis_model");
                if (specifyAnalysisModelId == null && modelComboItems != null) {
                    orgColumn.setDefaultValue(((ComboItem)modelComboItems.get(0)).getValue());
                }
            }
            Long modelId = null;
            if (controlFilters != null && !CollectionUtils.isEmpty((Collection)(modelFilterValues = controlFilters.getFilter("anamodel.id"))) && (primaryKeys = QueryServiceHelper.queryPrimaryKeys((String)"pa_analysismodel", (QFilter[])new QFilter[]{this.getModelIdFilter(systemFilter = new QFilter("analysis_system.id", "=", (Object)currentSystemId))}, null, (int)-1)).contains(modelFilterValues.get(0))) {
                modelId = Long.parseLong(modelFilterValues.get(0).toString());
            }
            if (modelId == null && defaultModelId != null) {
                modelId = Long.parseLong(defaultModelId);
            }
            this.initAnalysisPeriodFilter(args, modelId);
            specifyAnalysisModelId = formShowCustomParams.get("analysis_model");
            if (specifyAnalysisModelId != null && (createTimeColumn = args.getFilterColumn("createtime")) != null) {
                createTimeColumn.setDefaultValue(CompareTypeEnum.TODAY.getId());
            }
        }
        catch (Exception exception) {
            String errorMessage = exception.getCause() != null ? exception.getCause().getMessage() : exception.getMessage();
            throw new KDBizException(errorMessage);
        }
    }

    private void initAnalysisPeriodFilter(FilterContainerInitArgs args, Long modelId) {
        FilterColumn periodColumn = args.getFilterColumn("period.number");
        List<Object> periodComboItems = new ArrayList<ComboItem>(1);
        if (modelId != null) {
            DynamicObjectCollection periodDys;
            DynamicObject currentModel = BusinessDataServiceHelper.loadSingleFromCache((Object)modelId, (String)"pa_analysismodel");
            QFilter periodTypeFilter = new QFilter("periodtype", "=", (Object)currentModel.getDynamicObject("periodtype").getLong("id"));
            if (periodColumn != null && !CollectionUtils.isEmpty((Collection)(periodDys = QueryServiceHelper.query((String)"bd_period", (String)"id,name", (QFilter[])new QFilter[]{periodTypeFilter}, (String)"number asc", (int)20)))) {
                periodComboItems = periodDys.stream().map(model -> {
                    ComboItem item = new ComboItem();
                    item.setCaption(new LocaleString(model.getString("name")));
                    item.setValue(String.valueOf(model.getLong("id")));
                    item.setItemVisible(true);
                    return item;
                }).collect(Collectors.toList());
            }
        }
        this.setComboItems(periodColumn, periodComboItems);
    }

    private String initAnalysisSystemFilter(FilterContainerInitArgs args, Map<String, Object> formShowCustomParams) {
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        DynamicObjectCollection anaSystemDys = QueryServiceHelper.query((String)"pa_anasystemsetting", (String)"id,name", (QFilter[])new QFilter[]{enableFilter});
        String defaultSystemId = null;
        FilterColumn systemColumn = args.getFilterColumn("anamodel.analysis_system.number");
        if (systemColumn != null) {
            Long specifyAnaSystemId;
            List<Object> systemComboItems = new ArrayList(1);
            if (!CollectionUtils.isEmpty((Collection)anaSystemDys)) {
                systemComboItems = anaSystemDys.stream().map(model -> {
                    ComboItem item = new ComboItem();
                    item.setCaption(new LocaleString(model.getString("name")));
                    item.setValue(String.valueOf(model.getLong("id")));
                    item.setItemVisible(true);
                    return item;
                }).collect(Collectors.toList());
            }
            if ((specifyAnaSystemId = (Long)formShowCustomParams.get("analysis_system")) != null && anaSystemDys.stream().anyMatch(dy -> specifyAnaSystemId.longValue() == dy.getLong("id"))) {
                defaultSystemId = String.valueOf(specifyAnaSystemId);
            } else if (!CollectionUtils.isEmpty(systemComboItems)) {
                defaultSystemId = ((ComboItem)systemComboItems.get(0)).getValue();
            }
            systemColumn.setDefaultValue(defaultSystemId);
            this.setComboItems(systemColumn, systemComboItems);
        }
        return defaultSystemId;
    }

    private String initAnalysisModelFilter(FilterContainerInitArgs args, Map<String, Object> formShowCustomParams, Long anaSystemId) {
        String defaultModelId = null;
        if (anaSystemId != null) {
            QFilter systemFilter = new QFilter("analysis_system.id", "=", (Object)anaSystemId);
            DynamicObjectCollection anaModelDys = QueryServiceHelper.query((String)"pa_analysismodel", (String)"id,name", (QFilter[])new QFilter[]{this.getModelIdFilter(systemFilter)});
            FilterColumn modelColumn = args.getFilterColumn("anamodel.number");
            if (modelColumn != null) {
                Long specifyAnalysisModelId;
                List<Object> modelComboItems = new ArrayList(1);
                if (!CollectionUtils.isEmpty((Collection)anaModelDys)) {
                    modelComboItems = anaModelDys.stream().map(model -> {
                        ComboItem item = new ComboItem();
                        item.setCaption(new LocaleString(model.getString("name")));
                        item.setValue(String.valueOf(model.getLong("id")));
                        item.setItemVisible(true);
                        return item;
                    }).collect(Collectors.toList());
                }
                if ((specifyAnalysisModelId = (Long)formShowCustomParams.get("analysis_model")) != null && anaModelDys.stream().anyMatch(dy -> specifyAnalysisModelId.longValue() == dy.getLong("id"))) {
                    defaultModelId = String.valueOf(specifyAnalysisModelId);
                } else if (!CollectionUtils.isEmpty(modelComboItems)) {
                    defaultModelId = ((ComboItem)modelComboItems.get(0)).getValue();
                }
                modelColumn.setDefaultValue(defaultModelId);
                this.setComboItems(modelColumn, modelComboItems);
            }
        }
        return defaultModelId;
    }

    private void setComboItems(FilterColumn filterColumn, List<ComboItem> comboItemList) {
        if (filterColumn instanceof SchemeFilterColumn) {
            ((SchemeFilterColumn)filterColumn).setComboItems(comboItemList);
        } else if (filterColumn instanceof CommonFilterColumn) {
            ((CommonFilterColumn)filterColumn).setComboItems(comboItemList);
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        try {
            String fieldName = args.getFieldName();
            if ("anamodel.id".equals(fieldName)) {
                List anaSystemIds = ((IListView)this.getView()).getControlFilters().getFilter("anamodel.analysis_system.id");
                if (!CollectionUtils.isEmpty((Collection)anaSystemIds)) {
                    QFilter systemIdFilter = new QFilter("analysis_system.id", "=", (Object)Long.parseLong(anaSystemIds.get(0).toString()));
                    args.getQfilters().add(this.getModelIdFilter(systemIdFilter));
                }
            } else if ("anamodel.number".equals(fieldName)) {
                List anaSystemNumber = ((IListView)this.getView()).getControlFilters().getFilter("anamodel.analysis_system.number");
                if (CollectionUtils.isEmpty((Collection)anaSystemNumber)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5bf9\u5e94\u7684\u5206\u6790\u4f53\u7cfb\u3002", (String)"FAFTaskManagementListPlugin_1", (String)"macc-faf-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                if (CollectionUtils.isEmpty(anaSystemNumber = anaSystemNumber.stream().filter(number -> !ObjectUtils.isEmpty((Object)number)).collect(Collectors.toList()))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5bf9\u5e94\u7684\u5206\u6790\u4f53\u7cfb\u3002", (String)"FAFTaskManagementListPlugin_1", (String)"macc-faf-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                QFilter systemNumberFilter = new QFilter("analysis_system.number", "=", anaSystemNumber.get(0));
                args.getQfilters().add(this.getModelIdFilter(systemNumberFilter));
            } else if ("period.id".equals(fieldName)) {
                List anaModelIds = ((IListView)this.getView()).getControlFilters().getFilter("anamodel.id");
                if (!CollectionUtils.isEmpty((Collection)anaModelIds)) {
                    DynamicObject currentModel = BusinessDataServiceHelper.loadSingleFromCache((Object)Long.parseLong(anaModelIds.get(0).toString()), (String)"pa_analysismodel");
                    QFilter periodTypeFilter = new QFilter("periodtype", "=", (Object)currentModel.getDynamicObject("periodtype").getLong("id"));
                    args.getQfilters().add(periodTypeFilter);
                }
            } else if ("period.number".equals(fieldName)) {
                List anaModelNumber = ((IListView)this.getView()).getControlFilters().getFilter("anamodel.number");
                if (CollectionUtils.isEmpty((Collection)anaModelNumber)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5bf9\u5e94\u7684\u5206\u6790\u6a21\u578b\u3002", (String)"FAFTaskManagementListPlugin_2", (String)"macc-faf-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                if (CollectionUtils.isEmpty(anaModelNumber = anaModelNumber.stream().filter(number -> !ObjectUtils.isEmpty((Object)number)).collect(Collectors.toList()))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5bf9\u5e94\u7684\u5206\u6790\u6a21\u578b\u3002", (String)"FAFTaskManagementListPlugin_2", (String)"macc-faf-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                List anaSystemNumber = ((IListView)this.getView()).getControlFilters().getFilter("anamodel.analysis_system.number");
                QFilter systemNumberFilter = new QFilter("analysis_system.number", "=", anaSystemNumber.get(0));
                QFilter modelNumberFilter = new QFilter("number", "=", anaModelNumber.get(0));
                DynamicObject currentModel = BusinessDataServiceHelper.loadSingleFromCache((String)"pa_analysismodel", (String)"periodtype", (QFilter[])new QFilter[]{systemNumberFilter, modelNumberFilter});
                args.getQfilters().add(new QFilter("periodtype", "=", (Object)currentModel.getDynamicObject("periodtype").getLong("id")));
            }
        }
        catch (Exception exception) {
            String errorMessage = exception.getCause() != null ? exception.getCause().getMessage() : exception.getMessage();
            throw new KDBizException(errorMessage);
        }
    }

    private QFilter getModelIdFilter(QFilter systemNumberFilter) {
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        ArrayList validModelIds = new ArrayList(2);
        Map modelDys = BusinessDataServiceHelper.loadFromCache((String)"pa_analysismodel", (QFilter[])new QFilter[]{systemNumberFilter, enableFilter});
        block0: for (Map.Entry entry : modelDys.entrySet()) {
            DynamicObject model = (DynamicObject)entry.getValue();
            DynamicObjectCollection dimensionEntry = model.getDynamicObjectCollection("dimension_entry");
            for (DynamicObject dimEntry : dimensionEntry) {
                if (!"1".equals(dimEntry.getString("necessity_dim"))) continue;
                DynamicObject dimensionSource = dimEntry.getDynamicObject("dimension").getDynamicObject("dimensionsource");
                if (dimensionSource == null || !"bd_period".equals(dimensionSource.getString("number"))) continue block0;
                validModelIds.add(entry.getKey());
                continue block0;
            }
        }
        return new QFilter("id", "in", validModelIds);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String operateKey = ((FormOperate)args.getSource()).getOperateKey();
        if ("mark_failed".equals(operateKey)) {
            List taskIds = ((ListView)this.getView()).getSelectedRows().stream().map(row -> (Long)row.getPrimaryKeyValue()).collect(Collectors.toList());
            QueryTaskParam queryTaskParam = (QueryTaskParam)TaskParamFactory.get((TaskOptTypeEnum)TaskOptTypeEnum.QUERY, null);
            queryTaskParam.setTaskIds(taskIds);
            GenericServiceResult result = (GenericServiceResult)DispatchServiceHelper.invokeBizService((String)"macc", (String)"faf", (String)"TaskManagementService", (String)"queryTask", (Object[])new Object[]{SerializationUtils.toJsonString((Object)queryTaskParam)});
            Boolean success = result.getSuccess();
            if (success.booleanValue()) {
                Object[] tasks;
                for (Object task2 : tasks = (DynamicObject[])result.getData()) {
                    TaskStatusEnum execStatus = TaskStatusEnum.getEnumByCode((String)task2.getString("execstatus"));
                    if (TaskStatusEnum.TODO == execStatus || TaskStatusEnum.PROCESSING == execStatus) continue;
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u5c06\u6267\u884c\u72b6\u6001\u4e3a\u3010\u5f85\u6267\u884c\u3011\u548c\u3010\u6267\u884c\u4e2d\u3011\u7684\u4efb\u52a1\u6807\u8bb0\u4e3a\u6267\u884c\u5931\u8d25\u3002", (String)"FAFTaskManagementListPlugin_0", (String)"macc-faf-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                if (ArrayUtils.isNotEmpty((Object[])tasks)) {
                    this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u7cfb\u7edf\u5c06\u9009\u4e2d\u7684%s\u6761\u4efb\u52a1\u7684\u72b6\u6001\u6807\u8bb0\u4e3a\u6267\u884c\u5931\u8d25\uff0c\u4f46\u5e76\u4e0d\u4f1a\u5f71\u54cd\u4efb\u52a1\u7684\u6b63\u5e38\u6267\u884c\uff0c\u540e\u7eed\u6267\u884c\u65b0\u7684\u4efb\u52a1\u6709\u53ef\u80fd\u4f1a\u5bfc\u81f4\u5206\u6790\u6a21\u578b\u7684\u6570\u636e\u4e0e\u9884\u671f\u4e0d\u7b26\u5408\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\uff1f", (String)"FAFTaskManagementListPlugin_3", (String)"macc-faf-formplugin", (Object[])new Object[0]), tasks.length), null, MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("mark_failed", (IFormPlugin)this), null, Stream.of(tasks).map(task -> task.getString("id")).collect(Collectors.joining(",")));
                }
            } else {
                this.getView().showTipNotification(result.getMessage());
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        MessageBoxResult result = messageBoxClosedEvent.getResult();
        String customValue = messageBoxClosedEvent.getCustomVaule();
        if ("mark_failed".equals(callBackId) && MessageBoxResult.Yes.equals((Object)result)) {
            List taskIds = Stream.of(customValue.split(",")).map(Long::parseLong).collect(Collectors.toList());
            DispatchServiceHelper.invokeBizService((String)"macc", (String)"faf", (String)"TaskManagementService", (String)"manualFail", (Object[])new Object[]{taskIds});
            this.getView().invokeOperation("refresh");
        }
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        String formId;
        String bizAppId = ShowFormHelper.getBizAppId((FormShowParameter)e.getFormShowParameter());
        LicenseCheckResult checkResult = LicenseUtil.Check(bizAppId, formId = ((ListShowParameter)e.getFormShowParameter()).getBillFormId());
        boolean hasLicense = checkResult.getHasLicense();
        e.setCancel(!hasLicense);
        e.setCancelMessage(checkResult.getMsg());
        e.setCancelFormShowParameter(checkResult.getCancelFormShowParameter());
    }
}

