/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.param;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.faf.dto.ResultDTO;
import kd.macc.faf.enums.OlapFromServiceEnum;
import kd.macc.faf.handle.DataImportFactoryBuilder;
import kd.macc.faf.olap.OlapServerBaseMetaInfo;
import kd.macc.faf.olap.OlapServerDimemsionMetaInfo;
import kd.macc.faf.olap.driver.RequestFactoryBuilder;
import kd.macc.faf.param.FAFBaseDimOrMeasureSelect;
import kd.macc.faf.util.EntryUtil;

public class FAFDimensionSelect
extends FAFBaseDimOrMeasureSelect {
    public static void showDimension(AbstractFormPlugin that, String systemImport, String closeCallBackName) {
        FAFBaseDimOrMeasureSelect.showDimOrMember(that, "faf_dimselectf7", systemImport, closeCallBackName);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        String systemImport = (String)view.getFormShowParameter().getCustomParam("systemimport");
        switch (key) {
            case "system": {
                this.showSystem(this, "dimension_system");
                break;
            }
            case "btnok": {
                Long systemId = (Long)model.getValue("systemid");
                if (systemId == null || systemId == 0L) {
                    if ("bcm".equals(systemImport)) {
                        view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5408\u5e76\u4f53\u7cfb\u3002", (String)"FAFDimensionSelect_2", (String)"macc-faf-formplugin", (Object[])new Object[0]));
                    } else if ("epm".equals(systemImport)) {
                        view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9884\u7b97\u4f53\u7cfb\u3002", (String)"FAFDimensionSelect_3", (String)"macc-faf-formplugin", (Object[])new Object[0]));
                    }
                    return;
                }
                ArrayList list = new ArrayList(4);
                EntryUtil.selectToDo(this, "entryentity", p -> list.add(p.getLong("dimid")));
                if (list.isEmpty()) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"FAFDimensionSelect_4", (String)"macc-faf-formplugin", (Object[])new Object[0]));
                    return;
                }
                String dimCache = this.getPageCache().get("dimcache");
                Map longOlapServerDimensionMetaInfoMap = (Map)JSONObject.parseObject((String)dimCache, HashMap.class);
                List lst = list.stream().map(longOlapServerDimensionMetaInfoMap::get).filter(Objects::nonNull).map(p -> (OlapServerDimemsionMetaInfo)JSONObject.parseObject((String)p.toString(), OlapServerDimemsionMetaInfo.class)).collect(Collectors.toList());
                Long analysisSystemId = (Long)view.getFormShowParameter().getCustomParam("analysis_system");
                ResultDTO resultDTO = DataImportFactoryBuilder.saveDimension((OlapFromServiceEnum)OlapFromServiceEnum.getEnum((String)systemImport), lst, (Long)analysisSystemId, (Long)systemId, (String)((String)model.getValue("systemnumber")));
                view.returnDataToParent((Object)resultDTO);
                view.close();
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        if ("system".equals(propName) && (newValue == null || String.valueOf(newValue).isEmpty())) {
            this.getModel().deleteEntryData("entryentity");
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        Long systemId = (Long)this.getModel().getValue("systemid");
        if (systemId != null && systemId != 0L) {
            this.initView(systemId);
        }
    }

    private void initView(Long moduleId) {
        String modelField;
        String dimensionField;
        String entityNumber;
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        model.deleteEntryData("entryentity");
        String systemImport = (String)view.getFormShowParameter().getCustomParam("systemimport");
        OlapFromServiceEnum typeEnum = OlapFromServiceEnum.getEnum((String)systemImport);
        if (OlapFromServiceEnum.EPM != typeEnum && OlapFromServiceEnum.BCM != typeEnum) {
            return;
        }
        Map olapServerDimensionMetaInfo = RequestFactoryBuilder.getAllDim((OlapFromServiceEnum)typeEnum, param -> {
            param.setModuleId(moduleId);
            return param;
        });
        if (olapServerDimensionMetaInfo.isEmpty()) {
            return;
        }
        Map<Long, OlapServerDimemsionMetaInfo> data = olapServerDimensionMetaInfo.values().stream().collect(Collectors.toMap(OlapServerBaseMetaInfo::getId, v -> v));
        Long analysisSystemId = (Long)view.getFormShowParameter().getCustomParam("analysis_system");
        if (OlapFromServiceEnum.EPM == typeEnum) {
            entityNumber = "faf_epmdimmapping";
            dimensionField = "epmdimension";
            modelField = "epmmodel";
        } else {
            entityNumber = "faf_cmdimmapping";
            dimensionField = "cmdimension";
            modelField = "cmmodel";
        }
        QFilter filter = new QFilter("analysis_system", "=", (Object)analysisSystemId).and(new QFilter(modelField, "=", (Object)moduleId));
        DynamicObjectCollection dimMappingCol = QueryServiceHelper.query((String)entityNumber, (String)dimensionField, (QFilter[])filter.toArray());
        HashSet dimensionIdSet = new HashSet(dimMappingCol.size());
        dimMappingCol.forEach(p -> dimensionIdSet.add(p.getLong(dimensionField)));
        Iterator<Map.Entry<Long, OlapServerDimemsionMetaInfo>> iterator = data.entrySet().iterator();
        while (iterator.hasNext()) {
            Long dimensionId = iterator.next().getValue().getId();
            if (!dimensionIdSet.contains(dimensionId)) continue;
            iterator.remove();
        }
        this.getPageCache().put("dimcache", JSONObject.toJSONString(data));
        Collection<OlapServerDimemsionMetaInfo> collect = data.values();
        if (collect.size() > 0) {
            model.batchCreateNewEntryRow("entryentity", collect.size());
            model.beginInit();
            int index = 0;
            for (OlapServerDimemsionMetaInfo olapServerDimemsionMetaInfo : collect) {
                model.setValue("dimnumber", (Object)olapServerDimemsionMetaInfo.getNumber(), index);
                model.setValue("dimname", (Object)olapServerDimemsionMetaInfo.getName(), index);
                model.setValue("dimid", (Object)olapServerDimemsionMetaInfo.getId(), index);
                ++index;
            }
            model.endInit();
            view.updateView("entryentity");
        }
    }
}

