/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.param;

import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.macc.faf.enums.OlapFromServiceEnum;
import kd.macc.faf.helper.FAFDataSourceConfigHelper;
import kd.macc.faf.olap.OlapServerDimemsionMetaInfo;
import kd.macc.faf.param.FAFF7Return;
import kd.macc.faf.util.EntryUtil;

public class FAFDimensionSingleSelect
extends AbstractFormPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String olapDimmension = (String)formShowParameter.getCustomParam("olapDimmension");
        List list = SerializationUtils.fromJsonStringToList((String)olapDimmension, OlapServerDimemsionMetaInfo.class);
        if (list != null && list.size() > 0) {
            this.getModel().batchCreateNewEntryRow("entryentity", list.size());
            int i = 0;
            for (OlapServerDimemsionMetaInfo olapServerDimemsionMetaInfo : list) {
                this.getModel().setValue("dimnumber", (Object)olapServerDimemsionMetaInfo.getNumber(), i);
                this.getModel().setValue("dimname", (Object)olapServerDimemsionMetaInfo.getName(), i);
                this.getModel().setValue("dimid", (Object)olapServerDimemsionMetaInfo.getId(), i);
                ++i;
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if ("btnok".equals(key)) {
            EntryUtil.selectToDo(this, "entryentity", this::returnData);
        }
    }

    private void returnData(DynamicObject dynamicObject) {
        String number = dynamicObject.getString("dimnumber");
        String name = dynamicObject.getString("dimname");
        Long id = dynamicObject.getLong("dimid");
        FAFF7Return faff7Return = new FAFF7Return(id, name, number);
        IFormView view = this.getView();
        view.returnDataToParent((Object)faff7Return);
        view.close();
    }

    public static void openF7(AbstractFormPlugin that, OlapFromServiceEnum olapFromServiceEnum, String paramsrc, Set<Long> notNeedShowDimIds, String closeCallBackName) {
        if (notNeedShowDimIds == null) {
            notNeedShowDimIds = Collections.EMPTY_SET;
        }
        Collection values = FAFDataSourceConfigHelper.getDimensionFromParamSetting((OlapFromServiceEnum)olapFromServiceEnum, (String)paramsrc);
        Set finalNotNeedShowDimIds = notNeedShowDimIds;
        values.removeIf(p -> finalNotNeedShowDimIds.contains(p.getId()));
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setCustomParam("olapDimmension", (Object)SerializationUtils.toJsonString((Object)values));
        formShowParameter.setFormId("faf_dimensionselectf7");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)that, closeCallBackName));
        that.getView().showForm(formShowParameter);
    }
}

