/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.param;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.macc.faf.dto.DimensionDTO;
import kd.macc.faf.dto.MemberDTO;
import kd.macc.faf.dto.ResultDTO;
import kd.macc.faf.enums.OlapFromServiceEnum;
import kd.macc.faf.handle.DataImportFactoryBuilder;
import kd.macc.faf.olap.OlapServerDimemsionMetaInfo;
import kd.macc.faf.olap.driver.OlapRequestParam;
import kd.macc.faf.olap.driver.ParamBuilder;
import kd.macc.faf.olap.driver.RequestFactoryBuilder;
import kd.macc.faf.param.FAFBaseDimOrMeasureSelect;
import kd.macc.faf.param.FAFF7Return;
import kd.macc.faf.param.FAFMemberSelect;

public class FAFImportDimMember
extends FAFBaseDimOrMeasureSelect {
    public static void showMember(AbstractFormPlugin that, String systemImport, String closeCallBackName) {
        FAFBaseDimOrMeasureSelect.showDimOrMember(that, "faf_dimmember", systemImport, closeCallBackName);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"dimension", "dimmember"});
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getView().setEnable(Boolean.FALSE, new String[]{"advconap"});
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        Long systemId = (Long)model.getValue("systemid");
        String systemImport = (String)view.getFormShowParameter().getCustomParam("systemimport");
        String systemEmptyNotification = "bcm".equals(systemImport) ? ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5408\u5e76\u4f53\u7cfb\u3002", (String)"FAFImportDimMember_2", (String)"macc-faf-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9884\u7b97\u4f53\u7cfb\u3002", (String)"FAFImportDimMember_3", (String)"macc-faf-formplugin", (Object[])new Object[0]);
        switch (key) {
            case "system": {
                this.showSystem(this, "member_system");
                break;
            }
            case "btnok": {
                if (systemId == null || systemId == 0L) {
                    view.showTipNotification(systemEmptyNotification);
                    return;
                }
                int entryRowCount = model.getEntryRowCount("entryentity");
                if (entryRowCount == 0) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"FAFImportDimMember_4", (String)"macc-faf-formplugin", (Object[])new Object[0]));
                    return;
                }
                StringBuilder emptyRowBuilder = new StringBuilder();
                for (int i = 0; i < entryRowCount; ++i) {
                    Long dimId = (Long)model.getValue("dimid", i);
                    String dimMember = (String)model.getValue("dimmember", i);
                    if (dimId != null && dimId != 0L && dimMember != null && !dimMember.isEmpty()) continue;
                    emptyRowBuilder.append(',').append(i + 1);
                }
                if (emptyRowBuilder.length() > 0) {
                    view.showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u7b2c%s\u884c\u7ef4\u5ea6\u548c\u7ef4\u5ea6\u6210\u5458\u3002", (String)"FAFImportDimMember_1", (String)"macc-faf-formplugin", (Object[])new Object[0]), emptyRowBuilder.substring(1)));
                    return;
                }
                Long analysisSystemId = (Long)view.getFormShowParameter().getCustomParam("analysis_system");
                ResultDTO result = this.saveMeasure(systemImport, analysisSystemId, systemId, model);
                view.returnDataToParent((Object)result);
                view.close();
                break;
            }
            case "dimension": {
                if (systemId == null || systemId == 0L) {
                    view.showTipNotification(systemEmptyNotification);
                    return;
                }
                this.showDimension(systemId);
                break;
            }
            case "dimmember": {
                if (systemId == null || systemId == 0L) {
                    view.showTipNotification(systemEmptyNotification);
                    return;
                }
                int rowIndex = model.getEntryCurrentRowIndex("entryentity");
                String dimName = (String)model.getValue("dimension", rowIndex);
                String dimNumber = (String)model.getValue("dimnumber", rowIndex);
                if (StringUtils.isEmpty((String)dimName) || StringUtils.isEmpty((String)dimNumber)) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7ef4\u5ea6\u3002", (String)"FAFImportDimMember_5", (String)"macc-faf-formplugin", (Object[])new Object[0]));
                    return;
                }
                OlapFromServiceEnum anEnum = OlapFromServiceEnum.getEnum((String)systemImport);
                OlapRequestParam olapRequestParam = ParamBuilder.getParam((OlapFromServiceEnum)anEnum);
                olapRequestParam.setModuleId(systemId);
                olapRequestParam.setDimNumber(dimNumber);
                FAFMemberSelect.openF7(this, anEnum, dimName, olapRequestParam, "dimmember");
            }
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String key = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        IDataModel model = this.getModel();
        int rowIndex = model.getEntryCurrentRowIndex("entryentity");
        switch (key) {
            case "dimension": {
                if (!(returnData instanceof ListSelectedRowCollection)) break;
                ListSelectedRow row = ((ListSelectedRowCollection)returnData).get(0);
                model.setValue("dimension", (Object)row.getName(), rowIndex);
                model.setValue("dimid", row.getPrimaryKeyValue(), rowIndex);
                model.setValue("dimnumber", (Object)row.getNumber(), rowIndex);
                break;
            }
            case "dimmember": {
                if (!(returnData instanceof String)) break;
                List returnResultList = JSON.parseArray((String)((String)returnData), FAFF7Return.class);
                StringBuilder nameBuilder = new StringBuilder();
                ArrayList<MemberDTO> memberList = new ArrayList<MemberDTO>(returnResultList.size());
                for (FAFF7Return row : returnResultList) {
                    nameBuilder.append(',').append(row.getName());
                    memberList.add(new MemberDTO(row.getId(), row.getNumber(), row.getName()));
                }
                model.setValue("dimmember", (Object)nameBuilder.substring(1), rowIndex);
                model.setValue("memberjson", (Object)JSON.toJSONString(memberList), rowIndex);
                break;
            }
        }
    }

    private void showDimension(Long systemId) {
        ListShowParameter bsp = new ListShowParameter();
        bsp.setFormId("bos_listf7");
        StyleCss css = new StyleCss();
        css.setHeight("580px");
        css.setWidth("960px");
        bsp.getOpenStyle().setInlineStyleCss(css);
        bsp.getOpenStyle().setShowType(ShowType.Modal);
        bsp.setShowTitle(false);
        bsp.setLookUp(true);
        bsp.setMultiSelect(false);
        bsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "dimension"));
        QFilter filter = new QFilter("model", "=", (Object)systemId);
        IFormView view = this.getView();
        String systemImport = (String)view.getFormShowParameter().getCustomParam("systemimport");
        if ("bcm".equals(systemImport)) {
            bsp.setBillFormId("bcm_dimension");
            filter.and(new QFilter("number", "not in", Arrays.asList("Entity", "Year", "Period", "Account")));
        } else if ("epm".equals(systemImport)) {
            bsp.setBillFormId("epm_dimension");
            filter.and(new QFilter("number", "not in", Arrays.asList("Account", "BudgetPeriod", "Entity")));
        }
        bsp.getListFilterParameter().getQFilters().add(filter);
        view.showForm((FormShowParameter)bsp);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName = e.getProperty().getName();
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        Object newValue = e.getChangeSet()[0].getNewValue();
        boolean newValueIsEmpty = newValue == null || String.valueOf(newValue).isEmpty();
        int rowIndex = model.getEntryCurrentRowIndex("entryentity");
        if ("dimension".equals(propName)) {
            model.setValue("dimmember", null, rowIndex);
            model.setValue("memberjson", null, rowIndex);
            if (newValueIsEmpty) {
                model.setValue("dimnumber", null, rowIndex);
                model.setValue("dimid", null, rowIndex);
            }
        } else if ("dimmember".equals(propName) && newValueIsEmpty) {
            model.setValue("memberjson", null, rowIndex);
        } else if ("system".equals(propName)) {
            model.setValue("systemid", null);
            model.setValue("systemnumber", null);
            model.deleteEntryData("entryentity");
            if (newValueIsEmpty) {
                view.setEnable(Boolean.FALSE, new String[]{"advconap"});
            } else {
                view.setEnable(Boolean.TRUE, new String[]{"advconap"});
                model.createNewEntryRow("entryentity");
            }
        }
    }

    private ResultDTO saveMeasure(String systemImport, Long analysisSystemId, Long systemId, IDataModel model) {
        OlapFromServiceEnum typeEnum = OlapFromServiceEnum.getEnum((String)systemImport);
        Map dimMap = RequestFactoryBuilder.getAllDim((OlapFromServiceEnum)typeEnum, param -> {
            param.setModuleId(systemId);
            return param;
        });
        if (dimMap != null) {
            String systemNumber = (String)model.getValue("systemnumber");
            int entryRowCount = model.getEntryRowCount("entryentity");
            ArrayList<DimensionDTO> dimensionList = new ArrayList<DimensionDTO>(entryRowCount);
            ArrayList<Long> currentDimIdList = new ArrayList<Long>(entryRowCount);
            for (int i = 0; i < entryRowCount; ++i) {
                String memberJson;
                Long dimensionId = (Long)model.getValue("dimid", i);
                currentDimIdList.add(dimensionId);
                String dimensionNumber = (String)model.getValue("dimnumber", i);
                String dimensionName = (String)model.getValue("dimension", i);
                OlapServerDimemsionMetaInfo info = (OlapServerDimemsionMetaInfo)dimMap.get(dimensionNumber);
                String dimEntityName = null;
                if (info != null) {
                    dimEntityName = info.getDimEntityName();
                }
                if ((memberJson = (String)model.getValue("memberjson", i)) == null || memberJson.isEmpty()) continue;
                List memberList = JSON.parseArray((String)memberJson, MemberDTO.class);
                DimensionDTO dimensionDTO = new DimensionDTO(dimensionId, dimensionNumber, dimensionName, dimEntityName, memberList);
                dimensionList.add(dimensionDTO);
            }
            if (currentDimIdList.size() > 1) {
                String measureMappingEntity = OlapFromServiceEnum.EPM == typeEnum ? "faf_epmmeasuremapping" : "faf_cmmeasuremapping";
                String modelField = OlapFromServiceEnum.EPM == typeEnum ? "epmmodel" : "cmmodel";
                String dimensionField = OlapFromServiceEnum.EPM == typeEnum ? "epmdimension" : "cmdimension";
                QFilter filter = new QFilter("analysis_system", "=", (Object)analysisSystemId).and(new QFilter(modelField, "=", (Object)systemId));
                Map measureMappings = BusinessDataServiceHelper.loadFromCache((String)measureMappingEntity, (QFilter[])filter.toArray());
                if (measureMappings != null && !measureMappings.isEmpty()) {
                    for (Map.Entry mapping : measureMappings.entrySet()) {
                        DynamicObjectCollection measureMappingEntry = ((DynamicObject)mapping.getValue()).getDynamicObjectCollection("entryentity");
                        List mappingDimIdList = measureMappingEntry.stream().map(entry -> entry.getLong(dimensionField)).collect(Collectors.toList());
                        if (!currentDimIdList.containsAll(mappingDimIdList) || !mappingDimIdList.containsAll(currentDimIdList)) continue;
                        ArrayList<DimensionDTO> sortedDimensionList = new ArrayList<DimensionDTO>(dimensionList.size());
                        block2: for (Long mappingDimId : mappingDimIdList) {
                            for (DimensionDTO dimensionDTO : dimensionList) {
                                if (!mappingDimId.equals(dimensionDTO.getId())) continue;
                                sortedDimensionList.add(dimensionDTO);
                                continue block2;
                            }
                        }
                        dimensionList = sortedDimensionList;
                        break;
                    }
                }
            }
            return DataImportFactoryBuilder.saveMeasure((OlapFromServiceEnum)typeEnum, dimensionList, (Long)analysisSystemId, (Long)systemId, (String)systemNumber);
        }
        return new ResultDTO();
    }
}

