/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.param;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.ValueTextItem;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.SelectRowsEvent;
import kd.bos.form.control.events.SelectRowsEventListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.F7SelectedList;
import kd.bos.util.StringUtils;
import kd.macc.faf.enums.OlapFromServiceEnum;
import kd.macc.faf.olap.OlapServerDimMemberMetaInfo;
import kd.macc.faf.olap.OlapServerDimemsionMetaInfo;
import kd.macc.faf.olap.driver.OlapRequestParam;
import kd.macc.faf.olap.driver.RequestFactoryBuilder;
import kd.macc.faf.param.FAFF7Return;
import kd.macc.faf.util.EntryUtil;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.NotNull;

public class FAFMemberSelect
extends AbstractFormPlugin {
    public static String MODULE_ID = "MODULEID";
    public static String DIMENSION_NAME = "DIMENSION_NAME";
    public static String INIT_MEMBER_IDS = "INIT_MEMBER_IDS";
    private static final String F7SELECTEDLISTAP = "f7selectedlistap";
    private static final String MENBERF7VIEW_TREEID = "treeentryentity";
    private static final String MEMBERLIST = "PAMultipleMemberF7BasePlugin_MEMBERLIST_CACHE";
    private static final String MEMBER_ROOT_ID = "memberRootId";
    private static final String MEMBER_ROOT_NAME = "memberRootName";
    private static final String MEMBER_ROOT_NUMBER = "memberRootNumber";
    private static final String OLAP_REQUEST_PARAM = "OLAP_REQUEST_PARAM";
    private static String OLAP_REQUEST_PARAM_ClASS = "OLAP_REQUEST_PARAM_CLASS";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
    }

    public void afterBindData(EventObject e) {
        this.initView();
    }

    public void initialize() {
        super.initialize();
        EntryGrid entryGrid = (EntryGrid)this.getControl(MENBERF7VIEW_TREEID);
        F7SelectedList f7selectedlistap = (F7SelectedList)this.getControl(F7SELECTEDLISTAP);
        entryGrid.addSelectRowsListener(new SelectRowsEventListener(){

            public void selectRowsChange(SelectRowsEvent evt) {
                List newRows = evt.getNewRows();
                F7SelectedList f7selectedlistap = (F7SelectedList)FAFMemberSelect.this.getControl(FAFMemberSelect.F7SELECTEDLISTAP);
                List collect = newRows.stream().filter(p -> p != 0).map(newRow -> FAFMemberSelect.this.getModel().getEntryRowEntity(FAFMemberSelect.MENBERF7VIEW_TREEID, newRow.intValue())).map(entryRowEntity -> new ValueTextItem(String.valueOf(entryRowEntity.getInt("seq")), entryRowEntity.getString("name"))).collect(Collectors.toList());
                if (collect.size() > 0) {
                    f7selectedlistap.addItems(collect);
                } else {
                    f7selectedlistap.removeAllItems();
                }
            }
        });
        f7selectedlistap.addF7SelectedListRemoveListener(var1 -> {
            int seq = Integer.parseInt((String)var1.getParam());
            int[] selectRows = entryGrid.getSelectRows();
            int[] ints = ArrayUtils.removeElements((int[])selectRows, (int[])new int[]{seq - 1});
            int oldfocusRow = entryGrid.getEntryState().getFocusRow();
            entryGrid.selectRows(ints, oldfocusRow);
        });
        f7selectedlistap.addF7SelectedListRemoveAllListener(var1 -> entryGrid.clearEntryState());
    }

    private void initView() {
        OlapRequestParam olapRequestParam;
        IFormView view = this.getView();
        FormShowParameter fsp = view.getFormShowParameter();
        IPageCache pageCache = this.getPageCache();
        String olapRequestParamClass = (String)fsp.getCustomParam(OLAP_REQUEST_PARAM_ClASS);
        try {
            olapRequestParam = (OlapRequestParam)JSON.parseObject((String)((String)fsp.getCustomParam(OLAP_REQUEST_PARAM)), Class.forName(olapRequestParamClass));
        }
        catch (ClassNotFoundException e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u6c42\u6210\u5458\u6570\u636e\u65f6\u53c2\u6570\u4e0d\u6b63\u786e\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458", (String)"FAFMemberSelect_0", (String)"macc-faf-formplugin", (Object[])new Object[0]));
        }
        String dimensionName = (String)fsp.getCustomParam(DIMENSION_NAME);
        HashSet<String> ids = new HashSet<String>((Collection)fsp.getCustomParam(INIT_MEMBER_IDS));
        Map<String, OlapServerDimMemberMetaInfo> treeValue = this.loadDimensionMembers(olapRequestParam);
        if (treeValue.size() == 0) {
            this.cleanTree();
            return;
        }
        OlapServerDimMemberMetaInfo root = treeValue.get(olapRequestParam.getDimNumber());
        List<OlapServerDimMemberMetaInfo> olapServerDimMemberMetaInfoList = treeValue.values().stream().filter(p -> !p.getLongNumber().equals(olapRequestParam.getDimNumber())).collect(Collectors.toList());
        if (olapServerDimMemberMetaInfoList.size() == 0) {
            this.cleanTree();
            return;
        }
        if (root != null) {
            pageCache.put(MEMBER_ROOT_ID, root.getId().toString());
            pageCache.put(MEMBER_ROOT_NUMBER, root.getNumber());
            pageCache.put(MEMBER_ROOT_NAME, root.getName());
        } else {
            OlapServerDimMemberMetaInfo olapServerDimMemberMetaInfo = (OlapServerDimMemberMetaInfo)olapServerDimMemberMetaInfoList.get(0);
            if (olapServerDimMemberMetaInfo.getLevel() == 2) {
                pageCache.put(MEMBER_ROOT_ID, olapServerDimMemberMetaInfo.getParent().toString());
            } else {
                pageCache.put(MEMBER_ROOT_ID, "noParentId");
            }
            pageCache.put(MEMBER_ROOT_NUMBER, olapRequestParam.getDimNumber());
            pageCache.put(MEMBER_ROOT_NAME, dimensionName);
        }
        pageCache.put(MEMBERLIST, SerializationUtils.toJsonString(olapServerDimMemberMetaInfoList));
        this.setMemberTree(olapServerDimMemberMetaInfoList, ids);
    }

    private void setMemberTree(List<OlapServerDimMemberMetaInfo> olapServerDimMemberMetaInfoList, Set<String> ids) {
        int size = olapServerDimMemberMetaInfoList.size();
        if (size > 0) {
            int[] ints = this.getModel().batchCreateNewEntryRow(MENBERF7VIEW_TREEID, size + 1);
            this.getModel().beginInit();
            DynamicObject root = this.getModel().getEntryRowEntity(MENBERF7VIEW_TREEID, 0);
            root.set("number", (Object)this.getPageCache().get(MEMBER_ROOT_NUMBER));
            root.set("name", (Object)this.getPageCache().get(MEMBER_ROOT_NAME));
            root.set("pid", (Object)"");
            root.set("id", (Object)this.getPageCache().get(MEMBER_ROOT_ID));
            ArrayList<Integer> res = new ArrayList<Integer>(ids.size());
            ArrayList<ValueTextItem> valueTextItems = new ArrayList<ValueTextItem>(ids.size());
            for (int i = 0; i < olapServerDimMemberMetaInfoList.size(); ++i) {
                OlapServerDimMemberMetaInfo olapServerDimMemberMetaInfo = olapServerDimMemberMetaInfoList.get(i);
                DynamicObject mem = this.getModel().getEntryRowEntity(MENBERF7VIEW_TREEID, ints[i + 1]);
                mem.set("number", (Object)olapServerDimMemberMetaInfo.getNumber());
                mem.set("name", (Object)olapServerDimMemberMetaInfo.getName());
                mem.set("aggoprt", (Object)olapServerDimMemberMetaInfo.getAggoprt());
                mem.set("storagetype", (Object)olapServerDimMemberMetaInfo.getStorageType());
                mem.set("pid", (Object)olapServerDimMemberMetaInfo.getParent());
                mem.set("id", (Object)olapServerDimMemberMetaInfo.getId());
                if (!ids.contains(String.valueOf(olapServerDimMemberMetaInfo.getId()))) continue;
                res.add(i + 1);
                valueTextItems.add(new ValueTextItem(String.valueOf(mem.getInt("seq")), olapServerDimMemberMetaInfo.getName()));
            }
            this.getModel().endInit();
            this.getView().updateView(MENBERF7VIEW_TREEID);
            if (res.size() > 0) {
                EntryGrid entryGrid = (EntryGrid)this.getControl(MENBERF7VIEW_TREEID);
                int[] ints1 = res.stream().mapToInt(Integer::intValue).toArray();
                entryGrid.selectRows(ints1, ints1[0]);
                F7SelectedList f7selectedlistap = (F7SelectedList)this.getControl(F7SELECTEDLISTAP);
                f7selectedlistap.addItems(valueTextItems);
            }
        }
    }

    private void cleanTree() {
        this.getModel().deleteEntryData(MENBERF7VIEW_TREEID);
    }

    private Map<String, OlapServerDimMemberMetaInfo> loadDimensionMembers(OlapRequestParam olapRequestParam) {
        String systemImport = (String)this.getView().getFormShowParameter().getCustomParam("systemimport");
        OlapFromServiceEnum typeEnum = OlapFromServiceEnum.getEnum((String)systemImport);
        return RequestFactoryBuilder.getAllMemberOfDim((OlapFromServiceEnum)typeEnum, param -> olapRequestParam);
    }

    public static void openF7(AbstractFormPlugin that, OlapFromServiceEnum typeEnum, String title, OlapRequestParam param, String closeCallBackName) {
        FAFMemberSelect.openF7(that, typeEnum, title, param, closeCallBackName, null);
    }

    private static OlapServerDimemsionMetaInfo getOlapServerDimemsionMetaInfo(AbstractFormPlugin that, String systemImport, OlapRequestParam param) {
        OlapServerDimemsionMetaInfo dimMeta;
        String olapServerDimemsionMetaInfoCache = "olapServerDimemsionMetaInfo_" + param.getModuleId() + param.getDimNumber();
        String olapServerDimemsionMetaInfoString = that.getView().getPageCache().get(olapServerDimemsionMetaInfoCache);
        if (olapServerDimemsionMetaInfoString == null) {
            OlapFromServiceEnum typeEnum = OlapFromServiceEnum.getEnum((String)systemImport);
            dimMeta = RequestFactoryBuilder.getDimensioin((OlapFromServiceEnum)typeEnum, par -> param);
            that.getView().getPageCache().put(olapServerDimemsionMetaInfoCache, SerializationUtils.toJsonString((Object)dimMeta));
        } else {
            dimMeta = (OlapServerDimemsionMetaInfo)SerializationUtils.fromJsonString((String)olapServerDimemsionMetaInfoString, OlapServerDimemsionMetaInfo.class);
        }
        return dimMeta;
    }

    public static void openF7(AbstractFormPlugin that, OlapFromServiceEnum typeEnum, String title, @NotNull OlapRequestParam param, String closeCallBackName, Set<Long> initIds) {
        FAFMemberSelect.check(param);
        OlapServerDimemsionMetaInfo olapServerDimemsionMetaInfo = FAFMemberSelect.getOlapServerDimemsionMetaInfo(that, typeEnum.getCode(), param);
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("faf_memberselectf7");
        param.setDimensionEntityName(olapServerDimemsionMetaInfo.getDimEntityName());
        param.setDimId(olapServerDimemsionMetaInfo.getId());
        formShowParameter.setCustomParam(OLAP_REQUEST_PARAM_ClASS, (Object)param.getClass().getName());
        formShowParameter.setCustomParam(OLAP_REQUEST_PARAM, (Object)JSON.toJSONString((Object)param));
        formShowParameter.setCustomParam(DIMENSION_NAME, (Object)olapServerDimemsionMetaInfo.getName());
        formShowParameter.setCustomParam("systemimport", (Object)typeEnum.getCode());
        Set initIdstrs = initIds == null ? Collections.emptySet() : initIds.stream().map(Object::toString).collect(Collectors.toSet());
        formShowParameter.setCustomParam(INIT_MEMBER_IDS, initIdstrs);
        if (title != null) {
            formShowParameter.setCaption(String.format(ResManager.loadKDString((String)"\u6210\u5458\u9009\u62e9 - %s", (String)"FAFMemberSelect_1", (String)"macc-faf-formplugin", (Object[])new Object[0]), title));
        }
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)that, closeCallBackName);
        formShowParameter.setCloseCallBack(closeCallBack);
        that.getView().showForm(formShowParameter);
    }

    private static void check(OlapRequestParam param) {
        if (param.getModuleId() == null || param.getDimNumber() == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u6c42\u6210\u5458\u6570\u636e\u65f6\u53c2\u6570\u4e0d\u6b63\u786e\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458", (String)"FAFMemberSelect_0", (String)"macc-faf-formplugin", (Object[])new Object[0]));
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("btnok".equals(key)) {
            ArrayList returnResult = new ArrayList(16);
            EntryUtil.selectToDo(this, MENBERF7VIEW_TREEID, dynamicObject -> {
                String pid = dynamicObject.getString("pid");
                if (StringUtils.isNotEmpty((String)pid) && !"0".equals(pid)) {
                    String id = dynamicObject.getString("id");
                    returnResult.add(new FAFF7Return(Long.parseLong(id), dynamicObject.getString("name"), dynamicObject.getString("number")));
                }
            });
            IFormView view = this.getView();
            if (returnResult.isEmpty()) {
                view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"FAFMemberSelect_2", (String)"macc-faf-formplugin", (Object[])new Object[0]));
                return;
            }
            view.returnDataToParent((Object)JSON.toJSONString(returnResult));
            view.close();
        }
    }
}

