/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.param;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.macc.faf.model.impl.IDataMapEntry;
import kd.macc.faf.param.FAFParamTemplateHelper;
import kd.macc.faf.util.BaseDataUtil;

public class FAFSrcParamSettingFormPlugin
extends AbstractFormPlugin
implements HyperLinkClickListener {
    private static final String DATA_SOURCE = "DATASOURCE_FIELD";

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        JSONObject params = (JSONObject)this.getView().getFormShowParameter().getCustomParam("F7PARAM");
        this.getPageCache().put("pageType", params.getString("pageType"));
        if (DATA_SOURCE.equals(this.getPageCache().get("pageType"))) {
            this.dataSourceInit(params);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"save"});
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control control = (Control)evt.getSource();
        switch (key = control.getKey()) {
            case "save": {
                this.save();
                break;
            }
            default: {
                this.getView().close();
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String key = closedCallBackEvent.getActionId();
        IDataModel model = this.getModel();
        int curIdx = model.getEntryCurrentRowIndex("entryentity");
        switch (key) {
            case "bcm_cslscheme_f7callback": {
                Object returnData = closedCallBackEvent.getReturnData();
                ListSelectedRowCollection selectedRows = (ListSelectedRowCollection)returnData;
                if (selectedRows == null) {
                    return;
                }
                model.setValue("param", selectedRows.get(0).getPrimaryKeyValue(), curIdx);
                model.setValue("paramvalue", (Object)selectedRows.get(0).getName(), curIdx);
                break;
            }
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        if (DATA_SOURCE.equals(this.getPageCache().get("pageType"))) {
            int row = evt.getRowIndex();
            String fieldKey = evt.getFieldName();
            if ("paramvalue".equals(fieldKey)) {
                DynamicObject entryentity = this.getModel().getEntryRowEntity("entryentity", row);
                String relynumber = entryentity.getString("relynumber");
                String datarequest = entryentity.getString("datarequest");
                String requesttype = entryentity.getString("requesttype");
                String filter = entryentity.getString("filter");
                String formId = entryentity.getString("formid");
                String caption = entryentity.getString("caption");
                String paramNumber = entryentity.getString("number");
                String param = entryentity.getString("param");
                this.getDataSetWithMethod(requesttype, filter, datarequest, relynumber, formId, caption, paramNumber, param);
            }
        }
    }

    private Map<String, Object> getSrcParamMapFromJson(String srcParamJson) {
        if (srcParamJson == null || srcParamJson.isEmpty()) {
            return null;
        }
        return (Map)JSON.parseObject((String)srcParamJson, (TypeReference)new TypeReference<Map<String, Object>>(){}, (Feature[])new Feature[0]);
    }

    private void dataSourceInit(JSONObject params) {
        String datarequest;
        DynamicObject objectType;
        String paramNumber = params.getString("paramNumber");
        IDataModel model = this.getModel();
        Map<String, Object> srcParam = this.getSrcParamMapFromJson(params.getString("paramsrc_tag"));
        DynamicObject entityLoad = FAFParamTemplateHelper.getParamDynamic(paramNumber);
        DynamicObjectCollection entryentity = entityLoad.getDynamicObjectCollection("entryentity");
        HashMap<String, String> number2name = new HashMap<String, String>(2);
        HashMap<String, Object> number2value = new HashMap<String, Object>(2);
        if (srcParam != null) {
            try {
                for (DynamicObject dynamicObject : entryentity) {
                    String paramNum = dynamicObject.getString("paramnumber");
                    Object paramValue = srcParam.get(paramNum);
                    if (paramValue == null) continue;
                    objectType = dynamicObject.getDynamicObject("objecttype");
                    datarequest = objectType == null ? "" : objectType.getString("number");
                    String value2name = null;
                    String requestType = dynamicObject.getString("requesttype");
                    if ("0".equals(requestType)) {
                        value2name = this.getValueWithJczl(datarequest, paramValue);
                    } else if ("1".equals(requestType)) {
                        value2name = this.getValueWithInterface(datarequest, Long.parseLong(paramValue.toString()));
                    } else if ("2".equalsIgnoreCase(requestType)) {
                        value2name = paramValue.toString();
                    }
                    number2name.put(paramNum, value2name);
                    number2value.put(paramNum, paramValue);
                }
            }
            catch (RuntimeException exception) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u521d\u59cb\u5316\u5931\u8d25\u3002", (String)"FAFSrcParamSettingFormPlugin_0", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                return;
            }
        }
        int index = 0;
        model.batchCreateNewEntryRow("entryentity", entryentity.size());
        for (DynamicObject dynamicObject : entryentity) {
            String paramNum = dynamicObject.getString("paramNumber");
            model.setValue("name", (Object)dynamicObject.getString("paramname"), index);
            model.setValue("number", (Object)paramNum, index);
            model.setValue("datatype", (Object)this.getDataType(dynamicObject.getString("datatype")), index);
            model.setValue("isnecessary", (Object)(dynamicObject.getBoolean("isinput") ? "1" : "0"), index);
            model.setValue("paramvalue", (Object)number2name.getOrDefault(paramNum, dynamicObject.getString("operatename")), index);
            model.setValue("param", number2value.get(paramNum), index);
            objectType = dynamicObject.getDynamicObject("objecttype");
            datarequest = objectType == null ? "" : objectType.getString("number");
            model.setValue("datarequest", (Object)datarequest, index);
            model.setValue("relynumber", (Object)dynamicObject.getString("relyparamnumber"), index);
            model.setValue("requesttype", (Object)dynamicObject.getString("requesttype"), index);
            model.setValue("filter", (Object)dynamicObject.getString("filter"), index);
            model.setValue("formid", (Object)dynamicObject.getString("formid"), index);
            model.setValue("caption", (Object)dynamicObject.getString("caption"), index);
            this.getView().setEnable(Boolean.FALSE, index, new String[]{"isnecessary", "paramvalue"});
            ++index;
        }
    }

    private String getDataType(String dataTypeValue) {
        switch (dataTypeValue) {
            case "0": {
                return ResManager.loadKDString((String)"\u65e5\u671f", (String)"FAFSrcParamSettingFormPlugin_1", (String)"macc-faf-formplugin", (Object[])new Object[0]);
            }
            case "1": {
                return ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599", (String)"FAFSrcParamSettingFormPlugin_2", (String)"macc-faf-formplugin", (Object[])new Object[0]);
            }
            case "2": {
                return ResManager.loadKDString((String)"\u6d6e\u70b9\u6570", (String)"FAFSrcParamSettingFormPlugin_3", (String)"macc-faf-formplugin", (Object[])new Object[0]);
            }
            case "3": {
                return ResManager.loadKDString((String)"\u6574\u6570", (String)"FAFSrcParamSettingFormPlugin_4", (String)"macc-faf-formplugin", (Object[])new Object[0]);
            }
            case "4": {
                return ResManager.loadKDString((String)"\u5e03\u5c14\u578b", (String)"FAFSrcParamSettingFormPlugin_5", (String)"macc-faf-formplugin", (Object[])new Object[0]);
            }
            case "5": {
                return ResManager.loadKDString((String)"\u5b57\u7b26\u4e32", (String)"FAFSrcParamSettingFormPlugin_6", (String)"macc-faf-formplugin", (Object[])new Object[0]);
            }
            case "6": {
                return ResManager.loadKDString((String)"\u6587\u4ef6\u4e0a\u4f20", (String)"FAFSrcParamSettingFormPlugin_7", (String)"macc-faf-formplugin", (Object[])new Object[0]);
            }
        }
        return "";
    }

    private String getValueWithInterface(String datarequest, Long paramvalue) {
        return null;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        IDataModel model = this.getModel();
        if ("param".equals(name)) {
            int curIdx = e.getChangeSet()[0].getRowIndex();
            String number = (String)model.getValue("number", curIdx);
            int rowCount = model.getEntryRowCount("entryentity");
            JSONObject params = (JSONObject)this.getView().getFormShowParameter().getCustomParam("F7PARAM");
            String paramNumber = params.getString("paramNumber");
            DynamicObject entityLoad = FAFParamTemplateHelper.getParamDynamic(paramNumber);
            DynamicObjectCollection entryentity = entityLoad.getDynamicObjectCollection("entryentity");
            for (int i = 0; i < rowCount; ++i) {
                String relyNumber = (String)model.getValue("relynumber", i);
                if (!StringUtils.isNotEmpty((CharSequence)relyNumber) || !number.equals(relyNumber)) continue;
                model.setValue("param", null, i);
                model.setValue("paramvalue", (Object)((DynamicObject)entryentity.get(i)).getString("operatename"), i);
            }
        }
    }

    private String getValueWithJczl(String datarequest, Object ... paramValue) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)paramValue[0], (String)datarequest);
        return dynamicObject.getString("name");
    }

    private void getDataSetWithMethod(String requestTpye, String filter, String datarequest, String relynumber, String formId, String caption, String paramNumber, String param) {
        IDataMapEntry<Boolean, DynamicObject> booleanLongIDataMapEntry = this.checkAndGetRelyValue(relynumber);
        Boolean rely = (Boolean)booleanLongIDataMapEntry.getKey();
        DynamicObject relyDynamicObject = (DynamicObject)booleanLongIDataMapEntry.getValue();
        if (rely.booleanValue() && !StringUtils.isNotEmpty((CharSequence)relyDynamicObject.getString("param"))) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9%s\u3002", (String)"FAFSrcParamSettingFormPlugin_8", (String)"macc-faf-formplugin", (Object[])new Object[0]), relyDynamicObject.getString("name")));
            return;
        }
        if ("0".equals(requestTpye)) {
            this.openjczlF7(datarequest, filter, booleanLongIDataMapEntry);
        } else if ("1".equals(requestTpye)) {
            this.openf7withInteface(datarequest, booleanLongIDataMapEntry);
        } else if ("2".equals(requestTpye)) {
            this.openDynForm(paramNumber, formId, caption, booleanLongIDataMapEntry, param);
        }
    }

    private void openDynForm(String paramNumber, String formId, String caption, IDataMapEntry<Boolean, DynamicObject> booleanLongIDataMapEntry, String param) {
        FormShowParameter formShowParameter = new FormShowParameter();
        Boolean rely = (Boolean)booleanLongIDataMapEntry.getKey();
        if (rely.booleanValue()) {
            DynamicObject value = (DynamicObject)booleanLongIDataMapEntry.getValue();
            formShowParameter.setCustomParam("customDependOn", (Object)value.getString("param"));
        }
        formShowParameter.setCustomParam("customEcho", (Object)param);
        formShowParameter.setFormId(formId);
        formShowParameter.setCaption(caption);
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "bcm_cslscheme_f7callback");
        formShowParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(formShowParameter);
    }

    private void openf7withInteface(String datarequest, IDataMapEntry<Boolean, DynamicObject> booleanLongIDataMapEntry) {
    }

    private void openjczlF7(String datarequest, String filter, IDataMapEntry<Boolean, DynamicObject> booleanLongIDataMapEntry) {
        Boolean rely = (Boolean)booleanLongIDataMapEntry.getKey();
        String filterName = null;
        Set<Long> filterCollections = null;
        if (rely.booleanValue()) {
            filterName = filter;
            DynamicObject value = (DynamicObject)booleanLongIDataMapEntry.getValue();
            long paramfilter = value.getLong("param");
            filterCollections = Collections.singleton(paramfilter);
        }
        BaseDataUtil.openF7List(this, datarequest, "bcm_cslscheme_f7callback", filterName, filterCollections, Collections.singletonMap("custom", "fsa"));
    }

    private IDataMapEntry<Boolean, DynamicObject> checkAndGetRelyValue(String relynumber) {
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)relynumber)) {
            return new IDataMapEntry((Object)Boolean.FALSE, null);
        }
        DynamicObjectCollection entryentity = this.getModel().getEntryEntity("entryentity");
        Optional<DynamicObject> paramnumber = entryentity.stream().filter(p -> p.getString("number").equals(relynumber)).findFirst();
        DynamicObject dynamicObject = paramnumber.get();
        return new IDataMapEntry((Object)Boolean.TRUE, (Object)dynamicObject);
    }

    private void save() {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        DynamicObjectCollection entryentity = model.getEntryEntity("entryentity");
        HashMap<String, Object> returnData = new HashMap<String, Object>();
        for (DynamicObject dynamicObject : entryentity) {
            Object paramObjectValue;
            String isNecessary;
            block7: {
                isNecessary = dynamicObject.getString("isnecessary");
                String number = dynamicObject.getString("number");
                paramObjectValue = dynamicObject.get("paramvalue");
                if (DATA_SOURCE.equals(this.getPageCache().get("pageType"))) {
                    String value = (String)dynamicObject.get("param");
                    returnData.put(number, StringUtils.isNotEmpty((CharSequence)value) ? Long.valueOf(Long.parseLong(value)) : null);
                    if (StringUtils.isNotEmpty((CharSequence)value)) {
                        returnData.put(number + "name", paramObjectValue);
                    }
                } else {
                    try {
                        int paramValue;
                        if (number.equals("length") && (paramValue = Integer.parseInt((String)paramObjectValue)) < 0) {
                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b57\u6bb5\u957f\u5ea6\u7684\u53c2\u6570\u503c\u5e94\u4e3a\u5927\u4e8e\u7b49\u4e8e0\u7684\u6574\u6570\u3002", (String)"FAFSrcParamSettingFormPlugin_9", (String)"macc-faf-formplugin", (Object[])new Object[0]));
                            return;
                        }
                        returnData.put(dynamicObject.getString("number"), paramObjectValue);
                    }
                    catch (NumberFormatException e) {
                        if (!"1".equals(isNecessary)) break block7;
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u53c2\u6570\u503c\u5e94\u4e3a\u6574\u6570\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"FAFSrcParamSettingFormPlugin_10", (String)"macc-faf-formplugin", (Object[])new Object[0]));
                        return;
                    }
                }
            }
            if (!"1".equals(isNecessary) || (!DATA_SOURCE.equals(this.getPageCache().get("pageType")) || !StringUtils.isBlank((Object)dynamicObject.get("param"))) && (!"COMBINATION_PARAM".equals(this.getPageCache().get("pageType")) || !StringUtils.isBlank((Object)paramObjectValue))) continue;
            String name = dynamicObject.getString("name");
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9%s\u3002", (String)"FAFSrcParamSettingFormPlugin_8", (String)"macc-faf-formplugin", (Object[])new Object[0]), name));
            return;
        }
        view.returnDataToParent(returnData);
        view.close();
    }
}

