/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.qing;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.faf.enums.FAFDimensionTypeEnum;
import kd.macc.faf.fas.FAFIndexBusinessHelper;

public class FAFModelQueryRptListPlugin
extends AbstractReportListDataPlugin {
    private static final String ALGO_KEY = FAFModelQueryRptListPlugin.class.getName();
    private List<ReportColumn> columns;

    public DataSet query(ReportQueryParam queryParam, Object selectedObj) throws Throwable {
        Map paramMap = queryParam.getCustomParam();
        DynamicObject dyObjectModel = BusinessDataServiceHelper.loadSingleFromCache(paramMap.get("modelId"), (String)"pa_analysismodel");
        String entityName = FAFIndexBusinessHelper.getEntityNumber((DynamicObject)dyObjectModel);
        this.columns = this.buildColumns(dyObjectModel);
        String selectFields = this.columns.stream().map(ReportColumn::getFieldKey).collect(Collectors.joining(","));
        FilterInfo filterInfo = queryParam.getFilter();
        List qFilters = filterInfo.getQFilters();
        return QueryServiceHelper.queryDataSet((String)ALGO_KEY, (String)entityName, (String)selectFields, (QFilter[])qFilters.toArray(new QFilter[0]), null);
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) throws Throwable {
        columns.addAll(this.columns);
        return super.getColumns(columns);
    }

    private List<ReportColumn> buildColumns(DynamicObject dyObjectModel) {
        ArrayList<ReportColumn> columns = new ArrayList<ReportColumn>();
        DynamicObjectCollection dEntrys = dyObjectModel.getDynamicObjectCollection("dimension_entry");
        for (Object entry : dEntrys) {
            ReportColumn column = new ReportColumn();
            DynamicObject dimension = entry.getDynamicObject("dimension");
            if (dimension != null) {
                column.setFieldKey(dimension.getString("number"));
                column.setCaption(new LocaleString(dimension.getString("name")));
                String dimensiontype = dimension.getString("dimensiontype");
                if (FAFDimensionTypeEnum.DATABASE.eqScene((Object)dimensiontype)) {
                    column.setFieldType("basedata");
                    column.setEntityId(dimension.getDynamicObject("dimensionsource").getString("number"));
                } else if (FAFDimensionTypeEnum.ASSISTANTDATA.eqScene((Object)dimensiontype)) {
                    column.setFieldType("basedata");
                    column.setEntityId("bos_assistantdata_detail");
                } else if (FAFDimensionTypeEnum.DATE.eqScene((Object)dimensiontype)) {
                    column.setFieldType("date");
                } else {
                    column.setFieldType("text");
                }
            }
            columns.add(column);
        }
        DynamicObjectCollection mEntrys = dyObjectModel.getDynamicObjectCollection("measure_entry");
        for (DynamicObject entry : mEntrys) {
            DynamicObject measure = entry.getDynamicObject("measure");
            String number = measure.getString("number");
            String name = measure.getString("name");
            ReportColumn column = new ReportColumn();
            column.setFieldKey(number);
            column.setFieldType("decimal");
            column.setCaption(new LocaleString(name));
            column.setZeroShow(true);
            column.setScale(4);
            columns.add(column);
        }
        ReportColumn column = new ReportColumn();
        column.setFieldKey("id");
        column.setFieldType("text");
        column.setCaption(new LocaleString("id"));
        column.setHide(true);
        columns.add(0, column);
        return columns;
    }
}

