/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.qing;

import com.alibaba.fastjson.JSONArray;
import com.kingdee.bos.qing.api.customtable.interfaces.CustomHyperLinkAccessor;
import com.kingdee.bos.qing.api.customtable.model.CustomHyperParam;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.macc.faf.fas.FAFIndexBusinessHelper;
import kd.macc.faf.qing.FAFModelQueryRptPlugin;

public class QingRptfafModelQueryLink
implements CustomHyperLinkAccessor {
    private static final Log logger = LogFactory.getLog(QingRptfafModelQueryLink.class);
    private static final String P_SYSTEM = "p1_system";
    private static final String P_MODEL = "p2_model";
    private static final String P_PARAMKEY = "p3_number";
    private static final String P_PARAMVALUE = "p4_value";

    public Map<String, CustomHyperParam> initParams() {
        LinkedHashMap<String, CustomHyperParam> map = new LinkedHashMap<String, CustomHyperParam>();
        map.put(P_SYSTEM, this.builParam(P_SYSTEM, ResManager.loadKDString((String)"\u5206\u6790\u4f53\u7cfb.\u7f16\u53f7", (String)"QingRptfafModelQueryLink_0", (String)"macc-faf-formplugin", (Object[])new Object[0])));
        map.put(P_MODEL, this.builParam(P_MODEL, ResManager.loadKDString((String)"\u5206\u6790\u6a21\u578b.\u7f16\u53f7", (String)"QingRptfafModelQueryLink_1", (String)"macc-faf-formplugin", (Object[])new Object[0])));
        map.put(P_PARAMKEY, this.builParam(P_PARAMKEY, ResManager.loadKDString((String)"\u8fc7\u6ee4\u6761\u4ef6.\u7ef4\u5ea6\u7f16\u53f7", (String)"QingRptfafModelQueryLink_2", (String)"macc-faf-formplugin", (Object[])new Object[0])));
        map.put(P_PARAMVALUE, this.builParam(P_PARAMVALUE, ResManager.loadKDString((String)"\u8fc7\u6ee4\u6761\u4ef6.\u7ef4\u5ea6\u503c", (String)"QingRptfafModelQueryLink_3", (String)"macc-faf-formplugin", (Object[])new Object[0])));
        return map;
    }

    public void jump(Map<String, CustomHyperParam> params, Map<String, Object> context) {
        IFormView view = (IFormView)context.get("view");
        try {
            Object systemnumber = params.get(P_SYSTEM).getValue();
            Object modelnumber = params.get(P_MODEL).getValue();
            QFilter filter = new QFilter("analysis_system.number", "=", systemnumber).and("number", "=", modelnumber);
            DynamicObject dyModel = BusinessDataServiceHelper.loadSingle((String)"pa_analysismodel", (QFilter[])filter.toArray());
            if (dyModel == null) {
                view.showTipNotification(String.format(ResManager.loadKDString((String)"\u5206\u6790\u6a21\u578b(%1$s)\u4e0d\u5b58\u5728\u3002", (String)"QingRptfafModelQueryLink_4", (String)"macc-faf-formplugin", (Object[])new Object[0]), modelnumber));
                return;
            }
            Map<Object, String> filterParams = this.parseKeyVal(dyModel, params);
            logger.info("[faf] qingrpt query params" + filterParams);
            Map<Object, DynamicObject> dimensions = this.getDimensions(filterParams.keySet());
            QFilter qFilter = new QFilter("collectstatus", "=", (Object)1);
            Set<Map.Entry<Object, String>> entries = filterParams.entrySet();
            for (Map.Entry<Object, String> entry : entries) {
                DynamicObject dimension = dimensions.get(entry.getKey());
                Class primaryKeyType = FAFIndexBusinessHelper.getDimensionPrimaryKeyType((DynamicObject)dimension);
                if (primaryKeyType == Date.class) {
                    Date date = new SimpleDateFormat("EEE MMM dd HH:mm:ss Z yyyy", Locale.ENGLISH).parse(entry.getValue());
                    qFilter.and(dimension.getString("number"), "=", (Object)date);
                    continue;
                }
                if (primaryKeyType == Long.class) {
                    String value = entry.getValue();
                    if (!StringUtils.equals((CharSequence)"null", (CharSequence)value)) {
                        qFilter.and(dimension.getString("number"), "=", (Object)Long.valueOf(value));
                        continue;
                    }
                    qFilter.and(dimension.getString("number"), "=", (Object)0L);
                    continue;
                }
                if (primaryKeyType != String.class) continue;
                qFilter.and(dimension.getString("number"), "=", (Object)entry.getValue());
            }
            FAFModelQueryRptPlugin.openBy(view, dyModel.getPkValue(), qFilter);
        }
        catch (Exception ex) {
            logger.error("faf link query data erro", (Throwable)ex);
            view.showErrorNotification(String.format(ResManager.loadKDString((String)"\u5165\u53c2\u89e3\u6790\u53d1\u751f\u9519\u8bef,\u8bf7\u68c0\u67e5\u62a5\u8868\u914d\u7f6e\u4fe1\u606f: %s\u3002", (String)"QingRptfafModelQueryLink_5", (String)"macc-faf-formplugin", (Object[])new Object[0]), ex.getMessage()));
        }
    }

    private Map<Object, DynamicObject> getDimensions(Set<Object> pkvalueSet) {
        return BusinessDataServiceHelper.loadFromCache((Object[])pkvalueSet.toArray(), (String)"pa_dimension");
    }

    private Map<Object, String> parseKeyVal(DynamicObject dyModel, Map<String, CustomHyperParam> params) {
        DynamicObjectCollection dEntrys = dyModel.getDynamicObjectCollection("dimension_entry");
        Map<String, Object> collect = dEntrys.stream().collect(Collectors.toMap(dyn -> dyn.getString("dimension.number"), dynamicObject -> dynamicObject.get("dimension.id")));
        LinkedHashMap<Object, String> filterParams = new LinkedHashMap<Object, String>();
        Object keyObj = params.get(P_PARAMKEY).getValue();
        Object valObj = params.get(P_PARAMVALUE).getValue();
        if (keyObj instanceof String) {
            filterParams.put(collect.get(keyObj), String.valueOf(valObj));
        } else {
            JSONArray arrKey = (JSONArray)keyObj;
            for (int i = 0; i < arrKey.size(); ++i) {
                String key = arrKey.getJSONObject(i).getString("_value");
                if (valObj instanceof JSONArray) {
                    JSONArray arrVal = (JSONArray)valObj;
                    if (arrVal.size() <= i) continue;
                    String val = arrVal.getJSONObject(i).getString("_value");
                    if (!collect.containsKey(key)) {
                        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5165\u53c2\u9519\u8bef, %s \u4e0d\u5b58\u5728", (String)"QingRptfafModelQueryLink_6", (String)"macc-faf-formplugin", (Object[])new Object[0]), key));
                    }
                    filterParams.put(collect.get(key), val);
                    continue;
                }
                if (i != 0) continue;
                filterParams.put(collect.get(key), String.valueOf(valObj));
            }
        }
        return filterParams;
    }

    private CustomHyperParam builParam(String name, String alias) {
        CustomHyperParam param = new CustomHyperParam(name, alias, true);
        param.setParamType(CustomHyperParam.ParamType.String_Type);
        return param;
    }
}

