/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.report;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashSet;
import kd.bos.algo.util.Tuple2;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRFormula;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.faf.report.validate.FAFReportItemValidate;
import kd.macc.faf.util.CalculateUtils;
import kd.macc.faf.util.DimensionDyUtil;
import kd.macc.faf.util.EntityTreeUtil;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class FAFReportItemFormplugin
extends AbstractBillPlugIn {
    private final String[] needFlCondition = new String[]{"1", "3", "4"};
    private final String[] needMx = new String[]{"0", "1"};
    private final String[] needCjCondition = new String[]{"4", "5"};

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"formula2"});
    }

    public void afterBindData(EventObject e) {
        DynamicObject dimension;
        super.afterBindData(e);
        IDataModel model = this.getModel();
        String formuladesc = (String)model.getValue("formuladesc");
        DynamicObject groupDynamicObject = (DynamicObject)model.getValue("group");
        if (groupDynamicObject != null && (dimension = groupDynamicObject.getDynamicObject("dimension")) != null) {
            model.setValue("dimensionshow", (Object)dimension.getString("name"));
        }
        this.setFormula2(formuladesc);
        model.setDataChanged(false);
    }

    public void afterLoadData(EventObject e) {
        String number = this.getModel().getDataEntity().getString("number");
        Long id = (Long)this.getModel().getDataEntity().getPkValue();
        if (!FAFReportItemValidate.checkBeDepend(id, number).isEmpty()) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"number", "name"});
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if (StringUtils.equals((CharSequence)key, (CharSequence)"formula2")) {
            String computeType = (String)this.getModel().getValue("comptype");
            Object group = this.getModel().getValue("group");
            if (group == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u62a5\u8868\u9879\u76ee\u7c7b\u578b\u3002", (String)"FAFReportItemFormplugin_1", (String)"macc-faf-formplugin", (Object[])new Object[0]));
                return;
            }
            if (StringUtils.isEmpty((CharSequence)computeType)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8ba1\u7b97\u4f9d\u636e\u3002", (String)"FAFReportItemFormplugin_0", (String)"macc-faf-formplugin", (Object[])new Object[0]));
                return;
            }
            String formula_tag = (String)this.getModel().getValue("formula_tag");
            String formula = (String)this.getModel().getValue("formula");
            formula = formula_tag.length() <= 255 ? formula : formula_tag;
            String formuladesc_tag = (String)this.getModel().getValue("formuladesc_tag");
            String formuladesc = (String)this.getModel().getValue("formuladesc");
            formuladesc = formuladesc_tag.length() <= 255 ? formuladesc : formuladesc_tag;
            CRFormula crFormula = new CRFormula();
            crFormula.setExpression(formula);
            crFormula.setDescription(new LocaleString(formuladesc));
            this.showConditionForm(crFormula);
        }
    }

    private void showConditionForm(CRFormula crFormula) {
        String treeNodeString;
        String treeNodeRootName;
        String entity;
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        String comptype = (String)this.getModel().getValue("comptype");
        Object[] qFilter = null;
        DynamicObject group = (DynamicObject)model.getValue("group");
        long dimension_id = group.getLong("dimension_id");
        if ("1".equals(comptype)) {
            entity = "pa_reportitem";
            treeNodeRootName = new LocaleString(ResManager.loadKDString((String)"\u62a5\u8868\u9879", (String)"FAFReportItemFormplugin_2", (String)"macc-faf-formplugin", (Object[])new Object[0])).toString();
            Object id = this.getModel().getValue("id");
            if (id != null) {
                qFilter = new QFilter[]{new QFilter("id", "!=", id), new QFilter("group", "=", group.getPkValue())};
            }
        } else if ("0".equals(comptype)) {
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((Object)dimension_id, (String)"pa_dimension");
            Tuple2 entityFilter = DimensionDyUtil.getDimensionSourceNumberFromDimension((DynamicObject)dynamicObject);
            if (entityFilter == null) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u53ea\u652f\u6301\u7ef4\u5ea6\u7c7b\u578b\u4e3a\u201c\u57fa\u7840\u8d44\u6599\u201d\u3001\u201c\u8f85\u52a9\u8d44\u6599\u201d\u3001\u201c\u671f\u95f4\u7ef4\u5ea6\u201d\u7684\u7ef4\u5ea6\u6dfb\u52a0\u516c\u5f0f", (String)"FAFReportItemFormplugin_3", (String)"macc-faf-formplugin", (Object[])new Object[0]), dynamicObject.getString("name")));
            }
            entity = (String)entityFilter.t1;
            qFilter = (QFilter[])entityFilter.t2;
            treeNodeRootName = dynamicObject.getString("name");
        } else {
            return;
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setShowTitle(true);
        showParameter.setCaption(new LocaleString(ResManager.loadKDString((String)"\u516c\u5f0f\u8868\u8fbe\u5f0f", (String)"FAFReportItemFormplugin_4", (String)"macc-faf-formplugin", (Object[])new Object[0])).toString());
        showParameter.setFormId("faf_expression");
        showParameter.getCustomParams().put("formula", SerializationUtils.toJsonString((Object)crFormula));
        IPageCache pageCache = this.getPageCache();
        if (pageCache.get("treenodes" + entity + dimension_id) != null) {
            treeNodeString = pageCache.get("treenodes" + entity + dimension_id);
        } else {
            boolean hasFullName;
            DynamicObject setting = BusinessDataServiceHelper.loadSingle((String)"pa_formulasetting", (String)"leaffield,parentfield,groupfield,showform", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)entity)});
            StringBuilder selectFieldsB = new StringBuilder("id");
            boolean isExistName = this.checkExistProperty(entity, "name");
            boolean isExistNumber = this.checkExistProperty(entity, "number");
            if (isExistNumber) {
                selectFieldsB.append(", number");
            } else {
                selectFieldsB.append(", id as number");
            }
            if (isExistName) {
                selectFieldsB.append(", name");
            } else if (isExistNumber) {
                selectFieldsB.append(", number as name");
            } else {
                selectFieldsB.append(", id as name");
            }
            String showform = "2";
            if (setting != null) {
                String leaffield = setting.getString("leaffield");
                String parentfield = setting.getString("parentfield");
                String groupfield = setting.getString("groupfield");
                showform = setting.getString("showform");
                if (ArrayUtils.contains((Object[])this.needMx, (Object)showform) && StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{leaffield})) {
                    if (qFilter == null) {
                        qFilter = new QFilter[]{new QFilter(leaffield, "=", (Object)"1")};
                    } else {
                        QFilter[] qFilters = new QFilter[qFilter.length + 1];
                        System.arraycopy(qFilter, 0, qFilters, 0, qFilter.length);
                        qFilters[qFilters.length - 1] = new QFilter(leaffield, "=", (Object)"1");
                        qFilter = qFilters;
                    }
                }
                parentfield = StringUtils.isEmpty((CharSequence)parentfield) ? "'' as parentfield" : parentfield + "  as parentfield";
                groupfield = StringUtils.isEmpty((CharSequence)groupfield) ? "'' as groupfield" : groupfield + "  as groupfield," + groupfield + ".name as groupfield_name";
                if (StringUtils.isEmpty((CharSequence)showform)) {
                    showform = "0";
                }
                selectFieldsB.append(",").append(parentfield);
                selectFieldsB.append(",").append(groupfield);
            }
            if (hasFullName = this.checkExistProperty(entity, "fullname")) {
                selectFieldsB.append(",fullname");
            }
            if (this.checkExistProperty(entity, "enable")) {
                qFilter = (QFilter[])ArrayUtils.add((Object[])qFilter, (Object)new QFilter("enable", "=", (Object)"1"));
            }
            DynamicObjectCollection datas = QueryServiceHelper.query((String)entity, (String)selectFieldsB.toString(), (QFilter[])qFilter);
            treeNodeString = this.dyCollection2TreeNodeString(hasFullName, datas, treeNodeRootName, showform);
            pageCache.put("treenodes" + entity + dimension_id, treeNodeString);
        }
        showParameter.getCustomParams().put("treenodes", treeNodeString);
        showParameter.getCustomParams().put("fextraexpression", model.getValue("formulacom_tag"));
        showParameter.getCustomParams().put("PROXY_CLASS", "kd.macc.faf.verification.FAFReportItemProxy");
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "calculationruleCallback"));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        view.showForm(showParameter);
    }

    private boolean checkExistProperty(String entity, String property) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entity);
        DynamicProperty enable = dataEntityType.getProperty(property);
        if (enable == null) {
            return false;
        }
        return !StringUtils.isEmpty((CharSequence)enable.getAlias());
    }

    private String dyCollection2TreeNodeString(boolean hasFullName, DynamicObjectCollection datas, String treeNodeRootName, String showForm) {
        ArrayList<TreeNode> rootNode = new ArrayList<TreeNode>(Collections.singleton(new TreeNode("", "0", treeNodeRootName)));
        boolean needFl = ArrayUtils.contains((Object[])this.needFlCondition, (Object)showForm);
        boolean needCj = ArrayUtils.contains((Object[])this.needCjCondition, (Object)showForm);
        HashSet<String> itemTypeSet = new HashSet<String>(16);
        String flid = "";
        HashSet<String> treeNodeIdSet = new HashSet<String>(16);
        HashSet<String> treeNodeNumberSet = new HashSet<String>(16);
        for (DynamicObject data : datas) {
            if (needFl) {
                Object groupfield = data.get("groupfield");
                if (groupfield instanceof Long) {
                    flid = String.valueOf(groupfield);
                    if (itemTypeSet.add(flid)) {
                        String flname = data.getString("groupfield_name");
                        rootNode.add(new TreeNode("0", flid, flname));
                    }
                } else if ("".equals(groupfield)) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5728\u6210\u5458\u5c55\u793a\u9875\u9762\u914d\u7f6e\u8be5\u5b9e\u4f53\u5bf9\u8c61\u5206\u7c7b\u5b57\u6bb5", (String)"FAFReportItemFormplugin_5", (String)"macc-faf-formplugin", (Object[])new Object[0]));
                }
            }
            String cjId = "";
            if (needCj) {
                Object parentfield = data.get("parentfield");
                if (parentfield instanceof Number) {
                    cjId = String.valueOf(parentfield);
                    if ("0".equals(cjId)) {
                        cjId = "";
                    }
                } else if ("".equals(parentfield)) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5728\u6210\u5458\u5c55\u793a\u9875\u9762\u914d\u7f6e\u8be5\u5b9e\u4f53\u5bf9\u8c61\u5c42\u7ea7\u5b57\u6bb5", (String)"FAFReportItemFormplugin_6", (String)"macc-faf-formplugin", (Object[])new Object[0]));
                }
            }
            String number = data.getString("number");
            String name = data.getString("name");
            long id = data.getLong("id");
            String parentId = "0";
            if (!"".equals(flid + cjId)) {
                parentId = flid + cjId;
            }
            String treeNodeId = flid + id;
            String treeNumber = flid + number;
            if (!treeNodeIdSet.add(treeNodeId) || !treeNodeNumberSet.add(treeNumber)) continue;
            rootNode.add(new TreeNode(parentId, treeNodeId, number + " " + (hasFullName ? data.getString("fullname") : name), (Object)number));
        }
        TreeNode treeNode = EntityTreeUtil.buildBillTree(rootNode);
        return SerializationUtils.toJsonString((Object)treeNode);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Object returnData = closedCallBackEvent.getReturnData();
        if (returnData == null) {
            return;
        }
        if ("calculationruleCallback".equals(closedCallBackEvent.getActionId())) {
            JSONObject jsonObject = JSON.parseObject((String)((String)returnData));
            String expression = jsonObject.getString("expression");
            String formulacom = jsonObject.getString("fextraexpression");
            String description = jsonObject.getString("description");
            if (StringUtils.isEmpty((CharSequence)description)) {
                description = expression;
            }
            this.setFormula(expression, description, formulacom);
            this.setFormula2(description);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name;
        switch (name = e.getProperty().getName()) {
            case "formula2": {
                String newValue = (String)e.getChangeSet()[0].getNewValue();
                if (!StringUtils.isBlank((CharSequence)newValue)) break;
                this.clearFormula();
                break;
            }
            case "group": 
            case "comptype": {
                this.clearFormula();
                break;
            }
        }
    }

    private void clearFormula() {
        this.getModel().beginInit();
        this.getModel().setValue("formuladesc_tag", (Object)"");
        this.getModel().setValue("formuladesc", (Object)"");
        this.getModel().setValue("formula_tag", (Object)"");
        this.getModel().setValue("formula", (Object)"");
        this.getModel().setValue("formulacom_tag", (Object)"");
        this.getModel().setValue("formulacom", (Object)"");
        this.getModel().setValue("formula2", (Object)"");
        this.getModel().deleteEntryData("dep");
        this.getModel().endInit();
        this.getView().updateView();
    }

    private void setFormula(String expression, String description, String formulacom) {
        this.clearFormula();
        this.setFormula("formuladesc", description);
        this.setFormula("formula", expression);
        this.setFormula("formulacom", formulacom);
        this.parseFormula2Entry(this.getModel(), formulacom);
    }

    private void setFormula(String properiesName, String value) {
        String formulacomJy;
        String string = formulacomJy = value.length() > 255 ? value.substring(0, 252) + "..." : value;
        if (value.length() > 255) {
            this.getModel().setValue(properiesName + "_tag", (Object)value);
            this.getModel().setValue(properiesName, (Object)formulacomJy);
        } else {
            this.getModel().setValue(properiesName + "_tag", (Object)value);
            this.getModel().setValue(properiesName, (Object)value);
        }
    }

    private void setFormula2(String description) {
        String jy = description.length() > 255 ? description.substring(0, 252) + "..." : description;
        this.getModel().setValue("formula2", (Object)jy);
    }

    private void parseFormula2Entry(IDataModel model, String formulacom) {
        String comptype = (String)model.getValue("comptype");
        if ("1".equals(comptype)) {
            String[] split = formulacom.trim().split("[\\+\\-\\*/\\()\\s]+");
            HashSet<String> set = new HashSet<String>(split.length);
            for (String forulaItem : split) {
                if ("".equals(forulaItem)) continue;
                set.add(forulaItem);
            }
            if (!set.isEmpty()) {
                int size = set.size();
                model.batchCreateNewEntryRow("dep", size);
                int index = 0;
                for (String item : set) {
                    model.setValue("itemnumber", (Object)item, index);
                    ++index;
                }
            }
        }
    }

    public void afterImportData(ImportDataEventArgs e) {
        IDataModel model = (IDataModel)e.getSource();
        String formula = (String)model.getValue("formula");
        String formula_tag = (String)model.getValue("formula_tag");
        if (formula_tag == null || formula_tag.length() <= 255) {
            formula_tag = formula;
        }
        model.setValue("formula2", (Object)formula);
        model.setValue("formulacom_tag", (Object)CalculateUtils.formulaItemFormat((String)formula_tag, (boolean)true));
        model.setValue("formulacom", (Object)CalculateUtils.formulaItemFormat((String)formula, (boolean)true));
        this.parseFormula2Entry(model, formula_tag);
        super.afterImportData(e);
    }
}

