/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.report;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.control.Button;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.plugin.AbstractTreeListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.faf.report.validate.FAFReportItemValidate;

public class FAFReportItemListPlugin
extends AbstractTreeListPlugin {
    private void beforeNewValidate(BeforeDoOperationEventArgs args) {
        TreeView treeview = (TreeView)this.getView().getControl("treeview");
        if (treeview != null) {
            List accTypeId = treeview.getTreeState().getSelectedNodes();
            if (accTypeId.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u62a5\u8868\u9879\u76ee\u7c7b\u578b\u3002", (String)"FAFReportItemListPlugin_0", (String)"macc-faf-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            } else {
                Map objectMap = (Map)accTypeId.get(0);
                if (objectMap == null || "8609760E-EF83-4775-A9FF-CCDEC7C0B689".equals(objectMap.get("id"))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u62a5\u8868\u9879\u76ee\u7c7b\u578b\u3002", (String)"FAFReportItemListPlugin_0", (String)"macc-faf-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                }
            }
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate operateInfo = (FormOperate)args.getSource();
        String keyName = operateInfo.getOperateKey();
        if (keyName.equals("new")) {
            this.beforeNewValidate(args);
        } else if (keyName.equals("delete")) {
            this.beforeDeleteValidate(args);
        }
    }

    private void beforeDeleteValidate(BeforeDoOperationEventArgs args) {
        ListSelectedRowCollection listSelectedData = args.getListSelectedData();
        HashSet<Long> ids = new HashSet<Long>(listSelectedData.size());
        HashSet<String> numbers = new HashSet<String>(listSelectedData.size());
        for (ListSelectedRow listSelectedDatum : listSelectedData) {
            Long primaryKeyValue = (Long)listSelectedDatum.getPrimaryKeyValue();
            ids.add(primaryKeyValue);
            String number = listSelectedDatum.getNumber();
            numbers.add(number);
        }
        Set<String> dependNames = FAFReportItemValidate.checkBeDepend(ids, numbers);
        if (!dependNames.isEmpty()) {
            String message;
            String join = dependNames.stream().map(p -> "\"" + p + "\"").collect(Collectors.joining(","));
            if (dependNames.size() > 5 || join.length() > 80) {
                message = ResManager.loadKDString((String)"\u5df2\u88ab\u4ee5\u4e0b\u62a5\u8868\u9879\u76ee\u6240\u5f15\u7528,\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"FAFReportItemListPlugin_1", (String)"macc-faf-formplugin", (Object[])new Object[0]);
                this.getView().showMessage(message, join, MessageTypes.Default);
            } else {
                message = String.format(ResManager.loadKDString((String)"\u5df2\u88ab\u62a5\u8868\u9879\u76ee%s\u6240\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"FAFReportItemListPlugin_2", (String)"macc-faf-formplugin", (Object[])new Object[0]), join);
                this.getView().showTipNotification(message);
            }
            args.setCancel(true);
        }
    }

    public void initializeTree(EventObject e) {
        String reportItemTypeIdSetJson;
        super.initializeTree(e);
        IFormView parentView = this.getView().getParentView();
        if (parentView != null && "pa_reportdefinition".equals(parentView.getEntityId()) && (reportItemTypeIdSetJson = (String)this.getView().getFormShowParameter().getCustomParam("reportItemTypeIdSet")) != null && !reportItemTypeIdSetJson.isEmpty()) {
            Set reportItemTypeIdSet = (Set)JSON.parseObject((String)reportItemTypeIdSetJson, (TypeReference)new TypeReference<Set<Long>>(){}, (Feature[])new Feature[0]);
            this.getTreeModel().getTreeFilter().add(new QFilter("id", "in", (Object)reportItemTypeIdSet));
        }
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        String key = ((Button)evt.getSource()).getKey();
        if ("btnok".equals(key)) {
            this.checkBeforeAddReportItem(evt, null);
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        this.checkBeforeAddReportItem(null, args);
    }

    private void checkBeforeAddReportItem(BeforeClickEvent beforeClickEvent, HyperLinkClickArgs hyperLinkClickArgs) {
        ListSelectedRowCollection selectedRows;
        IFormView view = this.getView();
        IFormView parentView = view.getParentView();
        if (parentView != null && "pa_reportdefinition".equals(parentView.getEntityId()) && (selectedRows = this.getSelectedRows()) != null) {
            HashSet idSet = new HashSet(selectedRows.size());
            selectedRows.forEach(p -> idSet.add(Long.valueOf(String.valueOf(p.getPrimaryKeyValue()))));
            QFilter filter = new QFilter("id", "in", idSet);
            DynamicObjectCollection reportItemArr = QueryServiceHelper.query((String)"pa_reportitem", (String)"id,number,name,group", (QFilter[])filter.toArray());
            if (reportItemArr != null) {
                HashSet<Long> reportTypeSet = new HashSet<Long>(reportItemArr.size());
                for (DynamicObject reportItemObj : reportItemArr) {
                    reportTypeSet.add((Long)reportItemObj.get("group"));
                }
                HashSet<Long> relationDimensionIdSet = new HashSet<Long>(1);
                QFilter reportTypeFilter = new QFilter("id", "in", reportTypeSet);
                DynamicObject[] reportItemTypeArr = BusinessDataServiceHelper.load((String)"pa_reportitemtype", (String)"id,number,name,dimension", (QFilter[])reportTypeFilter.toArray());
                if (reportItemTypeArr != null) {
                    for (DynamicObject reportItemTypeObj : reportItemTypeArr) {
                        relationDimensionIdSet.add((Long)reportItemTypeObj.get("dimension_id"));
                    }
                }
                if (relationDimensionIdSet.size() > 1) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u62a5\u8868\u9879\u76ee\u5b58\u5728\u591a\u4e2a\u5173\u8054\u7ef4\u5ea6\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u62a5\u8868\u9879\u76ee\u3002", (String)"FAFReportItemListPlugin_3", (String)"macc-faf-formplugin", (Object[])new Object[0]));
                    if (beforeClickEvent != null) {
                        beforeClickEvent.setCancel(true);
                    } else if (hyperLinkClickArgs != null) {
                        hyperLinkClickArgs.setCancel(true);
                    }
                    return;
                }
                Long existReportItemDimensionId = (Long)view.getFormShowParameter().getCustomParam("existReportItemDimensionId");
                if (existReportItemDimensionId != null && !relationDimensionIdSet.isEmpty() && !relationDimensionIdSet.contains(existReportItemDimensionId)) {
                    view.showConfirm(ResManager.loadKDString((String)"\u5f53\u524d\u6240\u9009\u62a5\u8868\u9879\u76ee\u4e0e\u5df2\u9009\u62a5\u8868\u9879\u76ee\u5173\u8054\u7684\u7ef4\u5ea6\u4e0d\u540c\uff0c\u662f\u5426\u6e05\u7a7a\u5df2\u9009\u62a5\u8868\u9879\u76ee\uff1f", (String)"FAFReportItemListPlugin_4", (String)"macc-faf-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("confirmClearOldReportItem", (IFormPlugin)this));
                    if (beforeClickEvent != null) {
                        beforeClickEvent.setCancel(true);
                    } else if (hyperLinkClickArgs != null) {
                        hyperLinkClickArgs.setCancel(true);
                    }
                }
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String actionId = messageBoxClosedEvent.getCallBackId();
        MessageBoxResult messageBoxResult = messageBoxClosedEvent.getResult();
        if ("confirmClearOldReportItem".equals(actionId) && MessageBoxResult.Yes == messageBoxResult) {
            this.getView().invokeOperation("returndata");
        }
    }
}

