/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.report;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.NumberFormatProvider;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.FilterObject;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.license.api.LicenseCheckResult;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.report.IReportView;
import kd.bos.report.ReportList;
import kd.bos.report.filter.ReportFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.faf.FAFAbstactModelReport;
import kd.macc.faf.FAFReportDynFieldClass;
import kd.macc.faf.common.OpLogProxy;
import kd.macc.faf.datareview.FAFCustomReportFilter;
import kd.macc.faf.datareview.FAFDataReview2Plugin;
import kd.macc.faf.enums.DimensionNecessityEnum;
import kd.macc.faf.enums.DimensionTypeEnum;
import kd.macc.faf.formplugin.utils.PluginExceptionHelper;
import kd.macc.faf.helper.FAFMeasureHelper;
import kd.macc.faf.helper.ReportPublishDataHelper;
import kd.macc.faf.util.AnalysisModelUtil;
import kd.macc.faf.util.CalculateUtils;
import kd.macc.faf.util.LicenseUtil;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class FAFReportShowFormPlugin
extends FAFAbstactModelReport
implements BeforeF7SelectListener,
HyperLinkClickListener {
    String[] excludeFormatField = new String[]{"fseq", "report_item"};
    private static final Log logger = LogFactory.getLog(FAFReportShowFormPlugin.class);

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.buildPeriod(DimensionTypeEnum.DATABASE);
    }

    public FAFReportShowFormPlugin() {
        super("report", "org", null, "period", "daterange");
        this.setOrgNeedAuthority(false);
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        Collection collection;
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        if ("org".equals(name) && newValue instanceof Collection && (collection = (Collection)newValue).size() > 20) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8fc7\u6ee4\u6761\u4ef6\u4e2d\uff0c\u6700\u591a\u9009\u53d620\u4e2a\u7ec4\u7ec7\u3002", (String)"FAFReportShowFormPlugin_0", (String)"macc-faf-formplugin", (Object[])new Object[0]));
        }
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        IReportView view = this.getView();
        BasedataEdit analysisModel = (BasedataEdit)view.getControl("report");
        analysisModel.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        ReportList reportList = (ReportList)view.getControl("reportlistap");
        reportList.addHyperClickListener((HyperLinkClickListener)this);
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent evt) {
        super.beforeF7Select(evt);
        String fieldKey = evt.getProperty().getName();
        if ("report".equals(fieldKey)) {
            this.addRoleAndUserPermission(evt);
        }
    }

    @Override
    public Long getModelPkID() {
        DynamicObject report = (DynamicObject)this.getModel().getValue("report");
        if (report == null) {
            return null;
        }
        DynamicObject analysisModel = report.getDynamicObject("analysis_model");
        if (analysisModel == null) {
            return null;
        }
        return (Long)analysisModel.getPkValue();
    }

    @Override
    public Long getSystemId() {
        DynamicObject analysisModel;
        Long modelPkID = this.getModelPkID();
        if (modelPkID != null && (analysisModel = BusinessDataServiceHelper.loadSingleFromCache((Object)modelPkID, (String)"pa_analysismodel")) != null) {
            return analysisModel.getLong("analysis_system_id");
        }
        return null;
    }

    @Override
    public ReportFilter getPaCustomReportFilter(ReportFilter control) {
        return new FAFCustomReportFilter(this, control, dynamicObject -> {
            if (dynamicObject == null) {
                return null;
            }
            return dynamicObject.getDynamicObject("analysis_model");
        });
    }

    @Override
    public void beforeSelectPeriodOrOrgOrAccount(String fieldKey, Map<String, QFilter[]> map, BeforeF7SelectEvent evt) {
        DynamicObject report = (DynamicObject)this.getModel().getValue("report");
        if (report == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u62a5\u8868\u3002", (String)"FAFReportShowFormPlugin_1", (String)"macc-faf-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
        } else {
            BasedataEdit basedataEdit = (BasedataEdit)evt.getSource();
            String name = basedataEdit.getKey();
            QFilter[] qFilters = map.get(name);
            if (qFilters != null) {
                ListFilterParameter listFilterParameter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
                for (QFilter qFilter : qFilters) {
                    listFilterParameter.setFilter(qFilter);
                }
            }
        }
    }

    @Override
    protected String getModelTableNumber() {
        return this.getPageCache().get("tablenumber");
    }

    private void addRoleAndUserPermission(BeforeF7SelectEvent beforeF7SelectEvent) {
        ListShowParameter param = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        param.getListFilterParameter().setFilter(ReportPublishDataHelper.getPermQFilterByUserId((Long)RequestContext.get().getCurrUserId()));
    }

    @Override
    public boolean verifyQuery(ReportQueryParam queryParam) {
        IDataModel model = this.getModel();
        IReportView view = this.getView();
        try {
            FilterGrid.FilterGridState filterGridState;
            FilterCondition fc;
            List filterRow;
            FilterGrid filterGrid;
            FAFReportDynFieldClass.AbstractPeriod<?> abstractPeriod;
            Object value;
            ArrayList<QFilter> filterList = new ArrayList<QFilter>(3);
            DynamicObject report = (DynamicObject)model.getValue("report");
            DynamicObjectCollection orgDynamic = (DynamicObjectCollection)model.getValue("org");
            ArrayList<String> nullFilter = new ArrayList<String>(3);
            if (report == null) {
                List<String> valid = Collections.singletonList("report");
                String collect = valid.stream().map(s -> String.format("\"%s\"", ((FieldEdit)this.getControl((String)s)).getDisplayName().getLocaleValue())).collect(Collectors.joining("\u3001"));
                nullFilter.add(collect);
            }
            if ((value = (abstractPeriod = this.getCurrentDimensionType()).getValue()) == null && abstractPeriod.isMustInput()) {
                nullFilter.add("\"" + abstractPeriod.getControlName() + "\"");
            }
            if (!CollectionUtils.isEmpty(nullFilter)) {
                view.showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199%s\u3002", (String)"FAFReportShowFormPlugin_3", (String)"macc-faf-formplugin", (Object[])new Object[0]), StringUtils.join(nullFilter, (String)"\u3001")));
                return false;
            }
            if (report == null || value == null) {
                return false;
            }
            if (!super.verifyQuery(queryParam)) {
                return false;
            }
            Long analysisModelObj_id = report.getLong("analysis_model_id");
            DynamicObject analysisModelObj = BusinessDataServiceHelper.loadSingleFromCache((Object)analysisModelObj_id, (String)"pa_analysismodel");
            queryParam.setSortInfo(report.get("id").toString());
            String periodNumber = analysisModelObj.getDynamicObjectCollection("dimension_entry").stream().filter(p -> DimensionNecessityEnum.PERIOD.getCode().equals(p.getString("necessity_dim"))).map(p -> p.getDynamicObject("dimension").getString("number")).findFirst().orElse(null);
            filterList.add(abstractPeriod.getQFilter(periodNumber));
            String orgNumber = analysisModelObj.getDynamicObjectCollection("dimension_entry").stream().filter(p -> DimensionNecessityEnum.ORG.getCode().equals(p.getString("necessity_dim"))).map(p -> p.getDynamicObject("dimension").getString("number")).findFirst().orElse(null);
            if (!CollectionUtils.isEmpty((Collection)orgDynamic)) {
                if (orgDynamic.size() > 20) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u8fc7\u6ee4\u6761\u4ef6\u4e2d\uff0c\u6700\u591a\u9009\u53d620\u4e2a\u7ec4\u7ec7\u3002", (String)"FAFReportShowFormPlugin_0", (String)"macc-faf-formplugin", (Object[])new Object[0]));
                    return false;
                }
                filterList.add(new QFilter(orgNumber, "in", orgDynamic.stream().map(p -> p.getDynamicObject("fbasedataid").getPkValue()).collect(Collectors.toSet())));
            }
            if ((filterGrid = (FilterGrid)this.getControl("filtergridap")) != null && (filterRow = (fc = (filterGridState = filterGrid.getFilterGridState()).getFilterCondition()).getFilterRow()) != null && !filterRow.isEmpty()) {
                String entityName = AnalysisModelUtil.buildDetailEntityNumber((String)analysisModelObj.getString("tablenumber"));
                MainEntityType dataType = EntityMetadataCache.getDataEntityType((String)entityName);
                FilterBuilder filterBuilder = new FilterBuilder(dataType, fc, model);
                filterBuilder.buildFilter(false);
                FilterObject fo = filterBuilder.getFilterObject();
                fc.setFilter(fo.getFilter());
                filterList.add(filterBuilder.getQFilter());
            }
            FilterInfo filterInfo = queryParam.getFilter();
            filterInfo.setQFilters(filterList);
            queryParam.setFilter(filterInfo);
            StringBuilder sb = new StringBuilder();
            sb.append(new LocaleString(ResManager.loadKDString((String)"\u62a5\u8868", (String)"FAFReportShowFormPlugin_5", (String)"macc-faf-formplugin", (Object[])new Object[0])).toString()).append("\uff1a").append(((DynamicObject)model.getValue("report")).getString("name")).append("\uff1b  ");
            sb.append(abstractPeriod.getControlName()).append("\uff1a").append(abstractPeriod.getQFilterShowMessage()).append("\uff1b  ");
            String zz = orgDynamic.stream().map(p -> (DynamicObject)p.get("fbasedataid")).map(p -> p.getString("name")).collect(Collectors.joining("\uff0c"));
            if (StringUtils.isNotEmpty((CharSequence)zz)) {
                sb.append(new LocaleString(ResManager.loadKDString((String)"\u7ec4\u7ec7", (String)"FAFReportShowFormPlugin_7", (String)"macc-faf-formplugin", (Object[])new Object[0])).toString()).append("\uff1a").append(zz).append("\uff1b  ");
            }
            String msg = sb.toString();
            IClientViewProxy clientViewProxy = (IClientViewProxy)view.getService(IClientViewProxy.class);
            this.getPageCache().put("searchCondition", msg);
            clientViewProxy.preInvokeControlMethod("reportfilterap", "updateSearchCondition", new Object[]{msg});
            this.saveOperLog("query", new MultiLangEnumBridge("\u67e5\u8be2", "FAFReportShowFormPlugin_8", "macc-faf-formplugin"));
            return true;
        }
        catch (Exception e) {
            PluginExceptionHelper.throwKDBizException(e);
            return false;
        }
    }

    public void preProcessExportData(List<AbstractReportColumn> exportColumns, DynamicObjectCollection data, NumberFormatProvider numberFormatProvider) {
        try {
            this.saveOperLog("export", new MultiLangEnumBridge("\u5bfc\u51fa", "FAFReportShowFormPlugin_9", "macc-faf-formplugin"));
        }
        catch (Exception e) {
            PluginExceptionHelper.throwKDBizException(e);
        }
    }

    private void saveOperLog(String opKey, MultiLangEnumBridge opNameBridge) {
        IDataModel model = this.getModel();
        FAFReportDynFieldClass.AbstractPeriod<?> abstractPeriod = this.getCurrentDimensionType();
        DynamicObjectCollection orgDynamic = (DynamicObjectCollection)model.getValue("org");
        String zznumber = orgDynamic.stream().map(p -> (DynamicObject)p.get("fbasedataid")).map(p -> p.getString("number")).collect(Collectors.joining("\uff0c"));
        MultiLangEnumBridge opDescBridge = null;
        String[] opDescArgs = null;
        if (StringUtils.isEmpty((CharSequence)zznumber)) {
            opDescBridge = new MultiLangEnumBridge("\u62a5\u8868\uff1a%1$s\uff0c\u671f\u95f4\uff1a%2$s", "FAFReportShowFormPlugin_11", "macc-faf-formplugin");
            opDescArgs = new String[]{((DynamicObject)model.getValue("report")).getString("number"), abstractPeriod.getQFilterShowMessage()};
        } else {
            opDescBridge = new MultiLangEnumBridge("\u62a5\u8868\uff1a%1$s\uff0c\u671f\u95f4\uff1a%2$s\uff0c\u7ec4\u7ec7\uff1a%3$s", "FAFReportShowFormPlugin_12", "macc-faf-formplugin");
            opDescArgs = new String[]{((DynamicObject)model.getValue("report")).getString("number"), abstractPeriod.getQFilterShowMessage(), zznumber};
        }
        OpLogProxy.create((String)this.getView().getEntityId()).setOpName(opKey, opNameBridge).setOpDesc(opDescBridge, opDescArgs).saveLog();
    }

    public void packageData(PackageDataEvent e) {
        if (ReportColumn.class.isAssignableFrom(e.getSource().getClass())) {
            DynamicObject report = (DynamicObject)this.getModel().getValue("report");
            DynamicObject analysisModel = report.getDynamicObject("analysis_model");
            Map collect = new HashMap(0);
            String showorder = "";
            try {
                DynamicObject loadReport = BusinessDataServiceHelper.loadSingle((Object)report.get("id"), (String)"pa_reportdefinition");
                DynamicObjectCollection measureEntry = loadReport.getDynamicObjectCollection("measureentry");
                if (measureEntry != null && !measureEntry.isEmpty()) {
                    showorder = ((DynamicObject)measureEntry.get(0)).getString("showorder");
                    DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((Object)analysisModel.get("id"), (String)"pa_analysismodel");
                    List measureNumberList = dynamicObject.getDynamicObjectCollection("measure_entry").stream().map(x -> x.getDynamicObject("measure").getString("number")).collect(Collectors.toList());
                    collect = FAFMeasureHelper.getMeasureScaleMap((Long)dynamicObject.getLong("analysis_system_id"), measureNumberList);
                }
            }
            catch (Exception ex) {
                logger.error("FAFReportShowFormPlugin precision analysis error", (Throwable)ex);
                throw new KDBizException(ResManager.loadKDString((String)"\u6a21\u578b\u89e3\u6790\u81ea\u5b9a\u4e49\u7cbe\u5ea6\u5931\u8d25\u3002", (String)"FAFReportShowFormPlugin_10", (String)"macc-faf-formplugin", (Object[])new Object[0]));
            }
            String key = ((ReportColumn)e.getSource()).getFieldKey();
            String value = e.getRowData().getString(key);
            if (StringUtils.isNotEmpty((CharSequence)value) && !ArrayUtils.contains((Object[])this.excludeFormatField, (Object)key)) {
                String[] keySplit = key.split("!,!");
                String measureField = "0".equals(showorder) ? keySplit[0] : keySplit[keySplit.length - 1];
                int precision = collect.get(measureField) != null ? (Integer)collect.get(measureField) : 2;
                StringBuilder precisionFormat = new StringBuilder("#,##0");
                for (int i = 0; i < precision; ++i) {
                    if (i == 0) {
                        precisionFormat.append(".");
                    }
                    precisionFormat.append("0");
                }
                BigDecimal bigDecimal = new BigDecimal(value);
                bigDecimal = bigDecimal.setScale(precision, RoundingMode.HALF_UP);
                DecimalFormat decimalFormat = new DecimalFormat(precisionFormat.toString());
                e.setFormatValue((Object)decimalFormat.format(bigDecimal));
            }
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        String hyperLinkFieldName = hyperLinkClickEvent.getFieldName();
        DataEntityPropertyCollection properties = hyperLinkClickEvent.getRowData().getDynamicObjectType().getProperties();
        String fieldName = null;
        for (IDataEntityProperty property : properties) {
            String afterReplaceFieldName = property.getName().replaceAll("\\.", "_");
            if (!afterReplaceFieldName.equals(hyperLinkFieldName)) continue;
            fieldName = property.getName();
            break;
        }
        logger.info(String.format("FAFReportShowFormPlugin hyperLinkClick fieldName : %s", fieldName));
        if (fieldName == null) {
            return;
        }
        try {
            IDataModel model = this.getModel();
            DynamicObject reportDefinition = BusinessDataServiceHelper.loadSingle((Object)model.getValue("report_id"), (String)"pa_reportdefinition");
            if (reportDefinition != null) {
                DynamicObjectCollection rowReportItemEntry = reportDefinition.getDynamicObjectCollection("rowentry");
                DynamicObjectCollection columnDimEntry = reportDefinition.getDynamicObjectCollection("columnentry");
                DynamicObjectCollection measureEntry = reportDefinition.getDynamicObjectCollection("measureentry");
                if (rowReportItemEntry == null || rowReportItemEntry.isEmpty() || columnDimEntry == null || columnDimEntry.isEmpty() || measureEntry == null || measureEntry.isEmpty()) {
                    return;
                }
                boolean measureAfterDim = true;
                String showOrder = ((DynamicObject)measureEntry.get(0)).getString("showorder");
                if ("0".equals(showOrder)) {
                    measureAfterDim = false;
                }
                Long modelId = this.getModelPkID();
                Long systemId = this.getSystemId();
                Object period = this.getCurrentDimensionType().getValue();
                Set<Object> orgSet = null;
                DynamicObjectCollection orgDynamic = (DynamicObjectCollection)model.getValue("org");
                if (orgDynamic != null && !orgDynamic.isEmpty()) {
                    orgSet = orgDynamic.stream().map(p -> p.getDynamicObject("fbasedataid").getPkValue()).collect(Collectors.toSet());
                }
                List account = null;
                LinkedHashMap<String, Tuple<DimensionTypeEnum, List<Object>>> filterGridColumn = new LinkedHashMap<String, Tuple<DimensionTypeEnum, List<Object>>>(1);
                DynamicObject analysisModel = BusinessDataServiceHelper.loadSingle((Object)modelId, (String)"pa_analysismodel");
                DynamicObjectCollection dimensionEntry = analysisModel.getDynamicObjectCollection("dimension_entry");
                String orgField = null;
                String periodField = null;
                String accountField = null;
                if (dimensionEntry != null) {
                    for (DynamicObject dimensionRow : dimensionEntry) {
                        String necessityDim = dimensionRow.getString("necessity_dim");
                        DynamicObject dimension = dimensionRow.getDynamicObject("dimension");
                        if (DimensionNecessityEnum.ORG.getCode().equals(necessityDim)) {
                            orgField = dimension.getString("number");
                            continue;
                        }
                        if (DimensionNecessityEnum.PERIOD.getCode().equals(necessityDim)) {
                            periodField = dimension.getString("number");
                            continue;
                        }
                        if (!DimensionNecessityEnum.ACCOUNT.getCode().equals(necessityDim)) continue;
                        accountField = dimension.getString("number");
                    }
                }
                int rowIndex = hyperLinkClickEvent.getRowIndex() - 1;
                Long reportItemId = ((DynamicObject)rowReportItemEntry.get(rowIndex)).getLong("reportitem_id");
                DynamicObject reportItem = BusinessDataServiceHelper.loadSingle((Object)reportItemId, (String)"pa_reportitem");
                String computeType = reportItem.getString("comptype");
                String formula = reportItem.getString("formulacom_tag");
                if ("0".equals(computeType) && StringUtils.isNotEmpty((CharSequence)formula)) {
                    Long dimensionId = reportItem.getDynamicObject("group").getLong("dimension_id");
                    DynamicObject reportDim = BusinessDataServiceHelper.loadSingle((Object)dimensionId, (String)"pa_dimension");
                    Iterator dimType = DimensionTypeEnum.getEnum((String)reportDim.getString("dimensiontype"));
                    String rowDimKey = reportDim.getString("number");
                    Set dimMemberSet = CalculateUtils.getElementFromFormula((String)formula);
                    HashSet<String> restoreDimMemberSet = new HashSet<String>(dimMemberSet.size());
                    for (String memberCode : dimMemberSet) {
                        restoreDimMemberSet.add(CalculateUtils.restoreFormulaItem((String)memberCode, (boolean)false));
                    }
                    logger.info(String.format("FAFReportShowFormPlugin dimMemberSet : %s, restoreDimMemberSet : %s", JSON.toJSONString((Object)dimMemberSet), JSON.toJSONString(restoreDimMemberSet)));
                    if (rowDimKey.equals(accountField)) {
                        QFilter qFilter = new QFilter("number", "in", restoreDimMemberSet);
                        String entityNumber = "";
                        if (DimensionTypeEnum.DATABASE == dimType) {
                            entityNumber = reportDim.getDynamicObject("dimensionsource").getString("number");
                            String typeField = reportDim.getString("typefield");
                            Object groupId = reportDim.get("group_id");
                            if (StringUtils.isNotEmpty((CharSequence)typeField)) {
                                qFilter.and(typeField, "=", groupId);
                            }
                        } else if (DimensionTypeEnum.ASSISTANTDATA == dimType) {
                            entityNumber = "bos_assistantdata_detail";
                            Object groupId = reportDim.get("assistantsource_id");
                            qFilter.and("group", "=", groupId);
                        }
                        account = QueryServiceHelper.queryPrimaryKeys((String)entityNumber, (QFilter[])qFilter.toArray(), null, (int)-1);
                    } else if (!rowDimKey.equals(orgField) && !rowDimKey.equals(periodField)) {
                        filterGridColumn.put(rowDimKey, (Tuple<DimensionTypeEnum, List<Object>>)Tuple.create((Object)dimType, new ArrayList(restoreDimMemberSet)));
                    }
                }
                String[] memberValueAndMeasure = fieldName.split("!,!");
                int memberValueIndex = measureAfterDim ? 0 : 1;
                for (DynamicObject dimColumn : columnDimEntry) {
                    DynamicObject dimension = dimColumn.getDynamicObject("dimension");
                    String dimNumber = dimension.getString("number");
                    boolean isNecessityDimension = dimNumber.equals(orgField) || dimNumber.equals(periodField) || dimNumber.equals(accountField);
                    DimensionTypeEnum dimensionType = DimensionTypeEnum.getEnum((String)dimension.getString("dimensiontype"));
                    String memberNumber = dimColumn.getString("membernumber");
                    String memberName = dimColumn.getString("membernameencode");
                    if (StringUtils.isEmpty((CharSequence)memberName)) {
                        memberName = dimColumn.getString("membername");
                    }
                    String memberId = dimColumn.getString("memberid");
                    boolean dimFieldExist = false;
                    if (!dimNumber.equals(orgField) && !dimNumber.equals(periodField) && (DimensionTypeEnum.DATABASE == dimensionType || DimensionTypeEnum.ASSISTANTDATA == dimensionType) || dimensionType == DimensionTypeEnum.OTHER && StringUtils.isNotEmpty((CharSequence)memberName) && StringUtils.isEmpty((CharSequence)memberId) && StringUtils.isEmpty((CharSequence)memberNumber) || dimensionType == DimensionTypeEnum.DENUMS && StringUtils.isNotEmpty((CharSequence)memberName) && StringUtils.isNotEmpty((CharSequence)memberNumber)) {
                        dimFieldExist = true;
                    } else if (isNecessityDimension && StringUtils.isEmpty((CharSequence)memberName) && StringUtils.isEmpty((CharSequence)memberId) && StringUtils.isEmpty((CharSequence)memberNumber)) {
                        if (dimNumber.equals(orgField) && orgSet != null) {
                            dimFieldExist = true;
                        } else if (dimNumber.equals(periodField)) {
                            if (DimensionTypeEnum.DATABASE == dimensionType || DimensionTypeEnum.ASSISTANTDATA == dimensionType || DimensionTypeEnum.PERIOD == dimensionType) {
                                Object fieldObject = model.getValue("period");
                                if (fieldObject instanceof DynamicObjectCollection || fieldObject instanceof DynamicObject) {
                                    dimFieldExist = true;
                                }
                            } else if (DimensionTypeEnum.DATE == dimensionType) {
                                dimFieldExist = true;
                            }
                        }
                    }
                    if (!dimFieldExist) continue;
                    if (!dimNumber.equals(orgField) && !dimNumber.equals(periodField)) {
                        String convertedMemberCode = memberValueAndMeasure[memberValueIndex];
                        String restoreMemberCode = CalculateUtils.restoreFormulaItem((String)convertedMemberCode, (boolean)false);
                        logger.info(String.format("FAFReportShowFormPlugin convertedMemberCode : %s, restoreMemberCode : %s", convertedMemberCode, restoreMemberCode));
                        if (dimNumber.equals(accountField)) {
                            QFilter qFilter = new QFilter("number", "=", (Object)restoreMemberCode);
                            String entityNumber = "";
                            if (DimensionTypeEnum.DATABASE == dimensionType) {
                                entityNumber = dimension.getDynamicObject("dimensionsource").getString("number");
                                String typeField = dimension.getString("typefield");
                                Object groupId = dimension.get("group_id");
                                if (StringUtils.isNotEmpty((CharSequence)typeField)) {
                                    qFilter.and(typeField, "=", groupId);
                                }
                            } else if (DimensionTypeEnum.ASSISTANTDATA == dimensionType) {
                                entityNumber = "bos_assistantdata_detail";
                                Object groupId = dimension.get("assistantsource_id");
                                qFilter.and("group", "=", groupId);
                            }
                            account = QueryServiceHelper.queryPrimaryKeys((String)entityNumber, (QFilter[])qFilter.toArray(), null, (int)1);
                        } else {
                            filterGridColumn.put(dimNumber, (Tuple<DimensionTypeEnum, List<Object>>)Tuple.create((Object)dimensionType, Collections.singletonList(restoreMemberCode)));
                        }
                    }
                    ++memberValueIndex;
                }
                FilterGrid filterGrid = (FilterGrid)this.getControl("filtergridap");
                FilterCondition filterCondition = filterGrid.getFilterGridState().getFilterCondition();
                String originFilterJson = SerializationUtils.toJsonString((Object)filterCondition);
                FAFDataReview2Plugin.openF7FromHyperlink((AbstractFormPlugin)this, systemId, modelId, period, orgSet, account, originFilterJson, filterGridColumn);
            }
        }
        catch (Exception ex) {
            logger.error("FAFReportShowFormPlugin hyperLinkClick error", (Throwable)ex);
        }
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        String formId;
        String bizAppId = ShowFormHelper.getBizAppId((FormShowParameter)e.getFormShowParameter());
        LicenseCheckResult checkResult = LicenseUtil.Check(bizAppId, formId = e.getFormShowParameter().getFormId());
        boolean hasLicense = checkResult.getHasLicense();
        e.setCancel(!hasLicense);
        e.setCancelMessage(checkResult.getMsg());
        e.setCancelFormShowParameter(checkResult.getCancelFormShowParameter());
    }
}

