/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.report;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.util.Tuple2;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.CellStyle;
import kd.bos.entity.report.ColumnStyle;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.faf.enums.DimensionNecessityEnum;
import kd.macc.faf.enums.DimensionTypeEnum;
import kd.macc.faf.report.FAFMemberCodeUtils;
import kd.macc.faf.util.AnalysisModelUtil;
import kd.macc.faf.util.CalculateUtils;
import kd.macc.faf.util.DimensionDyUtil;
import kd.macc.faf.util.IDataDateUtil;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class FAFReportShowListPlugin
extends AbstractReportListDataPlugin {
    private static final Log logger = LogFactory.getLog(FAFReportShowListPlugin.class);
    List<CustomField> metaNames = null;

    public DataSet query(ReportQueryParam reportQueryParam, Object o) throws Throwable {
        Serializable filterDimensionNumberList;
        FilterInfo filter = reportQueryParam.getFilter();
        List paramFilters = filter.getQFilters();
        Long reportId = Long.parseLong(reportQueryParam.getSortInfo());
        ReportBuilder reportBuilder = new ReportBuilder(reportId, filter);
        Object[] qFilters = reportBuilder.getqFilters();
        qFilters = (QFilter[])ArrayUtils.addAll((Object[])qFilters, (Object[])paramFilters.toArray(new QFilter[0]));
        String tableNumber = reportBuilder.getTableNumber();
        String selectSql = reportBuilder.getSelectSql();
        List<String> groupFieldList = reportBuilder.getGroupByField();
        List<Dimension> dimensionList = reportBuilder.getDimensionList();
        List<Measure> measureList = reportBuilder.measureList;
        String itemRefDimensionField = reportBuilder.itemRefDimension;
        HashMap<ColOutputMeta, HashMap> filterDimensionCalculate = new HashMap<ColOutputMeta, HashMap>(16);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"PAReportShowListPlugin.query", (String)AnalysisModelUtil.buildEntityNumber((String)tableNumber), (String)selectSql, (QFilter[])qFilters, null);){
            GroupbyDataSet groupbyDataSet = dataSet.groupBy(groupFieldList.toArray(new String[0]));
            for (CustomField customField : reportBuilder.getMeasureList()) {
                groupbyDataSet = groupbyDataSet.sum(customField.number);
            }
            DataSet finish = groupbyDataSet.finish();
            while (finish.hasNext()) {
                Row row = finish.next();
                String itemRefDimension = row.getString(itemRefDimensionField);
                if (itemRefDimension == null) continue;
                ArrayList<String> filterDimensionIdList = new ArrayList<String>(16);
                filterDimensionNumberList = new ArrayList<String>(16);
                ArrayList<String> filterDimensionNameList = new ArrayList<String>(16);
                String itemRef = CalculateUtils.formulaItemFormat((String)itemRefDimension);
                for (Dimension dimension : dimensionList) {
                    String filterDimNumber = "";
                    String filterDimId = "";
                    String filterDimName = "";
                    if (dimension.dimensiontype == DimensionTypeEnum.OTHER) {
                        filterDimId = filterDimNumber = row.getString(dimension.number);
                        filterDimName = filterDimNumber;
                    } else if (dimension.dimensiontype == DimensionTypeEnum.DENUMS) {
                        filterDimId = filterDimNumber = row.getString(dimension.number);
                        filterDimName = row.getString(dimension.number);
                    } else if (dimension.dimensiontype == DimensionTypeEnum.DATE) {
                        filterDimNumber = dimension.number;
                        filterDimId = dimension.number;
                        filterDimName = dimension.name;
                    } else if (dimension.dimensiontype == DimensionTypeEnum.DATABASE || dimension.dimensiontype == DimensionTypeEnum.ASSISTANTDATA) {
                        filterDimId = String.valueOf(row.getLong(dimension.number + "_id"));
                        filterDimNumber = row.getString(dimension.number + "_number");
                        if (filterDimNumber == null) {
                            filterDimNumber = filterDimId;
                        }
                        if ((filterDimName = row.getString(dimension.number + "_name")) == null) {
                            filterDimName = filterDimNumber;
                        }
                    }
                    filterDimensionIdList.add(String.valueOf(filterDimId));
                    filterDimensionNumberList.add(filterDimNumber);
                    filterDimensionNameList.add(filterDimName);
                }
                String filterDimensionIds = StringUtils.join(filterDimensionIdList, (String)"!,!");
                String filterDimensionNumbers = StringUtils.join(filterDimensionNumberList, (String)"!,!");
                String filterDimensionNames = StringUtils.join(filterDimensionNameList, (String)"!,!");
                ColOutputMeta colOutputMeta = new ColOutputMeta(filterDimensionIds, filterDimensionNames, filterDimensionNumbers);
                BigDecimal[] measureValue = new BigDecimal[measureList.size()];
                for (int i = 0; i < measureList.size(); ++i) {
                    measureValue[i] = row.getBigDecimal(measureList.get((int)i).number);
                }
                HashMap<String, BigDecimal[]> objectObjectHashMap = new HashMap<String, BigDecimal[]>();
                objectObjectHashMap.put(itemRef, measureValue);
                filterDimensionCalculate.merge(colOutputMeta, objectObjectHashMap, (oldValue, newValue) -> {
                    oldValue.put(itemRef, measureValue);
                    return oldValue;
                });
            }
        }
        if (filterDimensionCalculate.isEmpty()) {
            return this.emptyDataSet();
        }
        List<ReportItem> reportItemList = reportBuilder.getReportItemList();
        Map<String, ReportItem> itemMap = reportItemList.stream().collect(Collectors.toMap(k -> k.formatNumber, v -> v));
        ArrayList<ReportItem> dimensionReportItemList = new ArrayList<ReportItem>(16);
        ArrayList<ReportItem> programReportItemList = new ArrayList<ReportItem>(16);
        for (ReportItem reportItem : reportItemList) {
            if ("0".equals(reportItem.comptype)) {
                dimensionReportItemList.add(reportItem);
                continue;
            }
            if (!"1".equals(reportItem.comptype)) continue;
            programReportItemList.add(reportItem);
        }
        if (dimensionReportItemList.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u62a5\u8868\u884c\u7ef4\u81f3\u5c11\u6dfb\u52a0\u4e00\u9879\u4ee5\u201c\u6309\u7ef4\u5ea6\u8ba1\u7b97\u201d\u7684\u62a5\u8868\u9879\u76ee\uff0c\u5426\u5219\u65e0\u6cd5\u8ba1\u7b97", (String)"FAFReportShowListPlugin_0", (String)"macc-faf-formplugin", (Object[])new Object[0]));
        }
        if (programReportItemList.size() > 0) {
            Set set = programReportItemList.stream().map(p -> p.number).collect(Collectors.toSet());
            QFilter qf = new QFilter("number", "not in", set).and(new QFilter("comptype", "=", (Object)"1")).and(new QFilter("group", "=", reportBuilder.group.getPkValue()));
            DataSet dataSet = QueryServiceHelper.queryDataSet((String)"queryItem", (String)"pa_reportitem", (String)"name,number,comptype, formulacom_tag", (QFilter[])qf.toArray(), null);
            filterDimensionNumberList = null;
            try {
                while (dataSet.hasNext()) {
                    Row next = dataSet.next();
                    programReportItemList.add(new ReportItem(next.getString("name"), next.getString("number"), next.getString("formulacom_tag"), next.getString("comptype")));
                }
            }
            catch (Throwable next) {
                filterDimensionNumberList = next;
                throw next;
            }
            finally {
                if (dataSet != null) {
                    if (filterDimensionNumberList != null) {
                        try {
                            dataSet.close();
                        }
                        catch (Throwable next) {
                            ((Throwable)filterDimensionNumberList).addSuppressed(next);
                        }
                    } else {
                        dataSet.close();
                    }
                }
            }
        }
        Map<String, String> map = dimensionReportItemList.stream().collect(Collectors.toMap(k -> k.formatNumber, v -> v.formula));
        Map<String, String> programReportItemMap = programReportItemList.stream().collect(Collectors.toMap(k -> k.formatNumber, v -> v.formula));
        filterDimensionCalculate.forEach((k, v) -> {
            List<Tuple2<String, List<BigDecimal>>> calculateValue = this.getCalculateValue(dimensionReportItemMap, (HashMap<String, BigDecimal[]>)v, measureList.size());
            for (Tuple2<String, List<BigDecimal>> stringListTuple : calculateValue) {
                String t1 = (String)stringListTuple.t1;
                ReportItem reportItem = (ReportItem)itemMap.get(t1);
                if (stringListTuple.t2 == null) {
                    logger.error(String.format("\u62a5\u8868\u9879\u76ee%s\u5728\u5217\u7ef4\u4e3a%s\u65f6\u627e\u4e0d\u5230\u76f8\u5e94\u7684\u503c\u4f9b\u5176\u8ba1\u7b97", reportItem.name, k.name));
                    continue;
                }
                reportItem.setValue((ColOutputMeta)k, ((List)stringListTuple.t2).toArray(new BigDecimal[0]));
            }
            if (programReportItemList.size() > 0) {
                HashMap depend1Value = dimensionReportItemList.stream().filter(p -> !p.value.isEmpty()).filter(p -> p.value.get(k) != null).collect(Collectors.toMap(ks -> ks.formatNumber, vs -> vs.value.get(k), (m1, m2) -> m2, HashMap::new));
                CalculateUtils bigDecimalCalculateUtils = new CalculateUtils((Map)depend1Value, measureList.size());
                bigDecimalCalculateUtils.setIfNullFunction(number -> BigDecimal.ZERO);
                Map independentFormula = bigDecimalCalculateUtils.depend2Independent(programReportItemMap);
                List<Tuple2<String, List<BigDecimal>>> itemCalculateValue = this.getCalculateValue(independentFormula, depend1Value, measureList.size());
                for (Tuple2<String, List<BigDecimal>> stringListTuple : itemCalculateValue) {
                    String t1 = (String)stringListTuple.t1;
                    ReportItem reportItem = (ReportItem)itemMap.get(t1);
                    if (reportItem == null) continue;
                    if (stringListTuple.t2 == null) {
                        logger.error(String.format("\u62a5\u8868\u9879%s\u5728\u5217\u7ef4\u4e3a%s\u65f6\u627e\u4e0d\u5230\u76f8\u5e94\u7684\u503c\u4f9b\u5176\u8ba1\u7b97", reportItem.name, k.name));
                        continue;
                    }
                    reportItem.setValue((ColOutputMeta)k, ((List)stringListTuple.t2).toArray(new BigDecimal[0]));
                }
            }
        });
        this.metaNames = reportBuilder.buildMetaName();
        List<Object[]> lists = reportBuilder.buildReportItemMetaValue(reportItemList, this.metaNames);
        Algo algo = Algo.create((String)((Object)((Object)this)).getClass().getName());
        Object[] fields = (Field[])this.metaNames.stream().map(p -> new Field(p.number, (DataType)DataType.BigDecimalType)).toArray(Field[]::new);
        fields = (Field[])ArrayUtils.add((Object[])fields, (Object)new Field("report_item", (DataType)DataType.StringType));
        ArrayList<Object[]> addReportNameList = new ArrayList<Object[]>(lists.size());
        for (int i = 0; i < lists.size(); ++i) {
            Object[] list = lists.get(i);
            list = ArrayUtils.add((Object[])list, (Object)reportItemList.get((int)i).name);
            addReportNameList.add(list);
        }
        logger.info(String.format("metaNames:%s", Arrays.stream(fields).map(Field::getName).collect(Collectors.joining("  "))));
        return algo.createDataSet(addReportNameList.iterator(), new RowMeta((Field[])fields));
    }

    private DataSet emptyDataSet() {
        Algo algo = Algo.create((String)((Object)((Object)this)).getClass().getName());
        return algo.createDataSetBuilder(new RowMeta(new Field[0])).build();
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) {
        ArrayList<AbstractReportColumn> list = new ArrayList<AbstractReportColumn>(16);
        if (this.metaNames != null) {
            ColLevel colLevel = ColLevel.buildLevel(this.metaNames);
            List<ColLevel> children = colLevel.getChildren();
            for (ColLevel child : children) {
                AbstractReportColumn build = this.build(child);
                columns.add(build);
            }
            list.addAll(columns);
        }
        return list;
    }

    private AbstractReportColumn build(ColLevel colLevel) {
        if (CollectionUtils.isEmpty(colLevel.getChildren())) {
            return this.addReportColumn(colLevel.getLongName(), colLevel.getName());
        }
        ReportColumnGroup reportColumnGroup1 = this.addReportColumnGroup(colLevel.getLongName(), colLevel.getName(), new AbstractReportColumn[0]);
        for (ColLevel child : colLevel.getChildren()) {
            AbstractReportColumn build = this.build(child);
            reportColumnGroup1.getChildren().add(build);
        }
        return reportColumnGroup1;
    }

    private ReportColumn addReportColumn(String columnKey, String columnCaption) {
        ReportColumn col = new ReportColumn();
        col.setFieldKey(columnKey);
        col.setCaption(new LocaleString(columnCaption));
        col.setHideSingleColumnRow(false);
        CellStyle cellStyle = new CellStyle();
        cellStyle.setTextAlign("right");
        col.setStyle((ColumnStyle)cellStyle);
        col.setFieldType("text");
        col.setHyperlink(true);
        return col;
    }

    private ReportColumnGroup addReportColumnGroup(String groupKey, String groupCaption, AbstractReportColumn ... column) {
        ReportColumnGroup group = new ReportColumnGroup();
        group.setFieldKey(groupKey);
        group.setCaption(new LocaleString(groupCaption));
        group.setHideSingleColumnRow(false);
        for (AbstractReportColumn abstractReportColumn : column) {
            group.getChildren().add(abstractReportColumn);
        }
        return group;
    }

    private List<Tuple2<String, List<BigDecimal>>> getCalculateValue(Map<String, String> reportItem0Map, HashMap<String, BigDecimal[]> v, int measureListLength) {
        ArrayList<Tuple2<String, List<BigDecimal>>> calculateValue = new ArrayList<Tuple2<String, List<BigDecimal>>>(reportItem0Map.size());
        reportItem0Map.forEach((numb, formula) -> {
            Boolean aBoolean;
            Matcher m = CalculateUtils.ELEMENT_PATTERN.matcher((CharSequence)formula);
            Map temp = this.clone(v);
            Boolean[] formulaValueExist = new Boolean[measureListLength];
            if (temp != null) {
                while (m.find()) {
                    String calcFormulaElement = m.group(1);
                    BigDecimal[] bigDecimals = (BigDecimal[])v.get(calcFormulaElement);
                    if (bigDecimals != null) {
                        for (int i = 0; i < bigDecimals.length; ++i) {
                            BigDecimal bigDecimal2 = bigDecimals[i];
                            if (bigDecimal2 == null) {
                                ((BigDecimal[])temp.get((Object)calcFormulaElement))[i] = BigDecimal.ZERO;
                                if (formulaValueExist[i] != null) continue;
                                formulaValueExist[i] = false;
                                continue;
                            }
                            formulaValueExist[i] = true;
                        }
                        continue;
                    }
                    Object[] newDecimalsArr = new BigDecimal[measureListLength];
                    Arrays.fill(newDecimalsArr, BigDecimal.ZERO);
                    temp.put(calcFormulaElement, newDecimalsArr);
                    for (int i = 0; i < formulaValueExist.length; ++i) {
                        if (formulaValueExist[i] != null) continue;
                        formulaValueExist[i] = false;
                    }
                }
            }
            CalculateUtils bigDecimalCalculateUtils = new CalculateUtils((aBoolean = Arrays.stream(formulaValueExist).map(a -> {
                if (a == null) {
                    a = false;
                }
                return a;
            }).reduce((a, b) -> a != false || b != false).orElse(false)) != false && temp != null ? temp : v, measureListLength);
            calculateValue.add(new Tuple2(numb, (Object)bigDecimalCalculateUtils.calculate(formula, bigDecimal -> bigDecimal)));
        });
        return calculateValue;
    }

    public <T extends Serializable> T clone(T obj) {
        Serializable cloneObj = null;
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ObjectOutputStream obs = new ObjectOutputStream(out);
            obs.writeObject(obj);
            obs.close();
            ByteArrayInputStream ios = new ByteArrayInputStream(out.toByteArray());
            ObjectInputStream ois = new ObjectInputStream(ios);
            cloneObj = (Serializable)ois.readObject();
            ois.close();
        }
        catch (Exception e) {
            logger.error("data copy error");
        }
        return (T)cloneObj;
    }

    public static class ColLevel {
        private final String name;
        private final String longName;
        private final String parentName;
        private final List<ColLevel> children = new ArrayList<ColLevel>(16);

        public ColLevel(String name, String parentName, String longName) {
            this.name = name;
            this.parentName = parentName;
            this.longName = longName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ColLevel colLevel = (ColLevel)o;
            return this.name.equals(colLevel.name) && this.longName.equals(colLevel.longName);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.longName);
        }

        private void buildChildren(List<ColLevel> colLevels) {
            for (ColLevel colLevel : colLevels) {
                if (colLevel.parentName.equals(this.longName)) {
                    this.children.add(colLevel);
                    continue;
                }
                for (ColLevel child : this.children) {
                    if (!colLevel.longName.startsWith(child.longName)) continue;
                    child.buildChildren(Collections.singletonList(colLevel));
                }
            }
        }

        public String getName() {
            return this.name;
        }

        public String getLongName() {
            return this.longName;
        }

        public List<ColLevel> getChildren() {
            return this.children;
        }

        public static ColLevel buildLevel(List<CustomField> fieldList) {
            ArrayList<ColLevel> list = new ArrayList<ColLevel>(16);
            for (CustomField field : fieldList) {
                ColLevel colLevel;
                int index;
                String longName = field.number;
                String localName = field.name;
                while ((index = longName.lastIndexOf("!,!")) > -1) {
                    int localNameIndex = localName.lastIndexOf("!,!");
                    String name = localName.substring(localNameIndex + 3);
                    localName = localName.substring(0, localNameIndex);
                    String levelLongName = longName;
                    ColLevel colLevel2 = new ColLevel(name, longName = longName.substring(0, index), levelLongName);
                    if (list.contains(colLevel2)) continue;
                    list.add(colLevel2);
                }
                if ("".equals(longName) || list.contains(colLevel = new ColLevel(localName, "", longName))) continue;
                list.add(colLevel);
            }
            list.sort(Comparator.comparing(a -> a.longName));
            ColLevel colLevel = new ColLevel("", "", "");
            colLevel.buildChildren(list);
            return colLevel;
        }
    }

    private static class ReportBuilder {
        QFilter[] qFilters;
        List<ReportItem> reportItemList;
        String itemRefDimension;
        String tableNumber;
        DynamicObject group;
        List<Dimension> dimensionList;
        List<Measure> measureList;
        String showOrder;
        private boolean isReBuildReportItemList = false;

        public ReportBuilder(Long reportId, FilterInfo filterInfo) {
            DynamicObject reportDynamicObject = BusinessDataServiceHelper.loadSingleFromCache((Object)reportId, (String)"pa_reportdefinition");
            Long analysis_model_id = reportDynamicObject.getLong("analysis_model_id");
            DynamicObject modelDynamicObject = BusinessDataServiceHelper.loadSingleFromCache((Object)analysis_model_id, (String)"pa_analysismodel");
            this.tableNumber = modelDynamicObject.getString("tablenumber");
            Map dimensionNecessityEnumNumberMap = DimensionDyUtil.loopDoDimensionNecessity((DynamicObject)modelDynamicObject, p -> p.getString("number"));
            DynamicObjectCollection columnEntryCol = reportDynamicObject.getDynamicObjectCollection("columnentry");
            DynamicObjectCollection rowEntryCol = reportDynamicObject.getDynamicObjectCollection("rowentry");
            DynamicObjectCollection measureEntryCol = reportDynamicObject.getDynamicObjectCollection("measureentry");
            if (measureEntryCol == null || measureEntryCol.isEmpty()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u62a5\u8868\u5b9a\u4e49\u4e2d\u7f3a\u5c11\u5ea6\u91cf\u5b9a\u4e49", (String)"FAFReportShowListPlugin_1", (String)"macc-faf-formplugin", (Object[])new Object[0]));
            }
            MulBasedataDynamicObjectCollection measure = (MulBasedataDynamicObjectCollection)((DynamicObject)measureEntryCol.get(0)).getDynamicObjectCollection("measure");
            this.showOrder = ((DynamicObject)measureEntryCol.get(0)).getString("showorder");
            if (rowEntryCol != null && !rowEntryCol.isEmpty()) {
                Object[] itemIds = rowEntryCol.stream().map(dy -> dy.getDynamicObject("reportitem").get("id")).toArray(Object[]::new);
                Map reportItemMap = BusinessDataServiceHelper.loadFromCache((Object[])itemIds, (String)"pa_reportitem");
                this.reportItemList = new ArrayList<ReportItem>(reportItemMap.size());
                for (DynamicObject reportItem : reportItemMap.values()) {
                    this.reportItemList.add(new ReportItem(reportItem.getString("name"), reportItem.getString("number"), reportItem.getString("formulacom_tag"), reportItem.getString("comptype")));
                }
            } else {
                throw new KDBizException(ResManager.loadKDString((String)"\u62a5\u8868\u5b9a\u4e49\u4e2d\u7f3a\u5c11\u884c\u7ef4\u5ea6\u5b9a\u4e49", (String)"FAFReportShowListPlugin_2", (String)"macc-faf-formplugin", (Object[])new Object[0]));
            }
            this.group = ((DynamicObject)rowEntryCol.get(0)).getDynamicObject("reportitem").getDynamicObject("group");
            Object pkValue = this.group.getPkValue();
            DynamicObject reportItemType = BusinessDataServiceHelper.loadSingleFromCache((Object)pkValue, (String)"pa_reportitemtype");
            this.itemRefDimension = reportItemType.getDynamicObject("dimension").getString("number");
            this.measureList = measure.stream().map(p -> new Measure(p.getDynamicObject("fbasedataid").get("name").toString(), p.getDynamicObject("fbasedataid").get("number").toString())).collect(Collectors.toList());
            DimensionTypeEnum dimensionTypeEnum = DimensionDyUtil.getDimensionTypeCodeFromNess((DynamicObject)modelDynamicObject, (DimensionNecessityEnum)DimensionNecessityEnum.PERIOD);
            this.dimensionList = this.buildDimension(columnEntryCol, dimensionNecessityEnumNumberMap, dimensionTypeEnum, filterInfo);
            this.dimensionList.removeIf(p -> CollectionUtils.isEmpty(p.getMemberList()));
            this.qFilters = this.buildFilter(columnEntryCol);
        }

        private List<Dimension> buildDimension(DynamicObjectCollection columnEntryCol, Map<DimensionNecessityEnum, String> dimensionNecessityEnumNumberMap, DimensionTypeEnum dimensionTypeEnum, FilterInfo filterInfo) {
            ArrayList<Dimension> dimensions = new ArrayList<Dimension>(columnEntryCol.size());
            String orgNumber = dimensionNecessityEnumNumberMap.get(DimensionNecessityEnum.ORG);
            String periodNumber = dimensionNecessityEnumNumberMap.get(DimensionNecessityEnum.PERIOD);
            for (DynamicObject columnEntry : columnEntryCol) {
                String[] nameSplit;
                String number;
                String name;
                DynamicObject dimensionObject = columnEntry.getDynamicObject("dimension");
                String dimNumber = dimensionObject.getString("number");
                String dimName = dimensionObject.getLocaleString("name").toString();
                String memberNumber = columnEntry.getString("membernumber");
                String memberName = columnEntry.getString("membernameencode");
                if (StringUtils.isEmpty((CharSequence)memberName)) {
                    memberName = columnEntry.getString("membername");
                }
                String memberId = columnEntry.getString("memberid");
                DimensionTypeEnum dimensionType = DimensionTypeEnum.getEnum((Integer)dimensionObject.getInt("dimensiontype"));
                Dimension dimension = new Dimension(dimName, dimNumber);
                ArrayList<Member> memberList = new ArrayList<Member>();
                Object[] orgAndPeriodNumberArray = new String[]{dimensionNecessityEnumNumberMap.get(DimensionNecessityEnum.ORG), dimensionNecessityEnumNumberMap.get(DimensionNecessityEnum.PERIOD)};
                boolean isNecessityDimension = ArrayUtils.contains((Object[])orgAndPeriodNumberArray, (Object)dimNumber);
                dimension.setDimensiontype(dimensionType);
                if (!(isNecessityDimension || DimensionTypeEnum.DATABASE != dimensionType && DimensionTypeEnum.ASSISTANTDATA != dimensionType)) {
                    String[] idSplit = memberId.trim().split(",");
                    String[] nameSplit2 = memberName.split(",");
                    String[] numberSplit = memberNumber.split(",");
                    if (idSplit.length != nameSplit2.length || idSplit.length != numberSplit.length) {
                        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u62a5\u8868\u5b9a\u4e49\u4e2d\u5217\u7ef4\u5ea6\uff08%s\uff09\u662f\u5426\u6709\u6210\u5458\u540d\u79f0\u6216\u7f16\u53f7\u7f3a\u5931", (String)"FAFReportShowListPlugin_3", (String)"macc-faf-formplugin", (Object[])new Object[0]), dimName));
                    }
                    for (int i = 0; i < nameSplit2.length; ++i) {
                        name = FAFMemberCodeUtils.decode(nameSplit2[i]);
                        number = FAFMemberCodeUtils.decode(numberSplit[i]);
                        memberList.add(new Member(name, number));
                    }
                } else if (dimensionType == DimensionTypeEnum.OTHER && StringUtils.isNotEmpty((CharSequence)memberName) && StringUtils.isEmpty((CharSequence)memberId) && StringUtils.isEmpty((CharSequence)memberNumber)) {
                    for (String s : nameSplit = memberName.trim().split(",")) {
                        if (!StringUtils.isNotEmpty((CharSequence)s)) continue;
                        memberList.add(new Member(s, s));
                    }
                } else if (dimensionType == DimensionTypeEnum.DENUMS && StringUtils.isNotEmpty((CharSequence)memberName) && StringUtils.isNotEmpty((CharSequence)memberNumber)) {
                    nameSplit = memberName.split(",");
                    String[] numberSplit = memberNumber.split(",");
                    if (numberSplit.length != nameSplit.length) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u62a5\u8868\u5b9a\u4e49\u5217\u7ef4\u4e2d\u679a\u4e3e\u503c\u51fa\u9519\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458", (String)"FAFReportShowListPlugin_4", (String)"macc-faf-formplugin", (Object[])new Object[0]));
                    }
                    for (int i = 0; i < nameSplit.length; ++i) {
                        if (!StringUtils.isNotEmpty((CharSequence)nameSplit[i])) continue;
                        memberList.add(new Member(nameSplit[i], numberSplit[i]));
                    }
                } else if (isNecessityDimension && StringUtils.isEmpty((CharSequence)memberName) && StringUtils.isEmpty((CharSequence)memberId) && StringUtils.isEmpty((CharSequence)memberNumber)) {
                    Object memberDynamicObject = null;
                    if (orgNumber.equals(dimNumber)) {
                        memberDynamicObject = filterInfo.getFilterItem("org").getValue();
                    } else if (periodNumber.equals(dimNumber)) {
                        if (dimensionTypeEnum == DimensionTypeEnum.DATABASE || dimensionTypeEnum == DimensionTypeEnum.ASSISTANTDATA || dimensionTypeEnum == DimensionTypeEnum.PERIOD) {
                            memberDynamicObject = filterInfo.getFilterItem("period").getValue();
                        } else if (dimensionTypeEnum == DimensionTypeEnum.DATE) {
                            Date startDate = (Date)filterInfo.getFilterItem("startdate").getValue();
                            Date endDate = (Date)filterInfo.getFilterItem("enddate").getValue();
                            if (startDate != null && endDate != null) {
                                String name2 = IDataDateUtil.dateToString((Date)startDate) + "~" + IDataDateUtil.dateToString((Date)endDate);
                                memberList.add(new Member(name2, dimNumber));
                            }
                        }
                    }
                    if (memberDynamicObject instanceof DynamicObjectCollection) {
                        for (DynamicObject dynamicObject : (DynamicObjectCollection)memberDynamicObject) {
                            long id = dynamicObject.getLong("id");
                            number = dynamicObject.getString("number");
                            String name3 = dynamicObject.getString("name");
                            if (number == null) {
                                number = String.valueOf(id);
                            }
                            if (name3 == null) {
                                name3 = number;
                            }
                            memberList.add(new Member(name3, number));
                        }
                    } else if (memberDynamicObject instanceof DynamicObject) {
                        long id = ((DynamicObject)memberDynamicObject).getLong("id");
                        String number2 = ((DynamicObject)memberDynamicObject).getString("number");
                        name = ((DynamicObject)memberDynamicObject).getString("name");
                        if (number2 == null) {
                            number2 = String.valueOf(id);
                        }
                        if (name == null) {
                            name = number2;
                        }
                        memberList.add(new Member(name, number2));
                    }
                }
                dimension.setMemberList(memberList);
                dimensions.add(dimension);
            }
            return dimensions;
        }

        private QFilter[] buildFilter(@NotNull DynamicObjectCollection columnEntryCol) {
            QFilter resultFilter = QFilter.of((String)"1=1", (Object[])new Object[0]);
            for (DynamicObject columnEntry : columnEntryCol) {
                String[] split;
                String memberId;
                DynamicObject dimension = columnEntry.getDynamicObject("dimension");
                String dimNumber = dimension.getString("number");
                String memberNumber = columnEntry.getString("membernumber");
                String memberName = columnEntry.getString("membernameencode");
                if (StringUtils.isEmpty((CharSequence)memberName)) {
                    memberName = columnEntry.getString("membername");
                }
                if (StringUtils.isNotEmpty((CharSequence)(memberId = columnEntry.getString("memberid")))) {
                    split = memberId.split(",");
                    HashSet<Long> ids = new HashSet<Long>(split.length);
                    for (String idStr : split) {
                        ids.add(Long.parseLong(idStr));
                    }
                    resultFilter.and(new QFilter(dimNumber, "in", ids));
                    continue;
                }
                if (!StringUtils.isNotEmpty((CharSequence)memberName) || !StringUtils.isEmpty((CharSequence)memberId) || !StringUtils.isEmpty((CharSequence)memberNumber)) continue;
                split = memberName.split(",");
                resultFilter.and(new QFilter(dimNumber, "in", (Object)split));
            }
            return resultFilter.toArray();
        }

        public String getSelectSql() {
            ArrayList<String> selectList = new ArrayList<String>(16);
            selectList.add(String.format("%s.number as %s", this.itemRefDimension, this.itemRefDimension));
            for (CustomField customField : this.measureList) {
                String number = customField.number;
                selectList.add(number);
            }
            Object[] onlyNumberType = new DimensionTypeEnum[]{DimensionTypeEnum.OTHER, DimensionTypeEnum.DENUMS, DimensionTypeEnum.DATE};
            for (Dimension field : this.dimensionList) {
                String number = field.number;
                if (ArrayUtils.contains((Object[])onlyNumberType, (Object)field.dimensiontype)) {
                    selectList.add(number);
                    continue;
                }
                selectList.add(String.format("%s.name as %s_name,%s.number as %s_number,%s.id as %s_id", number, number, number, number, number, number));
            }
            return StringUtils.join(selectList, (String)",");
        }

        public List<CustomField> buildMetaName() {
            List<List> dimensionCollect = this.dimensionList.stream().map(p -> p.getMemberList().stream().map(x -> x).collect(Collectors.toList())).collect(Collectors.toList());
            List<CustomField> dimensionDescartes = this.descartes(dimensionCollect.toArray(new List[0]));
            List measureCollect = this.measureList.stream().map(p -> p).collect(Collectors.toList());
            List<CustomField> meta = "1".equals(this.showOrder) ? this.descartes(dimensionDescartes, measureCollect) : this.descartes(measureCollect, dimensionDescartes);
            return meta;
        }

        private List<CustomField> descartes(List<CustomField> ... lists) {
            List<CustomField> tempList = new ArrayList<CustomField>();
            for (List<CustomField> list : lists) {
                tempList = tempList.isEmpty() ? list : tempList.stream().flatMap(item -> list.stream().map(item2 -> new CustomField(item.name + "!,!" + item2.name, item.number + "!,!" + item2.number))).collect(Collectors.toList());
            }
            return tempList;
        }

        public List<String> getGroupByField() {
            ArrayList<String> selectList = new ArrayList<String>();
            selectList.add(this.itemRefDimension);
            for (Dimension field : this.dimensionList) {
                String number = field.number;
                Object[] onlyNumberType = new DimensionTypeEnum[]{DimensionTypeEnum.OTHER, DimensionTypeEnum.DENUMS};
                Object[] dataBaseNumberType = new DimensionTypeEnum[]{DimensionTypeEnum.DATABASE, DimensionTypeEnum.ASSISTANTDATA, DimensionTypeEnum.PERIOD};
                if (ArrayUtils.contains((Object[])onlyNumberType, (Object)field.dimensiontype)) {
                    selectList.add(number);
                    continue;
                }
                if (!ArrayUtils.contains((Object[])dataBaseNumberType, (Object)field.dimensiontype)) continue;
                selectList.add(String.format("%s_id", number));
                selectList.add(String.format("%s_name", number));
                selectList.add(String.format("%s_number", number));
            }
            return selectList;
        }

        public QFilter[] getqFilters() {
            return this.qFilters;
        }

        public void setqFilters(QFilter[] qFilters) {
            this.qFilters = qFilters;
        }

        public String getTableNumber() {
            return this.tableNumber;
        }

        public List<ReportItem> getReportItemList() {
            return this.reportItemList;
        }

        public List<Dimension> getDimensionList() {
            return this.dimensionList;
        }

        public List<Measure> getMeasureList() {
            return this.measureList;
        }

        private void rebuildReportItemList(List<ReportItem> reportItemList) {
            for (ReportItem reportItem : reportItemList) {
                Map<ColOutputMeta, BigDecimal[]> outputMetaMap = reportItem.value;
                for (Map.Entry<ColOutputMeta, BigDecimal[]> next : outputMetaMap.entrySet()) {
                    ColOutputMeta key = next.getKey();
                    BigDecimal[] metaValue = next.getValue();
                    if (metaValue == null || metaValue.length <= 0) continue;
                    for (int i = 0; i < this.measureList.size(); ++i) {
                        String number;
                        if (metaValue.length <= i || metaValue[i] == null) continue;
                        String id = number = this.measureList.get((int)i).number;
                        String name = this.measureList.get((int)i).name;
                        if ("1".equals(this.showOrder)) {
                            number = key.number + "!,!" + number;
                            name = key.name + "!,!" + name;
                            id = key.number + "!,!" + id;
                        } else {
                            number = number + "!,!" + key.number;
                            name = name + "!,!" + key.name;
                            id = id + "!,!" + key.id;
                        }
                        ColOutputMeta colOutputMeta = new ColOutputMeta(id, name, number);
                        reportItem.setIncludeMeasure(colOutputMeta, metaValue[i]);
                    }
                }
                this.isReBuildReportItemList = true;
                reportItem.value = null;
            }
        }

        public List<Object[]> buildReportItemMetaValue(List<ReportItem> reportItemList, List<CustomField> metaNames) {
            if (!this.isReBuildReportItemList) {
                this.rebuildReportItemList(reportItemList);
            }
            ArrayList<Object[]> report = new ArrayList<Object[]>(reportItemList.size());
            for (ReportItem reportItem : reportItemList) {
                Map<ColOutputMeta, BigDecimal> includeMeasure = reportItem.includeMeasure;
                Object[] row = new Object[metaNames.size()];
                for (int i = 0; i < metaNames.size(); ++i) {
                    BigDecimal bigDecimal = includeMeasure.get(reportItem.number2ColOutputMeta.get(metaNames.get((int)i).number));
                    row[i] = bigDecimal;
                }
                report.add(row);
            }
            return report;
        }
    }

    private static class ReportItem
    extends CustomField {
        String formula;
        String comptype;
        String formatNumber;
        Map<ColOutputMeta, BigDecimal[]> value = new HashMap<ColOutputMeta, BigDecimal[]>(16);
        Map<ColOutputMeta, BigDecimal> includeMeasure = new HashMap<ColOutputMeta, BigDecimal>(16);
        Map<String, ColOutputMeta> number2ColOutputMeta = new HashMap<String, ColOutputMeta>(16);

        public ReportItem(String name, String number, String formula, String comptype) {
            super(name, number);
            this.formula = CalculateUtils.format((String)formula);
            this.formatNumber = CalculateUtils.formulaItemFormat((String)number);
            this.comptype = comptype;
        }

        public void setValue(ColOutputMeta col, BigDecimal[] formulaReturnValue) {
            this.value.put(col, formulaReturnValue);
        }

        public void setIncludeMeasure(ColOutputMeta col, BigDecimal formulaReturnValue) {
            this.includeMeasure.put(col, formulaReturnValue);
            this.number2ColOutputMeta.put(col.number, col);
        }
    }

    private static class Dimension
    extends CustomField {
        List<Member> memberList;
        DimensionTypeEnum dimensiontype;

        public Dimension(String name, String number) {
            super(name, number);
        }

        public void setDimensiontype(DimensionTypeEnum dimensiontype) {
            this.dimensiontype = dimensiontype;
        }

        public List<Member> getMemberList() {
            return this.memberList;
        }

        public void setMemberList(List<Member> memberList) {
            this.memberList = memberList;
        }
    }

    private static class Member
    extends CustomField {
        public Member(String name, String number) {
            super(name, number);
        }
    }

    private static class Measure
    extends CustomField {
        public Measure(String name, String number) {
            super(name, number);
        }
    }

    private static class ColOutputMeta
    extends CustomField {
        private final String id;

        public ColOutputMeta(String id, String name, String number) {
            super(name, number);
            this.id = id;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ColOutputMeta that = (ColOutputMeta)o;
            return this.id.equals(that.id);
        }

        public int hashCode() {
            return Objects.hash(this.id);
        }
    }

    private static class CustomField {
        String name;
        String number;

        public CustomField(String name, String number) {
            this.name = name;
            this.number = number;
        }
    }
}

