/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.report;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.util.Tuple2;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.JSONUtils;
import kd.bos.util.StringUtils;
import kd.macc.faf.designer.FAFNonBaseDataSelectFormPlugin;
import kd.macc.faf.designer.field.DefaultCombo;
import kd.macc.faf.designer.field.DefaultField;
import kd.macc.faf.designer.field.DefaultMulCombo;
import kd.macc.faf.enums.DimensionNecessityEnum;
import kd.macc.faf.enums.DimensionTypeEnum;
import kd.macc.faf.report.FAFMemberCodeUtils;
import kd.macc.faf.report.ReportPublishFormPlugin;
import kd.macc.faf.util.BaseDataUtil;
import kd.macc.faf.util.DimensionDyUtil;

public class ReportDefinitionFormPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener,
CellClickListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"advcontoolbarap", "advcontoolbarap1", "tbmain"});
        BasedataEdit measure = (BasedataEdit)this.getControl("measure");
        measure.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        EntryGrid columnEntry = (EntryGrid)this.getControl("columnentry");
        columnEntry.addCellClickListener((CellClickListener)this);
        BasedataEdit model = (BasedataEdit)this.getControl("analysis_model");
        model.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        Long analysisModelId = (Long)model.getValue("analysis_model_id");
        int rowCount = model.getEntryRowCount("columnentry");
        if (analysisModelId != null && analysisModelId > 0L && rowCount > 0) {
            model.beginInit();
            Map<Long, String> dimensionIdAndNecessityMap = this.getDimensionIdAndNecessityMap(analysisModelId);
            for (int i = 0; i < rowCount; ++i) {
                DynamicObject dimensionObj = (DynamicObject)model.getValue("dimension", i);
                DimensionTypeEnum dimensionType = DimensionTypeEnum.getEnum((String)dimensionObj.getString("dimensiontype"));
                Long dimensionId = dimensionObj.getLong("id");
                this.columnEntryEdit(dimensionType, i);
                if (dimensionIdAndNecessityMap.isEmpty()) continue;
                String necessity = dimensionIdAndNecessityMap.get(dimensionId);
                if (!DimensionNecessityEnum.ORG.getCode().equals(necessity) && !DimensionNecessityEnum.PERIOD.getCode().equals(necessity)) continue;
                view.setEnable(Boolean.FALSE, i, new String[]{"membername", "configbtn"});
            }
            model.endInit();
            view.updateView("columnentry");
        }
    }

    private void columnEntryEdit(DimensionTypeEnum dimensionType, int i) {
        if (DimensionTypeEnum.OTHER == dimensionType) {
            this.getView().setEnable(Boolean.FALSE, i, new String[]{"configbtn"});
        } else if (DimensionTypeEnum.DATABASE == dimensionType || DimensionTypeEnum.ASSISTANTDATA == dimensionType || DimensionTypeEnum.PERIOD == dimensionType || DimensionTypeEnum.DENUMS == dimensionType) {
            this.getView().setEnable(Boolean.FALSE, i, new String[]{"membername"});
        } else {
            this.getView().setEnable(Boolean.FALSE, i, new String[]{"membername", "configbtn"});
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        ChangeData changeData = e.getChangeSet()[0];
        switch (name) {
            case "analysis_model": {
                int rowEntryCount = model.getEntryRowCount("rowentry");
                int columnEntryCount = model.getEntryRowCount("columnentry");
                int measureEntryCount = model.getEntryRowCount("measureentry");
                Object oldValue = changeData.getOldValue();
                if (oldValue == null || rowEntryCount <= 0 && columnEntryCount <= 0 && measureEntryCount <= 0) break;
                view.showConfirm(ResManager.loadKDString((String)"\u66f4\u6539\u5206\u6790\u6a21\u578b\u5c06\u91cd\u65b0\u586b\u5199\u5173\u8054\u4fe1\u606f\uff0c\u662f\u5426\u786e\u8ba4\uff1f", (String)"ReportDefinitionFormPlugin_0", (String)"macc-faf-formplugin", (Object[])new Object[0]), null, MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("analysis_model", (IFormPlugin)this), null, String.valueOf(((DynamicObject)oldValue).getLong("id")));
                break;
            }
            case "membername": {
                DimensionTypeEnum dimensionType;
                DynamicObject dimensionObj;
                int currentRow = model.getEntryCurrentRowIndex("columnentry");
                Object newValue = changeData.getNewValue();
                if (newValue == null) {
                    model.setValue("membernameencode", null, currentRow);
                    model.setValue("membernumber", null, currentRow);
                    model.setValue("memberid", null, currentRow);
                }
                if ((dimensionObj = (DynamicObject)model.getValue("dimension", currentRow)) == null || DimensionTypeEnum.OTHER != (dimensionType = DimensionTypeEnum.getEnum((String)dimensionObj.getString("dimensiontype")))) break;
                String memberName = (String)model.getValue("membername", currentRow);
                this.checkTextDimension(memberName, currentRow);
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        String actionId = messageBoxClosedEvent.getCallBackId();
        String oldValue = messageBoxClosedEvent.getCustomVaule();
        MessageBoxResult messageBoxResult = messageBoxClosedEvent.getResult();
        if (MessageBoxResult.Yes == messageBoxResult) {
            OperationResult operationResult;
            if ("analysis_model".equals(actionId)) {
                model.deleteEntryData("rowentry");
                model.deleteEntryData("columnentry");
                int measureEntryCount = model.getEntryRowCount("measureentry");
                if (measureEntryCount > 0) {
                    model.setValue("measure", null, 0);
                }
            } else if ("formpublish".equals(actionId) && this.beforeSaveVerify() && (operationResult = view.invokeOperation("save")).isSuccess()) {
                Long reportId = (Long)model.getValue("id");
                ReportPublishFormPlugin.jumpMe(view, reportId);
            }
        } else if ("analysis_model".equals(actionId)) {
            model.beginInit();
            model.setValue("analysis_model", (Object)oldValue);
            model.endInit();
            this.getView().updateView("analysis_model");
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String operationKey = evt.getItemKey();
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        Long analysisModelId = (Long)model.getValue("analysis_model_id");
        List<Long> dimensionIdList = this.getDimensionId(analysisModelId);
        switch (operationKey) {
            case "addrow": {
                if (!this.checkAnalysisModel(analysisModelId)) break;
                int rowCount = model.getEntryRowCount("rowentry");
                HashSet<Long> hasExistId = new HashSet<Long>(rowCount);
                if (rowCount > 0) {
                    for (int i = 0; i < rowCount; ++i) {
                        Long id = (Long)model.getValue("reportitem_id", i);
                        hasExistId.add(id);
                    }
                }
                ListShowParameter bsp = new ListShowParameter();
                StyleCss css = new StyleCss();
                css.setHeight("580px");
                css.setWidth("960px");
                bsp.getOpenStyle().setInlineStyleCss(css);
                bsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "addRowDimCloseBack"));
                bsp.setBillFormId("pa_reportitem");
                bsp.setFormId("bos_templatetreelistf7");
                bsp.setLookUp(true);
                bsp.getOpenStyle().setShowType(ShowType.Modal);
                bsp.setMultiSelect(true);
                bsp.setShowTitle(false);
                Long existReportItemDimensionId = this.getReportItemDimensionId(null);
                bsp.getCustomParams().put("existReportItemDimensionId", existReportItemDimensionId);
                List qFilters = bsp.getListFilterParameter().getQFilters();
                qFilters.add(new QFilter("enable", "=", (Object)"1"));
                if (!hasExistId.isEmpty()) {
                    qFilters.add(new QFilter("id", "not in", hasExistId));
                }
                if (dimensionIdList != null) {
                    Set<Long> reportItemTypeIdSet = this.getReportItemTypeId(dimensionIdList);
                    try {
                        qFilters.add(new QFilter("group", "in", reportItemTypeIdSet));
                        bsp.getCustomParams().put("reportItemTypeIdSet", JSONUtils.toString(reportItemTypeIdSet));
                    }
                    catch (IOException e) {
                        view.showErrorNotification(ResManager.loadKDString((String)"\u7ef4\u5ea6\u6240\u5c5e\u7684\u62a5\u8868\u9879\u7c7b\u522b\u683c\u5f0f\u5316\u5f02\u5e38\u3002", (String)"ReportDefinitionFormPlugin_1", (String)"macc-faf-formplugin", (Object[])new Object[0]));
                        return;
                    }
                }
                view.showForm((FormShowParameter)bsp);
                break;
            }
            case "addrow1": {
                Long reportItemDimensionId;
                if (!this.checkAnalysisModel(analysisModelId)) break;
                int rowCount = model.getEntryRowCount("columnentry");
                HashSet<Long> hasExistId = new HashSet<Long>(rowCount);
                if (rowCount > 0) {
                    for (int i = 0; i < rowCount; ++i) {
                        Long id = (Long)model.getValue("dimension_id", i);
                        hasExistId.add(id);
                    }
                }
                ListShowParameter bsp = new ListShowParameter();
                StyleCss css = new StyleCss();
                css.setHeight("580px");
                css.setWidth("960px");
                bsp.getOpenStyle().setInlineStyleCss(css);
                bsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "addColumnDimCloseBack"));
                bsp.setBillFormId("pa_dimension");
                bsp.setFormId("bos_listf7");
                bsp.setLookUp(true);
                bsp.getOpenStyle().setShowType(ShowType.Modal);
                bsp.setMultiSelect(true);
                bsp.setShowTitle(false);
                List qFilters = bsp.getListFilterParameter().getQFilters();
                if (dimensionIdList != null && !dimensionIdList.isEmpty()) {
                    qFilters.add(new QFilter("id", "in", dimensionIdList));
                }
                if (!hasExistId.isEmpty()) {
                    qFilters.add(new QFilter("id", "not in", hasExistId));
                }
                if ((reportItemDimensionId = this.getReportItemDimensionId(null)) != null) {
                    qFilters.add(new QFilter("id", "!=", (Object)reportItemDimensionId));
                }
                view.showForm((FormShowParameter)bsp);
                break;
            }
        }
    }

    private Long getReportItemDimensionId(DynamicObject reportItem) {
        DynamicObject reportItemGroup;
        IDataModel model;
        int reportDimensionRow;
        if (reportItem == null && (reportDimensionRow = (model = this.getModel()).getEntryRowCount("rowentry")) > -1) {
            reportItem = (DynamicObject)model.getValue("reportitem", 0);
        }
        if (reportItem != null && (reportItemGroup = BusinessDataServiceHelper.loadSingleFromCache((Object)reportItem.get("group_id"), (String)"pa_reportitemtype")) != null) {
            return (Long)reportItemGroup.get("dimension_id");
        }
        return null;
    }

    private boolean checkAnalysisModel(Long analysisModelId) {
        if (analysisModelId == null || analysisModelId == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5206\u6790\u6a21\u578b\u3002", (String)"ReportDefinitionFormPlugin_2", (String)"macc-faf-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Object returnData = closedCallBackEvent.getReturnData();
        if (returnData != null) {
            String actionId = closedCallBackEvent.getActionId();
            IDataModel model = this.getModel();
            IFormView view = this.getView();
            switch (actionId) {
                case "NonBaseDataDimension": {
                    this.addEnumDimMember(returnData, model);
                    break;
                }
                case "addRowDimCloseBack": {
                    this.addRowDim(returnData, model, view);
                    break;
                }
                case "addColumnDimCloseBack": {
                    this.addColumnDim(returnData, model, view);
                    break;
                }
                case "dimMemberCloseBack": {
                    this.addCommonDimMember(returnData, model);
                    break;
                }
            }
        }
    }

    private void addRowDim(Object returnData, IDataModel model, IFormView view) {
        Long newReportItemDimensionId;
        Object newReportItemId;
        DynamicObject newReportItemObj;
        ListSelectedRowCollection listSelectedRows = (ListSelectedRowCollection)returnData;
        if (listSelectedRows.isEmpty()) {
            return;
        }
        Long reportItemDimensionId = this.getReportItemDimensionId(null);
        if (reportItemDimensionId != null && (newReportItemObj = BusinessDataServiceHelper.loadSingleFromCache((Object)(newReportItemId = listSelectedRows.get(0).getPrimaryKeyValue()), (String)"pa_reportitem")) != null && (newReportItemDimensionId = this.getReportItemDimensionId(newReportItemObj)) != null && reportItemDimensionId.longValue() != newReportItemDimensionId.longValue()) {
            model.deleteEntryData("rowentry");
        }
        model.beginInit();
        for (ListSelectedRow listSelectedRow : listSelectedRows) {
            int rowIndex = model.createNewEntryRow("rowentry");
            model.setValue("reportitem", listSelectedRow.getPrimaryKeyValue(), rowIndex);
        }
        model.endInit();
        view.updateView("rowentry");
        int columnEntry = model.getEntryRowCount("columnentry");
        if (columnEntry > 0 && (reportItemDimensionId = this.getReportItemDimensionId(null)) != null) {
            ArrayList<Integer> rowIndexList = new ArrayList<Integer>(1);
            StringBuilder rowNumberBuilder = new StringBuilder();
            for (int i2 = 0; i2 < columnEntry; ++i2) {
                Long dimensionId = (Long)model.getValue("dimension_id", i2);
                if (reportItemDimensionId.compareTo(dimensionId) != 0) continue;
                rowIndexList.add(i2);
                rowNumberBuilder.append(',').append(i2 + 1);
            }
            if (!rowIndexList.isEmpty() && rowNumberBuilder.length() > 0) {
                view.showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u7684\u5217\u7ef4\u5ea6\u4e0e\u62a5\u8868\u9879\u5173\u8054\u7ef4\u5ea6\u76f8\u540c\uff0c\u5df2\u81ea\u52a8\u79fb\u9664\u3002", (String)"ReportDefinitionFormPlugin_3", (String)"macc-faf-formplugin", (Object[])new Object[0]), rowNumberBuilder.substring(1)));
                model.deleteEntryRows("columnentry", rowIndexList.stream().mapToInt(i -> i).toArray());
            }
        }
    }

    private void addColumnDim(Object returnData, IDataModel model, IFormView view) {
        ListSelectedRowCollection listSelectedRows = (ListSelectedRowCollection)returnData;
        if (listSelectedRows.isEmpty()) {
            return;
        }
        Map<Long, String> dimensionIdAndNecessityMap = this.getDimensionIdAndNecessityMap((Long)model.getValue("analysis_model_id"));
        for (ListSelectedRow listSelectedRow : listSelectedRows) {
            int rowIndex = model.createNewEntryRow("columnentry");
            Long id = Long.valueOf(String.valueOf(listSelectedRow.getPrimaryKeyValue()));
            model.setValue("dimension", (Object)id, rowIndex);
            DynamicObject dimensionObj = (DynamicObject)model.getValue("dimension", rowIndex);
            DimensionTypeEnum dimensionType = DimensionTypeEnum.getEnum((String)dimensionObj.getString("dimensiontype"));
            this.columnEntryEdit(dimensionType, rowIndex);
            if (dimensionIdAndNecessityMap.isEmpty()) continue;
            String necessity = dimensionIdAndNecessityMap.get(id);
            if (!DimensionNecessityEnum.ORG.getCode().equals(necessity) && !DimensionNecessityEnum.PERIOD.getCode().equals(necessity)) continue;
            view.setEnable(Boolean.FALSE, rowIndex, new String[]{"membername", "configbtn"});
        }
    }

    private void addEnumDimMember(Object returnData, IDataModel model) {
        DefaultCombo combo = (DefaultCombo)returnData;
        LinkedHashMap comboEnumMap = combo.getComboEnumMap();
        StringBuilder memberName = new StringBuilder();
        StringBuilder memberNameEncode = new StringBuilder();
        StringBuilder memberNumberEncode = new StringBuilder();
        String value = combo.getValue();
        if (value != null && !value.isEmpty()) {
            String[] split;
            if (value.startsWith(",")) {
                value = value.substring(1);
            }
            if (value.endsWith(",")) {
                value = value.substring(0, value.length() - 1);
            }
            for (String number : split = value.split(",")) {
                String title = (String)comboEnumMap.get(number);
                if (title != null && !title.isEmpty()) {
                    memberName.append(',').append(title);
                    memberNameEncode.append(',').append(FAFMemberCodeUtils.encode(title));
                }
                if (number == null || number.isEmpty()) continue;
                memberNumberEncode.append(',').append(FAFMemberCodeUtils.encode(number));
            }
        }
        int rowIndex = model.getEntryCurrentRowIndex("columnentry");
        model.setValue("membername", (Object)(memberName.length() > 0 ? memberName.substring(1) : ""), rowIndex);
        model.setValue("membernameencode", (Object)(memberNameEncode.length() > 0 ? memberNameEncode.substring(1) : ""), rowIndex);
        model.setValue("membernumber", (Object)(memberNumberEncode.length() > 0 ? memberNumberEncode.substring(1) : ""), rowIndex);
    }

    private void addCommonDimMember(Object returnData, IDataModel model) {
        ListSelectedRowCollection listSelectedRows = (ListSelectedRowCollection)returnData;
        if (listSelectedRows.isEmpty()) {
            return;
        }
        StringBuilder memberName = new StringBuilder();
        StringBuilder memberNameEncode = new StringBuilder();
        StringBuilder memberNumberEncode = new StringBuilder();
        StringBuilder memberId = new StringBuilder();
        for (ListSelectedRow row : listSelectedRows) {
            if (row.getName() != null && !row.getName().isEmpty()) {
                memberName.append(',').append(row.getName());
                memberNameEncode.append(',').append(FAFMemberCodeUtils.encode(row.getName()));
            }
            if (row.getNumber() != null && !row.getNumber().isEmpty()) {
                memberNumberEncode.append(',').append(FAFMemberCodeUtils.encode(row.getNumber()));
            }
            memberId.append(',').append(row.getPrimaryKeyValue());
        }
        int rowIndex = model.getEntryCurrentRowIndex("columnentry");
        model.setValue("membername", (Object)(memberName.length() > 0 ? memberName.substring(1) : ""), rowIndex);
        model.setValue("membernameencode", (Object)(memberNameEncode.length() > 0 ? memberNameEncode.substring(1) : ""), rowIndex);
        model.setValue("membernumber", (Object)(memberNumberEncode.length() > 0 ? memberNumberEncode.substring(1) : ""), rowIndex);
        model.setValue("memberid", (Object)(memberId.length() > 0 ? memberId.substring(1) : ""), rowIndex);
    }

    private List<Long> getDimensionId(Long analysisModelId) {
        DynamicObjectCollection dimensionEntry;
        DynamicObject analysisModel = BusinessDataServiceHelper.loadSingleFromCache((Object)analysisModelId, (String)"pa_analysismodel");
        if (analysisModel != null && (dimensionEntry = analysisModel.getDynamicObjectCollection("dimension_entry")) != null && !dimensionEntry.isEmpty()) {
            ArrayList<Long> dimensionIdList = new ArrayList<Long>(dimensionEntry.size());
            for (DynamicObject entry : dimensionEntry) {
                String necessity_dim = entry.getString("necessity_dim");
                DimensionNecessityEnum dimensionNecessityEnum = DimensionNecessityEnum.getEnum((String)necessity_dim);
                DynamicObject dimension = entry.getDynamicObject("dimension");
                String dimensiontype = dimension.getString("dimensiontype");
                DimensionTypeEnum anEnum = DimensionTypeEnum.getEnum((String)dimensiontype);
                if (dimensionNecessityEnum != DimensionNecessityEnum.PERIOD && anEnum == DimensionTypeEnum.DATE) continue;
                dimensionIdList.add(entry.getLong("dimension_id"));
            }
            return dimensionIdList;
        }
        return null;
    }

    private Map<Long, String> getDimensionIdAndNecessityMap(Long analysisModelId) {
        DynamicObjectCollection dimensionEntry;
        HashMap<Long, String> dimensionIdAndNecessityMap = new HashMap<Long, String>(3);
        DynamicObject analysisModel = BusinessDataServiceHelper.loadSingleFromCache((Object)analysisModelId, (String)"pa_analysismodel");
        if (analysisModel != null && (dimensionEntry = analysisModel.getDynamicObjectCollection("dimension_entry")) != null && !dimensionEntry.isEmpty()) {
            for (DynamicObject entry : dimensionEntry) {
                String necessityDim = entry.getString("necessity_dim");
                if (necessityDim == null || necessityDim.isEmpty()) continue;
                dimensionIdAndNecessityMap.put(entry.getLong("dimension_id"), necessityDim);
            }
        }
        return dimensionIdAndNecessityMap;
    }

    private List<Long> getMeasureId(Long analysisModelId) {
        DynamicObjectCollection measureEntry;
        DynamicObject analysisModel = BusinessDataServiceHelper.loadSingleFromCache((Object)analysisModelId, (String)"pa_analysismodel");
        if (analysisModel != null && (measureEntry = analysisModel.getDynamicObjectCollection("measure_entry")) != null && !measureEntry.isEmpty()) {
            ArrayList<Long> measureIdList = new ArrayList<Long>(measureEntry.size());
            for (DynamicObject entry : measureEntry) {
                measureIdList.add(entry.getLong("measure_id"));
            }
            return measureIdList;
        }
        return null;
    }

    private Set<Long> getReportItemTypeId(List<Long> dimensionIdList) {
        QFilter qFilter = new QFilter("dimension", "in", dimensionIdList);
        DynamicObjectCollection reportItemTypeCol = QueryServiceHelper.query((String)"pa_reportitemtype", (String)"id", (QFilter[])qFilter.toArray());
        if (reportItemTypeCol != null && !reportItemTypeCol.isEmpty()) {
            HashSet<Long> reportItemTypeIdSet = new HashSet<Long>(reportItemTypeCol.size());
            for (DynamicObject reportItemType : reportItemTypeCol) {
                reportItemTypeIdSet.add(reportItemType.getLong("id"));
            }
            return reportItemTypeIdSet;
        }
        return Collections.emptySet();
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String key = beforeF7SelectEvent.getProperty().getName();
        Long analysisModelId = (Long)this.getModel().getValue("analysis_model_id");
        if ("measure".equals(key)) {
            if (!this.checkAnalysisModel(analysisModelId)) {
                beforeF7SelectEvent.setCancel(true);
            } else {
                List<Long> measureIdList = this.getMeasureId(analysisModelId);
                if (measureIdList != null && !measureIdList.isEmpty()) {
                    QFilter filter = new QFilter("id", "in", measureIdList);
                    ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                    showParameter.getListFilterParameter().getQFilters().add(filter);
                }
            }
        }
    }

    public void cellClick(CellClickEvent cellClickEvent) {
        super.click((EventObject)cellClickEvent);
        String fieldKey = cellClickEvent.getFieldKey();
        if ("configbtn".equals(fieldKey)) {
            String necessity;
            int[] selectRows = ((EntryGrid)this.getControl("columnentry")).getSelectRows();
            if (selectRows.length != 1) {
                return;
            }
            IDataModel model = this.getModel();
            int rowIndex = model.getEntryCurrentRowIndex("columnentry");
            DynamicObject dimensionObj = (DynamicObject)model.getValue("dimension", rowIndex);
            Long analysisModelId = (Long)model.getValue("analysis_model_id");
            Map<Long, String> dimensionIdAndNecessityMap = this.getDimensionIdAndNecessityMap(analysisModelId);
            if (!dimensionIdAndNecessityMap.isEmpty() && ("0".equals(necessity = dimensionIdAndNecessityMap.get(dimensionObj.getLong("id"))) || "1".equals(necessity))) {
                return;
            }
            String dimensionType = dimensionObj.getString("dimensiontype");
            DimensionTypeEnum anEnum = DimensionTypeEnum.getEnum((String)dimensionType);
            if (anEnum == DimensionTypeEnum.DATABASE || anEnum == DimensionTypeEnum.ASSISTANTDATA || anEnum == DimensionTypeEnum.PERIOD) {
                Tuple2 tuple = DimensionDyUtil.getDimensionSourceNumberFromDimension((DynamicObject)dimensionObj);
                if (tuple != null) {
                    String entity = (String)tuple.t1;
                    QFilter[] filter = (QFilter[])tuple.t2;
                    if (entity != null) {
                        String memberIdStr = (String)model.getValue("memberid");
                        ListShowParameter f7ShowParameter = BaseDataUtil.createF7ShowParameter(entity, true, memberIdStr);
                        f7ShowParameter.setCaption(((OrmLocaleValue)dimensionObj.get("name")).get((Object)Lang.get().toString()));
                        List qFilters = f7ShowParameter.getListFilterParameter().getQFilters();
                        if (filter != null) {
                            qFilters.addAll(Arrays.asList(filter));
                        }
                        f7ShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "dimMemberCloseBack"));
                        this.getView().showForm((FormShowParameter)f7ShowParameter);
                    }
                }
            } else if (anEnum == DimensionTypeEnum.DENUMS) {
                LinkedHashMap comboEnumMap = dimensionObj.getDynamicObjectCollection("entryentityenums").stream().collect(Collectors.toMap(dy -> dy.getString("value"), dy -> dy.getString("title"), (o1, o2) -> o1, LinkedHashMap::new));
                String enumMemberNumber = (String)model.getValue("membernumber", rowIndex);
                DefaultMulCombo defaultCombo = new DefaultMulCombo(enumMemberNumber, comboEnumMap);
                FAFNonBaseDataSelectFormPlugin.openDefaultValueFillingPage(this, (DefaultField)defaultCombo, dimensionObj.getLocaleString("name").toString());
            }
        }
    }

    public void cellDoubleClick(CellClickEvent ignore) {
    }

    private boolean checkTextDimension(String textDimension, int rowIndex) {
        if (textDimension == null || textDimension.isEmpty()) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5217\u7ef4\u5ea6\u8bbe\u7f6e-\u7b2c%d\u884c\u6210\u5458\u503c\u8303\u56f4\u3002", (String)"ReportDefinitionFormPlugin_4", (String)"macc-faf-formplugin", (Object[])new Object[0]), rowIndex + 1));
            return false;
        }
        if (textDimension.startsWith(",") || textDimension.endsWith(",")) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%d\u884c\u6210\u5458\u503c\u8303\u56f4\u7684\u9996\u5c3e\u4e0d\u80fd\u6709\u9017\u53f7\uff0c\u8bf7\u66f4\u6539\u3002", (String)"ReportDefinitionFormPlugin_5", (String)"macc-faf-formplugin", (Object[])new Object[0]), rowIndex + 1));
            return false;
        }
        return true;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String operateKey = ((FormOperate)args.getSource()).getOperateKey();
        if ("save".equals(operateKey)) {
            if (!this.beforeSaveVerify()) {
                args.setCancel(true);
            }
        } else if ("formpublish".equals(operateKey)) {
            Long id = (Long)this.getModel().getValue("id");
            if (id == null || id.compareTo(0L) == 0 || this.getModel().getDataChanged()) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u62a5\u8868\u6709\u53d8\u66f4\uff0c\u5373\u5c06\u4fdd\u5b58\u5e76\u53d1\u5e03\uff0c\u662f\u5426\u786e\u8ba4\uff1f", (String)"ReportDefinitionFormPlugin_6", (String)"macc-faf-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("formpublish", (IFormPlugin)this));
                args.setCancel(true);
                return;
            }
            ReportPublishFormPlugin.jumpMe(this.getView(), id);
        }
    }

    private boolean beforeSaveVerify() {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        int columnEntryCount = model.getEntryRowCount("columnentry");
        Map<Long, String> dimensionIdAndNecessityMap = this.getDimensionIdAndNecessityMap((Long)model.getValue("analysis_model_id"));
        for (int i = 0; i < columnEntryCount; ++i) {
            DynamicObject dimensionObj = (DynamicObject)model.getValue("dimension", i);
            DimensionTypeEnum dimensionType = DimensionTypeEnum.getEnum((String)dimensionObj.getString("dimensiontype"));
            String memberName = (String)model.getValue("membername", i);
            String necessity = dimensionIdAndNecessityMap.get(dimensionObj.getLong("id"));
            if (DimensionNecessityEnum.ORG.getCode().equals(necessity) || DimensionNecessityEnum.PERIOD.getCode().equals(necessity)) continue;
            if (DimensionTypeEnum.OTHER == dimensionType) {
                if (this.checkTextDimension(memberName, i)) continue;
                return false;
            }
            if (DimensionTypeEnum.DATABASE != dimensionType && DimensionTypeEnum.ASSISTANTDATA != dimensionType && DimensionTypeEnum.PERIOD != dimensionType && DimensionTypeEnum.DENUMS != dimensionType || !StringUtils.isEmpty((String)memberName)) continue;
            view.showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5217\u7ef4\u5ea6\u8bbe\u7f6e-\u7b2c%d\u884c\u6210\u5458\u503c\u8303\u56f4\u3002", (String)"ReportDefinitionFormPlugin_4", (String)"macc-faf-formplugin", (Object[])new Object[0]), i + 1));
            return false;
        }
        return true;
    }
}

