/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.report;

import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Button;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.faf.common.OpLogProxy;
import kd.macc.faf.formplugin.utils.PluginExceptionHelper;

public class ReportPublishFormPlugin
extends AbstractFormPlugin {
    private static final String PERM_ROLE = "perm_role";
    private static final String PERM_USER = "perm_user";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
    }

    public void afterCreateNewData(EventObject e) {
        DynamicObject report;
        super.afterCreateNewData(e);
        Long reportId = this.getReportId();
        if (reportId != null && (report = BusinessDataServiceHelper.loadSingleFromCache((Object)reportId, (String)"pa_reportdefinition")) != null) {
            this.init(report);
        }
    }

    private void init(DynamicObject report) {
        IDataModel model = this.getModel();
        String reportNumber = report.getString("number");
        String reportName = report.getString("name");
        switch (this.sourceParentPageByShowFrom()) {
            case "pa_reportdefinition": 
            case "bos_list": {
                model.setValue("number", (Object)reportNumber);
                model.setValue("name", (Object)reportName);
                break;
            }
            case "pa_publication_management": {
                model.setValue("number", (Object)reportNumber);
                model.setValue("name", (Object)reportName);
                model.setValue(PERM_ROLE, (Object)report.getDynamicObjectCollection(PERM_ROLE));
                model.setValue(PERM_USER, (Object)report.getDynamicObjectCollection(PERM_USER));
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        String itemKey = ((Button)evt.getSource()).getKey();
        try {
            if ("btnok".equals(itemKey)) {
                if (this.permissionIsEmpty()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6388\u6743\u89d2\u8272\u6216\u7528\u6237\u3002", (String)"ReportPublishFormPlugin_6", (String)"macc-faf-formplugin", (Object[])new Object[0]));
                    return;
                }
                Long reportId = this.getReportId();
                if (reportId != null) {
                    this.saveOrUpdatePermission(reportId);
                    this.getPageCache().put("closeable", "true");
                    this.refreshParentForm();
                }
                DynamicObject report = BusinessDataServiceHelper.loadSingle((Object)reportId, (String)"pa_reportdefinition");
                List permRoleNames = report.getDynamicObjectCollection(PERM_ROLE).stream().map(dy -> dy.getDynamicObject("fbasedataid")).map(dy -> dy.getString("name")).collect(Collectors.toList());
                List permUserNames = report.getDynamicObjectCollection(PERM_USER).stream().map(dy -> dy.getDynamicObject("fbasedataid")).map(dy -> dy.getString("name")).collect(Collectors.toList());
                MultiLangEnumBridge opDescBridge = new MultiLangEnumBridge("\u53d1\u5e03\u6210\u529f\uff0c\u62a5\u8868\u5b9a\u4e49\u7f16\u53f7\uff1a%1$s\uff0c\u62a5\u8868\u5b9a\u4e49\u540d\u79f0\uff1a%2$s\uff0c\u6388\u6743\u89d2\u8272\uff1a%3$s\uff0c\u6388\u6743\u7528\u6237\uff1a%4$s", "ReportPublishFormPlugin_2", "macc-faf-formplugin");
                String[] opDescArgs = new String[]{report.getString("number"), report.getString("name"), permRoleNames.isEmpty() ? "" : String.join((CharSequence)"\uff1b", permRoleNames), permUserNames.isEmpty() ? "" : String.join((CharSequence)"\uff1b", permUserNames)};
                OpLogProxy.create((String)this.getView().getEntityId()).setOpName("publish", new MultiLangEnumBridge("\u62a5\u8868\u53d1\u5e03", "ReportPublishFormPlugin_1", "macc-faf-formplugin")).setOpDesc(opDescBridge, opDescArgs).saveLog();
                this.getView().close();
            }
        }
        catch (Exception e) {
            PluginExceptionHelper.throwKDBizException(e);
        }
    }

    private void refreshParentForm() {
        IFormView parentView = this.getView().getParentView();
        if ("pa_publication_management".equals(this.sourceParentPageByShowFrom())) {
            parentView.invokeOperation("refresh");
        }
        parentView.showSuccessNotification(ResManager.loadKDString((String)"\u53d1\u5e03\u6210\u529f\u3002", (String)"ReportPublishFormPlugin_0", (String)"macc-faf-formplugin", (Object[])new Object[0]));
        this.getView().sendFormAction(parentView);
    }

    private boolean permissionIsEmpty() {
        MulBasedataDynamicObjectCollection permRole = (MulBasedataDynamicObjectCollection)this.getModel().getValue(PERM_ROLE);
        MulBasedataDynamicObjectCollection permUser = (MulBasedataDynamicObjectCollection)this.getModel().getValue(PERM_USER);
        return CollectionUtils.isEmpty((Collection)permRole) && CollectionUtils.isEmpty((Collection)permUser);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String operateKey = ((FormOperate)args.getSource()).getOperateKey();
        if ("close".equals(operateKey) && this.isChange()) {
            this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u9000\u51fa\uff1f%1$s\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"ReportPublishFormPlugin_3", (String)"macc-faf-formplugin", (Object[])new Object[0]), "\n"), MessageBoxOptions.YesNo, new ConfirmCallBackListener("cancel_publish", (IFormPlugin)this));
            args.setCancel(true);
        }
    }

    private boolean isChange() {
        String parentNumber = this.sourceParentPageByShowFrom();
        IDataModel model = this.getModel();
        MulBasedataDynamicObjectCollection permRole = (MulBasedataDynamicObjectCollection)model.getValue(PERM_ROLE);
        MulBasedataDynamicObjectCollection permUser = (MulBasedataDynamicObjectCollection)model.getValue(PERM_USER);
        if ("pa_reportdefinition".equals(parentNumber) || "bos_list".equals(parentNumber)) {
            return permRole.size() != 0 || permUser.size() != 0;
        }
        if ("pa_publication_management".equals(parentNumber)) {
            DynamicObject report = BusinessDataServiceHelper.loadSingleFromCache((Object)this.getReportId(), (String)"pa_reportdefinition");
            List changedPermRoleIds = report.getDynamicObjectCollection(PERM_ROLE).stream().map(baseData -> baseData.getDynamicObject("fbasedataid")).map(dy -> dy.get("id")).collect(Collectors.toList());
            List changedPermUserIds = report.getDynamicObjectCollection(PERM_USER).stream().map(baseData -> baseData.getDynamicObject("fbasedataid")).map(dy -> dy.get("id")).collect(Collectors.toList());
            List permRoleIds = permRole.stream().map(baseData -> baseData.getDynamicObject("fbasedataid")).map(dy -> dy.get("id")).collect(Collectors.toList());
            List permUserIds = permUser.stream().map(baseData -> baseData.getDynamicObject("fbasedataid")).map(dy -> dy.get("id")).collect(Collectors.toList());
            return changedPermRoleIds.size() != permRoleIds.size() || !changedPermRoleIds.containsAll(permRoleIds) || changedPermUserIds.size() != permUserIds.size() || !changedPermUserIds.containsAll(permUserIds);
        }
        return false;
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        String closeable = this.getPageCache().get("closeable");
        if (!"true".equals(closeable) && this.isChange()) {
            this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u9000\u51fa\uff1f%s\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"ReportPublishFormPlugin_4", (String)"macc-faf-formplugin", (Object[])new Object[0]), "\n"), MessageBoxOptions.YesNo, new ConfirmCallBackListener("cancel_publish", (IFormPlugin)this));
            this.getPageCache().put("closeable", null);
            e.setCancel(true);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        String result = messageBoxClosedEvent.getResultValue();
        if ("cancel_publish".equals(callBackId) && MessageBoxResult.Yes.name().equals(result)) {
            this.getPageCache().put("closeable", "true");
            this.getView().close();
        }
    }

    private void saveOrUpdatePermission(Long reportId) {
        IDataModel model = this.getModel();
        DynamicObjectCollection roles = (DynamicObjectCollection)model.getValue(PERM_ROLE);
        DynamicObjectCollection users = (DynamicObjectCollection)model.getValue(PERM_USER);
        DynamicObject report = BusinessDataServiceHelper.loadSingle((Object)reportId, (String)"pa_reportdefinition", (String)"id,perm_role,perm_user,publishtime");
        DynamicObjectCollection oldPermRoleList = report.getDynamicObjectCollection(PERM_ROLE);
        DynamicObjectCollection oldPermUserList = report.getDynamicObjectCollection(PERM_USER);
        switch (this.sourceParentPageByShowFrom()) {
            case "pa_reportdefinition": 
            case "bos_list": {
                List oldPermRoleIdList = oldPermRoleList.stream().map(dy -> dy.getString("fbasedataid_id")).collect(Collectors.toList());
                List oldPermUserIdList = oldPermUserList.stream().map(dy -> dy.getLong("fbasedataid_id")).collect(Collectors.toList());
                roles.removeIf(role -> oldPermRoleIdList.contains(role.getString("fbasedataid_id")));
                users.removeIf(user -> oldPermUserIdList.contains(user.getLong("fbasedataid_id")));
                oldPermRoleList.addAll((Collection)roles);
                oldPermUserList.addAll((Collection)users);
                report.set("publishtime", (Object)new Date());
                break;
            }
            case "pa_publication_management": {
                report.set(PERM_ROLE, (Object)roles);
                report.set(PERM_USER, (Object)users);
                report.set("publishtime", (Object)new Date());
            }
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{report});
    }

    private String sourceParentPageByShowFrom() {
        String sourceParentPageNumber = "";
        IFormView parentView = this.getView().getParentView();
        if (parentView != null) {
            sourceParentPageNumber = parentView.getEntityId();
        }
        return sourceParentPageNumber;
    }

    private Long getReportId() {
        return (Long)this.getView().getFormShowParameter().getCustomParam("reportId");
    }

    public static void jumpMe(IFormView view, Long reportId) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("pa_publication");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCustomParam("reportId", (Object)reportId);
        view.showForm(formShowParameter);
    }
}

