/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.report;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Button;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.faf.common.OpLogProxy;
import kd.macc.faf.formplugin.utils.PluginExceptionHelper;
import kd.macc.faf.report.ReportPublishFormPlugin;

public class ReportPublishManagementFormPlugin
extends AbstractFormPlugin
implements HyperLinkClickListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initialEntry();
    }

    public void click(EventObject evt) {
        super.click(evt);
        String itemKey = ((Button)evt.getSource()).getKey();
        if ("btnok".equals(itemKey)) {
            int[] selectedRows = ((EntryGrid)this.getView().getControl("entryentity")).getEntryState().getSelectedRows();
            if (ArrayUtils.isEmpty((int[])selectedRows)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u53d6\u6d88\u53d1\u5e03\u7684\u6570\u636e\u3002", (String)"ReportPublishManagementFormPlugin_0", (String)"macc-faf-formplugin", (Object[])new Object[0]));
                return;
            }
            this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u8bf7\u95ee\u662f\u5426\u786e\u5b9a\u53d6\u6d88\u53d1\u5e03\u6b64%s\u9879?", (String)"ReportPublishManagementFormPlugin_1", (String)"macc-faf-formplugin", (Object[])new Object[0]), selectedRows.length), MessageBoxOptions.YesNo, new ConfirmCallBackListener("cancel_publication", (IFormPlugin)this));
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        MessageBoxResult result = messageBoxClosedEvent.getResult();
        String callBackId = messageBoxClosedEvent.getCallBackId();
        try {
            if ("cancel_publication".equals(callBackId) && MessageBoxResult.Yes == result) {
                this.cancelPublicationInSelect();
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53d6\u6d88\u53d1\u5e03\u6210\u529f\u3002", (String)"ReportPublishManagementFormPlugin_2", (String)"macc-faf-formplugin", (Object[])new Object[0]));
                this.getView().invokeOperation("refresh");
            }
        }
        catch (Exception e) {
            PluginExceptionHelper.throwKDBizException(e);
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        String fieldName = hyperLinkClickEvent.getFieldName();
        if ("perm".equals(fieldName)) {
            Long reportId = (Long)this.getModel().getValue("id", hyperLinkClickEvent.getRowIndex());
            ReportPublishFormPlugin.jumpMe(this.getView(), reportId);
        }
    }

    private void initialEntry() {
        Map reports = BusinessDataServiceHelper.loadFromCache((String)"pa_reportdefinition", (String)"id,name,perm,publishtime,perm_role,perm_user", (QFilter[])new QFilter("publishtime", "is not null", null).toArray());
        if (!CollectionUtils.isEmpty((Map)reports)) {
            DynamicObjectCollection entryentity = this.getModel().getEntryEntity("entryentity");
            this.getModel().batchCreateNewEntryRow("entryentity", reports.size());
            DynamicProperty id = entryentity.getDynamicObjectType().getProperty("id");
            DynamicProperty number = entryentity.getDynamicObjectType().getProperty("number");
            DynamicProperty name = entryentity.getDynamicObjectType().getProperty("name");
            DynamicProperty perm = entryentity.getDynamicObjectType().getProperty("perm");
            DynamicProperty publishTime = entryentity.getDynamicObjectType().getProperty("publishtime");
            int index = 0;
            for (DynamicObject report : reports.values()) {
                DynamicObject dynamicObject = (DynamicObject)entryentity.get(index);
                id.setValue((Object)dynamicObject, (Object)report.getLong("id"));
                number.setValueFast((Object)dynamicObject, (Object)report.getString("number"));
                name.setValueFast((Object)dynamicObject, (Object)report.getString("name"));
                perm.setValueFast((Object)dynamicObject, (Object)this.getPermText(report));
                publishTime.setValueFast((Object)dynamicObject, (Object)report.getDate("publishtime"));
                ++index;
            }
        }
    }

    private String getPermText(DynamicObject report) {
        ArrayList<String> permTextList = new ArrayList<String>();
        DynamicObjectCollection perm_role = report.getDynamicObjectCollection("perm_role");
        DynamicObjectCollection perm_user = report.getDynamicObjectCollection("perm_user");
        if (!CollectionUtils.isEmpty((Collection)perm_role)) {
            permTextList.add(String.format(ResManager.loadKDString((String)"\u89d2\u8272%s\u4e2a", (String)"ReportPublishManagementFormPlugin_3", (String)"macc-faf-formplugin", (Object[])new Object[0]), perm_role.size()));
        }
        if (!CollectionUtils.isEmpty((Collection)perm_user)) {
            permTextList.add(String.format(ResManager.loadKDString((String)"\u7528\u6237%s\u4e2a", (String)"ReportPublishManagementFormPlugin_4", (String)"macc-faf-formplugin", (Object[])new Object[0]), perm_user.size()));
        }
        if (CollectionUtils.isEmpty(permTextList)) {
            return "";
        }
        return StringUtils.join((Object[])permTextList.toArray(), (String)"\uff0c");
    }

    private void cancelPublicationInSelect() {
        DynamicObject[] selectReports;
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        int[] selectedRows = ((EntryGrid)this.getView().getControl("entryentity")).getEntryState().getSelectedRows();
        List reportIds = Arrays.stream(selectedRows).boxed().map(selectIndex -> ((DynamicObject)entryEntity.get(selectIndex.intValue())).getLong("id")).collect(Collectors.toList());
        for (DynamicObject selectReport : selectReports = BusinessDataServiceHelper.loadFromCache((String)"pa_reportdefinition", (String)"id,number,name,publishtime,perm_role,perm_user", (QFilter[])new QFilter("id", "in", reportIds).toArray()).values().toArray(new DynamicObject[0])) {
            selectReport.set("perm_role", null);
            selectReport.set("perm_user", null);
            selectReport.set("publishtime", null);
        }
        SaveServiceHelper.save((DynamicObject[])selectReports);
        List reportLogList = Stream.of(selectReports).map(dy -> String.format(ResManager.loadKDString((String)"\u62a5\u8868\u5b9a\u4e49\u7f16\u53f7\uff1a%1$s\uff0c\u62a5\u8868\u5b9a\u4e49\u540d\u79f0\uff1a%2$s", (String)"ReportPublishManagementFormPlugin_5", (String)"macc-faf-formplugin", (Object[])new Object[0]), dy.getString("number"), dy.getString("name"))).collect(Collectors.toList());
        MultiLangEnumBridge opDescBridge = new MultiLangEnumBridge("\u53d6\u6d88\u53d1\u5e03\u6210\u529f\uff1a%s", "ReportPublishManagementFormPlugin_7", "macc-faf-formplugin");
        String[] opDescArgs = new String[]{reportLogList.isEmpty() ? "" : String.join((CharSequence)"\uff1b", reportLogList)};
        OpLogProxy.create((String)this.getView().getEntityId()).setOpName("cancel", new MultiLangEnumBridge("\u53d6\u6d88\u62a5\u8868\u53d1\u5e03", "ReportPublishManagementFormPlugin_6", "macc-faf-formplugin")).setOpDesc(opDescBridge, opDescArgs).saveLog();
    }

    public static void jumpMe(IFormView view) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("pa_publication_management");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        view.showForm(formShowParameter);
    }
}

