/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.report.validate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import org.jetbrains.annotations.NotNull;

public class FAFReportItemValidate
extends AbstractOperationServicePlugIn {
    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new LoopDependValidator());
    }

    public static Set<String> checkBeDepend(@NotNull Collection<Long> ids, @NotNull Collection<String> numbers) {
        QFilter[] qFilters = new QFilter[]{new QFilter("dep.itemnumber", "in", numbers), new QFilter("id", "not in", ids)};
        HashSet<String> set = new HashSet<String>(16);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"PAReportItemFormplugin.checkBeDepend", (String)"pa_reportitem", (String)"name", (QFilter[])qFilters, null);){
            while (dataSet.hasNext()) {
                Row next = dataSet.next();
                set.add(next.getString("name"));
            }
        }
        return set;
    }

    public static Set<String> checkBeDepend(@NotNull Long id, @NotNull String number) {
        return FAFReportItemValidate.checkBeDepend(Collections.singleton(id), Collections.singleton(number));
    }

    static class DataEntityMessage {
        int dataEntitiesInndex;
        String number;
        Set<String> itemnumbers;

        public DataEntityMessage(String number, int dataEntitiesInndex, Set<String> itemnumbers) {
            this.number = number;
            this.dataEntitiesInndex = dataEntitiesInndex;
            this.itemnumbers = itemnumbers;
        }
    }

    static class LoopDependValidator
    extends AbstractValidator {
        LoopDependValidator() {
        }

        public void validate() {
            Object comptype;
            ArrayList<DataEntityMessage> list = new ArrayList<DataEntityMessage>(16);
            HashSet<Long> groupIds = new HashSet<Long>(16);
            for (int i = 0; i < this.dataEntities.length; ++i) {
                ExtendedDataEntity dataEntity = this.dataEntities[i];
                DynamicObject dynamicObject = dataEntity.getDataEntity();
                comptype = dynamicObject.getString("comptype");
                String number = dynamicObject.getString("number");
                if (!number.matches("[0-9_A-Za-z]+")) {
                    this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7f16\u53f7\uff1a%s \u53ea\u652f\u6301\u5b57\u6bcd+\u6570\u5b57+\u4e0b\u5212\u7ebf\u7684\u7ec4\u5408\u3002", (String)"FAFReportItemValidate_0", (String)"macc-faf-formplugin", (Object[])new Object[0]), number));
                    continue;
                }
                if (!"1".equals(comptype)) continue;
                Long group_id = dynamicObject.getLong("group_id");
                groupIds.add(group_id);
                DynamicObjectCollection dep = dynamicObject.getDynamicObjectCollection("dep");
                Set<String> itemnumbers = dep.stream().map(p -> p.getString("itemnumber")).collect(Collectors.toSet());
                if (itemnumbers.contains(number)) {
                    this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"%s\u5b9a\u4e49\u7684\u516c\u5f0f\u5b58\u5728\u81ea\u5df1\u4f9d\u8d56\u81ea\u5df1\u7684\u60c5\u51b5\u3002", (String)"FAFReportItemValidate_1", (String)"macc-faf-formplugin", (Object[])new Object[0]), number));
                    continue;
                }
                list.add(new DataEntityMessage(number, i, itemnumbers));
            }
            if (!list.isEmpty()) {
                QFilter[] qFilters = new QFilter[]{new QFilter("group", "in", groupIds), new QFilter("comptype", "=", (Object)"1")};
                HashMap<String, Set<String>> map = new HashMap<String, Set<String>>(16);
                DataSet dataSet = QueryServiceHelper.queryDataSet((String)"LoopDependValidator", (String)"pa_reportitem", (String)"number,dep.itemnumber as devnumber", (QFilter[])qFilters, null);
                comptype = null;
                try {
                    while (dataSet.hasNext()) {
                        Row next = dataSet.next();
                        String dbNumber = next.getString("number");
                        String devnumber = next.getString("devnumber");
                        map.merge(dbNumber, new HashSet<String>(Collections.singleton(devnumber)), (ov, nv) -> {
                            ov.add(devnumber);
                            return ov;
                        });
                    }
                }
                catch (Throwable throwable) {
                    comptype = throwable;
                    throw throwable;
                }
                finally {
                    if (dataSet != null) {
                        if (comptype != null) {
                            try {
                                dataSet.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)comptype).addSuppressed(throwable);
                            }
                        } else {
                            dataSet.close();
                        }
                    }
                }
                for (DataEntityMessage dataEntityMessage : list) {
                    this.validate(dataEntityMessage, map);
                }
            }
        }

        private void validate(DataEntityMessage dataEntityMessage, Map<String, Set<String>> map) {
            if (this.validateLoop(dataEntityMessage.number, dataEntityMessage.itemnumbers, map, null, new HashSet<String>(16))) {
                this.addMessage(this.dataEntities[dataEntityMessage.dataEntitiesInndex], String.format(ResManager.loadKDString((String)"%s\u516c\u5f0f\u4e0e\u73b0\u6709\u7684\u62a5\u8868\u9879\u76ee\u5b58\u5728\u5faa\u73af\u4f9d\u8d56\u7684\u60c5\u51b5\u3002", (String)"FAFReportItemValidate_2", (String)"macc-faf-formplugin", (Object[])new Object[0]), dataEntityMessage.number));
            } else {
                map.put(dataEntityMessage.number, dataEntityMessage.itemnumbers);
            }
        }

        private boolean validateLoop(@NotNull String srcNumber, Set<String> itemnumbers, @NotNull Map<String, Set<String>> map, String number, Set<String> exSet) {
            if (srcNumber.equals(number)) {
                return true;
            }
            if (itemnumbers != null && !itemnumbers.isEmpty()) {
                for (String itemnumber : itemnumbers) {
                    Set<String> numberset = null;
                    if (!exSet.contains(itemnumber)) {
                        numberset = map.get(itemnumber);
                    }
                    if (!this.validateLoop(srcNumber, numberset, map, itemnumber, exSet)) continue;
                    return true;
                }
            }
            return false;
        }
    }
}

