/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.system;

import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.license.api.LicenseCheckResult;
import kd.bos.list.ListShowParameter;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.businessfield.BasedataField;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.macc.faf.enums.DimensionNecessityEnum;
import kd.macc.faf.helper.EntityMetaHelper;
import kd.macc.faf.helper.FAFAnalysisModelHelper;
import kd.macc.faf.util.AnalysisModelUtil;
import kd.macc.faf.util.BusinessPermissionHelper;
import kd.macc.faf.util.CustomizedDynamicFormBuilderUtil;
import kd.macc.faf.util.CustomizedFormBuilderInfo;
import kd.macc.faf.util.LicenseUtil;
import kd.macc.faf.util.ValidatorTipsUtil;
import org.apache.commons.lang3.StringUtils;

public class DataSupplementaryFormPlugin
extends AbstractFormPlugin
implements SearchEnterListener,
RowClickEventListener {
    public void initialize() {
        super.initialize();
        CardEntry cardEntry = (CardEntry)this.getControl("entryentity");
        cardEntry.addRowClickListener((RowClickEventListener)this);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Search search = (Search)this.getControl("searchap");
        search.addEnterListener((SearchEnterListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        this.initLabelEntry(null);
        CardEntry cardEntry = (CardEntry)this.getControl("entryentity");
        cardEntry.selectRows(0, true);
        cardEntry.entryRowClick(Integer.valueOf(0));
    }

    private void initLabelEntry(String analysisSysName) {
        DataSet dataSet;
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        List systemIdList = QueryServiceHelper.queryPrimaryKeys((String)"pa_anasystemsetting", (QFilter[])enableFilter.toArray(), null, (int)-1);
        QFilter filter = new QFilter("tablenumber", "!=", (Object)" ").and(enableFilter).and("analysis_system.id", "in", (Object)systemIdList);
        if (StringUtils.isNotEmpty((CharSequence)analysisSysName)) {
            filter.and("analysis_system.name", "like", (Object)("%" + analysisSysName + "%"));
        }
        if ((dataSet = QueryServiceHelper.queryDataSet((String)"DataSupplementaryFormPlugin.initLabelEntry", (String)"pa_analysismodel", (String)"id,name,analysis_system.id,analysis_system.name", (QFilter[])filter.toArray(), (String)"analysis_system.id desc, id desc")) != null) {
            IDataModel model = this.getModel();
            IFormView view = this.getView();
            model.deleteEntryData("entryentity");
            model.beginInit();
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                int entryIndex = model.createNewEntryRow("entryentity");
                model.setValue("systemid", row.get("analysis_system.id"), entryIndex);
                model.setValue("systemname", row.get("analysis_system.name"), entryIndex);
                model.setValue("modelid", row.get("id"), entryIndex);
                model.setValue("modelname", row.get("name"), entryIndex);
            }
            model.endInit();
            view.updateView("entryentity");
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        IDataModel model;
        Long modelId;
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if ("entryentity".equals(key) && (modelId = (Long)(model = this.getModel()).getValue("modelid", model.getEntryCurrentRowIndex("entryentity"))) != null) {
            this.repairBaseDimensionDisProp(modelId);
            this.showModelList();
        }
    }

    private void repairBaseDimensionDisProp(Long modelId) {
        DynamicObject anaModelDY = BusinessDataServiceHelper.loadSingle((Object)modelId, (String)"pa_analysismodel");
        String tableNumber = anaModelDY.getString("tablenumber");
        String inputTableName = anaModelDY.getString("tablename");
        Boolean isNewFilter = anaModelDY.getBoolean("isnewlistfilter");
        if (StringUtils.isNotEmpty((CharSequence)tableNumber)) {
            String inputTableName_dtl;
            String tableNumber_dtl;
            CustomizedFormBuilderInfo builderDetailInfo;
            boolean isNewVersion;
            CustomizedFormBuilderInfo builderInfo = this.getCustomizedFormBuilderInfo(tableNumber, inputTableName, isNewFilter);
            if (builderInfo.isChanged()) {
                EntityMetaHelper.constructMetadataList((CustomizedFormBuilderInfo)builderInfo, (DynamicObject)anaModelDY);
                CustomizedDynamicFormBuilderUtil.checkDesignerDataSaveResult((CustomizedFormBuilderInfo)builderInfo, (Map)CustomizedDynamicFormBuilderUtil.SaveEntityPage((CustomizedFormBuilderInfo)builderInfo, (Boolean)Boolean.FALSE), (boolean)true);
            }
            if ((isNewVersion = FAFAnalysisModelHelper.isModelNewVersion((DynamicObject)anaModelDY)) && (builderDetailInfo = this.getCustomizedFormBuilderInfo(tableNumber_dtl = tableNumber + "_d", inputTableName_dtl = inputTableName + "_d", isNewFilter)).isChanged()) {
                EntityMetaHelper.constructMetadataList((CustomizedFormBuilderInfo)builderDetailInfo, (DynamicObject)anaModelDY);
                CustomizedDynamicFormBuilderUtil.checkDesignerDataSaveResult((CustomizedFormBuilderInfo)builderDetailInfo, (Map)CustomizedDynamicFormBuilderUtil.SaveEntityPage((CustomizedFormBuilderInfo)builderDetailInfo, (Boolean)Boolean.FALSE), (boolean)true);
            }
            if (!isNewFilter.booleanValue()) {
                anaModelDY.set("isnewlistfilter", (Object)Boolean.TRUE);
                SaveServiceHelper.update((DynamicObject)anaModelDY);
            }
        }
    }

    private CustomizedFormBuilderInfo getCustomizedFormBuilderInfo(String tableNumber, String inputTableName, Boolean isNewFilter) {
        CustomizedFormBuilderInfo builderInfo = CustomizedDynamicFormBuilderUtil.createCustomizedFormBuilderInfo((String)AnalysisModelUtil.buildEntityNumber((String)tableNumber), (String)inputTableName, (String)"2UK0B8T0A=WJ", (String)"BaseFormModel");
        builderInfo.setBizUnitId("2XF5B1YXIBCY");
        builderInfo.setDbRoute("fias");
        for (EntityItem item : builderInfo.getEntityMeta().getItems()) {
            if (!(item instanceof BasedataField)) continue;
            BasedataField field = (BasedataField)item;
            try {
                String newDisplayProp;
                String oldDisplayProp = field.getDisplayProp();
                if (StringUtils.equals((CharSequence)oldDisplayProp, (CharSequence)(newDisplayProp = ((BasedataEntityType)EntityMetadataCache.getDataEntityTypeById((String)field.getBaseEntityId())).getNameProperty()))) continue;
                field.setDisplayProp(newDisplayProp);
                builderInfo.setChanged(true);
            }
            catch (Exception exception) {}
        }
        if (!isNewFilter.booleanValue()) {
            builderInfo.setChanged(true);
        }
        return builderInfo;
    }

    private void showModelList() {
        long currUserId;
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        int entryIndex = model.getEntryCurrentRowIndex("entryentity");
        Long systemId = (Long)model.getValue("systemid", entryIndex);
        Long modelId = (Long)model.getValue("modelid", entryIndex);
        String modelNewVersionMsg = ValidatorTipsUtil.isModelNewVersion(modelId);
        if (StringUtils.isNotEmpty((CharSequence)modelNewVersionMsg)) {
            IFormView listFlexView;
            view.showTipNotification(modelNewVersionMsg);
            String listFlexPageId = this.getPageCache().get("listFlexPageId");
            if (listFlexPageId != null && (listFlexView = view.getView(listFlexPageId)) != null) {
                listFlexView.invokeOperation("close");
                view.sendFormAction(listFlexView);
            }
            return;
        }
        QFilter filter = new QFilter("id", "=", (Object)modelId);
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"pa_analysismodel", (QFilter[])filter.toArray());
        String tableNumber = dynamicObject.getString("tablenumber");
        String entityNumber = AnalysisModelUtil.buildDetailEntityNumber((String)tableNumber);
        ListShowParameter lsp = new ListShowParameter();
        lsp.setBillFormId(entityNumber);
        lsp.setFormId("bos_list");
        lsp.setCaption(String.format(ResManager.loadKDString((String)"%s\u6570\u636e\u8865\u5f55\u5217\u8868", (String)"DataSupplementaryFormPlugin_0", (String)"macc-faf-formplugin", (Object[])new Object[0]), dynamicObject.get("tablename")));
        lsp.getCustomParams().put("analysis_system", systemId);
        lsp.getCustomParams().put("analysis_model", modelId);
        lsp.getOpenStyle().setShowType(ShowType.InContainer);
        lsp.setAppId(view.getFormShowParameter().getAppId());
        lsp.getOpenStyle().setTargetKey("listflex");
        List qFilters = lsp.getListFilterParameter().getQFilters();
        qFilters.add(new QFilter("importbatch", "!=", (Object)" "));
        this.getPageCache().put("listFlexPageId", lsp.getPageId());
        String orgField = null;
        DynamicObjectCollection dimensionCol = dynamicObject.getDynamicObjectCollection("dimension_entry");
        for (DynamicObject dimensionRow : dimensionCol) {
            DynamicObject dimension = dimensionRow.getDynamicObject("dimension");
            if (dimension == null) continue;
            String field = dimension.getString("number");
            String necessityDim = dimensionRow.getString("necessity_dim");
            if (!DimensionNecessityEnum.ORG.getCode().equals(necessityDim)) continue;
            orgField = field;
            break;
        }
        if (orgField != null && !PermissionServiceHelper.isSuperUser((long)(currUserId = RequestContext.get().getCurrUserId()))) {
            List permissionOrgIds = BusinessPermissionHelper.getUnionAppPermissionList((Long)currUserId, (String)"pa_anasystemsetting", (String)"3KAS06ROI392");
            if (permissionOrgIds != null && !permissionOrgIds.isEmpty()) {
                qFilters.add(new QFilter(orgField, "in", (Object)permissionOrgIds));
            } else {
                view.showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u6570\u636e\u8865\u5f55\u7684\u67e5\u8be2\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u6dfb\u52a0\u6743\u9650\u3002", (String)"DataSupplementaryFormPlugin_1", (String)"macc-faf-formplugin", (Object[])new Object[0]));
                return;
            }
        }
        view.showForm((FormShowParameter)lsp);
    }

    public void search(SearchEnterEvent searchEnterEvent) {
        String analysisSysName = searchEnterEvent.getText();
        this.initLabelEntry(analysisSysName);
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        String formId;
        String bizAppId = ShowFormHelper.getBizAppId((FormShowParameter)e.getFormShowParameter());
        LicenseCheckResult checkResult = LicenseUtil.Check(bizAppId, formId = e.getFormShowParameter().getFormId());
        boolean hasLicense = checkResult.getHasLicense();
        e.setCancel(!hasLicense);
        e.setCancelMessage(checkResult.getMsg());
        e.setCancelFormShowParameter(checkResult.getCancelFormShowParameter());
    }
}

