/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.system;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.faf.datasync.exec.AlgoXIncrementSummaryExecutor;
import kd.macc.faf.datasync.exec.data.DataSyncParams;
import kd.macc.faf.enums.DimensionNecessityEnum;
import kd.macc.faf.enums.DimensionTypeEnum;
import kd.macc.faf.enums.TimeTypeEnum;
import kd.macc.faf.helper.DLockHelper;
import kd.macc.faf.service.PeriodServiceHelper;
import kd.macc.faf.util.AnalysisModelUtil;

public class FAFAfterSuccessfulImportDataFormPlugin
extends BatchImportPlugin {
    public static final Log log = LogFactory.getLog(FAFAfterSuccessfulImportDataFormPlugin.class);
    private final List<String> otherBaseDimNumberList = new ArrayList<String>(4);
    private List<Long> successImportIdList = null;
    private Long analysisModelId = null;
    private DynamicObject analysisModelObj = null;
    private String entityNumber = null;
    private String modelOrgField = null;
    private String modelPeriodField = null;
    private String modelAccountField = null;
    private boolean isAccountBaseField = false;
    private String periodTypeForm = null;
    private TimeTypeEnum periodTypeEnum = null;
    private boolean isBasePeriod = true;

    protected void importData() throws Throwable {
        block12: {
            log.info("FAFAfterSuccessfulImportDataFormPlugin begin build param");
            if (this.analysisModelId == null) {
                this.analysisModelId = this.getAnalysisModelIdFromMeta();
            }
            if (this.analysisModelId != null) {
                this.analysisModelObj = BusinessDataServiceHelper.loadSingle((Object)this.analysisModelId, (String)"pa_analysismodel");
                this.buildField();
                this.entityNumber = AnalysisModelUtil.buildDetailEntityNumber((String)this.analysisModelObj.getString("tablenumber"));
            }
            DLock dLock = null;
            boolean tryLock = false;
            try {
                String lockKey = DLockHelper.getMLockKey((String)this.entityNumber);
                dLock = DLock.create((String)lockKey);
                if (dLock != null && dLock.tryLock(1000L)) {
                    if (DLockHelper.existsMOPLock((Long)this.analysisModelId)) {
                        DLock.forceUnlock((String[])new String[]{DLockHelper.getMLockKey((String)this.entityNumber)});
                        this.ctx.feedbackProgress(100, null, ResManager.loadKDString((String)"\u5f53\u524d\u5206\u6790\u6a21\u578b\u6b63\u5728\u8fdb\u884c\u5176\u4ed6\u4efb\u52a1\u7684\u6570\u636e\u5904\u7406\uff0c\u76ee\u524d\u65e0\u6cd5\u5bfc\u5165\u6570\u636e\uff0c\u8bf7\u7ec8\u6b62\u4efb\u52a1\uff0c\u7a0d\u540e\u518d\u8bd5\u3002", (String)"FAFAfterSuccessfulImportDataFormPlugin_0", (String)"macc-faf-formplugin", (Object[])new Object[0]));
                        this.getSaveWebApi().clear();
                        return;
                    }
                    tryLock = true;
                    log.info("FAFAfterSuccessfulImportDataFormPlugin begin save data");
                    super.importData();
                    if (this.successImportIdList != null && !this.successImportIdList.isEmpty()) {
                        DynamicObjectCollection successImportData;
                        log.info("FAFAfterSuccessfulImportDataFormPlugin begin build period and summary calculate");
                        QFilter idFilter = new QFilter("id", "in", this.successImportIdList);
                        String selectFields = this.modelOrgField + "," + this.modelPeriodField + "," + this.modelAccountField;
                        if (!this.otherBaseDimNumberList.isEmpty()) {
                            selectFields = selectFields + "," + String.join((CharSequence)",", this.otherBaseDimNumberList);
                        }
                        if ((successImportData = QueryServiceHelper.query((String)this.entityNumber, (String)selectFields, (QFilter[])idFilter.toArray())) != null && !successImportData.isEmpty()) {
                            if (this.isBasePeriod) {
                                this.supplementPeriodData(successImportData, this.analysisModelObj, this.analysisModelId);
                            }
                            this.summaryCalculate(successImportData, this.analysisModelObj, this.entityNumber, dLock);
                        }
                    } else {
                        log.info("FAFAfterSuccessfulImportDataFormPlugin no data to save, try to release lock");
                        DLock.forceUnlock((String[])new String[]{DLockHelper.getMLockKey((String)this.entityNumber)});
                    }
                } else {
                    this.ctx.feedbackProgress(100, null, ResManager.loadKDString((String)"\u5f53\u524d\u5206\u6790\u6a21\u578b\u6b63\u5728\u8fdb\u884c\u5176\u4ed6\u4efb\u52a1\u7684\u6570\u636e\u5904\u7406\uff0c\u76ee\u524d\u65e0\u6cd5\u5bfc\u5165\u6570\u636e\uff0c\u8bf7\u7ec8\u6b62\u4efb\u52a1\uff0c\u7a0d\u540e\u518d\u8bd5\u3002", (String)"FAFAfterSuccessfulImportDataFormPlugin_0", (String)"macc-faf-formplugin", (Object[])new Object[0]));
                    this.getSaveWebApi().clear();
                }
            }
            catch (Exception ex) {
                log.error("FAFAfterSuccessfulImportDataFormPlugin build period or summary calculate error", (Throwable)ex);
                if (dLock == null || !tryLock) break block12;
                DLock.forceUnlock((String[])new String[]{DLockHelper.getMLockKey((String)this.entityNumber)});
            }
        }
    }

    protected ApiResult save(List<ImportBillData> rowdatas, ImportLogger logger) {
        ApiResult result = super.save(rowdatas, logger);
        try {
            if (this.analysisModelId != null) {
                Object data = result.getData();
                if (data instanceof List) {
                    List dataList = (List)data;
                    if (this.successImportIdList == null) {
                        this.successImportIdList = new ArrayList<Long>(dataList.size());
                    }
                    for (Map dataMap : dataList) {
                        Object success = dataMap.get("success");
                        if (!Boolean.parseBoolean(String.valueOf(success))) continue;
                        Long dataId = Long.parseLong(String.valueOf(dataMap.get("id")));
                        this.successImportIdList.add(dataId);
                    }
                }
            } else {
                log.info("FAFAfterSuccessfulImportDataFormPlugin analysisModelId is empty, can not build successImportIdList");
            }
        }
        catch (Exception ex) {
            log.error(String.format("FAFAfterSuccessfulImportDataFormPlugin build successImportIdList error, analysisModelId\uff1a%d", this.analysisModelId), (Throwable)ex);
        }
        return result;
    }

    private Long getAnalysisModelIdFromMeta() {
        Object analysisModelIdObj;
        Map customProperties;
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)this.getBillFormId(), (MetaCategory)MetaCategory.Entity), (MetaCategory)MetaCategory.Entity);
        if (entityMetadata != null && (customProperties = entityMetadata.getRootEntity().getCustomProperties()) != null && (analysisModelIdObj = customProperties.get("analysis_model")) != null) {
            return Long.parseLong(String.valueOf(analysisModelIdObj));
        }
        return null;
    }

    private void buildField() {
        if (this.analysisModelObj == null) {
            return;
        }
        DynamicObjectCollection dimensionCol = this.analysisModelObj.getDynamicObjectCollection("dimension_entry");
        for (DynamicObject dimensionRow : dimensionCol) {
            DynamicObject dimension = dimensionRow.getDynamicObject("dimension");
            if (dimension == null) continue;
            String field = dimension.getString("number");
            String necessityDim = dimensionRow.getString("necessity_dim");
            DimensionTypeEnum dimensionType = DimensionTypeEnum.getEnum((String)dimension.getString("dimensiontype"));
            if (DimensionNecessityEnum.ORG.getCode().equals(necessityDim)) {
                this.modelOrgField = field;
                continue;
            }
            if (DimensionNecessityEnum.PERIOD.getCode().equals(necessityDim)) {
                this.modelPeriodField = field;
                DynamicObject dimensionSource = dimension.getDynamicObject("dimensionsource");
                if (dimensionSource != null) {
                    this.periodTypeForm = dimensionSource.getString("number");
                    log.info(String.format("FAFAfterSuccessfulImportDataFormPlugin periodType\uff1a%s", this.periodTypeForm));
                    if ("bd_period".equals(this.periodTypeForm) || "pa_analysisperiod".equals(this.periodTypeForm)) {
                        this.periodTypeEnum = TimeTypeEnum.PERIOD;
                        continue;
                    }
                    this.isBasePeriod = false;
                    continue;
                }
                log.info("FAFAfterSuccessfulImportDataFormPlugin dimensionSource is empty");
                this.isBasePeriod = false;
                if (DimensionTypeEnum.DATE != dimensionType) continue;
                this.periodTypeEnum = TimeTypeEnum.DATE;
                continue;
            }
            if (DimensionNecessityEnum.ACCOUNT.getCode().equals(necessityDim)) {
                this.modelAccountField = field;
                if (DimensionTypeEnum.DATABASE != dimensionType) continue;
                this.isAccountBaseField = true;
                continue;
            }
            if (DimensionTypeEnum.DATABASE != dimensionType) continue;
        }
    }

    private void summaryCalculate(DynamicObjectCollection successImportData, DynamicObject analysisModelObj, String entityNumber, DLock dLock) {
        log.info("FAFAfterSuccessfulImportDataFormPlugin, algoX summary calculate task begin");
        int size = this.successImportIdList.size();
        DataSyncParams params = new DataSyncParams();
        HashSet<Long> orgIdSet = new HashSet<Long>(size);
        HashSet<Long> periodIdSet = new HashSet<Long>(size);
        Date startDate = null;
        Date endDate = null;
        for (DynamicObject importData : successImportData) {
            orgIdSet.add(importData.getLong(this.modelOrgField));
            if (TimeTypeEnum.PERIOD == this.periodTypeEnum) {
                periodIdSet.add(importData.getLong(this.modelPeriodField));
                continue;
            }
            if (TimeTypeEnum.DATE != this.periodTypeEnum) continue;
            Date currentDate = importData.getDate(this.modelPeriodField);
            if (startDate == null || currentDate.before(startDate)) {
                startDate = currentDate;
            }
            if (endDate != null && !currentDate.after(endDate)) continue;
            endDate = currentDate;
        }
        params.setOrgIdSet(orgIdSet);
        if (TimeTypeEnum.PERIOD == this.periodTypeEnum) {
            params.setTimeType(TimeTypeEnum.PERIOD.getCode());
            params.setPeriodIdSet(periodIdSet);
        } else if (TimeTypeEnum.DATE == this.periodTypeEnum) {
            params.setTimeType(TimeTypeEnum.DATE.getCode());
            params.setStartDate(startDate);
            params.setEndDate(endDate);
            params.setPeriodIdSet(Collections.emptySet());
        } else {
            return;
        }
        if (TimeTypeEnum.DATE == this.periodTypeEnum) {
            AlgoXIncrementSummaryExecutor executor = new AlgoXIncrementSummaryExecutor(analysisModelObj, params);
            executor.asyncCommit(dLock);
        } else {
            Set collect = periodIdSet.stream().sorted(Comparator.naturalOrder()).collect(Collectors.toCollection(LinkedHashSet::new));
            for (Long period : collect) {
                params.setPeriodIdSet(Collections.singleton(period));
                AlgoXIncrementSummaryExecutor executor = new AlgoXIncrementSummaryExecutor(analysisModelObj, params);
                executor.asyncCommit(dLock);
            }
        }
    }

    private void supplementPeriodData(DynamicObjectCollection successImportData, DynamicObject analysisModelObj, Long analysisModelId) {
        ArrayList orgAndPeriodList = new ArrayList(successImportData.size());
        for (DynamicObject importData : successImportData) {
            HashMap<Long, Long> mp = new HashMap<Long, Long>(1);
            mp.put(importData.getLong(this.modelOrgField), importData.getLong(this.modelPeriodField));
            orgAndPeriodList.add(mp);
        }
        log.info(String.format("FAFAfterSuccessfulImportDataFormPlugin whether to add periodClock,orgAndPeriodList\uff1a%s", JSON.toJSONString(orgAndPeriodList)));
        PeriodServiceHelper.batchCreateCtrlRecord((long)analysisModelObj.getLong("analysis_system_id"), (long)analysisModelId, orgAndPeriodList, (String)this.periodTypeForm);
    }
}

