/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.system;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.param.AppCustomParam;
import kd.bos.entity.property.RefProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.AbstractElement;
import kd.bos.metadata.Plugin;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.businessfield.AssistantField;
import kd.bos.metadata.entity.businessfield.BasedataField;
import kd.bos.metadata.entity.businessfield.CreateDateField;
import kd.bos.metadata.entity.commonfield.DateTimeField;
import kd.bos.metadata.form.BasedataFormAp;
import kd.bos.metadata.form.FormAp;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataRefrenceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.macc.faf.datareview.FAFDataReview2Plugin;
import kd.macc.faf.engine.task.impl.FAFDataEntityCreateTask;
import kd.macc.faf.enums.DimensionNecessityEnum;
import kd.macc.faf.enums.DimensionTypeEnum;
import kd.macc.faf.enums.FAFDimensionTypeEnum;
import kd.macc.faf.enums.FAFSyncLogStatusEnum;
import kd.macc.faf.enums.ImportSystemSourceTypeEnum;
import kd.macc.faf.enums.ModelVersionEnum;
import kd.macc.faf.helper.EntityMetaHelper;
import kd.macc.faf.helper.FAFAnalysisModelHelper;
import kd.macc.faf.helper.FAFDimensionHelper;
import kd.macc.faf.helper.FAFMeasureHelper;
import kd.macc.faf.model.impl.IDataMapEntry;
import kd.macc.faf.system.FAFAnalysisModelOperationPlugin;
import kd.macc.faf.system.FAFAnalysisSystemConfigEdit;
import kd.macc.faf.system.FAFDynamicMetaImportPlugin;
import kd.macc.faf.system.ModelMarks;
import kd.macc.faf.util.AnalysisModelUtil;
import kd.macc.faf.util.CustomizedDynamicFormBuilderUtil;
import kd.macc.faf.util.CustomizedFormBuilderInfo;
import kd.macc.faf.util.ValidatorTipsUtil;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class FAFAnalysisModelEdit
extends FAFAnalysisModelOperationPlugin
implements BeforeF7SelectListener {
    private static final Log logger = LogFactory.getLog(FAFAnalysisModelEdit.class);
    private static final String ACTION_REBUILD = "rebuild";
    private static final String ITEMCLASS_TYPEFIELD = "itemclasstypefield";
    private static Set<String> COLLECTEXTRAFIELDS = null;
    private static Set<String> DETAILEXTRAFIELDS = null;

    public FAFAnalysisModelEdit() {
        COLLECTEXTRAFIELDS = new HashSet<String>(10);
        COLLECTEXTRAFIELDS.add("del");
        COLLECTEXTRAFIELDS.add("collectstatus");
        COLLECTEXTRAFIELDS.add("createtime");
        COLLECTEXTRAFIELDS.add("operationstatus");
        COLLECTEXTRAFIELDS.add("offstatus");
        COLLECTEXTRAFIELDS.add("datastatus");
        COLLECTEXTRAFIELDS.add("importbatch");
        COLLECTEXTRAFIELDS.add("situationtype");
        COLLECTEXTRAFIELDS.add("dimhash");
        DETAILEXTRAFIELDS = new HashSet<String>(COLLECTEXTRAFIELDS);
        DETAILEXTRAFIELDS.add("createstamp");
        DETAILEXTRAFIELDS.add("summaryid");
        DETAILEXTRAFIELDS.add("sourceformid");
        DETAILEXTRAFIELDS.add("sourcebillid");
        DETAILEXTRAFIELDS.add("execlogid");
        DETAILEXTRAFIELDS.add("subexeclogid");
        DETAILEXTRAFIELDS.add("execparentbillid");
    }

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        this.addItemClickListeners(new String[]{"dim_advcontool", "measure_advcontool", "tbmain"});
        this.addClickListeners(new String[]{"field_name", "measure_fieldname"});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        this.setVisible();
        Long id = (Long)model.getValue("id");
        if (id != 0L && BaseDataRefrenceHelper.isRefrenced((String)"pa_analysismodel", (Object)id)) {
            view.setEnable(Boolean.FALSE, new String[]{"number", "analysis_system", "periodtype", "accounttable", "tablenumber", "tablename", "description", ITEMCLASS_TYPEFIELD});
            view.setEnable(Boolean.FALSE, -1, new String[]{"necessity_dim"});
            this.getPageCache().put("reference", "true");
        }
        model.beginInit();
        this.setPeriodTypeAndAccountTable();
        model.endInit();
        view.updateView("dimension_entry");
        view.updateView("fs_baseinfo");
        this.setEntryRowDisable();
        model.setDataChanged(false);
    }

    private void setVisible() {
        IFormView view = this.getView();
        if (StringUtils.isNotEmpty((CharSequence)this.getModel().getValue("tablenumber").toString())) {
            view.setVisible(Boolean.FALSE, new String[]{"create_table"});
        } else {
            view.setVisible(Boolean.FALSE, new String[]{"tablename", "tablenumber"});
        }
        view.setVisible(Boolean.FALSE, new String[]{"dim_mulbase", "measure_mulbase", ITEMCLASS_TYPEFIELD});
        Object tableNumber = this.getModel().getValue("tablenumber");
        if (tableNumber != null && !"".equals(tableNumber.toString())) {
            boolean exist = this.rebuildMetaAndFields(false);
            view.setVisible(Boolean.valueOf(!exist), new String[]{ACTION_REBUILD});
        } else {
            view.setVisible(Boolean.FALSE, new String[]{ACTION_REBUILD});
        }
    }

    public boolean rebuildMetaAndFields(boolean rebuild) {
        boolean result = true;
        IDataModel model = this.getModel();
        Object tableNumber = this.getModel().getValue("tablenumber");
        if (tableNumber == null || StringUtils.isEmpty((CharSequence)tableNumber.toString())) {
            return result;
        }
        String inputTableNumber = tableNumber.toString();
        String inputTableName = model.getValue("tablename").toString();
        DynamicObject analysisModel = BusinessDataServiceHelper.loadSingle((Object)model.getValue("id"), (String)"pa_analysismodel");
        if (MetadataDao.checkNumber((String)AnalysisModelUtil.buildEntityNumber((String)inputTableNumber))) {
            Set infoKeys;
            CustomizedFormBuilderInfo builderInfo = this.getCustomizedFormBuilderInfo(model, inputTableNumber, inputTableName);
            List items = builderInfo.getEntityMeta().getItems();
            if (items != null && !(infoKeys = items.stream().map(AbstractElement::getKey).collect(Collectors.toSet())).containsAll(COLLECTEXTRAFIELDS)) {
                logger.info("MACC-FAF:summary sheet need rebuild, field missing!");
                if (rebuild) {
                    IDataMapEntry ans = FAFDataEntityCreateTask.rebuildMeta((DynamicObject)analysisModel, (String)inputTableNumber, (String)inputTableName, (boolean)false, (Boolean)Boolean.FALSE);
                    this.showRebuildMessage((FAFSyncLogStatusEnum)ans.getKey(), inputTableNumber);
                }
                result = false;
            }
        } else {
            logger.info("MACC-FAF:summary sheet need rebuild, Meta missing!");
            if (rebuild) {
                IDataMapEntry ans = FAFDataEntityCreateTask.rebuildMeta((DynamicObject)analysisModel, (String)inputTableNumber, (String)inputTableName, (boolean)false, (Boolean)Boolean.TRUE);
                this.showRebuildMessage((FAFSyncLogStatusEnum)ans.getKey(), inputTableNumber);
            }
            result = false;
        }
        String tableNumber_dtl = inputTableNumber + "_d";
        String inputTableName_dtl = String.format(ResManager.loadKDString((String)"%s_\u660e\u7ec6\u8868", (String)"FAFDataEntityCreateTask_15", (String)"macc-faf-common", (Object[])new Object[0]), inputTableName);
        if (MetadataDao.checkNumber((String)AnalysisModelUtil.buildEntityNumber((String)tableNumber_dtl))) {
            Set infoKeys;
            CustomizedFormBuilderInfo builderInfo = this.getCustomizedFormBuilderInfo(model, tableNumber_dtl, inputTableName_dtl);
            List items = builderInfo.getEntityMeta().getItems();
            if (items != null && !(infoKeys = items.stream().map(AbstractElement::getKey).collect(Collectors.toSet())).containsAll(DETAILEXTRAFIELDS)) {
                logger.info("MACC-FAF:detail sheet need rebuild, field missing!");
                if (rebuild) {
                    IDataMapEntry ans = FAFDataEntityCreateTask.rebuildMeta((DynamicObject)analysisModel, (String)tableNumber_dtl, (String)inputTableName_dtl, (boolean)true, (Boolean)Boolean.FALSE);
                    this.showRebuildMessage((FAFSyncLogStatusEnum)ans.getKey(), tableNumber_dtl);
                }
                result = false;
            }
        } else {
            logger.info("MACC-FAF:detail sheet need rebuild, Meta missing!");
            if (rebuild) {
                IDataMapEntry ans = FAFDataEntityCreateTask.rebuildMeta((DynamicObject)analysisModel, (String)tableNumber_dtl, (String)inputTableName_dtl, (boolean)true, (Boolean)Boolean.TRUE);
                this.showRebuildMessage((FAFSyncLogStatusEnum)ans.getKey(), tableNumber_dtl);
            }
            result = false;
        }
        return result;
    }

    private void showRebuildMessage(FAFSyncLogStatusEnum statusEnum, String tableNumber) {
        switch (statusEnum) {
            case SUCCESS: {
                this.getView().showSuccessNotification(String.format(ResManager.loadKDString((String)"\u6a21\u578b\uff1a%s\u91cd\u6784\u5143\u6570\u636e\u6210\u529f\u3002", (String)"FAFAnalysisModelEdit_31", (String)"macc-faf-formplugin", (Object[])new Object[0]), AnalysisModelUtil.buildEntityNumber((String)tableNumber)));
                break;
            }
            case FAILURE: {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u6a21\u578b\uff1a%s\u91cd\u6784\u5143\u6570\u636e\u5931\u8d25\u3002", (String)"FAFAnalysisModelEdit_32", (String)"macc-faf-formplugin", (Object[])new Object[0]), AnalysisModelUtil.buildEntityNumber((String)tableNumber)));
                break;
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        IFormView view = this.getView();
        Long anaSystemId = (Long)view.getFormShowParameter().getCustomParam("analysis_system");
        if (anaSystemId != null && anaSystemId != 0L) {
            this.getModel().setValue("analysis_system", (Object)anaSystemId);
            this.getModel().setValue("isnewlistfilter", (Object)Boolean.TRUE);
            this.getModel().setValue("marks", (Object)ModelMarks.defaultMarks());
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String operationKy = evt.getItemKey();
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        Object analysisSystem = model.getValue("analysis_system");
        switch (operationKy) {
            case "add_dim": {
                if (analysisSystem == null) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5206\u6790\u4f53\u7cfb\u3002", (String)"FAFAnalysisModelEdit_0", (String)"macc-faf-formplugin", (Object[])new Object[0]));
                    return;
                }
                BasedataEdit edit = (BasedataEdit)this.getControl("dim_mulbase");
                edit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
                edit.click();
                break;
            }
            case "add_measure": {
                if (analysisSystem == null) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5206\u6790\u4f53\u7cfb\u3002", (String)"FAFAnalysisModelEdit_0", (String)"macc-faf-formplugin", (Object[])new Object[0]));
                    return;
                }
                BasedataEdit edit = (BasedataEdit)this.getControl("measure_mulbase");
                edit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
                edit.click();
                break;
            }
            case "preview_model": {
                String[] fieldNameArray;
                String fieldNames;
                int i;
                FormShowParameter parameter = new FormShowParameter();
                parameter.getOpenStyle().setShowType(ShowType.Modal);
                parameter.setFormId("pa_preview_model");
                int dimEntryCount = model.getEntryRowCount("dimension_entry");
                int measureEntryCount = model.getEntryRowCount("measure_entry");
                ArrayList<String> hadSelectFields = new ArrayList<String>(dimEntryCount + measureEntryCount);
                for (i = 0; i < dimEntryCount; ++i) {
                    fieldNames = model.getValue("field_name", i).toString();
                    String dimName = ((DynamicObject)model.getValue("dimension", i)).getString("name");
                    if (StringUtils.isEmpty((CharSequence)fieldNames)) {
                        hadSelectFields.add(String.format(ResManager.loadKDString((String)"%s\u7f16\u53f7", (String)"FAFAnalysisModelEdit_1", (String)"macc-faf-formplugin", (Object[])new Object[0]), dimName));
                        hadSelectFields.add(String.format(ResManager.loadKDString((String)"%s\u540d\u79f0", (String)"FAFAnalysisModelEdit_2", (String)"macc-faf-formplugin", (Object[])new Object[0]), dimName));
                        continue;
                    }
                    for (String fieldName : fieldNameArray = fieldNames.split(",")) {
                        hadSelectFields.add(dimName + fieldName);
                    }
                }
                for (i = 0; i < measureEntryCount; ++i) {
                    fieldNames = model.getValue("measure_fieldname", i).toString();
                    String measureName = ((DynamicObject)model.getValue("measure", i)).getString("name");
                    for (String fieldName : fieldNameArray = fieldNames.split(",")) {
                        hadSelectFields.add(measureName + fieldName);
                    }
                }
                parameter.setCustomParam("had_selectField", hadSelectFields);
                parameter.setShowTitle(false);
                view.showForm(parameter);
                break;
            }
            case "create_table": {
                this.showCreateTable();
                break;
            }
            case "viewdata": {
                this.showViewData();
                break;
            }
            case "rebuild": {
                this.rebuildMetaAndFields(true);
                this.setVisible();
                break;
            }
        }
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        IDataModel model = this.getModel();
        String key = ((FormOperate)args.getSource()).getOperateKey();
        if (("deleteentry_dim".equals(key) || "deleteentry_measure".equals(key)) && (StringUtils.isNotEmpty((CharSequence)model.getValue("tablenumber").toString()) || "true".equals(this.getPageCache().get("reference")))) {
            String messageEntry;
            String rowIdKey;
            String controlKey;
            if ("deleteentry_dim".equals(key)) {
                controlKey = "dimension_entry";
                rowIdKey = "dimension_entry.id";
                messageEntry = ResManager.loadKDString((String)"\u7ef4\u5ea6", (String)"FAFAnalysisModelEdit_4", (String)"macc-faf-formplugin", (Object[])new Object[0]);
            } else {
                controlKey = "measure_entry";
                rowIdKey = "measure_entry.id";
                messageEntry = ResManager.loadKDString((String)"\u5ea6\u91cf", (String)"FAFAnalysisModelEdit_5", (String)"macc-faf-formplugin", (Object[])new Object[0]);
            }
            EntryGrid entryGrid = (EntryGrid)this.getControl(controlKey);
            int[] selectRows = entryGrid.getSelectRows();
            ArrayList<Integer> canCancelRow = new ArrayList<Integer>(selectRows.length);
            StringBuilder messageStringBuilder = new StringBuilder();
            for (int selectRow : selectRows) {
                if (model.getValue(rowIdKey, selectRow).equals(0L)) {
                    canCancelRow.add(selectRow);
                    continue;
                }
                messageStringBuilder.append(selectRow + 1).append("\u3001");
            }
            if (canCancelRow.isEmpty()) {
                args.setCancel(true);
            } else {
                int[] integers = Arrays.stream(canCancelRow.toArray(new Integer[0])).mapToInt(Integer::valueOf).toArray();
                entryGrid.selectRows(integers, integers[0]);
            }
            if (messageStringBuilder.length() > 0) {
                if (StringUtils.isEmpty((CharSequence)model.getValue("tablenumber").toString())) {
                    this.getView().showMessage(String.format(ResManager.loadKDString((String)"\u7531\u4e8e\u5206\u6790\u6a21\u578b\u5b58\u5728\u5f15\u7528\uff0c\u5df2\u4fdd\u5b58\u7684\u7b2c%1$s\u884c%2$s\u4e0d\u53ef\u5220\u9664\u3002", (String)"FAFAnalysisModelEdit_6", (String)"macc-faf-formplugin", (Object[])new Object[0]), messageStringBuilder.substring(0, messageStringBuilder.length() - 1), messageEntry));
                } else {
                    this.getView().showMessage(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c%2$s\u5df2\u521b\u5efa\u5bf9\u5e94\u7684\u6a21\u578b\u8868\u5b57\u6bb5\uff0c\u4e0d\u53ef\u5220\u9664\u3002", (String)"FAFAnalysisModelEdit_7", (String)"macc-faf-formplugin", (Object[])new Object[0]), messageStringBuilder.substring(0, messageStringBuilder.length() - 1), messageEntry));
                }
            }
        } else if ("save".equals(key)) {
            int entryRowCount = model.getEntryRowCount("dimension_entry");
            for (int i = 0; i < entryRowCount; ++i) {
                DynamicObject dimension;
                String fieldNumber = (String)model.getValue("field_number_tag", i);
                if (!StringUtils.isEmpty((CharSequence)fieldNumber) || (dimension = (DynamicObject)model.getValue("dimension", i)) == null) continue;
                String dimensionType = dimension.getString("dimensiontype");
                if (!DimensionTypeEnum.DATABASE.getCodeString().equals(dimensionType) && !DimensionTypeEnum.ASSISTANTDATA.getCodeString().equals(dimensionType) && !DimensionTypeEnum.PERIOD.getCodeString().equals(dimensionType)) continue;
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%d\u884c\u8bf7\u9009\u62e9\u5b57\u6bb5\u3002", (String)"FAFAnalysisModelEdit_24", (String)"macc-faf-formplugin", (Object[])new Object[0]), i + 1));
                args.setCancel(true);
                return;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        OperationResult operationResult = args.getOperationResult();
        if ("save".equals(operateKey) && operationResult.isSuccess()) {
            FAFAnalysisSystemConfigEdit.refreshParentPageAfterSave(this.getView());
            this.addTableField();
        } else if ("deleteentry_dim".equals(operateKey)) {
            this.setPeriodTypeAndAccountTable();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String changeName;
        IDataModel model = this.getModel();
        switch (changeName = e.getProperty().getName()) {
            case "necessity_dim": {
                ChangeData changeSet = e.getChangeSet()[0];
                if (changeSet.getNewValue() == null || "".equals(changeSet.getNewValue())) {
                    if (DimensionNecessityEnum.ACCOUNT.getCode().equals(changeSet.getOldValue())) {
                        model.setValue("accounttable", null);
                    } else if (DimensionNecessityEnum.PERIOD.getCode().equals(changeSet.getOldValue())) {
                        model.setValue("periodtype", null);
                    }
                    return;
                }
                model.beginInit();
                int rowIndex = changeSet.getRowIndex();
                String newValue = changeSet.getNewValue().toString();
                int entryRowCount = model.getEntryRowCount("dimension_entry");
                for (int i = 0; i < entryRowCount; ++i) {
                    Object value;
                    if (rowIndex == i || !newValue.equals(value = model.getValue("necessity_dim", i))) continue;
                    model.setValue("necessity_dim", null, i);
                }
                this.setPeriodTypeAndAccountTable();
                model.endInit();
                this.getView().updateView("dimension_entry");
                this.getView().updateView("fs_baseinfo");
                this.setEntryRowDisable();
                break;
            }
            case "field_name": {
                if (e.getChangeSet() == null || !StringUtils.isEmpty((CharSequence)e.getChangeSet()[0].getNewValue().toString())) break;
                model.setValue("field_number_tag", null);
                break;
            }
            case "analysis_system": {
                model.deleteEntryData("dimension_entry");
                model.deleteEntryData("measure_entry");
                model.setValue("dim_mulbase", null);
                model.setValue("measure_mulbase", null);
                break;
            }
        }
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        IDataModel model = this.getModel();
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "field_name": {
                int dimensionEntryIndex = model.getEntryCurrentRowIndex("dimension_entry");
                DynamicObjectCollection dynamicObjects = ((DynamicObject)model.getValue("dimension", dimensionEntryIndex)).getDynamicObjectCollection("dimensionentryentity");
                HashMap<String, String> availableField = null;
                if (!dynamicObjects.isEmpty()) {
                    availableField = new HashMap<String, String>(dynamicObjects.size());
                    for (DynamicObject dynObject : dynamicObjects) {
                        availableField.put(dynObject.getString("fieldnumber"), dynObject.getString("fieldname"));
                    }
                }
                FormShowParameter parameter = new FormShowParameter();
                parameter.getOpenStyle().setShowType(ShowType.Modal);
                parameter.setFormId("pa_fieldselectpopup");
                parameter.setCaption(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5b57\u6bb5", (String)"FAFAnalysisModelEdit_8", (String)"macc-faf-formplugin", (Object[])new Object[0]));
                parameter.setCustomParam("had_selectField", model.getValue("field_number_tag", dimensionEntryIndex));
                parameter.setCustomParam("param_available_field", availableField);
                parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "dim_fieldselect_popup_callback"));
                this.getView().showForm(parameter);
                break;
            }
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        IDataModel model = this.getModel();
        AbstractFormDataModel formModel = (AbstractFormDataModel)model;
        IFormView view = this.getView();
        Object returnData = closedCallBackEvent.getReturnData();
        if (returnData == null) {
            return;
        }
        switch (closedCallBackEvent.getActionId()) {
            case "dim_mulbase": {
                Collection returnCollection = (Collection)returnData;
                ArrayList<Object> primaryKeys = new ArrayList<Object>(returnCollection.size());
                for (Object dimId : returnCollection) {
                    Object primaryKeyValue = ((ListSelectedRow)dimId).getPrimaryKeyValue();
                    primaryKeys.add(primaryKeyValue);
                }
                Map dimensionMap = BusinessDataServiceHelper.loadFromCache((String)"pa_dimension", (String)"id,isdefault,dimensiontype,systemsource", (QFilter[])new QFilter("id", "in", primaryKeys).toArray(), (String)"isdefault, id DESC ");
                Tuple<Boolean, String> t1 = this.validateCountOfEntryBySystemParam(dimensionMap.values(), "0");
                if (!((Boolean)t1.item1).booleanValue()) {
                    this.getView().showTipNotification((String)t1.item2);
                    return;
                }
                Tuple<Boolean, String> t2 = this.validateSystemSource(dimensionMap.values(), "0");
                if (!((Boolean)t2.item1).booleanValue()) {
                    this.getView().showTipNotification((String)t2.item2);
                    return;
                }
                model.beginInit();
                this.addDimensionEntryBySelect(dimensionMap);
                this.setPeriodTypeAndAccountTable();
                model.endInit();
                view.updateView("dimension_entry");
                view.updateView("fs_baseinfo");
                break;
            }
            case "measure_mulbase": {
                Collection returnCollection = (Collection)returnData;
                ArrayList primaryKeys = new ArrayList(returnCollection.size());
                for (Object dimId : returnCollection) {
                    Iterator primaryKeyValue = ((ListSelectedRow)dimId).getPrimaryKeyValue();
                    primaryKeys.add(primaryKeyValue);
                }
                Map measureMap = BusinessDataServiceHelper.loadFromCache((String)"pa_measure", (String)"id,systemsource", (QFilter[])new QFilter("id", "in", primaryKeys).toArray(), null);
                Tuple<Boolean, String> t1 = this.validateCountOfEntryBySystemParam(measureMap.values(), "1");
                if (!((Boolean)t1.item1).booleanValue()) {
                    this.getView().showTipNotification((String)t1.item2);
                    return;
                }
                Tuple<Boolean, String> t2 = this.validateSystemSource(measureMap.values(), "1");
                if (!((Boolean)t2.item1).booleanValue()) {
                    this.getView().showTipNotification((String)t2.item2);
                    return;
                }
                formModel.beginInit();
                TableValueSetter tvs = new TableValueSetter(new String[0]);
                tvs.addField("measure", new Object[0]);
                tvs.addField("measure_fieldname", new Object[0]);
                tvs.addField("measure_fieldnumber", new Object[0]);
                for (Object e : primaryKeys) {
                    tvs.addRow(new Object[]{e, ResManager.loadKDString((String)"\u540d\u79f0", (String)"FAFAnalysisModelEdit_9", (String)"macc-faf-formplugin", (Object[])new Object[0]), "name"});
                }
                formModel.batchCreateNewEntryRow("measure_entry", tvs);
                formModel.endInit();
                view.updateView("measure_entry");
                break;
            }
            case "dim_fieldselect_popup_callback": {
                if (closedCallBackEvent.getReturnData() == null) break;
                Map selectFields = (Map)closedCallBackEvent.getReturnData();
                int n = model.getEntryCurrentRowIndex("dimension_entry");
                DynamicObjectCollection dimEntry = model.getEntryEntity("dimension_entry");
                DynamicObject entry = (DynamicObject)dimEntry.get(n);
                entry.set("field_name", (Object)StringUtils.join((Object[])selectFields.values().toArray(new String[0]), (char)','));
                entry.set("field_number_tag", (Object)StringUtils.join((Object[])selectFields.keySet().toArray(new String[0]), (char)','));
                view.updateView("dimension_entry");
                break;
            }
            case "callback_create_table": {
                this.setTableFromReturnData(returnData);
                break;
            }
        }
    }

    private Tuple<Boolean, String> validateCountOfEntryBySystemParam(Collection<DynamicObject> entryMap, String type) {
        int entryCount;
        String notification;
        int maxCount;
        int defaultCount;
        String settingValueStr;
        int currentRowCount;
        AppInfo appInfo = AppMetadataCache.getAppInfo((String)"faf");
        AppCustomParam appCustomParam = new AppCustomParam(appInfo.getId(), Stream.of("dimension_numb", "measure_numb").collect(Collectors.toSet()));
        Map customParameterMap = SystemParamServiceHelper.loadAppCustomParameterFromCache((AppCustomParam)appCustomParam);
        switch (type) {
            case "0": {
                currentRowCount = this.getModel().getEntryRowCount("dimension_entry");
                settingValueStr = (String)customParameterMap.get("dimension_numb");
                defaultCount = 40;
                maxCount = 80;
                notification = ResManager.loadKDString((String)"\u5206\u6790\u6a21\u578b\u53ea\u5141\u8bb8\u6dfb\u52a0%s\u4e2a\u7ef4\u5ea6\u3002", (String)"FAFAnalysisModelEdit_29", (String)"macc-faf-formplugin", (Object[])new Object[0]);
                break;
            }
            case "1": {
                currentRowCount = this.getModel().getEntryRowCount("measure_entry");
                settingValueStr = (String)customParameterMap.get("measure_numb");
                defaultCount = 10;
                maxCount = 50;
                notification = ResManager.loadKDString((String)"\u5206\u6790\u6a21\u578b\u53ea\u5141\u8bb8\u6dfb\u52a0%s\u4e2a\u5ea6\u91cf\u3002", (String)"FAFAnalysisModelEdit_30", (String)"macc-faf-formplugin", (Object[])new Object[0]);
                break;
            }
            default: {
                throw new KDBizException("Illegal Entry Type In Model");
            }
        }
        try {
            int settingValue = Integer.parseInt(settingValueStr);
            entryCount = 0 < settingValue && settingValue <= maxCount ? settingValue : (settingValue > maxCount ? maxCount : defaultCount);
        }
        catch (NumberFormatException numberFormatException) {
            entryCount = defaultCount;
        }
        if (currentRowCount + entryMap.size() > entryCount) {
            return new Tuple((Object)Boolean.FALSE, (Object)String.format(notification, entryCount));
        }
        return new Tuple((Object)Boolean.TRUE, null);
    }

    private Tuple<Boolean, String> validateSystemSource(Collection<DynamicObject> dynamicObjects, String type) {
        HashSet<ImportSystemSourceTypeEnum> importSystemSourceTypeEnumSet = new HashSet<ImportSystemSourceTypeEnum>(2);
        for (DynamicObject dynamicObject2 : dynamicObjects) {
            ImportSystemSourceTypeEnum dynamicObjectSystemSource = ImportSystemSourceTypeEnum.getEnumByCode((String)dynamicObject2.getString("systemsource"));
            if (dynamicObjectSystemSource == ImportSystemSourceTypeEnum.NEW) continue;
            importSystemSourceTypeEnumSet.add(dynamicObjectSystemSource);
        }
        if (importSystemSourceTypeEnumSet.size() > 1) {
            return new Tuple((Object)Boolean.FALSE, (Object)ResManager.loadKDString((String)"\u5df2\u9009\u7ef4\u5ea6/\u5ea6\u91cf\u5bf9\u5e94\u591a\u4e2a\u6765\u6e90\u4f53\u7cfb\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"FAFAnalysisModelEdit_21", (String)"macc-faf-formplugin", (Object[])new Object[0]));
        }
        if (importSystemSourceTypeEnumSet.size() == 0) {
            return new Tuple((Object)Boolean.TRUE, (Object)"");
        }
        ImportSystemSourceTypeEnum importSystemSourceTypeEnum = importSystemSourceTypeEnumSet.stream().findFirst().orElseGet(() -> null);
        List importPkIds = dynamicObjects.stream().filter(dynamicObject -> ImportSystemSourceTypeEnum.NEW != ImportSystemSourceTypeEnum.getEnumByCode((String)dynamicObject.getString("systemsource"))).map(dynamicObject -> dynamicObject.get("id")).collect(Collectors.toList());
        switch (importSystemSourceTypeEnum) {
            case BCM: 
            case EPM: {
                switch (type) {
                    case "0": {
                        DynamicObjectCollection dimensionMappings = FAFDimensionHelper.queryDimensionMappingByDimensionIds(importPkIds, (ImportSystemSourceTypeEnum)importSystemSourceTypeEnum);
                        if (CollectionUtils.isEmpty((Collection)dimensionMappings)) {
                            return new Tuple((Object)Boolean.FALSE, (Object)"");
                        }
                        Set dimensionModelIdSet = dimensionMappings.stream().map(mapping -> mapping.getLong("immodel")).collect(Collectors.toSet());
                        if (dimensionModelIdSet.size() == 1) {
                            return new Tuple((Object)Boolean.TRUE, (Object)"");
                        }
                        return new Tuple((Object)Boolean.FALSE, (Object)ResManager.loadKDString((String)"\u5df2\u9009\u7ef4\u5ea6/\u5ea6\u91cf\u5bf9\u5e94\u591a\u4e2a\u6765\u6e90\u4f53\u7cfb\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"FAFAnalysisModelEdit_21", (String)"macc-faf-formplugin", (Object[])new Object[0]));
                    }
                    case "1": {
                        String message;
                        DynamicObjectCollection measureMappings = FAFMeasureHelper.queryMeasureMappingByMeasureIds(importPkIds, (ImportSystemSourceTypeEnum)importSystemSourceTypeEnum);
                        if (CollectionUtils.isEmpty((Collection)measureMappings)) {
                            return new Tuple((Object)Boolean.FALSE, (Object)"");
                        }
                        Set measureModelIdSet = measureMappings.stream().map(mapping -> mapping.getLong("immodel")).collect(Collectors.toSet());
                        if (measureModelIdSet.size() != 1) {
                            return new Tuple((Object)Boolean.FALSE, (Object)ResManager.loadKDString((String)"\u5df2\u9009\u7ef4\u5ea6/\u5ea6\u91cf\u5bf9\u5e94\u591a\u4e2a\u6765\u6e90\u4f53\u7cfb\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"FAFAnalysisModelEdit_21", (String)"macc-faf-formplugin", (Object[])new Object[0]));
                        }
                        boolean isConsistent = Boolean.TRUE;
                        Map<Long, List<DynamicObject>> importMeasureMappingsGroupByMeasureId = measureMappings.stream().collect(Collectors.groupingBy(mapping -> mapping.getLong("measure")));
                        List<Object> dimNumberOfMeasure = new ArrayList();
                        for (Map.Entry<Long, List<DynamicObject>> measureIdMappingsEntry : importMeasureMappingsGroupByMeasureId.entrySet()) {
                            List<DynamicObject> mappingsOfCurrentMeasureId = measureIdMappingsEntry.getValue();
                            List mappingDimNumbersGroupByMeasureId = mappingsOfCurrentMeasureId.stream().map(dy -> dy.getString("entryimdimnumber")).collect(Collectors.toList());
                            if (CollectionUtils.isEmpty(dimNumberOfMeasure)) {
                                dimNumberOfMeasure = mappingDimNumbersGroupByMeasureId;
                                continue;
                            }
                            if (mappingDimNumbersGroupByMeasureId.size() != dimNumberOfMeasure.size()) {
                                isConsistent = false;
                                break;
                            }
                            ArrayList<Object> dimNumberOfMeasureCopy = new ArrayList<Object>(dimNumberOfMeasure);
                            dimNumberOfMeasureCopy.retainAll(mappingDimNumbersGroupByMeasureId);
                            if (dimNumberOfMeasureCopy.size() == mappingDimNumbersGroupByMeasureId.size()) continue;
                            isConsistent = false;
                            break;
                        }
                        if (isConsistent) {
                            return new Tuple((Object)Boolean.TRUE, (Object)"");
                        }
                        switch (importSystemSourceTypeEnum) {
                            case BCM: {
                                message = ResManager.loadKDString((String)"\u540c\u4e00\u5408\u5e76\u4f53\u7cfb\u4e0b\uff0c\u6240\u9009\u5ea6\u91cf\u7684\u6765\u6e90\u7ef4\u5ea6\u5fc5\u987b\u76f8\u540c\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"FAFAnalysisModelEdit_22", (String)"macc-faf-formplugin", (Object[])new Object[0]);
                                break;
                            }
                            case EPM: {
                                message = ResManager.loadKDString((String)"\u540c\u4e00\u9884\u7b97\u4f53\u7cfb\u4e0b\uff0c\u6240\u9009\u5ea6\u91cf\u7684\u6765\u6e90\u7ef4\u5ea6\u5fc5\u987b\u76f8\u540c\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"FAFAnalysisModelEdit_23", (String)"macc-faf-formplugin", (Object[])new Object[0]);
                                break;
                            }
                            default: {
                                throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u7cfb\u7edf\u6765\u6e90\u7c7b\u578b", (String)"FAFAnalysisModelEdit_27", (String)"macc-faf-formplugin", (Object[])new Object[0]));
                            }
                        }
                        return new Tuple((Object)Boolean.FALSE, (Object)message);
                    }
                }
                return new Tuple((Object)Boolean.FALSE, (Object)"");
            }
        }
        return new Tuple((Object)Boolean.TRUE, (Object)"");
    }

    private void addDimensionEntryBySelect(Map<Object, DynamicObject> dynamicObjectMap) {
        HashMap<Object, String> defaultDimensionPrimaryKeyMap = new HashMap<Object, String>(3);
        for (Map.Entry<Object, DynamicObject> entry : dynamicObjectMap.entrySet()) {
            if (!entry.getValue().getBoolean("isdefault")) continue;
            String number = entry.getValue().getString("number");
            if ("org".equals(number)) {
                defaultDimensionPrimaryKeyMap.put(entry.getKey(), "0");
                continue;
            }
            if ("period".equals(number)) {
                defaultDimensionPrimaryKeyMap.put(entry.getKey(), "1");
                continue;
            }
            defaultDimensionPrimaryKeyMap.put(entry.getKey(), "2");
        }
        HashSet<String> existNecessity = new HashSet<String>(3);
        int rowCount = this.getModel().getEntryRowCount("dimension_entry");
        for (int i = 0; i < rowCount; ++i) {
            Object value = this.getModel().getValue("necessity_dim", i);
            if (value == null) continue;
            existNecessity.add(value.toString());
        }
        this.getModel().beginInit();
        for (Object primaryKey : dynamicObjectMap.keySet()) {
            String necessity = (String)defaultDimensionPrimaryKeyMap.get(primaryKey);
            int entryRow = necessity != null ? this.getModel().insertEntryRow("dimension_entry", 0) : this.getModel().createNewEntryRow("dimension_entry");
            this.getModel().setValue("dimension", primaryKey, entryRow);
            if (necessity == null || existNecessity.contains(necessity)) continue;
            this.getModel().setValue("necessity_dim", (Object)necessity, entryRow);
        }
        rowCount = this.getModel().getEntryRowCount("dimension_entry");
        String fieldName = ResManager.loadKDString((String)"\u540d\u79f0", (String)"FAFAnalysisModelEdit_9", (String)"macc-faf-formplugin", (Object[])new Object[0]);
        for (int i = 0; i < rowCount; ++i) {
            DimensionTypeEnum dimensionType = DimensionTypeEnum.getEnum((String)((DynamicObject)this.getModel().getValue("dimension", i)).get("dimensiontype").toString());
            if (DimensionTypeEnum.OTHER == dimensionType || DimensionTypeEnum.DENUMS == dimensionType) {
                this.getView().setEnable(Boolean.FALSE, i, new String[]{"field_name", "necessity_dim"});
            } else if (DimensionTypeEnum.ASSISTANTDATA == dimensionType) {
                this.getView().setEnable(Boolean.FALSE, i, new String[]{"necessity_dim"});
            } else if (DimensionTypeEnum.DATE == dimensionType) {
                this.getView().setEnable(Boolean.FALSE, i, new String[]{"field_name"});
            }
            if (this.getModel().getValue("field_name", i) != null && !StringUtils.isEmpty((CharSequence)this.getModel().getValue("field_name", i).toString())) continue;
            DynamicObjectCollection dimensions = ((DynamicObject)this.getModel().getValue("dimension", i)).getDynamicObjectCollection("dimensionentryentity");
            for (DynamicObject dim : dimensions) {
                if (!"name".equals(dim.getString("fieldnumber")) || !fieldName.equals(dim.getString("fieldname"))) continue;
                this.getModel().setValue("field_name", (Object)fieldName, i);
                this.getModel().setValue("field_number_tag", (Object)"name", i);
            }
        }
        this.getModel().endInit();
    }

    private void setEntryRowDisable() {
        IDataModel model = this.getModel();
        int rowCount = model.getEntryRowCount("dimension_entry");
        for (int i = 0; i < rowCount; ++i) {
            DimensionTypeEnum dimensionType = DimensionTypeEnum.getEnum((String)((DynamicObject)model.getValue("dimension", i)).get("dimensiontype").toString());
            if (DimensionTypeEnum.OTHER == dimensionType || DimensionTypeEnum.DENUMS == dimensionType) {
                this.getView().setEnable(Boolean.FALSE, i, new String[]{"field_name", "necessity_dim"});
                continue;
            }
            if (DimensionTypeEnum.ASSISTANTDATA == dimensionType) {
                this.getView().setEnable(Boolean.FALSE, i, new String[]{"necessity_dim"});
                continue;
            }
            if (DimensionTypeEnum.DATE != dimensionType) continue;
            this.getView().setEnable(Boolean.FALSE, i, new String[]{"field_name"});
        }
    }

    private void setPeriodTypeAndAccountTable() {
        IDataModel model = this.getModel();
        int rowCount = model.getEntryRowCount("dimension_entry");
        String selectFields = "group.id, typefield, dimensionsource, dimensiontype, assistantsource";
        boolean existPeriod = false;
        boolean existAccount = false;
        for (int i = 0; i < rowCount; ++i) {
            Optional optional;
            long group;
            Object pkValue;
            Object necessity = model.getValue("necessity_dim", i);
            if (DimensionNecessityEnum.PERIOD.getCode().equals(necessity)) {
                existPeriod = true;
                pkValue = ((DynamicObject)model.getValue("dimension", i)).getPkValue();
                DynamicObject periodDim = QueryServiceHelper.queryOne((String)"pa_dimension", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("id", "=", pkValue)});
                group = periodDim.getLong("group.id");
                optional = EntityMetaHelper.getBaseEntityId((String)periodDim.getString("dimensionsource"), (String)periodDim.getString("typefield"));
                if (optional.isPresent() && "bd_period_type".equals(optional.get())) {
                    model.setValue("periodtype", (Object)group);
                    continue;
                }
                model.setValue("periodtype", null);
                continue;
            }
            if (!DimensionNecessityEnum.ACCOUNT.getCode().equals(necessity)) continue;
            existAccount = true;
            pkValue = ((DynamicObject)model.getValue("dimension", i)).getPkValue();
            DynamicObject accountDim = QueryServiceHelper.queryOne((String)"pa_dimension", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("id", "=", pkValue)});
            group = accountDim.getLong("group.id");
            optional = EntityMetaHelper.getBaseEntityId((String)accountDim.getString("dimensionsource"), (String)accountDim.getString("typefield"));
            if (optional.isPresent() && ("bd_accounttable".equals(optional.get()) || "pa_accounttype".equals(optional.get()))) {
                model.setValue(ITEMCLASS_TYPEFIELD, optional.get());
                model.setValue("accounttable", (Object)group);
                continue;
            }
            model.setValue("accounttable", null);
        }
        if (!existPeriod) {
            model.setValue("periodtype", null);
        }
        if (!existAccount) {
            model.setValue("accounttable", null);
        }
    }

    @Override
    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        IDataModel model = this.getModel();
        if (key.equals("dim_mulbase")) {
            this.openCurrentDimensionSelectList(e, model);
        }
        if (key.equals("measure_mulbase")) {
            this.openCurrentMeasureSelectList(e, model);
        }
    }

    private void openCurrentMeasureSelectList(BeforeF7SelectEvent e, IDataModel model) {
        if (e.getFormShowParameter() instanceof ListShowParameter) {
            ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
            ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(3);
            qFilterList.add(new QFilter("system", "=", this.getModel().getValue("analysis_system_id")));
            qFilterList.add(this.getSelectedMeasureFilter());
            qFilterList.add(this.getSystemImportMeasureFilter());
            showParameter.setListFilterParameter(new ListFilterParameter(qFilterList, null));
            showParameter.setCaption(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5ea6\u91cf", (String)"FAFAnalysisModelEdit_11", (String)"macc-faf-formplugin", (Object[])new Object[0]));
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, e.getProperty().getName());
            e.getFormShowParameter().setCloseCallBack(closeCallBack);
        }
    }

    private QFilter getSystemImportMeasureFilter() {
        long anaSystemId;
        DynamicObjectCollection importMeasureMappings;
        ImportSystemSourceTypeEnum existImportMeasureSystemSourceType = null;
        Long existImportMeasureId = null;
        DynamicObjectCollection measureEntry = this.getModel().getEntryEntity("measure_entry");
        for (DynamicObject dynamicObject : measureEntry) {
            DynamicObject measure = dynamicObject.getDynamicObject("measure");
            ImportSystemSourceTypeEnum measureSystemSourceTypeEnum = ImportSystemSourceTypeEnum.getEnumByCode((String)measure.getString("systemsource"));
            if (measureSystemSourceTypeEnum == ImportSystemSourceTypeEnum.NEW || existImportMeasureSystemSourceType != null) continue;
            existImportMeasureSystemSourceType = measureSystemSourceTypeEnum;
            existImportMeasureId = (Long)measure.getPkValue();
        }
        if (existImportMeasureSystemSourceType != null && !CollectionUtils.isEmpty((Collection)(importMeasureMappings = FAFMeasureHelper.queryMeasureMappingByAnaSystem((Object)(anaSystemId = ((Long)this.getModel().getValue("analysis_system_id")).longValue()), existImportMeasureSystemSourceType)))) {
            ArrayList<Long> validatedImportMeasureIds = new ArrayList<Long>();
            Map<Long, List<DynamicObject>> importMeasureMappingsGroupByMeasureId = importMeasureMappings.stream().collect(Collectors.groupingBy(mapping -> mapping.getLong("measure")));
            List<DynamicObject> existImportMeasureMappings = importMeasureMappingsGroupByMeasureId.get(existImportMeasureId);
            long importModelId = existImportMeasureMappings.get(0).getLong("immodel");
            List dimNumberOfMeasure = existImportMeasureMappings.stream().map(dy -> dy.getString("entryimdimnumber")).collect(Collectors.toList());
            for (Map.Entry<Long, List<DynamicObject>> measureIdMappingsEntry : importMeasureMappingsGroupByMeasureId.entrySet()) {
                Long measureId = measureIdMappingsEntry.getKey();
                List<DynamicObject> mappingsOfCurrentMeasureId = measureIdMappingsEntry.getValue();
                long importModelIdOfCurrentMeasure = mappingsOfCurrentMeasureId.get(0).getLong("immodel");
                List mappingDimNumbersGroupByMeasureId = mappingsOfCurrentMeasureId.stream().map(dy -> dy.getString("entryimdimnumber")).collect(Collectors.toList());
                if (importModelIdOfCurrentMeasure != importModelId || mappingDimNumbersGroupByMeasureId.size() != dimNumberOfMeasure.size() || !mappingDimNumbersGroupByMeasureId.containsAll(dimNumberOfMeasure)) continue;
                validatedImportMeasureIds.add(measureId);
            }
            return new QFilter("systemsource", "=", (Object)ImportSystemSourceTypeEnum.NEW.getCode()).or(new QFilter("systemsource", "=", (Object)existImportMeasureSystemSourceType.getCode()).and(new QFilter("id", "in", validatedImportMeasureIds)));
        }
        return null;
    }

    private QFilter getSelectedMeasureFilter() {
        ArrayList<Long> selectedPKList = new ArrayList<Long>();
        DynamicObjectCollection measureEntry = this.getModel().getEntryEntity("measure_entry");
        for (DynamicObject entry : measureEntry) {
            DynamicObject measure = entry.getDynamicObject("measure");
            selectedPKList.add((Long)measure.getPkValue());
        }
        return new QFilter("id", "not in", (Object)selectedPKList.toArray(new Long[0]));
    }

    private void openCurrentDimensionSelectList(BeforeF7SelectEvent e, IDataModel model) {
        Object analysisSystem = model.getValue("analysis_system");
        if (e.getFormShowParameter() instanceof ListShowParameter) {
            ArrayList<Long> selectedPKList = new ArrayList<Long>();
            ImportSystemSourceTypeEnum existImportDimensionSystemSourceType = null;
            Long existImportDimensionId = null;
            DynamicObjectCollection value = model.getEntryEntity("dimension_entry");
            for (DynamicObject dynamicObject : value) {
                DynamicObject dimension = dynamicObject.getDynamicObject("dimension");
                selectedPKList.add((Long)dimension.getPkValue());
                ImportSystemSourceTypeEnum dimensionSystemSourceTypeEnum = ImportSystemSourceTypeEnum.getEnumByCode((String)dimension.getString("systemsource"));
                if (dimensionSystemSourceTypeEnum == ImportSystemSourceTypeEnum.NEW || existImportDimensionSystemSourceType != null) continue;
                existImportDimensionSystemSourceType = dimensionSystemSourceTypeEnum;
                existImportDimensionId = (Long)dimension.getPkValue();
            }
            ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
            long anaSystemId = ((DynamicObject)analysisSystem).getLong("id");
            ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(3);
            qFilterList.add(new QFilter("system", "=", (Object)anaSystemId));
            qFilterList.add(new QFilter("id", "not in", (Object)selectedPKList.toArray(new Long[0])));
            qFilterList.add(this.getSystemSourceFilter(anaSystemId, existImportDimensionId, existImportDimensionSystemSourceType));
            showParameter.setListFilterParameter(new ListFilterParameter(qFilterList, null));
            showParameter.setCaption(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ef4\u5ea6", (String)"FAFAnalysisModelEdit_10", (String)"macc-faf-formplugin", (Object[])new Object[0]));
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, e.getProperty().getName());
            e.getFormShowParameter().setCloseCallBack(closeCallBack);
        }
    }

    private QFilter getSystemSourceFilter(long anaSystemId, Long existImportDimensionId, ImportSystemSourceTypeEnum existImportDimensionSystemSourceType) {
        QFilter systemSourceFilter = null;
        if (existImportDimensionSystemSourceType != null) {
            switch (existImportDimensionSystemSourceType) {
                case ASSTACT: {
                    systemSourceFilter = new QFilter("systemsource", "=", (Object)ImportSystemSourceTypeEnum.NEW.getCode()).or(new QFilter("systemsource", "=", (Object)existImportDimensionSystemSourceType.getCode()));
                    break;
                }
                case BCM: 
                case EPM: {
                    DynamicObjectCollection importDimensionMapping = FAFDimensionHelper.queryDimensionMappingByAnaSystem((Object)anaSystemId, (ImportSystemSourceTypeEnum)existImportDimensionSystemSourceType);
                    if (CollectionUtils.isEmpty((Collection)importDimensionMapping)) break;
                    long importModelId = 0L;
                    for (DynamicObject mapping2 : importDimensionMapping) {
                        if (mapping2.getLong("dimension") != existImportDimensionId.longValue()) continue;
                        importModelId = mapping2.getLong("immodel");
                        break;
                    }
                    long finalImportModelId = importModelId;
                    List importDimensionIds = importDimensionMapping.stream().filter(mapping -> mapping.getLong("immodel") == finalImportModelId).map(mapping -> mapping.getLong("dimension")).collect(Collectors.toList());
                    systemSourceFilter = new QFilter("systemsource", "=", (Object)ImportSystemSourceTypeEnum.NEW.getCode()).or(new QFilter("systemsource", "=", (Object)existImportDimensionSystemSourceType.getCode()).and(new QFilter("id", "in", importDimensionIds)));
                    break;
                }
            }
        }
        return systemSourceFilter;
    }

    private void showCreateTable() {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        Long id = (Long)model.getValue("id");
        if (id == 0L) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u5206\u6790\u6a21\u578b\u3002", (String)"FAFAnalysisModelEdit_12", (String)"macc-faf-formplugin", (Object[])new Object[0]));
            return;
        }
        if (model.getDataChanged()) {
            view.showTipNotification(ResManager.loadKDString((String)"\u9875\u9762\u914d\u7f6e\u6709\u6539\u52a8\uff0c\u8bf7\u5148\u4fdd\u5b58\u5206\u6790\u6a21\u578b\u3002", (String)"FAFAnalysisModelEdit_13", (String)"macc-faf-formplugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter formShow = new FormShowParameter();
        formShow.setFormId("pa_tableconfig");
        formShow.getOpenStyle().setShowType(ShowType.Modal);
        formShow.setCustomParam("tablenumber", model.getValue("number"));
        formShow.setCustomParam("tablename", (Object)((OrmLocaleValue)model.getValue("name")).get((Object)"zh_CN"));
        formShow.setCustomParam("analysisModel_id", (Object)id);
        formShow.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "callback_create_table"));
        view.showForm(formShow);
    }

    @Deprecated
    private void setTableFromReturnData(Object obj) {
        if (obj instanceof Map) {
            IDataModel model = this.getModel();
            IFormView view = this.getView();
            Map result = (Map)obj;
            boolean success = Boolean.parseBoolean((String)result.get("result"));
            if (success) {
                FAFAnalysisModelHelper.upgradeModelVersion((Long)((Long)this.getModel().getValue("id")));
                model.setValue("tablenumber", result.get("tablenumber"));
                model.setValue("tablename", result.get("tablename"));
                model.setValue("version", (Object)ModelVersionEnum.new_version.getCodeStr());
                view.setVisible(Boolean.TRUE, new String[]{"tablename", "tablenumber"});
                view.setVisible(Boolean.FALSE, new String[]{"create_table"});
                model.setDataChanged(false);
                view.showSuccessNotification(String.format(ResManager.loadKDString((String)"\u6570\u636e\u8868[%s]\u521b\u5efa\u6210\u529f\u3002", (String)"FAFAnalysisModelEdit_18", (String)"macc-faf-formplugin", (Object[])new Object[0]), result.get("tablename")));
            }
        }
    }

    private void addTableField() {
        IDataModel model = this.getModel();
        String tableNumber = model.getValue("tablenumber").toString();
        String inputTableName = model.getValue("tablename").toString();
        if (StringUtils.isNotEmpty((CharSequence)tableNumber)) {
            String inputTableName_dtl;
            String tableNumber_dtl;
            CustomizedFormBuilderInfo builderDetailInfo;
            boolean isNewVersion;
            CustomizedFormBuilderInfo builderInfo = this.getCustomizedFormBuilderInfo(model, tableNumber, inputTableName);
            DynamicObject allColumnAnalysisModel = BusinessDataServiceHelper.loadSingleFromCache((Object)model.getValue("id"), (String)"pa_analysismodel");
            if (builderInfo.isChanged() || FAFAnalysisModelEdit.isMetaNeedRebuild(builderInfo, AnalysisModelUtil.buildEntityNumber((String)tableNumber), Boolean.FALSE)) {
                EntityMetaHelper.constructMetadataList((CustomizedFormBuilderInfo)builderInfo, (DynamicObject)allColumnAnalysisModel);
                CustomizedDynamicFormBuilderUtil.checkDesignerDataSaveResult((CustomizedFormBuilderInfo)builderInfo, (Map)CustomizedDynamicFormBuilderUtil.SaveEntityPage((CustomizedFormBuilderInfo)builderInfo, (Boolean)Boolean.FALSE), (boolean)true);
                CustomizedDynamicFormBuilderUtil.updateDefaultValue((String)AnalysisModelUtil.buildEntityNumber((String)tableNumber), (String)this.getPageCache().get("addmeasure"), (String)builderInfo.getDbRoute());
            }
            if ((isNewVersion = FAFAnalysisModelHelper.isModelNewVersion((DynamicObject)allColumnAnalysisModel)) && ((builderDetailInfo = this.getCustomizedFormBuilderInfo(model, tableNumber_dtl = tableNumber + "_d", inputTableName_dtl = inputTableName + "_d")).isChanged() || FAFAnalysisModelEdit.isMetaNeedRebuild(builderDetailInfo, AnalysisModelUtil.buildEntityNumber((String)tableNumber_dtl), Boolean.TRUE))) {
                EntityMetaHelper.constructMetadataList((CustomizedFormBuilderInfo)builderDetailInfo, (DynamicObject)allColumnAnalysisModel);
                CustomizedDynamicFormBuilderUtil.checkDesignerDataSaveResult((CustomizedFormBuilderInfo)builderDetailInfo, (Map)CustomizedDynamicFormBuilderUtil.SaveEntityPage((CustomizedFormBuilderInfo)builderDetailInfo, (Boolean)Boolean.FALSE), (boolean)true);
                CustomizedDynamicFormBuilderUtil.updateDefaultValue((String)AnalysisModelUtil.buildEntityNumber((String)tableNumber_dtl), (String)this.getPageCache().get("addmeasure"), (String)builderInfo.getDbRoute());
            }
            this.getPageCache().remove("addmeasure");
        }
    }

    @NotNull
    private CustomizedFormBuilderInfo getCustomizedFormBuilderInfo(IDataModel model, String tableNumber, String inputTableName) {
        String fieldName;
        CustomizedFormBuilderInfo builderInfo = CustomizedDynamicFormBuilderUtil.createCustomizedFormBuilderInfo((String)AnalysisModelUtil.buildEntityNumber((String)tableNumber), (String)inputTableName, (String)"2UK0B8T0A=WJ", (String)"BaseFormModel");
        builderInfo.setBizUnitId("2XF5B1YXIBCY");
        builderInfo.setDbRoute("fias");
        EntityMetadata entityMeta = builderInfo.getEntityMeta();
        List items = entityMeta.getItems();
        ArrayList<String> fieldNumberList = new ArrayList<String>(items.size());
        for (Object item : items) {
            fieldNumberList.add(item.getKey());
        }
        DynamicObjectCollection dimEntrys = model.getEntryEntity("dimension_entry");
        for (DynamicObject dimEntry : dimEntrys) {
            String fieldNumberTag;
            Set nowRefPropSet;
            BasedataField entityItem;
            Set refPropSet;
            DynamicObject dimension = dimEntry.getDynamicObject("dimension");
            String fieldNumber = dimension.getString("number");
            int index = fieldNumberList.indexOf(fieldNumber.toLowerCase());
            if (index != -1 && items.get(index) instanceof BasedataField && (!(refPropSet = (entityItem = (BasedataField)items.get(index)).getRefProps().stream().map(RefProp::getName).collect(Collectors.toSet())).containsAll(nowRefPropSet = Arrays.stream((fieldNumberTag = dimEntry.getString("field_number_tag")).split(",")).collect(Collectors.toSet())) || refPropSet.size() != nowRefPropSet.size())) {
                List refPropList = nowRefPropSet.stream().map(RefProp::new).collect(Collectors.toList());
                entityItem.getRefProps().clear();
                entityItem.getRefProps().addAll(refPropList);
                builderInfo.setChanged(true);
            }
            if (fieldNumberList.contains(fieldNumber.toLowerCase())) continue;
            builderInfo.setChanged(true);
            fieldName = dimension.getString("name");
            FAFDimensionTypeEnum dimensionType = FAFDimensionTypeEnum.getEnum((String)dimension.getString("dimensiontype"));
            switch (dimensionType) {
                case DATABASE: 
                case PERIOD: {
                    List refProps = Arrays.stream(dimEntry.getString("field_number_tag").split(",")).map(RefProp::new).collect(Collectors.toList());
                    String baseNumber = dimension.getString("dimensionsource.number");
                    builderInfo.addField(BasedataField.class, fieldNumber, fieldName, baseNumber, null, refProps);
                    break;
                }
                case ASSISTANTDATA: {
                    List refProps = Arrays.stream(dimEntry.getString("field_number_tag").split(",")).map(RefProp::new).collect(Collectors.toList());
                    String baseNumber = dimension.getString("assistantsource.number");
                    String assistTypeId = dimension.getString("assistantsource.id");
                    builderInfo.addField(AssistantField.class, fieldNumber, fieldName, baseNumber, assistTypeId, refProps);
                    break;
                }
                case OTHER: {
                    builderInfo.addTextField(fieldNumber, fieldName, 255, "");
                    break;
                }
                case DATE: {
                    builderInfo.addField(DateTimeField.class, fieldNumber, fieldName, "");
                    break;
                }
                case DENUMS: {
                    Long dimensionId = dimension.getLong("id");
                    dimension = BusinessDataServiceHelper.loadSingleFromCache((Object)dimensionId, (String)"pa_dimension");
                    HashMap<String, String> comItemMap = new HashMap<String, String>(10);
                    DynamicObjectCollection enums = dimension.getDynamicObjectCollection("entryentityenums");
                    for (DynamicObject anEnum : enums) {
                        comItemMap.put(anEnum.getString("title"), anEnum.getString("value"));
                    }
                    builderInfo.addComboField(fieldNumber, fieldName, "", comItemMap);
                    break;
                }
            }
        }
        HashSet<String> addMeasures = new HashSet<String>(10);
        DynamicObjectCollection measureEntrys = model.getEntryEntity("measure_entry");
        for (DynamicObject measureEntry : measureEntrys) {
            DynamicObject measure = measureEntry.getDynamicObject("measure");
            fieldName = measure.getString("name");
            String fieldNumber = measure.getString("number");
            if (fieldNumberList.contains(fieldNumber.toLowerCase())) continue;
            builderInfo.setChanged(true);
            builderInfo.addDecimalField(fieldNumber, fieldName, null);
            addMeasures.add(fieldNumber);
        }
        if (!addMeasures.isEmpty()) {
            this.getPageCache().put("addmeasure", String.join((CharSequence)",", addMeasures));
        }
        for (EntityItem item : builderInfo.getEntityMeta().getItems()) {
            if (!(item instanceof BasedataField)) continue;
            BasedataField field = (BasedataField)item;
            try {
                String newDisplayProp;
                String oldDisplayProp = field.getDisplayProp();
                if (StringUtils.equals((CharSequence)oldDisplayProp, (CharSequence)(newDisplayProp = ((BasedataEntityType)EntityMetadataCache.getDataEntityTypeById((String)field.getBaseEntityId())).getNameProperty()))) continue;
                field.setDisplayProp(newDisplayProp);
                builderInfo.setChanged(true);
            }
            catch (Exception exception) {}
        }
        if (!((Boolean)this.getModel().getValue("isnewlistfilter")).booleanValue()) {
            builderInfo.setChanged(true);
        }
        return builderInfo;
    }

    private void showViewData() {
        Long analysisModelId = (Long)this.getModel().getDataEntity().getPkValue();
        if (analysisModelId > 0L) {
            String modelNewVersionMsg = ValidatorTipsUtil.isModelNewVersion(analysisModelId);
            if (StringUtils.isNotEmpty((CharSequence)modelNewVersionMsg)) {
                this.getView().showTipNotification(modelNewVersionMsg);
            } else {
                Object analysisSystemId = this.getModel().getValue("analysis_system_id");
                FAFDataReview2Plugin.openF7(this, null, analysisSystemId, analysisModelId, null, null);
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u5206\u6790\u6a21\u578b\u3002", (String)"FAFAnalysisModelEdit_12", (String)"macc-faf-formplugin", (Object[])new Object[0]));
        }
    }

    public static boolean isMetaNeedRebuild(CustomizedFormBuilderInfo builderInfo, String entityNumber, Boolean isDetail) {
        BasedataFormAp basedataFormAp;
        List formPlugins;
        FormAp rootAp;
        List items;
        DynamicProperty createStampProperty;
        DynamicProperty dimHashProperty;
        DynamicProperty createTimeProperty;
        MainEntityType dataEntityType;
        DynamicProperty importBatchProperty;
        boolean needRebuild = false;
        EntityMetadata entityMeta = builderInfo.getEntityMeta();
        DynamicObject bizAppObj = BizAppServiceHelp.getBizAppByFormID((String)entityMeta.getId());
        if (bizAppObj == null || !"2UK0B8T0A=WJ".equals(bizAppObj.getPkValue())) {
            needRebuild = true;
        }
        if ((importBatchProperty = (dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber)).getProperty("importbatch")) == null) {
            builderInfo.addTextField("importbatch", ResManager.loadKDString((String)"\u5bfc\u5165\u6279\u6b21\u53f7", (String)"FAFAnalysisModelEdit_19", (String)"macc-faf-formplugin", (Object[])new Object[0]), 255, "0");
            needRebuild = true;
        }
        if ((createTimeProperty = dataEntityType.getProperty("createtime")) == null) {
            builderInfo.addField(CreateDateField.class, "createtime", ResManager.loadKDString((String)"\u521b\u5efa\u65f6\u95f4", (String)"FAFAnalysisModelEdit_20", (String)"macc-faf-formplugin", (Object[])new Object[0]), "");
            needRebuild = true;
        }
        if ((dimHashProperty = dataEntityType.getProperty("dimhash")) == null) {
            builderInfo.addTextField("dimhash", ResManager.loadKDString((String)"\u591a\u7ef4\u5ea6\u54c8\u5e0c\u503c", (String)"FAFAnalysisModelEdit_28", (String)"macc-faf-formplugin", (Object[])new Object[0]), 16, "");
            HashMap<String, String> tableIndexMap = new HashMap<String, String>(4);
            tableIndexMap.put("idx_" + entityNumber + "dimhash", "fdimhash");
            builderInfo.setTableIndexMap(tableIndexMap);
            needRebuild = true;
        }
        if (Boolean.TRUE.equals(isDetail) && (createStampProperty = dataEntityType.getProperty("createstamp")) == null) {
            builderInfo.addBigIntField("createstamp", ResManager.loadKDString((String)"\u521b\u5efa\u65f6\u95f4\u6233", (String)"FAFAnalysisModelEdit_26", (String)"macc-faf-formplugin", (Object[])new Object[0]), "0");
            needRebuild = true;
        }
        if ((items = entityMeta.getItems()) != null && !items.isEmpty()) {
            Iterator iterator = items.iterator();
            while (iterator.hasNext()) {
                EntityItem next = (EntityItem)iterator.next();
                if (!"createtime".equals(next.getKey()) || next instanceof CreateDateField) continue;
                iterator.remove();
                builderInfo.addField(CreateDateField.class, "createtime", ResManager.loadKDString((String)"\u521b\u5efa\u65f6\u95f4", (String)"FAFAnalysisModelEdit_20", (String)"macc-faf-formplugin", (Object[])new Object[0]), "");
                needRebuild = true;
                break;
            }
        }
        if (!needRebuild && (rootAp = builderInfo.getFormMeta().getRootAp()) instanceof BasedataFormAp && (formPlugins = (basedataFormAp = (BasedataFormAp)rootAp).getPlugins()) != null && !formPlugins.isEmpty()) {
            String className = ((Plugin)formPlugins.get(0)).getClassName();
            needRebuild = !FAFDynamicMetaImportPlugin.class.getName().equals(className);
        }
        return needRebuild;
    }

    public void beforeClosed(BeforeClosedEvent e) {
        String importPageId = this.getPageCache().get("importPageId");
        if (StringUtils.isNotEmpty((CharSequence)importPageId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9000\u51fa\u5206\u6790\u6a21\u578b\u524d\uff0c\u8bf7\u5148\u5173\u95ed\u5df2\u6253\u5f00\u7684\u660e\u7ec6\u5bfc\u5165\u9875\u9762\u3002", (String)"FAFAnalysisModelEdit_25", (String)"macc-faf-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        super.beforeClosed(e);
    }
}

