/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.system;

import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.control.Button;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.macc.faf.enums.FAFWorkTaskTypeEnum;
import kd.macc.faf.helper.FAFTableDataHelper;
import kd.macc.faf.util.AnalysisModelUtil;
import kd.macc.faf.util.FAFTableUtil;

public class FAFAnalysisModelList
extends AbstractListPlugin {
    public void setFilter(SetFilterEvent e) {
        Long anaSystemId = (Long)this.getView().getFormShowParameter().getCustomParam("anaSystemId");
        if (anaSystemId != null && anaSystemId != 0L) {
            QFilter filter = new QFilter("analysis_system", "=", (Object)anaSystemId);
            e.addCustomQFilter(filter);
        }
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        Long anaSystemId = (Long)this.getView().getFormShowParameter().getCustomParam("anaSystemId");
        if (anaSystemId != null && anaSystemId != 0L) {
            e.getParameter().setCustomParam("analysis_system", (Object)anaSystemId);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
    }

    public void click(EventObject evt) {
        ListSelectedRowCollection selectedRows;
        super.click(evt);
        Button source = (Button)evt.getSource();
        if ("btnok".equals(source.getKey()) && !(selectedRows = ((ListView)source.getView()).getSelectedRows()).isEmpty()) {
            Long primaryKeyValue = (Long)selectedRows.get(0).getPrimaryKeyValue();
            FAFTableDataHelper.checkAndRebuildEntity((Object)primaryKeyValue);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        Object source = args.getSource();
        if (source instanceof FormOperate && "donothing_delete".equals(operateKey = ((FormOperate)source).getOperateKey())) {
            ListSelectedRowCollection listSelectedData = args.getListSelectedData();
            if (listSelectedData == null || listSelectedData.size() > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u6761\u6570\u636e\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"FAFAnalysisModelList_0", (String)"macc-faf-formplugin", (Object[])new Object[0]));
                return;
            }
            ListSelectedRow row = listSelectedData.get(0);
            Long primaryKey = Long.valueOf(row.getPrimaryKeyValue().toString());
            DynamicObject syncParam = BusinessDataServiceHelper.loadSingle((Object)primaryKey, (String)"pa_analysismodel", (String)"tablenumber,enable");
            if (syncParam != null) {
                String tableNumber = syncParam.getString("tablenumber");
                if (StringUtils.isNotEmpty((String)tableNumber)) {
                    List primaryKeys;
                    FAFTableDataHelper.checkAndRebuildEntity((Object)primaryKey, (String)tableNumber);
                    String entity = AnalysisModelUtil.buildEntityNumber((String)tableNumber);
                    if (MetadataDao.checkNumber((String)entity) && !CollectionUtils.isEmpty((Collection)(primaryKeys = QueryServiceHelper.queryPrimaryKeys((String)entity, null, null, (int)1)))) {
                        this.getView().showConfirm(ResManager.loadKDString((String)"\u5220\u9664\u5206\u6790\u6a21\u578b\u4f1a\u5220\u9664\u5df2\u540c\u6b65\u6570\u636e\u4e14\u65e0\u6cd5\u6062\u590d\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u5220\u9664\uff1f", (String)"FAFAnalysisModelList_1", (String)"macc-faf-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, ConfirmTypes.Delete, new ConfirmCallBackListener("delete_confirm_analysis", (IFormPlugin)this));
                        return;
                    }
                }
                this.getView().invokeOperation("delete");
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        IFormView anaSystemConfigView;
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        if ("delete".equals(operateKey) && operationResult.isSuccess() && (anaSystemConfigView = this.getView().getParentView()) != null && "pa_anasystemconfig".equals(anaSystemConfigView.getEntityId())) {
            anaSystemConfigView.updateView();
            this.getView().sendFormAction(anaSystemConfigView);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        String callBackId = event.getCallBackId();
        String result = event.getResultValue();
        if ("delete_confirm_analysis".equals(callBackId) && "Yes".equals(result)) {
            this.getView().invokeOperation("delete");
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if ("resetentity".equals(itemKey)) {
            QFilter qFilter = new QFilter("tablenumber", "!=", (Object)" ");
            DynamicObjectCollection analysisModels = QueryServiceHelper.query((String)"pa_analysismodel", (String)"id,tablenumber,tablename", (QFilter[])new QFilter[]{qFilter});
            for (DynamicObject analysisModel : analysisModels) {
                boolean exist;
                String tableNumber = analysisModel.getString("tablenumber");
                String tableName = analysisModel.getString("tablename");
                Long id = analysisModel.getLong("id");
                if (!StringUtils.isNotEmpty((String)tableNumber) || (exist = MetadataDao.checkNumber((String)AnalysisModelUtil.buildEntityNumber((String)tableNumber)))) continue;
                FAFTableUtil.createOrDropTable((Long)id, (FAFWorkTaskTypeEnum)FAFWorkTaskTypeEnum.Create_Table_Task, (String)tableNumber, (String)tableName, (Boolean)Boolean.FALSE);
            }
        }
    }
}

