/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.system;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.form.JobForm;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.service.GenericServiceResult;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.faf.absplugin.AbstractTaskCallBackPlugin;
import kd.macc.faf.helper.FAFTableDataHelper;
import kd.macc.faf.management.bo.param.request.QueryTaskParam;
import kd.macc.faf.management.enums.TaskOptTypeEnum;
import kd.macc.faf.management.enums.TaskStatusEnum;
import kd.macc.faf.management.factory.TaskParamFactory;
import kd.macc.faf.util.AnalysisModelUtil;

public class FAFAnalysisModelOperationPlugin
extends AbstractTaskCallBackPlugin {
    private static final Log logger = LogFactory.getLog(FAFAnalysisModelOperationPlugin.class);

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String key = ((FormOperate)args.getSource()).getOperateKey();
        if (StringUtils.equals((CharSequence)key, (CharSequence)"droptable")) {
            String importPageId = this.getPageCache().get("importPageId");
            if (StringUtils.isNotEmpty((CharSequence)importPageId)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5220\u9664\u6570\u636e\u8868\u524d\uff0c\u8bf7\u5148\u5173\u95ed\u5df2\u6253\u5f00\u7684\u660e\u7ec6\u5bfc\u5165\u9875\u9762\u3002", (String)"FAFAnalysisModelOperationPlugin_3", (String)"macc-faf-formplugin", (Object[])new Object[0]));
            } else {
                this.confirmDroptable();
            }
            args.setCancel(true);
        }
    }

    private void confirmDroptable() {
        IDataModel model = this.getModel();
        Long pkvalue = (Long)model.getValue("id");
        String tableNumber = (String)model.getValue("tablenumber");
        String tableName = (String)model.getValue("tablename");
        if (pkvalue == 0L || StringUtils.isEmpty((CharSequence)tableNumber) || StringUtils.isEmpty((CharSequence)tableName)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u8fd8\u672a\u521b\u5efa\u8868\uff0c\u65e0\u9700\u5220\u9664\u3002", (String)"FAFAnalysisModelOperationPlugin_0", (String)"macc-faf-formplugin", (Object[])new Object[0]));
        } else {
            if (this.isExistUnFinishedTask(pkvalue)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u5206\u6790\u6a21\u578b\u76ee\u524d\u6709\u5f85\u6267\u884c\u6216\u6267\u884c\u4e2d\u7684\u4efb\u52a1\uff0c\u65e0\u6cd5\u5220\u9664\u6570\u636e\u8868\u3002", (String)"FAFAnalysisModelOperationPlugin_4", (String)"macc-faf-formplugin", (Object[])new Object[0]));
                return;
            }
            String detailEntityNumber = AnalysisModelUtil.buildDetailEntityNumber((String)tableNumber);
            String summaryEntityNumber = AnalysisModelUtil.buildEntityNumber((String)tableNumber);
            if (AnalysisModelUtil.isShardingEntity((String)detailEntityNumber) || AnalysisModelUtil.isShardingEntity((String)summaryEntityNumber)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u5206\u6790\u6a21\u578b\u7684\u6570\u636e\u8868\u5df2\u505a\u6c34\u5e73\u5206\u8868\uff0c\u65e0\u6cd5\u5220\u9664\u6570\u636e\u8868\u3002", (String)"FAFAnalysisModelOperationPlugin_5", (String)"macc-faf-formplugin", (Object[])new Object[0]));
                return;
            }
            FAFTableDataHelper.checkAndRebuildEntity((Object)pkvalue, (String)tableNumber);
            List primaryKeys = QueryServiceHelper.queryPrimaryKeys((String)detailEntityNumber, null, null, (int)1);
            if (!CollectionUtils.isEmpty((Collection)primaryKeys)) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5220\u9664\u6570\u636e\u8868\u540c\u65f6\u4f1a\u5220\u9664\u5df2\u540c\u6b65\u6570\u636e\u4e14\u65e0\u6cd5\u6062\u590d\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u5220\u9664\uff1f", (String)"FAFAnalysisModelOperationPlugin_1", (String)"macc-faf-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, ConfirmTypes.Delete, new ConfirmCallBackListener("droptablecallback", (IFormPlugin)this));
            } else {
                this.dispatchDroptable(this.getModel().getDataEntity());
            }
        }
    }

    private boolean isExistUnFinishedTask(Long modelId) {
        QueryTaskParam queryTaskParam = (QueryTaskParam)TaskParamFactory.get((TaskOptTypeEnum)TaskOptTypeEnum.QUERY, null);
        queryTaskParam.setModelId(modelId);
        queryTaskParam.setTaskStatuses(Stream.of(TaskStatusEnum.TODO.getCode(), TaskStatusEnum.PROCESSING.getCode()).collect(Collectors.toList()));
        GenericServiceResult result = (GenericServiceResult)DispatchServiceHelper.invokeBizService((String)"macc", (String)"faf", (String)"TaskManagementService", (String)"queryTask", (Object[])new Object[]{SerializationUtils.toJsonString((Object)queryTaskParam)});
        Boolean success = result.getSuccess();
        if (success.booleanValue()) {
            return ArrayUtils.isNotEmpty((Object[])((Object[])result.getData()));
        }
        throw new KDBizException(result.getMessage());
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        String callBackId = event.getCallBackId();
        String result = event.getResultValue();
        if ("droptablecallback".equals(callBackId) && "Yes".equals(result)) {
            this.dispatchDroptable(this.getModel().getDataEntity());
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String key = e.getActionId();
        if (StringUtils.equals((CharSequence)key, (CharSequence)"droptabletaskcallback")) {
            this.taskCallBack(e);
        }
    }

    @Override
    public void taskCallBack(boolean success, ClosedCallBackEvent e) {
        if (success) {
            this.getView().invokeOperation("refresh");
            this.getView().setVisible(Boolean.FALSE, new String[]{"tablename", "tablenumber"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"create_table"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"importdata"});
        }
    }

    private void dispatchDroptable(DynamicObject dataEntity) {
        try {
            JobInfo jobInfo = new JobInfo();
            jobInfo.setRunByLang(Lang.get());
            jobInfo.setAppId("faf");
            jobInfo.setJobType(JobType.REALTIME);
            jobInfo.setRunByUserId(RequestContext.get().getCurrUserId());
            jobInfo.setRunByOrgId(RequestContext.get().getOrgId());
            jobInfo.setName("model-droptabletask job");
            String jobId = UUID.randomUUID().toString();
            jobInfo.setId(jobId);
            logger.info("AnalysisModelDroptableTask.dispatchDroptable JobId:{}", (Object)jobId);
            jobInfo.setTaskClassname("kd.macc.faf.system.AnalysisModelDroptableTask");
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("pageId", this.getPageCache().getPageId());
            params.put("modelId", dataEntity.getPkValue());
            jobInfo.setParams(params);
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "droptabletaskcallback");
            JobFormInfo jobFormInfo = new JobFormInfo(jobInfo);
            jobFormInfo.setCaption(ResManager.loadKDString((String)"\u5220\u9664\u6570\u636e\u8868\u5f02\u6b65\u4efb\u52a1", (String)"FAFAnalysisModelOperationPlugin_2", (String)"macc-faf-formplugin", (Object[])new Object[0]));
            jobFormInfo.setCloseCallBack(closeCallBack);
            jobFormInfo.setCanBackground(false);
            jobFormInfo.setCanStop(false);
            JobForm.dispatch((JobFormInfo)jobFormInfo, (IFormView)this.getView());
        }
        catch (Exception ex) {
            logger.error("dispatchDroptable error", (Throwable)ex);
            throw new KDBizException(new ErrorCode("0", ex.getMessage()), new Object[0]);
        }
    }
}

