/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.system;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.license.api.LicenseCheckResult;
import kd.bos.list.ListShowParameter;
import kd.macc.faf.helper.FAFAnasystemSettingHelper;
import kd.macc.faf.util.LicenseUtil;

public class FAFAnalysisSystemConfigEdit
extends AbstractFormPlugin {
    private static final HashMap<String, String> formIdMap = new HashMap();

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"dim_setting", "metric_setting", "module_setting", "mapping_setting", "syncschema_setting", "edit"});
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.processReturnCreateSystemByTemplate();
        this.initAnaSystemBasePanel();
        this.initMulPropertiesPanel();
    }

    private void processReturnCreateSystemByTemplate() {
        Map returnData = (Map)this.getView().getFormShowParameter().getCustomParam("returnData");
        if (returnData != null && !"true".equals(returnData.get("createTabelFlag"))) {
            HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
            btnNameMaps.put(MessageBoxResult.No.getValue(), ResManager.loadKDString((String)"\u7a0d\u540e\u5904\u7406", (String)"FAFAnalysisSystemConfigEdit_0", (String)"macc-faf-formplugin", (Object[])new Object[0]));
            btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u7acb\u5373\u524d\u5f80", (String)"FAFAnalysisSystemConfigEdit_1", (String)"macc-faf-formplugin", (Object[])new Object[0]));
            this.getView().showConfirm(null, ResManager.loadKDString((String)"\u5206\u6790\u6a21\u578b\u81ea\u52a8\u521b\u5efa\u6570\u636e\u8868\u5931\u8d25\uff0c\u8bf7\u524d\u5f80\u5206\u6790\u6a21\u578b\u624b\u5de5\u91cd\u8bd5\u3002", (String)"FAFAnalysisSystemConfigEdit_2", (String)"macc-faf-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("createTabelfailure"), btnNameMaps);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        if ("createTabelfailure".equals(event.getCallBackId())) {
            MessageBoxResult result = event.getResult();
            if (MessageBoxResult.Yes.getValue() == result.getValue()) {
                Map returnData = (Map)this.getView().getFormShowParameter().getCustomParam("returnData");
                BillShowParameter fsp = new BillShowParameter();
                fsp.setFormId("pa_analysismodel");
                fsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                fsp.setPkId((Object)Long.valueOf(String.valueOf(returnData.get("modelId"))));
                this.getView().showForm((FormShowParameter)fsp);
            }
        }
    }

    private void initAnaSystemBasePanel() {
        DynamicObject currentAnaSystem = FAFAnasystemSettingHelper.getAnasystemSettingById((Object)this.getCurrentAnaSystemId());
        Label name = (Label)this.getControl("name");
        name.setText(currentAnaSystem.getString("name"));
        Label number = (Label)this.getControl("number");
        number.setText(currentAnaSystem.getString("number"));
        Label moduleRange = (Label)this.getControl("modulerange");
        if (currentAnaSystem.getDynamicObject("modulerange") != null) {
            moduleRange.setText(currentAnaSystem.getDynamicObject("modulerange").getString("name"));
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{currentAnaSystem.getBoolean("enable") ? "unable" : "enable"});
    }

    private void initMulPropertiesPanel() {
        Map anaSystemEachPropertyCount = FAFAnasystemSettingHelper.getAnaSystemEachPropertyCount((Long)this.getCurrentAnaSystemId());
        Label dimNumber = (Label)this.getControl("label_dim_number");
        dimNumber.setText(String.valueOf(anaSystemEachPropertyCount.get("pa_dimension")));
        Label metricNumber = (Label)this.getControl("label_metric_number");
        metricNumber.setText(String.valueOf(anaSystemEachPropertyCount.get("pa_measure")));
        Label moduleNumber = (Label)this.getControl("label_module_number");
        moduleNumber.setText(String.valueOf(anaSystemEachPropertyCount.get("pa_analysismodel")));
        Label mappingNumber = (Label)this.getControl("label_mapping_number");
        mappingNumber.setText(String.valueOf(anaSystemEachPropertyCount.get("pa_mappingrelationship")));
        Label syncSchemaNumber = (Label)this.getControl("label_syncSchema_number");
        syncSchemaNumber.setText(String.valueOf(anaSystemEachPropertyCount.get("pa_syncdataschema")));
        this.showEachListPageByKey();
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("dim_setting".equals(key) || "metric_setting".equals(key) || "module_setting".equals(key) || "mapping_setting".equals(key) || "syncschema_setting".equals(key)) {
            this.getPageCache().put("listPageKey", key);
            this.showEachListPageByKey();
        } else if ("edit".equals(key)) {
            BillShowParameter billShowParameter = new BillShowParameter();
            billShowParameter.setPkId((Object)this.getCurrentAnaSystemId());
            billShowParameter.setFormId("pa_anasystemsetting");
            billShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            billShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "anaSystemEdit"));
            this.getView().showForm((FormShowParameter)billShowParameter);
        }
    }

    private void showEachListPageByKey() {
        String listPageKey = this.getPageCache().get("listPageKey");
        ListShowParameter showParameter = new ListShowParameter();
        listPageKey = StringUtils.isEmpty((CharSequence)listPageKey) ? "dim_setting" : listPageKey;
        showParameter.setBillFormId(formIdMap.get(listPageKey));
        showParameter.setFormId("bos_list");
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey("listflex");
        showParameter.setCustomParam("anaSystemId", (Object)this.getCurrentAnaSystemId());
        if ("module_setting".equals(listPageKey)) {
            showParameter.setCaption(ResManager.loadKDString((String)"\u5206\u6790\u6a21\u578b", (String)"FAFAnalysisSystemConfigEdit_3", (String)"macc-faf-formplugin", (Object[])new Object[0]));
        }
        this.getView().showForm((FormShowParameter)showParameter);
        this.addPageKeyClickStyle(listPageKey);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String returnData = (String)closedCallBackEvent.getReturnData();
        String actionId = closedCallBackEvent.getActionId();
        if ("anaSystemEdit".equals(actionId) && "1".equals(returnData)) {
            this.getView().updateView();
        }
    }

    private void addPageKeyClickStyle(String listPageKey) {
        for (String key : formIdMap.keySet()) {
            HashMap<String, String> blockStyle = new HashMap<String, String>();
            if (key.equals(listPageKey)) {
                blockStyle.put("bc", "themeColor");
            } else {
                blockStyle.put("bc", "transparent");
            }
            this.getView().updateControlMetadata(key + "_block", blockStyle);
        }
    }

    private Long getCurrentAnaSystemId() {
        return Long.valueOf(this.getView().getFormShowParameter().getCustomParam("anaSystemId").toString());
    }

    public static void refreshParentPageAfterSave(IFormView sourceView) {
        IFormView anaSystemConfigView;
        IFormView listView;
        Object[] permAppIds = new String[]{"pa", "faf"};
        if (ArrayUtils.contains((Object[])permAppIds, (Object)sourceView.getFormShowParameter().getAppId()) && (listView = sourceView.getParentView()) != null && (anaSystemConfigView = listView.getParentView()) != null && "pa_anasystemconfig".equals(anaSystemConfigView.getEntityId())) {
            anaSystemConfigView.updateView();
            sourceView.sendFormAction(anaSystemConfigView);
        }
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        String formId;
        String bizAppId = ShowFormHelper.getBizAppId((FormShowParameter)e.getFormShowParameter());
        LicenseCheckResult checkResult = LicenseUtil.Check(bizAppId, formId = e.getFormShowParameter().getFormId());
        boolean hasLicense = checkResult.getHasLicense();
        e.setCancel(!hasLicense);
        e.setCancelMessage(checkResult.getMsg());
        e.setCancelFormShowParameter(checkResult.getCancelFormShowParameter());
    }

    static {
        formIdMap.put("dim_setting", "pa_dimension");
        formIdMap.put("metric_setting", "pa_measure");
        formIdMap.put("module_setting", "pa_analysismodel");
        formIdMap.put("mapping_setting", "pa_mappingrelationship");
        formIdMap.put("syncschema_setting", "pa_syncdataschema");
    }
}

