/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.system;

import java.nio.charset.StandardCharsets;
import java.util.EventObject;
import java.util.HashMap;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.UrlUtil;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.macc.faf.export.sys.AnalysisSystemExportBuilder;
import kd.macc.faf.export.sys.AnalysisSystemImportParser;

public class FAFAnalysisSystemExImportPlugin
extends AbstractListPlugin
implements UploadListener {
    private static final Log logger = LogFactory.getLog(FAFAnalysisSystemExImportPlugin.class);
    private static DistributeSessionlessCache redisCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("", new DistributeCacheHAPolicy(true, true));

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Toolbar toolbar = (Toolbar)this.getControl("toolbarap");
        toolbar.addUploadListener((UploadListener)this);
    }

    public void upload(UploadEvent evt) {
        if (!this.checkPermission()) {
            evt.setCancel(true);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u5206\u6790\u4f53\u7cfb\u201d\u7684\u201c\u4f53\u7cfb\u5bfc\u5165\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"FAFAnalysisSystemExImportPlugin_0", (String)"macc-faf-formplugin", (Object[])new Object[0]));
        } else {
            Object[] urls = evt.getUrls();
            String url = (String)urls[0];
            OperationResult save = AnalysisSystemImportParser.create((String)url).executeSave();
            if (save.isSuccess()) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u6210\u529f\u3002", (String)"FAFAnalysisSystemExImportPlugin_1", (String)"macc-faf-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().showOperationResult(save);
            }
        }
    }

    private boolean checkPermission() {
        long currUserId = RequestContext.get().getCurrUserId();
        String appId = this.getView().getFormShowParameter().getAppId();
        String appPk = AppMetadataCache.getAppInfo((String)appId).getId();
        return PermissionServiceHelper.checkPermission((Long)currUserId, (String)appPk, (String)"pa_anasystemsetting", (String)"35OKY=COJ19Y");
    }

    public void afterUpload(UploadEvent evt) {
        BillList billlist = (BillList)this.getControl("billlistap");
        billlist.refresh();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate operate = (FormOperate)args.getSource();
        if ("sysexport".equals(operate.getOperateKey())) {
            ListSelectedRowCollection selectedRows = args.getListSelectedData();
            if (selectedRows.size() > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u6279\u91cf\u5bfc\u51fa\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"FAFAnalysisSystemExImportPlugin_2", (String)"macc-faf-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            } else {
                try {
                    String url = this.exportSysDynamicObjectFile(args.getListSelectedData().get(0).getPrimaryKeyValue());
                    this.getView().download(url);
                }
                catch (Exception ex) {
                    logger.info("\u201d\u5206\u6790\u4f53\u7cfb\u201c\u5bfc\u51fa\u5931\u8d25", (Object)ex);
                    this.getView().showTipNotification(ex.getMessage());
                    args.setCancel(true);
                }
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
    }

    public String exportSysDynamicObjectFile(Object primaryKeyValue) {
        AnalysisSystemExportBuilder exportBuilder = new AnalysisSystemExportBuilder(primaryKeyValue);
        String url = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsFullUrl(exportBuilder.getExportFileName(), exportBuilder.build().getBytes(StandardCharsets.UTF_8), 60);
        String tempFileId = UrlUtil.getParam((String)url, (String)"id");
        HashMap<String, String> refEntitiyMap = new HashMap<String, String>(2);
        refEntitiyMap.put("appId", "faf");
        refEntitiyMap.put("entityNum", "pa_anasystemsetting");
        refEntitiyMap.put("permissionItemId", "35OL0A4+A/HX");
        redisCache.put("TempFileCheckId:" + tempFileId, (Object)SerializationUtils.toJsonString(refEntitiyMap), 7200);
        return url;
    }
}

