/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.system;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.util.CollectionUtils;
import kd.macc.faf.helper.FAFAnalysisModelHelper;
import kd.macc.faf.helper.FAFDimensionHelper;
import kd.macc.faf.helper.FAFMappingRelationShipDataHelper;
import kd.macc.faf.helper.FAFMeasureHelper;

public class FAFAnalysisSystemList
extends AbstractListPlugin {
    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        if ("number".equals(args.getFieldName()) && "bos_list".equals(this.getView().getFormShowParameter().getFormId())) {
            Long anaSystemId = (Long)((BillListHyperLinkClickEvent)args.getHyperLinkClickEvent()).getCurrentRow().getPrimaryKeyValue();
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("pa_anasystemconfig");
            formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            formShowParameter.setCustomParam("anaSystemId", (Object)anaSystemId);
            this.getView().showForm(formShowParameter);
            args.setCancel(true);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if ("new".equals(operateKey)) {
            BillShowParameter billShowParameter = new BillShowParameter();
            billShowParameter.setFormId("pa_anasystemsetting");
            billShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            billShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "anaSystemEdit"));
            this.getView().showForm((FormShowParameter)billShowParameter);
            args.setCancel(true);
        } else if ("newbymodel".equals(operateKey)) {
            BillShowParameter billShowParameter = new BillShowParameter();
            billShowParameter.setFormId("pa_anasystemsetting");
            billShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            billShowParameter.setCustomParam("bytemplate", (Object)"true");
            billShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "anaSystemEdit"));
            this.getView().showForm((FormShowParameter)billShowParameter);
            args.setCancel(true);
        } else if ("delete".equals(operateKey)) {
            Object[] primaryKeyValues = args.getListSelectedData().getPrimaryKeyValues();
            boolean isValidated = this.deleteValidate(primaryKeyValues);
            if (isValidated) {
                try (TXHandle h = TX.required();){
                    try {
                        FAFDimensionHelper.deleteDimensionByAnaSystemIds((Object[])primaryKeyValues);
                        FAFMeasureHelper.deleteMeasureByAnaSystemIds((Object[])primaryKeyValues);
                    }
                    catch (Exception e) {
                        h.markRollback();
                    }
                }
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u5141\u8bb8\u5220\u9664\u53ea\u5b58\u5728\u9ed8\u8ba4\u5ea6\u91cf,\u7ef4\u5ea6\u7684\u5206\u6790\u4f53\u7cfb\u3002", (String)"FAFAnalysisSystemList_0", (String)"macc-faf-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
    }

    private boolean deleteValidate(Object[] primaryKeyValues) {
        DynamicObjectCollection dimensionByAnaSystem = FAFDimensionHelper.queryDimensionByAnaSystem((Object[])primaryKeyValues);
        DynamicObjectCollection measureByAnaSystem = FAFMeasureHelper.queryMeasureByAnaSystem((Object[])primaryKeyValues);
        DynamicObjectCollection modelByAnaSystem = FAFAnalysisModelHelper.queryModelByAnaSystem((Object[])primaryKeyValues);
        DynamicObjectCollection mappingByAnaSystem = FAFMappingRelationShipDataHelper.queryMappingByAnaSystem((Object[])primaryKeyValues);
        Map<Long, List<DynamicObject>> dimensionGroupedByAnaSystem = dimensionByAnaSystem.stream().collect(Collectors.groupingBy(measure -> measure.getLong("system")));
        Map<Long, List<DynamicObject>> measureGroupedByAnaSystem = measureByAnaSystem.stream().collect(Collectors.groupingBy(measure -> measure.getLong("system")));
        Map<Long, List<DynamicObject>> modelGroupedByAnaSystem = modelByAnaSystem.stream().collect(Collectors.groupingBy(measure -> measure.getLong("analysis_system")));
        Map<Long, List<DynamicObject>> mappingGroupedByAnaSystem = mappingByAnaSystem.stream().collect(Collectors.groupingBy(measure -> measure.getLong("anasystem")));
        for (Object primaryKeyValue : primaryKeyValues) {
            Long pk = Long.valueOf(primaryKeyValue.toString());
            List<DynamicObject> dimensions = dimensionGroupedByAnaSystem.get(pk);
            List<DynamicObject> measures = measureGroupedByAnaSystem.get(pk);
            List<DynamicObject> models = modelGroupedByAnaSystem.get(pk);
            List<DynamicObject> mappings = mappingGroupedByAnaSystem.get(pk);
            if (CollectionUtils.isEmpty(dimensions) && CollectionUtils.isEmpty(measures) && CollectionUtils.isEmpty(models) && CollectionUtils.isEmpty(mappings)) continue;
            return false;
        }
        return true;
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        Object returnData = closedCallBackEvent.getReturnData();
        String actionId = closedCallBackEvent.getActionId();
        if ("anaSystemEdit".equals(actionId) && returnData != null) {
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("pa_anasystemconfig");
            formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            if (returnData instanceof Map) {
                formShowParameter.setCustomParam("anaSystemId", ((Map)returnData).get("systemId"));
                formShowParameter.setCustomParam("returnData", returnData);
            } else {
                formShowParameter.setCustomParam("anaSystemId", returnData);
            }
            this.getView().showForm(formShowParameter);
            this.getView().invokeOperation("refresh");
        }
    }
}

