/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.faf.system;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.entity.operate.SaveAndNew;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.ItemClassTypeProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.ItemClassEdit;
import kd.bos.form.field.ItemClassTypeEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataRefrenceHelper;
import kd.macc.faf.designer.FAFEntityMetadata;
import kd.macc.faf.designer.FAFRefPropsEdit;
import kd.macc.faf.enums.FAFDimensionTypeEnum;
import kd.macc.faf.enums.ImportSystemSourceTypeEnum;
import kd.macc.faf.helper.EntityMetaHelper;
import kd.macc.faf.helper.FAFAnalysisModelHelper;
import kd.macc.faf.helper.FAFDimensionHelper;
import kd.macc.faf.system.FAFAnalysisSystemConfigEdit;
import kd.macc.faf.util.AnalysisModelUtil;
import kd.macc.faf.util.CustomizedDynamicFormBuilderUtil;
import kd.macc.faf.util.CustomizedFormBuilderInfo;

public class FAFDimensionEdit
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final Log logger = LogFactory.getLog(FAFDimensionEdit.class);
    private static final String FIELD_SYSTEM = "system";
    private static final String FIELD_DIMENSIONTYPE = "dimensiontype";
    private static final String FIELD_DIMENSIONSOURCE = "dimensionsource";
    private static final String IS_DEFAULT_PRESET = "isdefault";
    private static final String FIELD_ASSISTANTSOURCE = "assistantsource";
    private static final String FIELD_TYPEFIELD = "typefield";
    private static final String FIELD_GROUP_TYPE = "grouptype";
    private static final String FIELD_GROUP = "group";
    private static final String ENTRY_ENTITY = "dimensionentryentity";
    private static final String ENTRY_ENTITYENUMS = "entryentityenums";
    private static final String E_FIELD_FIELDNAME = "fieldname";
    private static final String E_FIELD_FIELDNUMBER = "fieldnumber";
    private static final String E_FIELD_DATATYPE = "datatype";

    public void registerListener(EventObject evt) {
        BasedataEdit fieldDimensionsourceEdit = (BasedataEdit)this.getView().getControl(FIELD_DIMENSIONSOURCE);
        fieldDimensionsourceEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit fieldgroupEdit = (BasedataEdit)this.getView().getControl(FIELD_GROUP);
        fieldgroupEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
    }

    public void afterCreateNewData(EventObject e) {
        Long systemId = (Long)this.getView().getFormShowParameter().getCustomParam(FIELD_SYSTEM);
        if (systemId != null && systemId != 0L) {
            this.getModel().setValue(FIELD_SYSTEM, (Object)systemId);
            this.getView().setEnable(Boolean.FALSE, new String[]{FIELD_SYSTEM});
        }
        this.getModel().setValue(FIELD_DIMENSIONTYPE, (Object)FAFDimensionTypeEnum.DATABASE.getCode());
        FieldEdit edit = (FieldEdit)this.getControl(FIELD_DIMENSIONSOURCE);
        edit.setMustInput(true);
        FieldEdit edit2 = (FieldEdit)this.getControl(FIELD_ASSISTANTSOURCE);
        edit2.setMustInput(false);
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        this.getModel().setDataChanged(false);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        String code = (String)this.getModel().getValue(FIELD_DIMENSIONTYPE);
        if (FAFDimensionTypeEnum.DATABASE.eqScene((Object)code) || FAFDimensionTypeEnum.ASSISTANTDATA.eqScene((Object)code)) {
            this.setTypefieldBySource((DynamicObject)this.getModel().getValue(FIELD_DIMENSIONSOURCE));
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setCtrlMustInput();
        this.lockCtrls();
        this.getModel().setDataChanged(false);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        OperationResult operationResult = args.getOperationResult();
        if (args.getSource() instanceof Save && operationResult.isSuccess()) {
            String nameChanged = this.getPageCache().get("nameChanged");
            if ("true".equals(nameChanged)) {
                try {
                    this.updateReferDimensionNameOfModel();
                    this.getPageCache().put("nameChanged", "false");
                }
                catch (Exception exception) {
                    throw new KDBizException(new ErrorCode("", exception.getMessage()), new Object[]{exception.getMessage(), exception});
                }
            }
            FAFAnalysisSystemConfigEdit.refreshParentPageAfterSave(this.getView());
        }
        if (args.getSource() instanceof SaveAndNew && operationResult.isSuccess()) {
            this.unlockCtrls();
        }
    }

    private void updateReferDimensionNameOfModel() {
        QFilter systemFilter = new QFilter("analysis_system", "=", (Object)((DynamicObject)this.getModel().getValue(FIELD_SYSTEM)).getLong("id"));
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        Map dynamicObjectMap = BusinessDataServiceHelper.loadFromCache((String)"pa_analysismodel", (QFilter[])new QFilter[]{systemFilter, enableFilter});
        Object dimensionNumber = this.getModel().getValue("number");
        if (!CollectionUtils.isEmpty((Map)dynamicObjectMap)) {
            for (DynamicObject model : dynamicObjectMap.values()) {
                Optional<DynamicObject> first = model.getDynamicObjectCollection("dimension_entry").stream().filter(entry -> dimensionNumber.equals(entry.getDynamicObject("dimension").getString("number"))).findFirst();
                if (!first.isPresent()) continue;
                String tableNumber = model.getString("tablenumber");
                String tableName = model.getString("tablename");
                if (!StringUtils.isNotBlank((CharSequence)tableNumber)) continue;
                this.updateModelTableName(tableNumber, tableName, model);
                boolean isNewVersion = FAFAnalysisModelHelper.isModelNewVersion((DynamicObject)model);
                if (!isNewVersion) continue;
                String tableNumber_dtl = tableNumber + "_d";
                String inputTableName_dtl = tableName + "_d";
                this.updateModelTableName(tableNumber_dtl, inputTableName_dtl, model);
            }
        }
    }

    private void updateModelTableName(String tableNumber, String tableName, DynamicObject model) {
        CustomizedFormBuilderInfo builderInfo = CustomizedDynamicFormBuilderUtil.createCustomizedFormBuilderInfo((String)AnalysisModelUtil.buildEntityNumber((String)tableNumber), (String)tableName, (String)"2UK0B8T0A=WJ", (String)"BaseFormModel");
        Object dimensionNumber = this.getModel().getValue("number");
        String dimensionName = this.getModel().getValue("name").toString();
        builderInfo.getEntityMeta().getItems().stream().filter(item -> dimensionNumber.equals(item.getKey())).findFirst().ifPresent(entityItem -> entityItem.setName(new LocaleString(dimensionName)));
        EntityMetaHelper.constructMetadataList((CustomizedFormBuilderInfo)builderInfo, (DynamicObject)model);
        CustomizedDynamicFormBuilderUtil.checkDesignerDataSaveResult((CustomizedFormBuilderInfo)builderInfo, (Map)CustomizedDynamicFormBuilderUtil.SaveEntityPage((CustomizedFormBuilderInfo)builderInfo, (Boolean)Boolean.FALSE), (boolean)true);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        switch (propName) {
            case "dimensionsource": {
                this.dimensionSourceChanged((DynamicObject)newValue);
                break;
            }
            case "dimensiontype": {
                this.dimensionTypeChange(e.getChangeSet()[0]);
                break;
            }
            case "number": {
                String number = (String)this.getModel().getValue("number");
                number = StringUtils.lowerCase((String)number);
                this.getModel().setValue("number", (Object)number);
                break;
            }
            case "name": {
                Object oldValue = e.getChangeSet()[0].getOldValue();
                if (ObjectUtils.nullSafeEquals((Object)oldValue, (Object)newValue)) break;
                this.getPageCache().put("nameChanged", "true");
                break;
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String operationKy = evt.getItemKey();
        if (operationKy.equals("newentry")) {
            String entityNumber = this.getDimensionSourceNumber();
            if (StringUtils.isEmpty((CharSequence)entityNumber)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u7ef4\u5ea6\u6765\u6e90\u201d\u3002", (String)"FAFDimensionEdit_5", (String)"macc-faf-formplugin", (Object[])new Object[0]));
                return;
            }
            List<String> list = this.getSelectValue();
            List<String> lockFieldNumbers = this.getLockFieldNumbers();
            FAFRefPropsEdit.openF7(this, ResManager.loadKDString((String)"\u5206\u6790\u6a21\u578b\u663e\u793a\u5b57\u6bb5", (String)"FAFDimensionEdit_0", (String)"macc-faf-formplugin", (Object[])new Object[0]), entityNumber, list, lockFieldNumbers, "propertyEdit");
        }
    }

    private List<String> getLockFieldNumbers() {
        Long pkId = (Long)this.getModel().getValue("id");
        List<String> fieldNumbers = new ArrayList<String>(4);
        DynamicObjectCollection fieldDys = QueryServiceHelper.query((String)"pa_dimension", (String)"dimensionentryentity.fieldnumber", (QFilter[])new QFilter("id", "=", (Object)pkId).toArray());
        if (!CollectionUtils.isEmpty((Collection)fieldDys) && BaseDataRefrenceHelper.isRefrenced((String)this.getModel().getDataEntityType().getName(), (Object)pkId)) {
            fieldNumbers = fieldDys.stream().map(dy -> dy.getString("dimensionentryentity.fieldnumber")).collect(Collectors.toList());
        }
        return fieldNumbers;
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String key = evt.getProperty().getName();
        if (key.equals(FIELD_DIMENSIONSOURCE)) {
            evt.addCustomQFilter(new QFilter("modeltype", "=", (Object)"BaseFormModel"));
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        if ("propertyEdit".equalsIgnoreCase(e.getActionId()) && e.getReturnData() != null) {
            Map returnData = (Map)e.getReturnData();
            List refProps = (List)returnData.get("RefProps");
            this.resetEntryEntity(this.getDimensionSourceNumber(), refProps);
            this.getModel().setDataChanged(false);
        }
    }

    private void dimensionTypeChange(ChangeData changeData) {
        this.clearOldValue();
        switch (FAFDimensionTypeEnum.getEnum((String)((String)changeData.getNewValue()))) {
            case ASSISTANTDATA: {
                this.resetEntryEntity("bos_assistantdata_detail", this.getDefaultRefProps());
                break;
            }
            case PERIOD: {
                this.resetEntryEntity("pa_analysisperiod", this.getPeriodRefProps());
                this.resetEntryEntityEnums();
                this.getModel().setValue(FIELD_DIMENSIONSOURCE, (Object)"pa_analysisperiod");
            }
        }
        this.setCtrlMustInput();
    }

    private void clearOldValue() {
        this.resetEntryEntity(null, this.getDefaultRefProps());
        this.resetEntryEntityEnums();
        this.getModel().setValue(FIELD_DIMENSIONSOURCE, null);
        this.getModel().setValue(FIELD_ASSISTANTSOURCE, null);
    }

    private String getDimensionSourceNumber() {
        String code = (String)this.getModel().getValue(FIELD_DIMENSIONTYPE);
        if (FAFDimensionTypeEnum.DATABASE.eqScene((Object)code)) {
            return (String)this.getModel().getValue("dimensionsource_id");
        }
        if (FAFDimensionTypeEnum.ASSISTANTDATA.eqScene((Object)code)) {
            return "bos_assistantdata_detail";
        }
        return "";
    }

    private void dimensionSourceChanged(DynamicObject newValue) {
        String code = (String)this.getModel().getValue(FIELD_DIMENSIONTYPE);
        if (FAFDimensionTypeEnum.DATABASE.eq((Object)code)) {
            this.resetEntryEntity(newValue == null ? null : (String)newValue.getPkValue(), this.getDefaultRefProps());
        }
        this.setTypefieldBySource(newValue);
        this.setCtrlMustInput();
    }

    private void setTypefieldBySource(DynamicObject newValue) {
        if (newValue != null) {
            ItemClassTypeEdit ctrlGroupTYpe = (ItemClassTypeEdit)this.getControl(FIELD_GROUP_TYPE);
            ItemClassTypeProp itemClassTypeProp = (ItemClassTypeProp)ctrlGroupTYpe.getProperty();
            List comboItems = itemClassTypeProp.getComboItems();
            Optional<BasedataProp> op = this.getBasedataProps((String)newValue.getPkValue(), new HashSet<ValueMapItem>(comboItems));
            if (op.isPresent()) {
                String selectFieldName;
                String saveFieldName = (String)this.getModel().getValue(FIELD_TYPEFIELD);
                if (StringUtils.equals((CharSequence)saveFieldName, (CharSequence)(selectFieldName = op.get().getName()))) {
                    ItemClassEdit edit = (ItemClassEdit)this.getControl(FIELD_GROUP);
                    edit.setCaption(op.get().getDisplayName());
                } else {
                    this.setNewTypefield(op.get());
                }
            } else {
                this.setNewTypefield(null);
            }
        } else {
            this.setNewTypefield(null);
        }
    }

    private void setNewTypefield(BasedataProp basedataProp) {
        if (basedataProp != null) {
            ItemClassEdit edit = (ItemClassEdit)this.getControl(FIELD_GROUP);
            edit.setCaption(basedataProp.getDisplayName());
            this.getModel().setValue(FIELD_TYPEFIELD, (Object)basedataProp.getName());
            this.getModel().setValue(FIELD_GROUP_TYPE, (Object)basedataProp.getBaseEntityId());
        } else {
            this.getModel().setValue(FIELD_TYPEFIELD, null);
            this.getModel().setValue(FIELD_GROUP_TYPE, null);
        }
        this.getModel().setValue(FIELD_GROUP, null);
    }

    private Optional<BasedataProp> getBasedataProps(String number, HashSet<ValueMapItem> set) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)number);
        return dataEntityType.getProperties().stream().filter(property -> property instanceof BasedataProp && this.contains(set, (BasedataProp)property)).map(property -> (BasedataProp)property).findFirst();
    }

    private boolean contains(HashSet<ValueMapItem> set, BasedataProp prop) {
        for (ValueMapItem item : set) {
            if (!item.getValue().equals(prop.getBaseEntityId()) || !item.getName().toString().equals(prop.getName())) continue;
            return true;
        }
        return false;
    }

    private void setCtrlMustInput() {
        String value = (String)this.getModel().getValue(FIELD_GROUP_TYPE);
        boolean notEmptyType = StringUtils.isNotEmpty((CharSequence)value);
        this.setMustInput(FIELD_GROUP, notEmptyType);
        this.getView().setVisible(Boolean.valueOf(notEmptyType), new String[]{FIELD_GROUP});
        String code = (String)this.getModel().getValue(FIELD_DIMENSIONTYPE);
        if (FAFDimensionTypeEnum.DATABASE.eqScene((Object)code)) {
            this.setMustInput(FIELD_DIMENSIONSOURCE, true);
            this.setMustInput(FIELD_ASSISTANTSOURCE, false);
        } else if (FAFDimensionTypeEnum.ASSISTANTDATA.eqScene((Object)code)) {
            this.setMustInput(FIELD_DIMENSIONSOURCE, false);
            this.setMustInput(FIELD_ASSISTANTSOURCE, true);
        } else {
            this.setMustInput(FIELD_DIMENSIONSOURCE, false);
            this.setMustInput(FIELD_ASSISTANTSOURCE, false);
        }
    }

    private void setMustInput(String key, boolean mustInput) {
        FieldEdit edit = (FieldEdit)this.getControl(key);
        edit.setMustInput(mustInput);
    }

    private void lockCtrls() {
        Long pkValue = (Long)this.getModel().getDataEntity().getPkValue();
        if (pkValue > 0L) {
            Boolean isDefault = (Boolean)this.getModel().getValue(IS_DEFAULT_PRESET);
            if (Boolean.TRUE.equals(isDefault)) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"number", FIELD_SYSTEM, FIELD_DIMENSIONTYPE});
            } else {
                this.getView().setEnable(Boolean.FALSE, new String[]{FIELD_SYSTEM});
            }
            if (BaseDataRefrenceHelper.isRefrenced((String)"pa_dimension", (Object)pkValue)) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"number", FIELD_SYSTEM, FIELD_DIMENSIONTYPE, FIELD_DIMENSIONSOURCE, FIELD_ASSISTANTSOURCE});
                if (FAFDimensionTypeEnum.DENUMS.eq(this.getModel().getValue(FIELD_DIMENSIONTYPE)) && FAFDimensionHelper.dimensionAlreadyCreateModeling((Object)pkValue)) {
                    this.getView().setEnable(Boolean.FALSE, new String[]{"advconapenums"});
                }
            }
            String systemSource = (String)this.getModel().getValue("systemsource");
            if (ImportSystemSourceTypeEnum.BCM.getCode().equals(systemSource) || ImportSystemSourceTypeEnum.EPM.getCode().equals(systemSource)) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"number", FIELD_DIMENSIONTYPE, FIELD_DIMENSIONSOURCE});
            }
        }
    }

    private void unlockCtrls() {
        this.getView().setEnable(Boolean.TRUE, new String[]{"number", "name", FIELD_SYSTEM, FIELD_DIMENSIONTYPE, FIELD_DIMENSIONSOURCE, FIELD_ASSISTANTSOURCE, "advconapenums"});
    }

    private void resetEntryEntity(String entityNumber, List<String> refProps) {
        this.getModel().deleteEntryData(ENTRY_ENTITY);
        if (entityNumber == null || refProps == null) {
            return;
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField(E_FIELD_FIELDNAME, new Object[0]);
        vs.addField(E_FIELD_FIELDNUMBER, new Object[0]);
        vs.addField(E_FIELD_DATATYPE, new Object[0]);
        FAFEntityMetadata metadata = new FAFEntityMetadata(entityNumber);
        for (String refProp : refProps) {
            FAFEntityMetadata.RefFieldProp fprop = metadata.getRefFieldProp(refProp);
            if (fprop != null) {
                vs.addRow(new Object[]{fprop.getDisplayName(), fprop.getName(), fprop.getType()});
                continue;
            }
            logger.info(entityNumber + " not get RefFieldProp" + refProp);
        }
        model.batchCreateNewEntryRow(ENTRY_ENTITY, vs);
        model.endInit();
        this.getView().updateView(ENTRY_ENTITY);
    }

    private void resetEntryEntityEnums() {
        this.getModel().deleteEntryData(ENTRY_ENTITYENUMS);
        this.getModel().createNewEntryRow(ENTRY_ENTITYENUMS);
    }

    private List<String> getDefaultRefProps() {
        return Arrays.asList("number", "name");
    }

    private List<String> getPeriodRefProps() {
        return Arrays.asList("number", "name", "year", "semiannual", "quarter", "month", "yquarter", "ymonth", "isadjust", "hierarchical");
    }

    private List<String> getSelectValue() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRY_ENTITY);
        return entryEntity.stream().map(field -> field.getString(E_FIELD_FIELDNUMBER)).collect(Collectors.toList());
    }
}

